/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.util.coord.egm96;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.zip.GZIPInputStream;
import pt.lsts.neptus.types.coord.LocationType;

public class EGM96Util {
    private static final int L_VALUE = 65341;
    private static final int _361 = 361;
    private static InputStream inputStreamCORCOEF;
    private static InputStream inputStreamEGM96;
    private static double[] cc;
    private static double[] cs;
    private static double[] hc;
    private static double[] hs;
    private static final int nmax = 360;
    static double[] drts;
    static double[] dirt;
    static double[] rlnn;
    static double cothet;
    static double sithet;
    static int ir;

    private static double hundu(int nmax, double[] p, double[] hc, double[] hs, double[] sinml, double[] cosml, double gr, double re, double[] cc, double[] cs) {
        double ar;
        double gm = 3.986004418E14;
        double ae = 6378137.0;
        double arn = ar = 6378137.0 / re;
        double b = 0.0;
        double a = 0.0;
        double ac = 0.0;
        int k = 3;
        for (int n = 2; n <= nmax; ++n) {
            arn *= ar;
            double sum = p[++k] * hc[k];
            double sumc = p[k] * cc[k];
            double sum2 = 0.0;
            for (int m = 1; m <= n; ++m) {
                double tempc = cc[++k] * cosml[m] + cs[k] * sinml[m];
                double temp = hc[k] * cosml[m] + hs[k] * sinml[m];
                sumc += p[k] * tempc;
                sum += p[k] * temp;
            }
            ac += sumc;
            a += sum * arn;
        }
        return a * 3.986004418E14 / (gr * re) + (ac += cc[1] + p[2] * cc[2] + p[3] * (cc[3] * cosml[1] + cs[3] * sinml[1])) / 100.0 - 0.53;
    }

    private static double[][] dscml(double rlon, int nmax) {
        double[] sinml = new double[362];
        double[] cosml = new double[362];
        double a = Math.sin(rlon);
        double b = Math.cos(rlon);
        sinml[1] = a;
        cosml[1] = b;
        sinml[2] = 2.0 * b * a;
        cosml[2] = 2.0 * b * b - 1.0;
        for (int m = 3; m <= nmax; ++m) {
            sinml[m] = 2.0 * b * sinml[m - 1] - sinml[m - 2];
            cosml[m] = 2.0 * b * cosml[m - 1] - cosml[m - 2];
        }
        return new double[][]{sinml, cosml};
    }

    private static void dhcsin(int nmax, double[] hc, double[] hs) {
        int n;
        double j2 = 0.00108262982131;
        double j4 = -2.37091120053E-6;
        double j6 = 6.08346498882E-9;
        double j8 = -1.4268108792E-11;
        double j10 = 1.21439275882E-14;
        int m = (nmax + 1) * (nmax + 2) / 2;
        for (n = 1; n <= m; ++n) {
            hs[n] = 0.0;
            hc[n] = 0.0;
        }
        BufferedReader br = new BufferedReader(new InputStreamReader(inputStreamEGM96));
        try {
            String line = br.readLine();
            while (line != null) {
                if (line.startsWith("#") || "".equalsIgnoreCase(line) || line.startsWith(";")) {
                    line = br.readLine();
                    continue;
                }
                String[] tokens = line.trim().split("[ \\t;]+");
                n = Integer.parseInt(tokens[0]);
                if (n > nmax) {
                    line = br.readLine();
                    continue;
                }
                m = Integer.parseInt(tokens[1]);
                double c = Double.parseDouble(tokens[2]);
                double s = Double.parseDouble(tokens[3]);
                double ec = Double.parseDouble(tokens[4]);
                double es = Double.parseDouble(tokens[5]);
                n = n * (n + 1) / 2 + m + 1;
                hc[n] = c;
                hs[n] = s;
                line = br.readLine();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        hc[4] = hc[4] + j2 / Math.sqrt(5.0);
        hc[11] = hc[11] + j4 / 3.0;
        hc[22] = hc[22] + j6 / Math.sqrt(13.0);
        hc[37] = hc[37] + j8 / Math.sqrt(17.0);
        hc[56] = hc[56] + j10 / Math.sqrt(21.0);
    }

    private static double[] legfdn(int m, double theta, int nmx) {
        int n2;
        int n1;
        int n;
        int nmx1 = nmx + 1;
        int nmx2p = 2 * nmx + 1;
        int m1 = m + 1;
        int m2 = m + 2;
        int m3 = m + 3;
        double[] rleg = new double[362];
        if (ir == 0) {
            ir = 1;
            for (n = 1; n <= nmx2p; ++n) {
                EGM96Util.drts[n] = Math.sqrt(n);
                EGM96Util.dirt[n] = 1.0 / drts[n];
            }
        }
        cothet = Math.cos(theta);
        sithet = Math.sin(theta);
        EGM96Util.rlnn[1] = 1.0;
        EGM96Util.rlnn[2] = sithet * drts[3];
        for (n1 = 3; n1 <= m1; ++n1) {
            n = n1 - 1;
            n2 = 2 * n;
            EGM96Util.rlnn[n1] = drts[n2 + 1] * dirt[n2] * sithet * rlnn[n];
        }
        switch (m) {
            case 1: {
                rleg[2] = rlnn[2];
                rleg[3] = drts[5] * cothet * rleg[2];
                break;
            }
            case 0: {
                rleg[1] = 1.0;
                rleg[2] = cothet * drts[3];
            }
        }
        rleg[m1] = rlnn[m1];
        if (m2 <= nmx1) {
            rleg[m2] = drts[m1 * 2 + 1] * cothet * rleg[m1];
            if (m3 <= nmx1) {
                for (n1 = m3; n1 <= nmx1; ++n1) {
                    n = n1 - 1;
                    if (m == 0 && n < 2 || m == 1 && n < 3) continue;
                    n2 = 2 * n;
                    rleg[n1] = drts[n2 + 1] * dirt[n + m] * dirt[n - m] * (drts[n2 - 1] * cothet * rleg[n1 - 1] - drts[n + m - 1] * drts[n - m - 1] * dirt[n2 - 3] * rleg[n1 - 2]);
                }
            }
        }
        return rleg;
    }

    private static double[] radgra(double lat, double lon) {
        double a = 6378137.0;
        double e2 = 0.00669437999013;
        double geqt = 9.7803253359;
        double k = 0.00193185265246;
        double t1 = Math.sin(lat) * Math.sin(lat);
        double n = 6378137.0 / Math.sqrt(1.0 - 0.00669437999013 * t1);
        double t2 = n * Math.cos(lat);
        double x = t2 * Math.cos(lon);
        double y = t2 * Math.sin(lon);
        double z = n * 0.99330562000987 * Math.sin(lat);
        double re = Math.sqrt(x * x + y * y + z * z);
        double rlat = Math.atan(z / Math.sqrt(x * x + y * y));
        double gr = 9.7803253359 * (1.0 + 0.00193185265246 * t1) / Math.sqrt(1.0 - 0.00669437999013 * t1);
        double[] ret = new double[]{rlat, gr, re};
        return ret;
    }

    private static double undulation(double lat, double lon, int nmax, int k) {
        double[] ret = EGM96Util.radgra(lat, lon);
        double rlat = ret[0];
        double gr = ret[1];
        double re = ret[2];
        rlat = 1.5707963267948966 - rlat;
        double[] p = new double[65342];
        for (int j = 1; j <= k; ++j) {
            int m = j - 1;
            double[] rleg = EGM96Util.legfdn(m, rlat, nmax);
            for (int i = j; i <= k; ++i) {
                p[(i - 1) * i / 2 + m + 1] = rleg[i];
            }
        }
        double[][] retll = EGM96Util.dscml(lon, nmax);
        double[] sinml = retll[0];
        double[] cosml = retll[1];
        return EGM96Util.hundu(nmax, p, hc, hs, sinml, cosml, gr, re, cc, cs);
    }

    private static void init_arrays() {
        for (int i = 1; i <= 65341; ++i) {
            EGM96Util.cs[i] = 0.0;
            EGM96Util.cc[i] = 0.0;
        }
        BufferedReader br = new BufferedReader(new InputStreamReader(inputStreamCORCOEF));
        try {
            String line = br.readLine();
            while (line != null) {
                if (line.startsWith("#") || "".equalsIgnoreCase(line) || line.startsWith(";")) {
                    line = br.readLine();
                    continue;
                }
                String[] tokens = line.trim().split("[ \\t;]+");
                int n = Integer.parseInt(tokens[0]);
                int m = Integer.parseInt(tokens[1]);
                double t1 = Double.parseDouble(tokens[2]);
                double t2 = Double.parseDouble(tokens[3]);
                int ig = n * (n + 1) / 2 + m + 1;
                EGM96Util.cc[ig] = t1;
                EGM96Util.cs[ig] = t2;
                line = br.readLine();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        EGM96Util.dhcsin(360, hc, hs);
    }

    public static double calcHeight(double latDegrees, double lonDegrees) {
        double u = EGM96Util.undulation(Math.toRadians(latDegrees), Math.toRadians(lonDegrees), 360, 361);
        return u;
    }

    public static void main(String[] args) {
        System.out.printf("Lat: %f | Lon: %f | MSL(Height to WGS84): %f = %f\n", 39.107, -8.982, 53.9372077, EGM96Util.calcHeight(39.107, -8.982));
        System.out.printf("Lat: %f | Lon: %f | MSL(Height to WGS84): %f = %f\n", 38.82593, -9.331607, 53.9372077, EGM96Util.calcHeight(38.82593, -9.331607));
        System.out.printf("Lat: %f | Lon: %f | MSL(Height to WGS84): %f = %f\n", 38.82593, -9.331607, 53.9372077, EGM96Util.calcHeight(38.82593, -9.331607));
        System.out.printf("Lat: %f | Lon: %f | MSL(Height to WGS84): %f = %f\n", 38.82593, -9.331607, 53.9372077, EGM96Util.calcHeight(38.82593, -9.331607));
        LocationType locFEUP = new LocationType();
        locFEUP.setLatitudeStr("41N10'42.4368''");
        locFEUP.setLongitudeStr("8W35'45.4572''");
        System.out.printf("Lat: %f | Lon: %f | MSL(Height to WGS84): %f = %f\n", locFEUP.getLatitudeDegs(), locFEUP.getLongitudeDegs(), 124.0, EGM96Util.calcHeight(locFEUP.getLatitudeDegs(), locFEUP.getLongitudeDegs()));
    }

    static {
        cc = new double[65342];
        cs = new double[65342];
        hc = new double[65342];
        hs = new double[65342];
        try {
            inputStreamCORCOEF = new GZIPInputStream(EGM96Util.class.getResourceAsStream("CORCOEF.gz"));
            inputStreamEGM96 = new GZIPInputStream(EGM96Util.class.getResourceAsStream("EGM96.gz"));
            EGM96Util.init_arrays();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        drts = new double[1301];
        dirt = new double[1301];
        rlnn = new double[362];
        ir = 0;
    }
}

