/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.util.editors;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.loader.FileHandler;
import pt.lsts.neptus.util.GuiUtils;

public class EditorLauncher
extends JPanel
implements Runnable,
FileHandler {
    private static final long serialVersionUID = 1L;
    public final short WINDOWS_TYPE = 0;
    public final short LINUX_TYPE = 1;
    public final short TEXT_EDITOR_TYPE = 0;
    public final short XML_EDITOR_TYPE = 1;
    protected final String TEXT_EDITOR_WIN_1 = "notepad";
    protected final String TEXT_EDITOR_WIN_2 = "textpad";
    protected final String TEXT_EDITOR_WIN_3 = "c:\\Program Files\\TextPad 4\\TextPad.exe";
    protected final String TEXT_EDITOR_LINUX_1 = "emacs";
    protected final String TEXT_EDITOR_LINUX_2 = "kate";
    protected final String TEXT_EDITOR_LINUX_3 = "jed";
    protected Runtime rt;
    protected Process ps;
    protected String exeCmd = "";
    protected String path;
    protected short type;
    protected boolean waitForCompletion;
    private JPanel jContentPane = null;
    private JFrame jFrame = null;
    private JButton jButton = null;
    private JButton jButton1 = null;
    private JPanel jPanel = null;
    private JTextField jTextField = null;
    private boolean exitOnCompletion = false;

    public EditorLauncher() {
        this.initialize();
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
        }
        return this.jContentPane;
    }

    private JFrame getJFrame() {
        if (this.jFrame == null) {
            this.jFrame = new JFrame();
            this.jFrame.setContentPane(this.getJContentPane());
            this.jFrame.setTitle("Editor Laucher");
            this.jFrame.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/images/neptus-icon.png")));
            this.jFrame.setSize(315, 90);
            this.jFrame.setDefaultCloseOperation(2);
            this.jFrame.setResizable(false);
            GuiUtils.centerOnScreen(this.jFrame);
        }
        return this.jFrame;
    }

    private JButton getJButton() {
        if (this.jButton == null) {
            this.jButton = new JButton();
            this.jButton.setText("don't wait");
            this.jButton.setMnemonic(68);
            this.jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NeptusLog.pub().info((Object)"<###>actionPerformed()");
                    EditorLauncher.this.getJFrame().dispose();
                }
            });
        }
        return this.jButton;
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setSize(300, 200);
        this.add((Component)this.getJPanel(), "South");
        this.add((Component)this.getJTextField(), "Center");
    }

    public void showFramed() {
        JFrame jf = this.getJFrame();
        jf.add(this);
        jf.setVisible(true);
    }

    protected String getEditorCommand(short type) {
        String envEditor = "";
        String envXMLEditor = "";
        String osName = System.getProperty("os.name");
        int os = -1;
        if (osName.toLowerCase().indexOf("windows") != -1) {
            os = 0;
        } else if (osName.toLowerCase().indexOf("linux") != -1) {
            os = 1;
        }
        try {
            envEditor = System.getenv("NEPTUS_EDITOR");
            envXMLEditor = System.getenv("NEPTUS_XMLEDITOR");
        }
        catch (Error e) {
            envEditor = System.getProperty("NEPTUS_EDITOR");
            envXMLEditor = System.getProperty("NEPTUS_XMLEDITOR");
        }
        String exeCmd = "";
        if (type == 1) {
            if (envXMLEditor != null) {
                exeCmd = envXMLEditor;
            } else if (envEditor != null) {
                exeCmd = envEditor;
            } else if (os == 0) {
                exeCmd = "notepad";
            } else if (os == 1) {
                exeCmd = "emacs";
            }
        } else if (envEditor != null) {
            exeCmd = envEditor;
        } else if (os == 0) {
            exeCmd = "notepad";
        } else if (os == 1) {
            exeCmd = "emacs";
        }
        return exeCmd;
    }

    public boolean editFile(String path, short type, boolean waitForCompletion, boolean exitOnCompletion) {
        this.exitOnCompletion = exitOnCompletion;
        if (exitOnCompletion) {
            waitForCompletion = true;
        }
        return this.editFile(path, type, waitForCompletion);
    }

    public boolean editFile(String path, short type, boolean waitForCompletion) {
        this.path = path;
        this.type = type;
        this.waitForCompletion = waitForCompletion;
        this.exeCmd = this.getEditorCommand(type);
        if (this.exeCmd.equals("")) {
            JOptionPane.showMessageDialog(this, "Editor not found!\nSet environment variable NEPTUS_EDITOR and \noptionaly also NEPTUS_XMLEDITOR to the editor \nof choice.");
            return false;
        }
        this.rt = Runtime.getRuntime();
        new Thread(this).start();
        return true;
    }

    public boolean editFile(String path) {
        return this.editFile(path, (short)0, false);
    }

    public boolean editFileWait(String path) {
        return this.editFile(path, (short)0, true);
    }

    public boolean editXMLFile(String path) {
        return this.editFile(path, (short)1, false);
    }

    public boolean editXMLFileWait(String path) {
        return this.editFile(path, (short)1, true);
    }

    @Override
    public void run() {
        try {
            String[] cmdArray = new String[]{this.exeCmd, this.path};
            this.ps = this.rt.exec(cmdArray);
            if (this.exitOnCompletion) {
                this.ps.waitFor();
                System.exit(this.ps.exitValue());
            }
            if (this.waitForCompletion) {
                this.jTextField.setText(this.exeCmd + " " + this.path);
                this.showFramed();
                this.ps.waitFor();
                NeptusLog.pub().info((Object)("<###> " + this.ps.exitValue()));
                this.jFrame.dispose();
            } else {
                this.ps = null;
                this.rt = null;
            }
        }
        catch (IOException e) {
            NeptusLog.pub().error((Object)this, (Throwable)e);
        }
        catch (InterruptedException e) {
            NeptusLog.pub().error((Object)this, (Throwable)e);
        }
    }

    private JButton getJButton1() {
        if (this.jButton1 == null) {
            this.jButton1 = new JButton();
            this.jButton1.setText("terminate editor");
            this.jButton1.setMnemonic(84);
            this.jButton1.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NeptusLog.pub().info((Object)"<###>actionPerformed()");
                    EditorLauncher.this.ps.destroy();
                    EditorLauncher.this.jFrame.dispose();
                }
            });
        }
        return this.jButton1;
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            this.jPanel = new JPanel();
            this.jPanel.add((Component)this.getJButton(), null);
            this.jPanel.add((Component)this.getJButton1(), null);
        }
        return this.jPanel;
    }

    private JTextField getJTextField() {
        if (this.jTextField == null) {
            this.jTextField = new JTextField();
            this.jTextField.setForeground(Color.gray);
            this.jTextField.setEditable(false);
            this.jTextField.setBackground(new Color(255, 255, 244));
        }
        return this.jTextField;
    }

    public static void main(String[] args) {
        EditorLauncher ed = new EditorLauncher();
        ed.getClass();
        boolean rsb = ed.editFile("/home/zp/teste.txt", (short)0, true);
        NeptusLog.pub().info((Object)("<###>>" + rsb));
    }

    @Override
    public void handleFile(File f) {
        String string = f.getAbsolutePath();
        this.getClass();
        this.editFile(string, (short)0, true, true);
    }
}

