/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.util.editors;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.gui.swing.NeptusFileView;

public class TextEditor
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private Container pane;
    private JPanel south;
    private JFileChooser fileDialog;
    private File chosenFile;
    private String generalInfo;
    private JLabel infoLabel;
    private JTextArea textArea;
    private JScrollPane scrollPane;
    private JMenuBar menuBar;
    private JMenu fileMenu;
    private JMenu fontMenu;
    private JMenu fontTypeMenu;
    private JMenu fontSizeMenu;
    private JMenu fontStyleMenu;
    private JMenu fontColorMenu;
    private JMenu helpMenu;
    private JMenuItem saveItem;
    private JMenuItem saveAsItem;
    private JMenuItem openItem;
    private JMenuItem exitItem;
    private JMenuItem aboutItem;
    private ButtonGroup fontTypeGroup;
    private ButtonGroup fontSizeGroup;
    private ButtonGroup fontColorGroup;
    private JRadioButtonMenuItem courierItem;
    private JRadioButtonMenuItem dialogItem;
    private JRadioButtonMenuItem timesItem;
    private JRadioButtonMenuItem font10Item;
    private JRadioButtonMenuItem font12Item;
    private JRadioButtonMenuItem font14Item;
    private JRadioButtonMenuItem font16Item;
    private JRadioButtonMenuItem font18Item;
    private JRadioButtonMenuItem blackItem;
    private JRadioButtonMenuItem grayItem;
    private JRadioButtonMenuItem redItem;
    private JRadioButtonMenuItem blueItem;
    private JCheckBoxMenuItem italicItem;
    private JCheckBoxMenuItem boldItem;
    protected UndoAction undoAction;
    protected RedoAction redoAction;
    protected UndoManager undo = new UndoManager();

    public TextEditor() {
        super("Neptus Text Editor");
        String fi = new File("images/neptus-icon.png").getAbsolutePath();
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(fi));
        MouseOver mouseOver = new MouseOver();
        this.setDefaultCloseOperation(0);
        this.pane = this.getContentPane();
        this.pane.setLayout(new BorderLayout());
        this.south = new JPanel();
        this.south.setLayout(new FlowLayout());
        this.pane.add((Component)this.south, "South");
        this.menuBar = new JMenuBar();
        this.setJMenuBar(this.menuBar);
        this.fileDialog = new JFileChooser();
        this.fileDialog.setFileSelectionMode(0);
        this.fileDialog.setFileView(new NeptusFileView());
        this.generalInfo = "Type text into the window DUPA";
        this.infoLabel = new JLabel(this.generalInfo);
        this.fileMenu = new JMenu("File");
        this.fileMenu.setMnemonic(70);
        this.fontMenu = new JMenu("Font");
        this.fontTypeMenu = new JMenu("Type");
        this.fontSizeMenu = new JMenu("Size");
        this.fontStyleMenu = new JMenu("Style");
        this.fontColorMenu = new JMenu("Color");
        this.helpMenu = new JMenu("Help");
        this.saveItem = new JMenuItem("Save");
        this.saveAsItem = new JMenuItem("Save As...");
        this.openItem = new JMenuItem("Open...");
        this.openItem.setMnemonic(79);
        this.exitItem = new JMenuItem("Exit");
        this.exitItem.setMnemonic(69);
        this.fontTypeGroup = new ButtonGroup();
        this.courierItem = new JRadioButtonMenuItem("Courier", true);
        this.dialogItem = new JRadioButtonMenuItem("Dialog");
        this.timesItem = new JRadioButtonMenuItem("TimesRoman");
        this.fontSizeGroup = new ButtonGroup();
        this.font10Item = new JRadioButtonMenuItem("10");
        this.font12Item = new JRadioButtonMenuItem("12", true);
        this.font14Item = new JRadioButtonMenuItem("14");
        this.font16Item = new JRadioButtonMenuItem("16");
        this.font18Item = new JRadioButtonMenuItem("18");
        this.italicItem = new JCheckBoxMenuItem("Italic");
        this.boldItem = new JCheckBoxMenuItem("Bold");
        this.fontColorGroup = new ButtonGroup();
        this.blackItem = new JRadioButtonMenuItem("Black");
        this.grayItem = new JRadioButtonMenuItem("Gray", true);
        this.blueItem = new JRadioButtonMenuItem("Blue");
        this.redItem = new JRadioButtonMenuItem("Red");
        this.aboutItem = new JMenuItem("About");
        this.textArea = new JTextArea();
        this.scrollPane = new JScrollPane(this.textArea);
        this.fileMenu.add(this.saveItem);
        this.fileMenu.add(this.saveAsItem);
        this.fileMenu.add(this.openItem);
        this.fileMenu.add(this.exitItem);
        this.fontMenu.add(this.fontTypeMenu);
        this.fontMenu.add(this.fontSizeMenu);
        this.fontMenu.add(this.fontStyleMenu);
        this.fontMenu.add(this.fontColorMenu);
        this.fontTypeGroup.add(this.courierItem);
        this.fontTypeGroup.add(this.dialogItem);
        this.fontTypeGroup.add(this.timesItem);
        this.fontTypeMenu.add(this.courierItem);
        this.fontTypeMenu.add(this.dialogItem);
        this.fontTypeMenu.add(this.timesItem);
        this.fontSizeGroup.add(this.font10Item);
        this.fontSizeGroup.add(this.font12Item);
        this.fontSizeGroup.add(this.font14Item);
        this.fontSizeGroup.add(this.font16Item);
        this.fontSizeGroup.add(this.font18Item);
        this.fontSizeMenu.add(this.font10Item);
        this.fontSizeMenu.add(this.font12Item);
        this.fontSizeMenu.add(this.font14Item);
        this.fontSizeMenu.add(this.font16Item);
        this.fontSizeMenu.add(this.font18Item);
        this.fontStyleMenu.add(this.italicItem);
        this.fontStyleMenu.add(this.boldItem);
        this.fontColorGroup.add(this.blackItem);
        this.fontColorGroup.add(this.grayItem);
        this.fontColorGroup.add(this.redItem);
        this.fontColorGroup.add(this.blueItem);
        this.fontColorMenu.add(this.blackItem);
        this.fontColorMenu.add(this.blueItem);
        this.fontColorMenu.add(this.grayItem);
        this.fontColorMenu.add(this.redItem);
        this.helpMenu.add(this.aboutItem);
        this.menuBar.add(this.fileMenu);
        this.menuBar.add(this.fontMenu);
        this.menuBar.add(this.helpMenu);
        this.south.add(this.infoLabel);
        this.pane.add((Component)this.scrollPane, "Center");
        this.saveItem.addActionListener(this);
        this.saveAsItem.addActionListener(this);
        this.openItem.addActionListener(this);
        this.exitItem.addActionListener(this);
        this.courierItem.addActionListener(this);
        this.dialogItem.addActionListener(this);
        this.timesItem.addActionListener(this);
        this.font10Item.addActionListener(this);
        this.font12Item.addActionListener(this);
        this.font14Item.addActionListener(this);
        this.font16Item.addActionListener(this);
        this.font18Item.addActionListener(this);
        this.italicItem.addActionListener(this);
        this.boldItem.addActionListener(this);
        this.blackItem.addActionListener(this);
        this.grayItem.addActionListener(this);
        this.redItem.addActionListener(this);
        this.blueItem.addActionListener(this);
        this.aboutItem.addActionListener(this);
        this.fileMenu.addMouseListener(mouseOver);
        this.fontMenu.addMouseListener(mouseOver);
        this.helpMenu.addMouseListener(mouseOver);
        this.fontTypeMenu.addMouseListener(mouseOver);
        this.fontSizeMenu.addMouseListener(mouseOver);
        this.fontStyleMenu.addMouseListener(mouseOver);
        this.fontColorMenu.addMouseListener(mouseOver);
        this.saveItem.addMouseListener(mouseOver);
        this.saveAsItem.addMouseListener(mouseOver);
        this.openItem.addMouseListener(mouseOver);
        this.exitItem.addMouseListener(mouseOver);
        this.courierItem.addMouseListener(mouseOver);
        this.dialogItem.addMouseListener(mouseOver);
        this.timesItem.addMouseListener(mouseOver);
        this.font10Item.addMouseListener(mouseOver);
        this.font12Item.addMouseListener(mouseOver);
        this.font14Item.addMouseListener(mouseOver);
        this.font16Item.addMouseListener(mouseOver);
        this.font18Item.addMouseListener(mouseOver);
        this.italicItem.addMouseListener(mouseOver);
        this.boldItem.addMouseListener(mouseOver);
        this.blackItem.addMouseListener(mouseOver);
        this.grayItem.addMouseListener(mouseOver);
        this.redItem.addMouseListener(mouseOver);
        this.blueItem.addMouseListener(mouseOver);
        this.aboutItem.addMouseListener(mouseOver);
        this.textArea.setFont(new Font("Monospaced", 0, 12));
        this.saveItem.setEnabled(false);
        this.setSize(800, 600);
        this.addWindowListener(new WindowCloser());
    }

    private void save() {
        try {
            PrintWriter output = new PrintWriter(new FileWriter(this.chosenFile));
            output.print(this.textArea.getText());
            output.close();
            this.saveItem.setEnabled(true);
        }
        catch (IOException e) {
            this.errorDialog("Error in saving file! dupa!");
        }
    }

    private void load() {
        boolean eof = false;
        String line = "";
        String fileText = "";
        try {
            BufferedReader input = new BufferedReader(new FileReader(this.chosenFile));
            while (!eof) {
                line = input.readLine();
                if (line == null) {
                    eof = true;
                    continue;
                }
                fileText = fileText + line + "\r\n";
            }
            input.close();
            this.textArea.setText(fileText);
            this.saveItem.setEnabled(true);
        }
        catch (IOException e) {
            this.errorDialog("Error in loading file!");
        }
    }

    private void saveItemAction() {
        int result = this.fileDialog.showSaveDialog(this);
        if (result == 1) {
            return;
        }
        this.chosenFile = this.fileDialog.getSelectedFile();
        this.save();
    }

    private void loadItemAction() {
        int result = this.fileDialog.showOpenDialog(this);
        if (result == 1) {
            return;
        }
        this.chosenFile = this.fileDialog.getSelectedFile();
        this.load();
    }

    private void errorDialog(String errorText) {
        JOptionPane.showMessageDialog(this, errorText, "Error", 0);
    }

    private void exitItemAction() {
        String exitText = "Are you sure you want to exit?";
        int choice = JOptionPane.showConfirmDialog(this, exitText, "Confirm", 0);
        if (choice == 0) {
            System.exit(0);
        }
    }

    private void aboutItemAction() {
        String aboutText = "Neptus Text Editor\nThis Text Editor was written originaly by Greg Solon.\nVersion 2.0";
        JOptionPane.showMessageDialog(this, aboutText, "About", -1);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String fontName = this.textArea.getFont().getName();
        int fontStyle = this.textArea.getFont().getStyle();
        int fontSize = this.textArea.getFont().getSize();
        if (e.getSource() == this.saveItem) {
            this.save();
        } else if (e.getSource() == this.saveAsItem) {
            this.saveItemAction();
        } else if (e.getSource() == this.openItem) {
            this.loadItemAction();
        } else if (e.getSource() == this.exitItem) {
            this.exitItemAction();
        } else if (e.getSource() == this.courierItem) {
            this.textArea.setFont(new Font("Monospaced", fontStyle, fontSize));
        } else if (e.getSource() == this.dialogItem) {
            this.textArea.setFont(new Font("Dialog", fontStyle, fontSize));
        } else if (e.getSource() == this.timesItem) {
            this.textArea.setFont(new Font("Serif", fontStyle, fontSize));
        } else if (e.getSource() == this.font10Item) {
            this.textArea.setFont(new Font(fontName, fontStyle, 10));
        } else if (e.getSource() == this.font12Item) {
            this.textArea.setFont(new Font(fontName, fontStyle, 12));
        } else if (e.getSource() == this.font14Item) {
            this.textArea.setFont(new Font(fontName, fontStyle, 14));
        } else if (e.getSource() == this.font16Item) {
            this.textArea.setFont(new Font(fontName, fontStyle, 16));
        } else if (e.getSource() == this.font18Item) {
            this.textArea.setFont(new Font(fontName, fontStyle, 18));
        } else if (e.getSource() == this.italicItem || e.getSource() == this.boldItem) {
            if (this.italicItem.isSelected() && !this.boldItem.isSelected()) {
                this.textArea.setFont(new Font(fontName, 2, fontSize));
            } else if (this.italicItem.isSelected() && this.boldItem.isSelected()) {
                this.textArea.setFont(new Font(fontName, 3, fontSize));
            } else if (!this.italicItem.isSelected() && this.boldItem.isSelected()) {
                this.textArea.setFont(new Font(fontName, 1, fontSize));
            } else {
                this.textArea.setFont(new Font(fontName, 0, fontSize));
            }
        } else if (e.getSource() == this.blackItem) {
            this.textArea.setForeground(Color.black);
        } else if (e.getSource() == this.grayItem) {
            this.textArea.setForeground(Color.gray);
        } else if (e.getSource() == this.redItem) {
            this.textArea.setForeground(new Color(140, 45, 25));
        } else if (e.getSource() == this.blueItem) {
            this.textArea.setForeground(new Color(0, 0, 128));
        } else if (e.getSource() == this.aboutItem) {
            this.aboutItemAction();
        }
    }

    public static void main(String[] args) {
        TextEditor editor = new TextEditor();
        editor.setVisible(true);
    }

    class RedoAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public RedoAction() {
            super("Redo");
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                TextEditor.this.undo.redo();
            }
            catch (CannotRedoException ex) {
                NeptusLog.pub().info((Object)("<###>Unable to redo: " + ex));
                ex.printStackTrace();
            }
            this.updateRedoState();
            TextEditor.this.undoAction.updateUndoState();
        }

        protected void updateRedoState() {
            if (TextEditor.this.undo.canRedo()) {
                this.setEnabled(true);
                this.putValue("Name", TextEditor.this.undo.getRedoPresentationName());
            } else {
                this.setEnabled(false);
                this.putValue("Name", "Redo");
            }
        }
    }

    class UndoAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public UndoAction() {
            super("Undo");
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                TextEditor.this.undo.undo();
            }
            catch (CannotUndoException ex) {
                NeptusLog.pub().info((Object)("<###>Unable to undo: " + ex));
                ex.printStackTrace();
            }
            this.updateUndoState();
            TextEditor.this.redoAction.updateRedoState();
        }

        protected void updateUndoState() {
            if (TextEditor.this.undo.canUndo()) {
                this.setEnabled(true);
                this.putValue("Name", TextEditor.this.undo.getUndoPresentationName());
            } else {
                this.setEnabled(false);
                this.putValue("Name", "Undo");
            }
        }
    }

    class WindowCloser
    extends WindowAdapter {
        WindowCloser() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            TextEditor.this.exitItemAction();
        }
    }

    class MouseOver
    extends MouseAdapter {
        MouseOver() {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            if (e.getSource() == TextEditor.this.fileMenu) {
                TextEditor.this.infoLabel.setText("Save/Open documents or exit the Text Editor");
            } else if (e.getSource() == TextEditor.this.fontMenu) {
                TextEditor.this.infoLabel.setText("Control the appearance of the text");
            } else if (e.getSource() == TextEditor.this.helpMenu) {
                TextEditor.this.infoLabel.setText("Help information relating to the Text Editor");
            } else if (e.getSource() == TextEditor.this.fontTypeMenu) {
                TextEditor.this.infoLabel.setText("Set the font type");
            } else if (e.getSource() == TextEditor.this.fontSizeMenu) {
                TextEditor.this.infoLabel.setText("Set the font size");
            } else if (e.getSource() == TextEditor.this.fontStyleMenu) {
                TextEditor.this.infoLabel.setText("Set the font style");
            } else if (e.getSource() == TextEditor.this.fontColorMenu) {
                TextEditor.this.infoLabel.setText("Set the font color");
            } else if (e.getSource() == TextEditor.this.saveItem) {
                TextEditor.this.infoLabel.setText("Save the text in the file you are working on");
            } else if (e.getSource() == TextEditor.this.saveAsItem) {
                TextEditor.this.infoLabel.setText("Save the text to a selected file");
            } else if (e.getSource() == TextEditor.this.openItem) {
                TextEditor.this.infoLabel.setText("Open a new text file");
            } else if (e.getSource() == TextEditor.this.exitItem) {
                TextEditor.this.infoLabel.setText("Exit the Text Editor");
            } else if (e.getSource() == TextEditor.this.courierItem) {
                TextEditor.this.infoLabel.setText("Set the font type to Courier");
            } else if (e.getSource() == TextEditor.this.dialogItem) {
                TextEditor.this.infoLabel.setText("Set the font type to Dialog");
            } else if (e.getSource() == TextEditor.this.timesItem) {
                TextEditor.this.infoLabel.setText("Set the font type to TimesRoman");
            } else if (e.getSource() == TextEditor.this.font10Item) {
                TextEditor.this.infoLabel.setText("Set the font size to 10");
            } else if (e.getSource() == TextEditor.this.font12Item) {
                TextEditor.this.infoLabel.setText("Set the font size to 12");
            } else if (e.getSource() == TextEditor.this.font14Item) {
                TextEditor.this.infoLabel.setText("Set the font size to 14");
            } else if (e.getSource() == TextEditor.this.font16Item) {
                TextEditor.this.infoLabel.setText("Set the font size to 16");
            } else if (e.getSource() == TextEditor.this.font18Item) {
                TextEditor.this.infoLabel.setText("Set the font size to 18");
            } else if (e.getSource() == TextEditor.this.italicItem) {
                TextEditor.this.infoLabel.setText("Set the font style to italic");
            } else if (e.getSource() == TextEditor.this.boldItem) {
                TextEditor.this.infoLabel.setText("Set the font style to bold");
            } else if (e.getSource() == TextEditor.this.blackItem) {
                TextEditor.this.infoLabel.setText("Set the font color to black");
            } else if (e.getSource() == TextEditor.this.grayItem) {
                TextEditor.this.infoLabel.setText("Set the font color to gray");
            } else if (e.getSource() == TextEditor.this.redItem) {
                TextEditor.this.infoLabel.setText("Set the font color to red");
            } else if (e.getSource() == TextEditor.this.blueItem) {
                TextEditor.this.infoLabel.setText("Set the font color to blue");
            } else if (e.getSource() == TextEditor.this.aboutItem) {
                TextEditor.this.infoLabel.setText("View information about this Text Editor");
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            TextEditor.this.infoLabel.setText(TextEditor.this.generalInfo);
        }
    }
}

