/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.util.gui;

import java.util.Date;
import pt.lsts.neptus.util.DateTimeUtil;
import pt.lsts.neptus.util.MathMiscUtils;

public class LBLUtil {
    public static String writeTimeLabel(long timeStampMillis) {
        String timeStr;
        try {
            timeStr = timeStampMillis <= 0L ? "" : " (" + DateTimeUtil.timeFormaterNoMillis2UTC.format(new Date(timeStampMillis)) + " UTC" + ")";
        }
        catch (Exception e) {
            timeStr = "";
        }
        String deltaTimeStr = LBLUtil.calcEllapsedTime(timeStampMillis);
        String ellapsedTime = timeStr + deltaTimeStr;
        return ellapsedTime;
    }

    private static String calcEllapsedTime(long timeStampMillis) {
        String deltaTimeStr;
        try {
            deltaTimeStr = timeStampMillis <= 0L ? "" : " \u2206t " + LBLUtil.convertTimeMilliSecondsToFormatedString(System.currentTimeMillis() - timeStampMillis);
        }
        catch (Exception e) {
            deltaTimeStr = "";
        }
        return deltaTimeStr;
    }

    private static String convertTimeMilliSecondsToFormatedString(long timeMilliSeconds) {
        String tt = "";
        tt = timeMilliSeconds < 60000L ? MathMiscUtils.parseToEngineeringNotation(timeMilliSeconds / 1000L, 0) + "s" : DateTimeUtil.milliSecondsToFormatedString(timeMilliSeconds);
        return tt;
    }
}

