/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.util.gui;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.Timer;
import java.util.TimerTask;
import javax.imageio.ImageIO;
import pt.lsts.neptus.NeptusLog;

public class MouseRecorder
implements AWTEventListener {
    protected BufferedImage img = null;
    protected BufferedImage lastSnapshot = null;
    protected Point lastPoint = null;
    protected long lastTime = 0L;
    protected Graphics2D pathGraphics = null;
    protected Dimension screenSize;
    protected Robot r;
    String fileName = "Snapshots_" + System.currentTimeMillis();
    File dir = new File("log/MouseRecorder" + this.fileName);

    public MouseRecorder() {
        try {
            this.r = new Robot();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.screenSize = Toolkit.getDefaultToolkit().getScreenSize();
    }

    protected void createSnapshot(Point clicked, boolean leftClick) {
        BufferedImage image = this.r.createScreenCapture(new Rectangle(this.screenSize));
        if (clicked != null) {
            Graphics2D g = (Graphics2D)image.getGraphics();
            Color color = Color.orange;
            if (!leftClick) {
                color = Color.green;
            }
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), 80));
            g.fill(new Ellipse2D.Double(clicked.getX() - 8.0, clicked.getY() - 8.0, 16.0, 16.0));
            g.setColor(color.darker().darker());
            g.draw(new Ellipse2D.Double(clicked.getX() - 8.0, clicked.getY() - 8.0, 16.0, 16.0));
            g.drawImage(this.img, null, null);
            this.img = null;
        }
        this.saveSnapshot(image);
    }

    public void startRecording() {
        Toolkit.getDefaultToolkit().addAWTEventListener(this, 48L);
        this.createSnapshot(null, false);
    }

    public void stopRecording() {
        this.createSnapshot(null, false);
        Toolkit.getDefaultToolkit().removeAWTEventListener(this);
    }

    @Override
    public void eventDispatched(AWTEvent event) {
        MouseEvent mouseEvent = (MouseEvent)event;
        boolean leftClick = mouseEvent.getButton() == 1;
        Point point = mouseEvent.getLocationOnScreen();
        switch (event.getID()) {
            case 500: {
                NeptusLog.pub().info((Object)("<###> " + (1 & event.getID())));
                this.createSnapshot(point, leftClick);
                DelayedSnapshot timerTask = new DelayedSnapshot();
                timerTask.setP(point);
                timerTask.setLeftBtn(leftClick);
                new Timer("delayed snapshot").schedule((TimerTask)timerTask, 100L);
                break;
            }
            case 503: {
                this.drawPath(point);
                break;
            }
            case 506: {
                this.drawPath(MouseInfo.getPointerInfo().getLocation());
                break;
            }
        }
    }

    private void drawPath(Point p) {
        if (this.img == null) {
            this.img = new BufferedImage((int)this.screenSize.getWidth(), (int)this.screenSize.getHeight(), 2);
            this.pathGraphics = (Graphics2D)this.img.getGraphics();
            this.pathGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        if (this.lastPoint != null) {
            this.pathGraphics.setColor(Color.black);
            this.pathGraphics.draw(new Line2D.Double(this.lastPoint, p));
            if (System.currentTimeMillis() - this.lastTime > 1000L) {
                double width = (double)(System.currentTimeMillis() - this.lastTime) / 1000.0;
                width = Math.min(width, 60.0);
                this.pathGraphics.draw(new Ellipse2D.Double(p.getX() - width / 2.0, p.getY() - width / 2.0, width, width));
                this.pathGraphics.setColor(new Color(0, 0, 0, 200));
                this.pathGraphics.fill(new Ellipse2D.Double(p.getX() - width / 2.0, p.getY() - width / 2.0, width, width));
            }
        }
        this.lastPoint = p;
        this.lastTime = System.currentTimeMillis();
    }

    private void saveSnapshot(BufferedImage image) {
        this.dir.mkdirs();
        try {
            String filename = System.currentTimeMillis() + ".png";
            ImageIO.write((RenderedImage)image, "PNG", new File(this.dir, filename));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private class DelayedSnapshot
    extends TimerTask {
        private Point p;
        private boolean isLeftBtn;

        private DelayedSnapshot() {
        }

        public void setP(Point p) {
            this.p = p;
        }

        public void setLeftBtn(boolean isLeftBtn) {
            this.isLeftBtn = isLeftBtn;
        }

        @Override
        public void run() {
            MouseRecorder.this.createSnapshot(this.p, this.isLeftBtn);
        }
    }
}

