/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.util.http.client;

import org.apache.http.HttpResponse;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.impl.client.AbstractHttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import pt.lsts.neptus.comm.proxy.ProxyInfoProvider;

public class HttpClientConnectionHelper {
    private DefaultHttpClient client;
    private PoolingClientConnectionManager httpConnectionManager;
    private int maxTotalConnections = 4;
    private int defaultMaxConnectionsPerRoute = 50;
    private int connectionTimeout = 5000;
    private boolean initializeProxyRoutePlanner = true;

    public HttpClientConnectionHelper() {
    }

    public HttpClientConnectionHelper(int maxTotalConnections, int defaultMaxConnectionsPerRoute, int connectionTimeout, boolean initializeProxyRoutePlanner) {
        this.maxTotalConnections = maxTotalConnections;
        this.defaultMaxConnectionsPerRoute = defaultMaxConnectionsPerRoute;
        this.connectionTimeout = connectionTimeout;
        this.initializeProxyRoutePlanner = initializeProxyRoutePlanner;
    }

    public void initializeComm() {
        SchemeRegistry schemeRegistry = new SchemeRegistry();
        schemeRegistry.register(new Scheme("http", 80, (SchemeSocketFactory)PlainSocketFactory.getSocketFactory()));
        schemeRegistry.register(new Scheme("https", 443, (SchemeSocketFactory)PlainSocketFactory.getSocketFactory()));
        this.httpConnectionManager = new PoolingClientConnectionManager(schemeRegistry);
        this.httpConnectionManager.setMaxTotal(this.maxTotalConnections);
        this.httpConnectionManager.setDefaultMaxPerRoute(this.defaultMaxConnectionsPerRoute);
        BasicHttpParams params = new BasicHttpParams();
        HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)this.connectionTimeout);
        this.client = new DefaultHttpClient((ClientConnectionManager)this.httpConnectionManager, (HttpParams)params);
        if (this.initializeProxyRoutePlanner) {
            ProxyInfoProvider.setRoutePlanner((AbstractHttpClient)this.client);
        }
    }

    public void cleanUp() {
        if (this.client != null) {
            // empty if block
        }
        if (this.httpConnectionManager != null) {
            this.httpConnectionManager.shutdown();
        }
    }

    public DefaultHttpClient getClient() {
        return this.client;
    }

    public PoolingClientConnectionManager getHttpConnectionManager() {
        return this.httpConnectionManager;
    }

    public int getMaxTotalConnections() {
        return this.maxTotalConnections;
    }

    public int getDefaultMaxConnectionsPerRoute() {
        return this.defaultMaxConnectionsPerRoute;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public boolean isInitializeProxyRoutePlanner() {
        return this.initializeProxyRoutePlanner;
    }

    public void autenticateProxyIfNeeded(HttpResponse iGetResultCode) {
        this.autenticateProxyIfNeeded(iGetResultCode, null);
    }

    public void autenticateProxyIfNeeded(HttpResponse iGetResultCode, HttpContext localContext) {
        if (localContext == null) {
            localContext = new BasicHttpContext();
        }
        ProxyInfoProvider.authenticateConnectionIfNeeded(iGetResultCode, localContext, this.client);
    }
}

