/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.util.lbl;

import java.util.LinkedList;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.types.coord.CoordinateSystem;
import pt.lsts.neptus.types.coord.CoordinateUtil;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.map.TransponderElement;
import pt.lsts.neptus.util.MathMiscUtils;

public class LBLTriangulationHelper {
    private final LinkedList<TransponderElement> transponders = new LinkedList();
    private final LinkedList<CoordinateSystem> coordSystemsList = new LinkedList();
    private final LinkedList<Double> distanciesList = new LinkedList();
    private double[] distances = new double[]{Double.NaN, Double.NaN, Double.NaN};
    private double[] distancesPrev = new double[]{Double.NaN, Double.NaN, Double.NaN};
    private final LocationType lastKnownPos = new LocationType();
    private long lastCalcPosTimeMillis = -1L;
    private LocationType start = new LocationType();

    public LBLTriangulationHelper(TransponderElement[] transpondersArray, LocationType start) throws Exception {
        this.reset(transpondersArray, start);
    }

    private void initialize() {
        this.calcCoordinateSystems(this.transponders, this.coordSystemsList, this.distanciesList);
        this.resetDistArray();
    }

    public void reset(TransponderElement[] transpondersArray, LocationType start) throws Exception {
        if (transpondersArray == null || transpondersArray.length == 1) {
            throw new Exception("Number of Transponders should be grater than 1!");
        }
        for (TransponderElement transponderElement : transpondersArray) {
            this.transponders.add(transponderElement);
        }
        this.start = start;
        this.initialize();
    }

    public void reset() {
        this.initialize();
    }

    private void resetDistArray() {
        int ts = this.transponders.size();
        if (ts > 0) {
            this.distances = new double[ts];
            this.distancesPrev = new double[ts];
            for (int i = 0; i < this.distances.length; ++i) {
                this.distances[i] = Double.NaN;
                this.distancesPrev[i] = Double.NaN;
            }
        }
        this.lastKnownPos.setLocation(this.start);
    }

    public LocationType getLastKnownPos() {
        return new LocationType(this.lastKnownPos);
    }

    public void resetLastKnownPos(LocationType lastKnownPos, long lastKnownPosMillis) {
        this.lastKnownPos.setLocation(lastKnownPos);
        this.lastCalcPosTimeMillis = lastKnownPosMillis;
    }

    public long getLastKnownPosMillis() {
        return this.lastCalcPosTimeMillis;
    }

    public LocationType updateRangeAccepted(long id, double range, long timeStampMillis) {
        LocationType loc = null;
        try {
            int nTrans = this.transponders.size();
            int indOrigin = (int)id;
            if (indOrigin == -1) {
                NeptusLog.pub().debug((Object)(this + "\nTransponder " + id + " not found in list!"));
                return null;
            }
            int indPrevOrigin = (indOrigin - 1) % nTrans;
            if (indPrevOrigin == -1) {
                indPrevOrigin = nTrans - 1;
            }
            loc = this.updatePosition(indPrevOrigin, indOrigin, this.distances[indPrevOrigin], range, this.coordSystemsList.get(indPrevOrigin), this.distanciesList.get(indPrevOrigin), this.lastKnownPos, this.start, timeStampMillis);
        }
        catch (Exception e) {
            NeptusLog.pub().error((Object)e.getMessage(), (Throwable)e);
        }
        int idx = Integer.parseInt(("" + id).replaceAll("ch", ""));
        this.distancesPrev[idx] = this.distances[idx];
        this.distances[idx] = range;
        return loc;
    }

    public LocationType updateRange(long id, double range, long timeStampMillis, String reason) {
        if (reason.length() == 0) {
            return this.updateRangeAccepted(id, range, timeStampMillis);
        }
        return this.updateRangeRejected(id, range, timeStampMillis, reason);
    }

    public LocationType updateRangeRejected(long id, double range, long timeStampMillis, String reason) {
        LocationType loc = null;
        try {
            int nTrans = this.transponders.size();
            int indOrigin = (int)id;
            int indPrevOrigin = (indOrigin - 1) % nTrans;
            if (indPrevOrigin == -1) {
                indPrevOrigin = nTrans - 1;
            }
            loc = this.updatePosition(indPrevOrigin, indOrigin, this.distances[indPrevOrigin], this.distances[indOrigin], this.coordSystemsList.get(indPrevOrigin), this.distanciesList.get(indPrevOrigin), this.lastKnownPos, this.start, timeStampMillis);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        int idx = Integer.parseInt(("" + id).replaceAll("ch", ""));
        this.distances[idx] = Double.NaN;
        return loc;
    }

    private void calcCoordinateSystems(LinkedList<TransponderElement> transpondersList, LinkedList<CoordinateSystem> coordSystemsList, LinkedList<Double> distanciesList) {
        coordSystemsList.clear();
        distanciesList.clear();
        for (int i = 0; i < transpondersList.size(); ++i) {
            LocationType t1 = transpondersList.get(i).getCenterLocation();
            LocationType t2 = i < transpondersList.size() - 1 ? transpondersList.get(i + 1).getCenterLocation() : transpondersList.getFirst().getCenterLocation();
            double[] res = t1.getOffsetFrom(t2);
            CoordinateUtil.cartesianToCylindricalCoordinates(res[0], res[1], res[2]);
            double distance = t1.getHorizontalDistanceInMeters(new LocationType(t2));
            double xyAngle = t1.getXYAngle(new LocationType(t2));
            CoordinateSystem cs = new CoordinateSystem();
            cs.setLocation(t1);
            cs.setYaw(Math.toDegrees(xyAngle - 1.5707963267948966));
            cs.setId(t1.getId() + t2.getId());
            cs.setName(cs.getId());
            coordSystemsList.add(cs);
            distanciesList.add(distance);
        }
    }

    private LocationType updatePosition(int trans1, int trans2, double trans1ToVehicleDistance, double trans2ToVehicleDistance, CoordinateSystem cs, double distance, LocationType lastKnownPos, LocationType start, long timeStampMillis) {
        try {
            LocationType[] locArray = this.calculate(trans1, trans2, trans1ToVehicleDistance, trans2ToVehicleDistance, cs, distance);
            if (locArray == null) {
                NeptusLog.pub().debug((Object)"LBL Range updatePosition\nInvalid fix for calculation!!");
                return null;
            }
            LocationType loc = this.fixLocationWithLastKnown(locArray, lastKnownPos, start);
            lastKnownPos.setLocation(loc);
            this.lastCalcPosTimeMillis = timeStampMillis;
            return loc;
        }
        catch (Exception e) {
            NeptusLog.pub().error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private LocationType[] calculate(int trans1, int trans2, double trans1ToVehicleDistance, double trans2ToVehicleDistance, CoordinateSystem cs, double distance) {
        double da1 = trans1ToVehicleDistance;
        double db1 = trans2ToVehicleDistance;
        double paY = 0.0;
        double pbY = distance;
        String lat = cs.getLatitudeStr();
        String lon = cs.getLongitudeStr();
        double yawHR = cs.getYaw();
        double[] cyl = CoordinateUtil.sphericalToCylindricalCoordinates(cs.getOffsetDistance(), cs.getAzimuth(), cs.getZenith());
        double legacyOffsetDistance = MathMiscUtils.round(cyl[0], 3);
        double legacyTheta = MathMiscUtils.round(Math.toDegrees(cyl[1]), 3);
        double legacyOffsetNorth = cs.getOffsetNorth();
        double legacyOffsetEast = cs.getOffsetEast();
        double t1Depth = 0.0;
        double daH1 = Math.sqrt(Math.pow(da1, 2.0) - Math.pow(t1Depth, 2.0));
        double dbH1 = Math.sqrt(Math.pow(db1, 2.0) - Math.pow(t1Depth, 2.0));
        double offsetY = (Math.pow(daH1, 2.0) - Math.pow(dbH1, 2.0) + Math.pow(pbY, 2.0) - Math.pow(paY, 2.0)) / (2.0 * pbY - 2.0 * paY);
        double offsetX = Math.sqrt(Math.pow(daH1, 2.0) - Math.pow(offsetY - paY, 2.0));
        if (Double.isNaN(offsetX) || Double.isNaN(offsetY)) {
            return null;
        }
        double[] offsetsIne = CoordinateUtil.bodyFrameToInertialFrame(offsetX, offsetY, 0.0, 0.0, 0.0, Math.toRadians(yawHR));
        double offsetNorth = MathMiscUtils.round(offsetsIne[0], 3) + legacyOffsetNorth;
        double offsetEast = MathMiscUtils.round(offsetsIne[1], 3) + legacyOffsetEast;
        double[] offsetsIne2 = CoordinateUtil.bodyFrameToInertialFrame(-offsetX, offsetY, 0.0, 0.0, 0.0, Math.toRadians(yawHR));
        double offsetNorth2 = MathMiscUtils.round(offsetsIne2[0], 3) + legacyOffsetNorth;
        double offsetEast2 = MathMiscUtils.round(offsetsIne2[1], 3) + legacyOffsetEast;
        LocationType loc = new LocationType();
        loc.setLatitudeStr(lat);
        loc.setLongitudeStr(lon);
        loc.setDepth(t1Depth);
        loc.setOffsetNorth(offsetNorth);
        loc.setOffsetEast(offsetEast);
        loc.setOffsetDistance(legacyOffsetDistance);
        loc.setAzimuth(legacyTheta);
        LocationType loc2 = new LocationType();
        loc2.setLatitudeStr(lat);
        loc2.setLongitudeStr(lon);
        loc2.setDepth(t1Depth);
        loc2.setOffsetNorth(offsetNorth2);
        loc2.setOffsetEast(offsetEast2);
        loc2.setOffsetDistance(legacyOffsetDistance);
        loc2.setAzimuth(legacyTheta);
        LocationType[] locArray = new LocationType[]{loc, loc2};
        return locArray;
    }

    private LocationType fixLocationWithLastKnown(LocationType[] newLocArray, LocationType lasKnownLoc, LocationType startPos) {
        double lasKnownLocDist;
        LocationType fixedLoc = new LocationType();
        LocationType newLoc = new LocationType(newLocArray[0]);
        LocationType helperLoc = new LocationType(newLocArray[1]);
        double newLocDist = lasKnownLoc.getDistanceInMeters(newLoc);
        fixedLoc = newLocDist <= (lasKnownLocDist = lasKnownLoc.getDistanceInMeters(helperLoc)) ? newLoc : helperLoc;
        return fixedLoc;
    }
}

