/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.util.llf;

import java.util.LinkedHashMap;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import org.apache.commons.collections.map.LRUMap;
import pt.lsts.imc.IMCMessage;
import pt.lsts.imc.IMCMessageType;
import pt.lsts.imc.lsf.LsfIndex;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.mra.importers.IMraLogGroup;

public class IndexedLogTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private final LinkedHashMap<Integer, Integer> rowToIndex = new LinkedHashMap();
    private final LRUMap cache = new LRUMap(100);
    private int rowCount = 1;
    private final LsfIndex index;
    private final IMCMessageType imcMsgType;
    private Vector<String> names = null;
    private Vector<String> msgNames = null;

    public synchronized IMCMessage getMessage(int row) {
        if (!this.rowToIndex.containsKey(row)) {
            return null;
        }
        int idx = this.rowToIndex.get(row);
        if (this.cache.containsKey((Object)idx)) {
            return (IMCMessage)this.cache.get((Object)idx);
        }
        try {
            IMCMessage m = this.index.getMessage(idx);
            this.cache.put((Object)idx, (Object)m);
            return m;
        }
        catch (Exception e) {
            NeptusLog.pub().error((Object)e);
            return null;
        }
    }

    private void loadIndexes(double initTime, double finalTime) {
        double time;
        int rowIndex = 0;
        int mgid = this.imcMsgType.getId();
        int curIndex = this.index.getFirstMessageOfType(mgid);
        while (curIndex != -1 && !((time = this.index.timeOf(curIndex)) > finalTime)) {
            if (time >= initTime || initTime < 0.0) {
                this.rowToIndex.put(rowIndex++, curIndex);
            }
            curIndex = this.index.getNextMessageOfType(mgid, curIndex);
        }
        this.rowCount = rowIndex;
    }

    protected void load(double initTime, double finalTime) {
    }

    public IndexedLogTableModel(IMraLogGroup source, String msgName) {
        this(source, msgName, -1L, (long)(source.getLsfIndex().getEndTime() * 1000.0));
    }

    public IndexedLogTableModel(IMraLogGroup source, String msgName, long initTime, long finalTime) {
        this.index = source.getLsfIndex();
        this.imcMsgType = this.index.getDefinitions().getType(msgName);
        this.names = new Vector();
        this.names.add("time");
        this.names.add("src");
        this.names.add("src_ent");
        this.names.add("dst");
        this.names.add("dst_ent");
        for (String element : this.imcMsgType.getFieldNames()) {
            if (this.imcMsgType.getFieldUnits(element) != null && !this.imcMsgType.getFieldUnits(element).isEmpty()) {
                this.names.add(element + " " + "(" + this.imcMsgType.getFieldUnits(element) + ")");
                continue;
            }
            this.names.add(element);
        }
        this.msgNames = new Vector();
        this.msgNames.add("time");
        this.msgNames.add("src");
        this.msgNames.add("src_ent");
        this.msgNames.add("dst");
        this.msgNames.add("dst_ent");
        this.msgNames.addAll(this.imcMsgType.getFieldNames());
        this.loadIndexes((double)initTime / 1000.0, (double)finalTime / 1000.0);
    }

    @Override
    public int getColumnCount() {
        if (this.names == null) {
            return 0;
        }
        return this.names.size();
    }

    @Override
    public int getRowCount() {
        if (this.index == null) {
            return 1;
        }
        return this.rowCount;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.index == null) {
            return "Unable to load data";
        }
        IMCMessage m = this.getMessage(rowIndex);
        if (m != null) {
            switch (this.msgNames.get(columnIndex)) {
                case "time": {
                    return m.getTimestampMillis();
                }
                case "src": {
                    return m.getSourceName();
                }
                case "src_ent": {
                    return this.index.getEntityName(m.getSrc(), (int)m.getSrcEnt());
                }
                case "dst": {
                    return this.index.getSystemName(m.getDst());
                }
                case "dst_ent": {
                    return this.index.getEntityName(m.getDst(), (int)m.getDstEnt());
                }
            }
            String type = m.getTypeOf(this.msgNames.get(columnIndex));
            if (type.startsWith("uint") || type.startsWith("int") || type.startsWith("fp")) {
                String unit = m.getUnitsOf(this.msgNames.get(columnIndex));
                Number nb = null;
                nb = m.getAsNumber(this.msgNames.get(columnIndex));
                if (!(nb == null || unit != null && ("enumerated".equalsIgnoreCase(unit.toLowerCase()) || "bitmask".equalsIgnoreCase(unit.toLowerCase()) || "bitfield".equalsIgnoreCase(unit.toLowerCase())))) {
                    return nb;
                }
            }
            return "" + m.getString(this.msgNames.get(columnIndex), false);
        }
        return null;
    }

    @Override
    public Class<?> getColumnClass(int c) {
        if (this.getValueAt(0, c) == null) {
            return String.class;
        }
        return this.getValueAt(0, c).getClass();
    }

    @Override
    public String getColumnName(int column) {
        return this.names.get(column);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }
}

