/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.util.llf;

import com.l2fprod.common.swing.renderer.DefaultCellRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.TimeZone;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.HighlighterFactory;
import pt.lsts.imc.lsf.LsfIndex;
import pt.lsts.neptus.gui.swing.RangeSlider;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.mra.LogMarker;
import pt.lsts.neptus.mra.MRAPanel;
import pt.lsts.neptus.mra.importers.IMraLog;
import pt.lsts.neptus.mra.importers.IMraLogGroup;
import pt.lsts.neptus.mra.plots.LogMarkerListener;
import pt.lsts.neptus.mra.visualizations.MRAVisualization;
import pt.lsts.neptus.util.ImageUtils;
import pt.lsts.neptus.util.llf.IndexedLogTableModel;
import pt.lsts.neptus.util.llf.MessageHtmlVisualization;

public class LogTableVisualization
implements MRAVisualization,
LogMarkerListener {
    IMraLog log;
    MRAPanel mraPanel;
    LinkedHashMap<Integer, LogMarker> markerList = new LinkedHashMap();
    protected SimpleDateFormat fmt = new SimpleDateFormat("HH:mm:ss.SSS");
    IndexedLogTableModel model;
    JXTable table;
    JPanel panel = new JPanel((LayoutManager)new MigLayout());
    RangeSlider rangeSlider;
    JButton btnFilter = new JButton(new AbstractAction("Filter"){

        @Override
        public void actionPerformed(ActionEvent e) {
            long initTime = LogTableVisualization.this.log.firstLogEntry().getTimestampMillis();
            LogTableVisualization.this.model = new IndexedLogTableModel(LogTableVisualization.this.mraPanel.getSource(), LogTableVisualization.this.log.name(), initTime + (long)LogTableVisualization.this.rangeSlider.getValue(), initTime + (long)LogTableVisualization.this.rangeSlider.getUpperValue());
            LogTableVisualization.this.table.setModel((TableModel)LogTableVisualization.this.model);
            LogTableVisualization.this.table.revalidate();
            LogTableVisualization.this.table.repaint();
        }
    });
    private long finalTime;
    private long initTime;
    JLabel lblInitTime = new JLabel();
    JLabel lblFinalTime = new JLabel();

    public LogTableVisualization(IMraLog source, MRAPanel panel) {
        this.log = source;
        this.mraPanel = panel;
        this.fmt.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    @Override
    public String getName() {
        return this.log.name();
    }

    @Override
    public Component getComponent(IMraLogGroup source, double timestep) {
        this.model = new IndexedLogTableModel(source, this.log.name());
        this.table = new JXTable(this.model){

            public TableCellRenderer getCellRenderer(int row, int column) {
                return new DefaultCellRenderer(){

                    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                        if (column == 0 && value != null) {
                            this.setText(LogTableVisualization.this.fmt.format(new Date((Long)value)));
                        }
                        if (LogTableVisualization.this.markerList.containsKey(row)) {
                            this.setForeground(Color.RED);
                            this.setToolTipText("Marker: " + LogTableVisualization.this.markerList.get(row).getLabel());
                        }
                        return this;
                    }
                };
            }
        };
        this.table.setAutoCreateRowSorter(true);
        this.table.setFillsViewportHeight(true);
        this.table.setCellSelectionEnabled(true);
        this.table.setSelectionMode(2);
        this.table.setHighlighters(new Highlighter[]{HighlighterFactory.createAlternateStriping()});
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (LogTableVisualization.this.table.getSelectedRow() != -1 && e.getClickCount() == 2) {
                    int msgIndex = LogTableVisualization.this.table.convertRowIndexToModel(LogTableVisualization.this.table.getSelectedRow());
                    LogTableVisualization.this.mraPanel.loadVisualization(new MessageHtmlVisualization(LogTableVisualization.this.model.getMessage(msgIndex)), true);
                }
            }
        });
        this.table.setAutoResizeMode(0);
        LsfIndex idx = source.getLsfIndex();
        this.finalTime = (long)(idx.getEndTime() * 1000.0);
        this.initTime = (long)(idx.getStartTime() * 1000.0);
        if (this.finalTime < this.initTime) {
            return new JLabel(I18n.text("Cannot show visualization because messages are unordered"));
        }
        this.rangeSlider = new RangeSlider(0, (int)(this.finalTime - this.initTime));
        this.rangeSlider.setUpperValue((int)(this.finalTime - this.initTime));
        this.rangeSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                LogTableVisualization.this.lblInitTime.setText(LogTableVisualization.this.fmt.format(new Date((long)LogTableVisualization.this.rangeSlider.getValue() + LogTableVisualization.this.initTime)));
                LogTableVisualization.this.lblFinalTime.setText(LogTableVisualization.this.fmt.format(new Date((long)LogTableVisualization.this.rangeSlider.getUpperValue() + LogTableVisualization.this.initTime)));
            }
        });
        this.rangeSlider.setValue(0);
        this.panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0), I18n.textf("%msgtype messages", this.log.name())));
        this.panel.add((Component)new JScrollPane((Component)this.table), "w 100%, h 100%, wrap");
        this.panel.add((Component)this.lblInitTime, "split");
        this.panel.add((Component)this.rangeSlider, "w 100%");
        this.panel.add((Component)this.lblFinalTime, "");
        this.panel.add((Component)this.btnFilter, "wrap");
        return this.panel;
    }

    @Override
    public boolean canBeApplied(IMraLogGroup source) {
        return true;
    }

    @Override
    public ImageIcon getIcon() {
        return ImageUtils.getIcon("images/menus/table.png");
    }

    @Override
    public Double getDefaultTimeStep() {
        return null;
    }

    @Override
    public boolean supportsVariableTimeSteps() {
        return false;
    }

    @Override
    public MRAVisualization.Type getType() {
        return MRAVisualization.Type.TABLE;
    }

    @Override
    public void onCleanup() {
        this.mraPanel = null;
    }

    @Override
    public void onHide() {
    }

    @Override
    public void onShow() {
    }

    @Override
    public void addLogMarker(LogMarker marker) {
        Long timestamp = new Double(marker.getTimestamp()).longValue();
        for (int i = 0; i < this.log.getNumberOfEntries() - 1; ++i) {
            if (timestamp >= (Long)this.model.getValueAt(i, 0) - 10L) continue;
            this.markerList.put(i, marker);
            break;
        }
        this.model.fireTableDataChanged();
    }

    @Override
    public void removeLogMarker(LogMarker marker) {
        for (Integer m : this.markerList.keySet()) {
            if (marker.getTimestamp() != this.markerList.get(m).getTimestamp()) continue;
            this.markerList.remove(m);
            this.model.fireTableDataChanged();
            break;
        }
    }

    @Override
    public void GotoMarker(LogMarker marker) {
    }
}

