/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.util.llf;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.LinkedHashMap;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.mra.LogMarker;
import pt.lsts.neptus.mra.MRAPanel;
import pt.lsts.neptus.mra.importers.IMraLogGroup;
import pt.lsts.neptus.mra.plots.GenericPlot;
import pt.lsts.neptus.mra.visualizations.MRAVisualization;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.ImageUtils;
import pt.lsts.neptus.util.llf.LogTableVisualization;
import pt.lsts.neptus.util.llf.LsfReportProperties;
import pt.lsts.neptus.util.llf.MessageHtmlVisualization;

public class LogTree
extends JTree {
    MRAPanel panel;
    LinkedHashMap<String, Component> visList = new LinkedHashMap();
    IMraLogGroup source;
    private DefaultMutableTreeNode root = new DefaultMutableTreeNode("root");
    DefaultMutableTreeNode visualizationsNode = new DefaultMutableTreeNode(I18n.text("Visualizations"));
    DefaultMutableTreeNode chartsNode = new DefaultMutableTreeNode(I18n.text("Charts"));
    DefaultMutableTreeNode tablesNode = new DefaultMutableTreeNode(I18n.text("Tables"));
    DefaultMutableTreeNode markersNode;
    DefaultMutableTreeNode newPlotNode = new DefaultMutableTreeNode(I18n.text("New Plot"));
    DefaultTreeModel treeModel = new DefaultTreeModel(this.root);
    DefaultTreeCellRenderer treeRenderer = new DefaultTreeCellRenderer(){
        private LinkedHashMap<Object, ImageIcon> iconCache = new LinkedHashMap();

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            if (node.getUserObject() instanceof MRAVisualization) {
                MRAVisualization viz = (MRAVisualization)node.getUserObject();
                this.setText(viz.getName());
                if (!this.iconCache.containsKey(viz)) {
                    this.iconCache.put(viz, viz.getIcon());
                }
                this.setIcon(this.iconCache.get(viz));
            }
            if (node.getUserObject() instanceof LogMarker) {
                LogMarker mark = (LogMarker)node.getUserObject();
                this.setText(mark.getLabel());
                if (!this.iconCache.containsKey("markers")) {
                    this.iconCache.put("markers", ImageUtils.getIcon("images/menus/marker.png"));
                }
                this.setIcon(this.iconCache.get("markers"));
            }
            return this;
        }
    };
    MouseAdapter mouseAdapter = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getButton() == 1) {
                TreePath path;
                if (e.getClickCount() == 1) {
                    // empty if block
                }
                if (e.getClickCount() == 2 && (path = LogTree.this.getPathForLocation(e.getX(), e.getY())) != null) {
                    DefaultMutableTreeNode n = (DefaultMutableTreeNode)path.getLastPathComponent();
                    if (n.getUserObject() instanceof MRAVisualization) {
                        LogTree.this.panel.openVisualization((MRAVisualization)n.getUserObject());
                    }
                    if (n == LogTree.this.newPlotNode) {
                        NeptusLog.pub().info((Object)"<###>New Plot");
                    }
                    if (n.getUserObject() instanceof LogMarker) {
                        LogTree.this.panel.synchVisualizations((LogMarker)n.getUserObject());
                    }
                }
            }
            if (e.getButton() == 3) {
                JPopupMenu menu = new JPopupMenu();
                TreePath path = LogTree.this.getPathForLocation(e.getX(), e.getY());
                LogTree.this.setSelectionPath(path);
                boolean showMenu = false;
                if (path != null) {
                    final DefaultMutableTreeNode n = (DefaultMutableTreeNode)path.getLastPathComponent();
                    if (n.getUserObject() instanceof MRAVisualization) {
                        // empty if block
                    }
                    if (n.getUserObject() instanceof LogMarker) {
                        menu.add(new AbstractAction(I18n.text("Remove")){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                if (LsfReportProperties.generatingReport) {
                                    GuiUtils.infoMessage(LogTree.this.panel.getRootPane(), I18n.text("Can not remove Marks"), I18n.text("Can not remove Marks - Generating Report."));
                                    return;
                                }
                                LogTree.this.panel.removeMarker((LogMarker)n.getUserObject());
                            }
                        });
                        menu.add(new AbstractAction(I18n.text("GoTo")){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                LogTree.this.panel.synchVisualizations((LogMarker)n.getUserObject());
                            }
                        });
                        showMenu = true;
                    } else if (n.getUserObject() instanceof LogTableVisualization || n.getUserObject() instanceof GenericPlot || n.getUserObject() instanceof MessageHtmlVisualization) {
                        menu.add(new AbstractAction("Remove"){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                LogTree.this.panel.removeTreeObject(n.getUserObject());
                            }
                        });
                        showMenu = true;
                    }
                    if (showMenu) {
                        menu.show(LogTree.this, e.getX(), e.getY());
                    }
                }
            }
            super.mouseClicked(e);
        }
    };

    public LogTree(IMraLogGroup source, MRAPanel panel) {
        this.source = source;
        this.panel = panel;
        this.setModel(this.treeModel);
        this.setCellRenderer(this.treeRenderer);
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        this.addMouseListener(this.mouseAdapter);
        this.loadDefaultNodes();
        this.treeModel.nodeStructureChanged(this.root);
    }

    public void loadDefaultNodes() {
        this.root.add(this.visualizationsNode);
        this.root.add(this.chartsNode);
        this.root.add(this.tablesNode);
    }

    public void addVisualization(MRAVisualization vis) {
        DefaultMutableTreeNode parent;
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(vis);
        switch (vis.getType()) {
            case VISUALIZATION: {
                parent = this.visualizationsNode;
                break;
            }
            case CHART: {
                parent = this.chartsNode;
                break;
            }
            case TABLE: {
                parent = this.tablesNode;
                break;
            }
            default: {
                parent = this.visualizationsNode;
            }
        }
        parent.add(node);
        this.treeModel.nodeStructureChanged(this.root);
        this.expandAllTree();
    }

    public void remove(Object obj, DefaultMutableTreeNode parent) {
        for (int i = 0; i < parent.getChildCount(); ++i) {
            if (!(parent.getChildAt(i) instanceof DefaultMutableTreeNode)) continue;
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)parent.getChildAt(i);
            if (!node.isLeaf()) {
                this.remove(obj, node);
                continue;
            }
            if (!node.isLeaf() || !node.getUserObject().equals(obj)) continue;
            parent.remove(node);
            if (parent.getChildCount() == 0 && parent.getParent() instanceof DefaultMutableTreeNode) {
                ((DefaultMutableTreeNode)parent.getParent()).remove(parent);
            }
            this.treeModel.nodeStructureChanged(this.root);
            this.expandAllTree();
            return;
        }
    }

    public void remove(Object obj) {
        this.remove(obj, this.root);
    }

    public void addMarker(LogMarker marker) {
        if (this.markersNode == null) {
            this.markersNode = new DefaultMutableTreeNode(I18n.text("Markers"));
            this.root.add(this.markersNode);
        }
        this.markersNode.add(new DefaultMutableTreeNode(marker));
        this.treeModel.nodeStructureChanged(this.root);
        this.expandAllTree();
    }

    public void removeMarker(LogMarker marker) {
        for (int i = 0; i < this.markersNode.getChildCount(); ++i) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.markersNode.getChildAt(i);
            if ((LogMarker)node.getUserObject() != marker) continue;
            this.markersNode.remove(node);
        }
        if (this.markersNode.getChildCount() == 0) {
            this.root.remove(this.markersNode);
            this.markersNode = null;
        }
        this.treeModel.nodeStructureChanged(this.root);
        this.expandAllTree();
    }

    private void expandAllTree() {
        for (int i = 0; i < this.getRowCount(); ++i) {
            this.expandRow(i);
        }
    }
}

