/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.util.llf;

import com.lowagie.text.Document;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.jfree.chart.JFreeChart;
import pt.lsts.imc.IMCMessage;
import pt.lsts.imc.LblBeacon;
import pt.lsts.imc.SonarData;
import pt.lsts.imc.VehicleCommand;
import pt.lsts.imc.lsf.LsfIndex;
import pt.lsts.imc.lsf.LsfIterator;
import pt.lsts.imc.types.PlanSpecificationAdapter;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.comm.manager.imc.ImcId16;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.mp.Maneuver;
import pt.lsts.neptus.mp.ManeuverFactory;
import pt.lsts.neptus.mp.OperationLimits;
import pt.lsts.neptus.mp.SystemPositionAndAttitude;
import pt.lsts.neptus.mp.maneuvers.Elevator;
import pt.lsts.neptus.mp.maneuvers.FollowPath;
import pt.lsts.neptus.mp.maneuvers.FollowTrajectory;
import pt.lsts.neptus.mp.maneuvers.Goto;
import pt.lsts.neptus.mp.maneuvers.IMCSerialization;
import pt.lsts.neptus.mp.maneuvers.Loiter;
import pt.lsts.neptus.mp.maneuvers.PopUp;
import pt.lsts.neptus.mp.maneuvers.RowsManeuver;
import pt.lsts.neptus.mp.maneuvers.StationKeeping;
import pt.lsts.neptus.mp.maneuvers.Unconstrained;
import pt.lsts.neptus.mp.maneuvers.YoYo;
import pt.lsts.neptus.mra.LogMarker;
import pt.lsts.neptus.mra.api.CorrectedPosition;
import pt.lsts.neptus.mra.importers.IMraLog;
import pt.lsts.neptus.mra.importers.IMraLogGroup;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.neptus.types.coord.CoordinateSystem;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.map.MapGroup;
import pt.lsts.neptus.types.map.MapType;
import pt.lsts.neptus.types.map.MarkElement;
import pt.lsts.neptus.types.map.PathElement;
import pt.lsts.neptus.types.map.TransponderElement;
import pt.lsts.neptus.types.mission.MapMission;
import pt.lsts.neptus.types.mission.MissionType;
import pt.lsts.neptus.types.mission.plan.PlanType;
import pt.lsts.neptus.types.vehicle.VehicleType;
import pt.lsts.neptus.types.vehicle.VehiclesHolder;
import pt.lsts.neptus.util.DateTimeUtil;
import pt.lsts.neptus.util.FileUtil;
import pt.lsts.neptus.util.GuiUtils;

public class LogUtils {
    public static LinkedHashMap<String, String> generateStatistics(IMraLogGroup source) {
        if (source.getLog("EstimatedState") == null) {
            return new LinkedHashMap<String, String>();
        }
        IMraLog parser = source.getLog("EstimatedState");
        IMCMessage entry = parser.firstLogEntry();
        long startMillis = parser.getCurrentEntry().getTimestampMillis();
        long startMillis2 = parser.firstLogEntry().getTimestampMillis();
        NeptusLog.pub().info((Object)("<###> " + startMillis + "" + startMillis2));
        double lastTime = 0.0;
        double maxDepth = 0.0;
        double avgDepth = entry.getDouble("depth");
        double maxRoll = 0.0;
        double minRoll = 0.0;
        double maxPitch = 0.0;
        double minPitch = 0.0;
        long numStates = 1L;
        double avgRoll = entry.getDouble("phi");
        double avgPitch = entry.getDouble("theta");
        double distance = 0.0;
        IMCMessage prevEntry = null;
        CorrectedPosition corPosition = new CorrectedPosition(source);
        LocationType lastLoc = null;
        for (SystemPositionAndAttitude loc : corPosition.getPositions()) {
            if (lastLoc != null) {
                distance += loc.getPosition().getDistanceInMeters(lastLoc);
            }
            lastLoc = loc.getPosition();
        }
        while ((entry = parser.nextLogEntry()) != null) {
            double depth = entry.getDouble("depth");
            maxDepth = Math.max(maxDepth, entry.getDouble("depth"));
            double phi = entry.getDouble("phi");
            double theta = entry.getDouble("theta");
            maxRoll = Math.max(maxRoll, phi);
            minRoll = Math.min(minRoll, phi);
            maxPitch = Math.max(maxPitch, theta);
            minPitch = Math.min(minPitch, theta);
            avgDepth = (avgDepth * (double)numStates + depth) / (double)(numStates + 1L);
            avgRoll = (avgRoll * (double)numStates + phi) / (double)(numStates + 1L);
            avgPitch = (avgPitch * (double)numStates + theta) / (double)(numStates + 1L);
            ++numStates;
            prevEntry = entry;
            lastTime = prevEntry.getTimestamp();
        }
        lastTime = parser.getLastEntry().getTimestamp();
        LinkedHashMap<String, String> stats = new LinkedHashMap<String, String>();
        long endMillis = (long)(lastTime * 1000.0);
        Date ds = new Date(startMillis);
        Date df = new Date(endMillis);
        stats.put(I18n.text("Vehicle"), "" + LogUtils.getVehicle(source));
        stats.put(I18n.text("Mission start time"), "" + ds);
        stats.put(I18n.text("Mission end time"), "" + df);
        stats.put(I18n.text("Mission duration"), DateTimeUtil.milliSecondsToFormatedString(endMillis - startMillis));
        stats.put(I18n.text("Maximum depth"), GuiUtils.getNeptusDecimalFormat(2).format(maxDepth) + " " + I18n.textc("m", "meters"));
        stats.put(I18n.text("Avg depth"), GuiUtils.getNeptusDecimalFormat(2).format(avgDepth) + " " + I18n.textc("m", "meters"));
        stats.put(I18n.text("Roll min/max/amp/avg"), GuiUtils.getNeptusDecimalFormat(2).format(Math.toDegrees(minRoll)) + "\u00b0 / " + GuiUtils.getNeptusDecimalFormat(2).format(Math.toDegrees(maxRoll)) + "\u00b0 / " + GuiUtils.getNeptusDecimalFormat(2).format(Math.toDegrees(maxRoll - minRoll)) + "\u00b0 / " + GuiUtils.getNeptusDecimalFormat(2).format(Math.toDegrees(avgRoll)) + "\u00b0");
        stats.put(I18n.text("Pitch min/max/amp/avg"), GuiUtils.getNeptusDecimalFormat(2).format(Math.toDegrees(minPitch)) + "\u00b0 / " + GuiUtils.getNeptusDecimalFormat(2).format(Math.toDegrees(maxPitch)) + "\u00b0 / " + GuiUtils.getNeptusDecimalFormat(2).format(Math.toDegrees(maxPitch - minPitch)) + "\u00b0 / " + GuiUtils.getNeptusDecimalFormat(2).format(Math.toDegrees(avgPitch)) + "\u00b0");
        stats.put(I18n.text("Distance travelled"), GuiUtils.getNeptusDecimalFormat(2).format(distance) + " " + I18n.textc("m", "meters"));
        stats.put(I18n.text("Mean speed"), GuiUtils.getNeptusDecimalFormat(2).format(distance / ((double)(endMillis - startMillis) / 1000.0)) + " " + I18n.text("m/s"));
        LocationType loc = LogUtils.getHomeRef(source);
        if (loc != null) {
            stats.put(I18n.text("Home Latitude"), loc.getLatitudeAsPrettyString());
            stats.put(I18n.text("Home Longitude"), loc.getLongitudeAsPrettyString());
        }
        return stats;
    }

    public static Date getStartDate(IMraLogGroup source) {
        if (source.getLog("EstimatedState") == null) {
            return null;
        }
        long startMillis = source.getLog("EstimatedState").currentTimeMillis();
        return new Date(startMillis);
    }

    public static Date[] getMessageMinMaxDates(IMraLog msgLog) {
        if (msgLog == null) {
            return null;
        }
        long startMillis = msgLog.firstLogEntry().getTimestampMillis();
        long endMillis = msgLog.getLastEntry().getTimestampMillis();
        return new Date[]{new Date(startMillis), new Date(endMillis)};
    }

    public static MissionType generateMission(IMraLogGroup source) {
        TransponderElement[] te;
        MissionType mission = new MissionType();
        LocationType lt = LogUtils.getHomeRef(source);
        if (lt != null) {
            CoordinateSystem cs = new CoordinateSystem();
            cs.setLocation(lt);
            mission.setHomeRef(cs);
        }
        MapType map = new MapType();
        MapMission mm = new MapMission();
        mm.setId(map.getId());
        mm.setMap(map);
        MarkElement start = new MarkElement();
        start.setId("start");
        map.addObject(start);
        LocationType sloc = LogUtils.getStartupPoint(source);
        if (sloc != null) {
            start.setCenterLocation(sloc);
        } else {
            start.setCenterLocation(new LocationType(mission.getHomeRef()));
        }
        mission.addMap(mm);
        for (TransponderElement t : te = LogUtils.getTransponders(source)) {
            t.setParentMap(map);
            t.setMapGroup(map.getMapGroup());
            map.addObject(t);
        }
        return mission;
    }

    public static LocationType getHomeRef(IMraLogGroup source) {
        IMraLog parser = source.getLog("HomeRef");
        if (parser != null) {
            IMCMessage lastEntry = parser.getLastEntry();
            double lat = lastEntry.getDouble("lat");
            double lon = lastEntry.getDouble("lon");
            double depth = lastEntry.getDouble("depth");
            lat = Math.toDegrees(lat);
            lon = Math.toDegrees(lon);
            LocationType center = new LocationType();
            center.setLatitudeDegs(lat);
            center.setLongitudeDegs(lon);
            center.setDepth(depth);
            return center;
        }
        if (source.getLog("EstimatedState") != null) {
            IMCMessage lastEntry = source.getLog("EstimatedState").getLastEntry();
            double lat = lastEntry.getDouble("lat");
            double lon = lastEntry.getDouble("lon");
            double depth = lastEntry.getDouble("depth");
            lat = Math.toDegrees(lat);
            lon = Math.toDegrees(lon);
            LocationType center = new LocationType();
            center.setLatitudeDegs(lat);
            center.setLongitudeDegs(lon);
            center.setDepth(depth);
            return center;
        }
        return null;
    }

    public static OperationLimits getOperationLimits(IMraLogGroup source) {
        IMraLog parser = source.getLog("OperationalLimits");
        if (parser == null) {
            return null;
        }
        IMCMessage lastEntry = parser.getLastEntry();
        if (lastEntry == null) {
            return null;
        }
        OperationLimits limits = new OperationLimits();
        LinkedHashMap bitmask = lastEntry.getBitmask("mask");
        if (((Boolean)bitmask.get("MAX_DEPTH")).booleanValue()) {
            limits.setMaxDepth(lastEntry.getDouble("max_depth"));
        }
        if (((Boolean)bitmask.get("MIN_ALT")).booleanValue()) {
            limits.setMinAltitude(lastEntry.getDouble("min_altitude"));
        }
        if (((Boolean)bitmask.get("MAX_ALT")).booleanValue()) {
            limits.setMaxAltitude(lastEntry.getDouble("max_altitude"));
        }
        if (((Boolean)bitmask.get("MIN_SPEED")).booleanValue()) {
            limits.setMinSpeed(lastEntry.getDouble("min_speed"));
        }
        if (((Boolean)bitmask.get("MAX_SPEED")).booleanValue()) {
            limits.setMaxSpeed(lastEntry.getDouble("max_speed"));
        }
        if (((Boolean)bitmask.get("MAX_VRATE")).booleanValue()) {
            limits.setMaxVertRate(lastEntry.getDouble("max_vrate"));
        }
        if (((Boolean)bitmask.get("AREA")).booleanValue()) {
            limits.setOpAreaLat(Math.toDegrees(lastEntry.getDouble("lat")));
            limits.setOpAreaLon(Math.toDegrees(lastEntry.getDouble("lon")));
            limits.setOpRotationRads(lastEntry.getDouble("orientation"));
            limits.setOpAreaWidth(lastEntry.getDouble("width"));
            limits.setOpAreaLength(lastEntry.getDouble("length"));
        }
        return limits;
    }

    public static LocationType getStartupPoint(IMraLogGroup source, int src) {
        IMraLog parser = source.getLog("NavigationStartupPoint");
        if (parser != null) {
            IMCMessage entry = parser.getCurrentEntry();
            while (entry != null) {
                if (entry.getHeader().getInteger("src") != src) {
                    entry = parser.nextLogEntry();
                    continue;
                }
                double lat = entry.getDouble("lat");
                double lon = entry.getDouble("lon");
                double depth = entry.getDouble("depth");
                lat = Math.toDegrees(lat);
                lon = Math.toDegrees(lon);
                LocationType center = new LocationType();
                center.setLatitudeDegs(lat);
                center.setLongitudeDegs(lon);
                center.setDepth(depth);
                return center;
            }
        }
        return null;
    }

    public static LocationType getStartupPoint(IMraLogGroup source) {
        IMraLog parser = source.getLog("NavigationStartupPoint");
        if (parser != null) {
            IMCMessage lastEntry = parser.getLastEntry();
            double lat = lastEntry.getDouble("lat");
            double lon = lastEntry.getDouble("lon");
            double depth = lastEntry.getDouble("depth");
            lat = Math.toDegrees(lat);
            lon = Math.toDegrees(lon);
            LocationType center = new LocationType();
            center.setLatitudeDegs(lat);
            center.setLongitudeDegs(lon);
            center.setDepth(depth);
            return center;
        }
        return null;
    }

    public static TransponderElement[] getTransponders(IMraLogGroup source) {
        IMraLog parser = source.getLog("LblConfig");
        if (parser == null) {
            return new TransponderElement[0];
        }
        Vector<TransponderElement> transp = new Vector<TransponderElement>();
        try {
            IMCMessage config = parser.getLastEntry();
            if (config.getMessageList("beacons") != null) {
                for (IMCMessage lblBeacon : config.getMessageList("beacons")) {
                    String beacon = lblBeacon.getString("beacon");
                    double lat = Math.toDegrees(lblBeacon.getDouble("lat"));
                    double lon = Math.toDegrees(lblBeacon.getDouble("lon"));
                    double depth = lblBeacon.getDouble("depth");
                    TransponderElement el = new TransponderElement();
                    LocationType lt = new LocationType();
                    lt.setLatitudeDegs(lat);
                    lt.setLongitudeDegs(lon);
                    lt.setDepth(depth);
                    el.setId(beacon);
                    el.setCenterLocation(lt);
                    transp.add(el);
                }
            } else {
                for (int i = 0; i < 6; ++i) {
                    IMCMessage msg = config.getMessage("beacon" + i);
                    if (msg == null) continue;
                    LblBeacon lblBeacon = LblBeacon.clone((IMCMessage)msg);
                    String beacon = lblBeacon.getBeacon();
                    double lat = Math.toDegrees(lblBeacon.getLat());
                    double lon = Math.toDegrees(lblBeacon.getLon());
                    double depth = lblBeacon.getDepth();
                    TransponderElement el = new TransponderElement();
                    LocationType lt = new LocationType();
                    lt.setLatitudeDegs(lat);
                    lt.setLongitudeDegs(lon);
                    lt.setDepth(depth);
                    el.setId(beacon);
                    el.setCenterLocation(lt);
                    transp.add(el);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return transp.toArray(new TransponderElement[0]);
    }

    public static boolean isValidLogFolder(File dir) {
        if (!dir.isDirectory() || !dir.canRead()) {
            return false;
        }
        for (File f : dir.listFiles()) {
            if (FileUtil.getFileExtension(f).equalsIgnoreCase("llf")) {
                return f.canRead();
            }
            if (!f.getName().equalsIgnoreCase("data.bsf")) continue;
            return f.canRead();
        }
        return false;
    }

    public static boolean isValidZipSource(File zipFile) {
        try {
            ZipInputStream zis = new ZipInputStream(new FileInputStream(zipFile));
            ZipEntry ze = zis.getNextEntry();
            while (ze != null) {
                if (FileUtil.getFileExtension(ze.getName()).equalsIgnoreCase("llf")) {
                    zis.close();
                    return true;
                }
                ze = zis.getNextEntry();
            }
            zis.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static LogValidity isValidLSFSource(File dir) {
        if (!dir.isDirectory() || !dir.canRead()) {
            return LogValidity.NO_DIRECTORY;
        }
        int lsfFx = 0;
        int lsfGzFx = 0;
        int lsfBZip2Fx = 0;
        int defXmlFx = 0;
        block12: for (File f : dir.listFiles()) {
            switch (FileUtil.getFileExtension(f)) {
                case "lsf": {
                    lsfFx = (short)(lsfFx + 1);
                    continue block12;
                }
                case "gz": {
                    String fex = FileUtil.getFileNameWithoutExtension(f.getName());
                    if (FileUtil.getFileExtension(fex).equalsIgnoreCase("lsf")) {
                        lsfGzFx = (short)(lsfGzFx + 1);
                        continue block12;
                    }
                    if (!FileUtil.getFileExtension(fex).equalsIgnoreCase("xml")) continue block12;
                    defXmlFx = (short)(defXmlFx + 1);
                    continue block12;
                }
                case "xml": {
                    defXmlFx = (short)(defXmlFx + 1);
                    continue block12;
                }
                case "bz2": {
                    String fex = FileUtil.getFileNameWithoutExtension(f.getName());
                    if (!FileUtil.getFileExtension(fex).equalsIgnoreCase("lsf")) continue block12;
                    lsfBZip2Fx = (short)(lsfBZip2Fx + 1);
                    continue block12;
                }
            }
        }
        if (lsfFx + lsfGzFx + lsfBZip2Fx > 0 && defXmlFx > 0) {
            return LogValidity.VALID;
        }
        if (lsfFx + lsfGzFx + lsfBZip2Fx == 0) {
            return LogValidity.NO_VALID_LOG_FILE;
        }
        return LogValidity.NO_XML_DEFS;
    }

    public static PlanType generatePlan(MissionType mt, IMraLogGroup source) {
        try {
            IMraLog log = source.getLog("PlanSpecification");
            if (log == null || log.getNumberOfEntries() > 1) {
                return LogUtils.generatePlanFromVehicleCommands(mt, source);
            }
            PlanSpecificationAdapter imcPlan = new PlanSpecificationAdapter(log.getLastEntry());
            PlanType plan = new PlanType(mt);
            plan.setId(imcPlan.getPlanId());
            for (String manId : imcPlan.getAllManeuvers().keySet()) {
                IMCMessage maneuver = (IMCMessage)imcPlan.getAllManeuvers().get(manId);
                Maneuver man = LogUtils.parseManeuver(manId, maneuver);
                plan.getGraph().addManeuver(man);
            }
            for (PlanSpecificationAdapter.Transition imcTransition : imcPlan.getAllTransitions()) {
                plan.getGraph().addTransition(imcTransition.getSourceManeuver(), imcTransition.getDestManeuver(), imcTransition.getConditions());
            }
            plan.getGraph().setInitialManeuver(imcPlan.getFirstManeuverId());
            return plan;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static PlanType generatePlanFromVehicleCommands(MissionType mt, IMraLogGroup source) {
        try {
            IMraLog log = source.getLog("VehicleCommand");
            if (log == null) {
                return null;
            }
            PlanType pt = new PlanType(mt);
            pt.setId("Executed");
            IMCMessage msg = log.nextLogEntry();
            int count = 1;
            while (msg != null) {
                pt.lsts.imc.Maneuver maneuver;
                VehicleCommand cmd = VehicleCommand.clone((IMCMessage)msg);
                if (cmd.getType() == VehicleCommand.TYPE.REQUEST && cmd.getCommand() == VehicleCommand.COMMAND.EXEC_MANEUVER && (maneuver = cmd.getManeuver()) != null) {
                    String id = "" + count++;
                    Maneuver man = LogUtils.parseManeuver(id, (IMCMessage)maneuver);
                    pt.getGraph().addManeuver(man);
                }
                msg = log.nextLogEntry();
            }
            return pt;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected static Maneuver parseManeuver(String manId, IMCMessage msg) {
        String manType = msg.getAbbrev();
        Maneuver maneuver = null;
        if ("Goto".equalsIgnoreCase(manType)) {
            maneuver = new Goto();
        } else if ("Popup".equalsIgnoreCase(manType)) {
            maneuver = new PopUp();
        } else if ("Loiter".equalsIgnoreCase(manType)) {
            maneuver = new Loiter();
        } else if ("Teleoperation".equalsIgnoreCase(manType)) {
            maneuver = new Unconstrained();
        } else if ("Rows".equalsIgnoreCase(manType)) {
            maneuver = new RowsManeuver();
        } else if ("FollowTrajectory".equalsIgnoreCase(manType)) {
            maneuver = new FollowTrajectory();
        } else if ("FollowPath".equalsIgnoreCase(manType)) {
            maneuver = FollowPath.createFollowPathOrPattern(msg);
        } else if ("StationKeeping".equalsIgnoreCase(manType)) {
            maneuver = new StationKeeping();
        } else if ("Elevator".equalsIgnoreCase(manType)) {
            maneuver = new Elevator();
        } else if ("YoYo".equalsIgnoreCase(manType)) {
            maneuver = new YoYo();
        } else {
            try {
                maneuver = ManeuverFactory.createManeuver(manType, "pt.lsts.neptus.mp.maneuvers." + manType);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (maneuver == null) {
            return null;
        }
        ((Maneuver)maneuver).setId(manId);
        if (maneuver instanceof IMCSerialization) {
            ((IMCSerialization)((Object)maneuver)).parseIMCMessage(msg);
        }
        return maneuver;
    }

    public static String parseInlineName(String data) {
        if (data.startsWith("%INLINE{")) {
            return data.substring("%INLINE{".length(), data.length() - 1);
        }
        return null;
    }

    public static LocationType getLocation(IMCMessage estimatedStateMessage) {
        try {
            if (estimatedStateMessage != null) {
                LocationType loc = new LocationType();
                long refMode = estimatedStateMessage.getLong("ref");
                if (!estimatedStateMessage.getMessageType().getFieldNames().contains("ref")) {
                    refMode = 2L;
                }
                if (refMode == 1L || refMode == 2L) {
                    loc.setLatitudeRads(estimatedStateMessage.getDouble("lat"));
                    loc.setLongitudeRads(estimatedStateMessage.getDouble("lon"));
                    loc.setDepth(estimatedStateMessage.getDouble("depth"));
                }
                if (refMode == 0L || refMode == 2L) {
                    loc.translatePosition(estimatedStateMessage.getDouble("x"), estimatedStateMessage.getDouble("y"), estimatedStateMessage.getDouble("z"));
                }
                loc.convertToAbsoluteLatLonDepth();
                return loc;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static LocationType getLocation(LocationType baseLoc, IMCMessage estimatedStateEntry) {
        LocationType loc = LogUtils.getLocation(estimatedStateEntry);
        if (loc == null) {
            return null;
        }
        long refMode = estimatedStateEntry.getLong("ref");
        if (refMode == 0L) {
            loc.setLatitudeDegs(baseLoc.getLatitudeDegs());
            loc.setLongitudeDegs(baseLoc.getLongitudeDegs());
            loc.setDepth(baseLoc.getDepth());
        }
        return loc;
    }

    public static PathElement generatePath(MissionType mission, IMraLogGroup source) {
        MapType mt = new MapType();
        LocationType lt = new LocationType(mission.getStartLocation());
        PathElement pe = new PathElement(MapGroup.getMapGroupInstance(mission), mt, lt);
        pe.setParentMap(mt);
        mt.addObject(pe);
        IMraLog parser = source.getLog("EstimatedState");
        if (parser == null) {
            return pe;
        }
        IMCMessage entry = parser.nextLogEntry();
        LocationType tmp = new LocationType();
        while (entry != null) {
            double depth;
            double lon;
            double lat;
            parser.advance(100L);
            entry = parser.nextLogEntry();
            if (entry == null) continue;
            long refMode = entry.getLong("ref");
            if (refMode == 0L) {
                pe.addPoint(entry.getDouble("y"), entry.getDouble("x"), entry.getDouble("z"), false);
                continue;
            }
            if (refMode == 1L) {
                lat = entry.getDouble("lat");
                lon = entry.getDouble("lon");
                depth = entry.getDouble("depth");
                if (lat == tmp.getLatitudeDegs() || lon == tmp.getLongitudeDegs()) continue;
                tmp.setLatitudeDegs(Math.toDegrees(lat));
                tmp.setLongitudeDegs(Math.toDegrees(lon));
                tmp.setDepth(depth);
                double[] offs = tmp.getOffsetFrom(mission.getStartLocation());
                pe.addPoint(offs[1], offs[0], offs[2], false);
                continue;
            }
            if (refMode != 2L) continue;
            lat = entry.getDouble("lat");
            lon = entry.getDouble("lon");
            depth = entry.getDouble("depth");
            double x = entry.getDouble("x");
            double y = entry.getDouble("y");
            double z = entry.getDouble("z");
            tmp.setLatitudeDegs(Math.toDegrees(lat));
            tmp.setLongitudeDegs(Math.toDegrees(lon));
            tmp.setDepth(depth);
            double[] offs = tmp.getOffsetFrom(mission.getStartLocation());
            pe.addPoint(offs[1] + y, offs[0] + x, offs[2] + z, false);
        }
        pe.setMyColor(Color.green);
        pe.setFinished(true);
        MapMission mm = new MapMission();
        mm.setId(mt.getId());
        mm.setMap(mt);
        mission.addMap(mm);
        MapGroup.getMapGroupInstance(mission).addMap(mt);
        return pe;
    }

    public static PathElement generatePath(MissionType mission, Vector<LocationType> locations) {
        MapType mt = new MapType();
        LocationType first = locations.firstElement();
        locations.remove(0);
        PathElement pe = new PathElement(MapGroup.getMapGroupInstance(mission), mt, first);
        pe.setParentMap(mt);
        mt.addObject(pe);
        for (LocationType l : locations) {
            double[] offsets = l.getOffsetFrom(first);
            pe.addPoint(offsets[0], offsets[1], offsets[2], false);
        }
        pe.setMyColor(Color.green);
        pe.setFinished(true);
        MapMission mm = new MapMission();
        mm.setId(mt.getId());
        mm.setMap(mt);
        mission.addMap(mm);
        MapGroup.getMapGroupInstance(mission).addMap(mt);
        return pe;
    }

    public static VehicleType getVehicle(IMraLogGroup source) {
        String[] privateLogs;
        for (String privateLog : privateLogs = new String[]{"Voltage", "CpuUsage", "Temperature"}) {
            int src_id;
            VehicleType vt;
            IMCMessage msg;
            IMraLog log = source.getLog(privateLog);
            if (log == null || (msg = log.nextLogEntry()) == null || (vt = VehiclesHolder.getVehicleWithImc(new ImcId16(src_id = msg.getHeader().getInteger("src")))) == null) continue;
            return vt;
        }
        return null;
    }

    public static void saveCharAsPdf(JFreeChart chart, File outFile) {
        Rectangle pageSize = new Rectangle(1024.0f, 768.0f);
        try {
            FileOutputStream out = new FileOutputStream(outFile);
            Document doc = new Document(pageSize);
            PdfWriter writer = PdfWriter.getInstance((Document)doc, (OutputStream)out);
            writer.setPdfVersion('1');
            doc.open();
            PdfContentByte cb = writer.getDirectContent();
            int width = (int)pageSize.getWidth();
            int height = (int)pageSize.getHeight();
            PdfTemplate tp = cb.createTemplate((float)width, (float)height);
            Graphics2D g2 = tp.createGraphicsShapes((float)width, (float)height);
            chart.draw(g2, (Rectangle2D)new Rectangle2D.Double(0.0, 0.0, width, height));
            g2.dispose();
            cb.addTemplate(tp, 0.0f, 0.0f);
            doc.close();
            out.flush();
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void savePlanAsPdf(StateRenderer2D renderer, File outFile) {
        Rectangle pageSize = new Rectangle(800.0f, 600.0f);
        try {
            FileOutputStream out = new FileOutputStream(outFile);
            Document doc = new Document(pageSize);
            PdfWriter writer = PdfWriter.getInstance((Document)doc, (OutputStream)out);
            writer.setPdfVersion('1');
            doc.open();
            PdfContentByte cb = writer.getDirectContent();
            int width = (int)pageSize.getWidth();
            int height = (int)pageSize.getHeight();
            PdfTemplate tp = cb.createTemplate((float)width, (float)height);
            Graphics2D g2 = tp.createGraphicsShapes((float)width, (float)height);
            renderer.setSize(width, height);
            renderer.update(g2);
            g2.dispose();
            cb.addTemplate(tp, 0.0f, 0.0f);
            doc.close();
            out.flush();
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static LinkedHashMap<Integer, String> getEntities(IMraLogGroup source) {
        LinkedHashMap<Integer, String> entities = new LinkedHashMap<Integer, String>();
        entities.put(255, "Unknown");
        IMraLog parser = source.getLog("EntityInfo");
        if (parser != null) {
            IMCMessage entry = parser.nextLogEntry();
            while (entry != null) {
                try {
                    entities.put(entry.getInteger("id"), entry.getString("label"));
                }
                catch (Exception e) {
                    // empty catch block
                }
                entry = parser.nextLogEntry();
            }
        }
        return entities;
    }

    public static LinkedHashMap<Integer, String> getEntities(IMraLogGroup source, int srcId) {
        LinkedHashMap<Integer, String> entities = new LinkedHashMap<Integer, String>();
        entities.put(255, "Unknown");
        IMraLog parser = source.getLog("EntityInfo");
        if (parser != null) {
            IMCMessage entry = parser.nextLogEntry();
            while (entry != null) {
                if (entry.getHeader().getInteger("src") == srcId) {
                    try {
                        entities.put(entry.getInteger("id"), entry.getString("label"));
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                entry = parser.nextLogEntry();
            }
        }
        return entities;
    }

    public static ArrayList<LogMarker> getMarkersFromSource(IMraLogGroup source) {
        try {
            ObjectInputStream ois = new ObjectInputStream(new FileInputStream(source.getFile("Data.lsf").getParent() + "mra/marks.dat"));
            ArrayList markers = (ArrayList)ois.readObject();
            ois.close();
            return markers;
        }
        catch (Exception e) {
            return new ArrayList<LogMarker>();
        }
    }

    public static boolean hasIMCSidescan(IMraLogGroup source) {
        LsfIndex index = source.getLsfIndex();
        LsfIterator it = index.getIterator(SonarData.class);
        SonarData sd = (SonarData)it.next();
        if (sd == null) {
            return false;
        }
        while (sd != null) {
            if (sd.getType() == SonarData.TYPE.SIDESCAN) {
                return true;
            }
            sd = (SonarData)it.next();
        }
        return false;
    }

    public static void main(String[] args) {
        NeptusLog.pub().info((Object)("<###> " + LogUtils.parseInlineName("%INLINE{Goto}")));
        NeptusLog.pub().info((Object)("<###> " + LogUtils.parseInlineName("%INLINE{Popup}")));
    }

    public static enum LogValidity {
        VALID,
        NO_DIRECTORY,
        NO_XML_DEFS,
        NO_VALID_LOG_FILE;

    }
}

