/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.util.llf;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Vector;
import pt.lsts.imc.IMCDefinition;
import pt.lsts.imc.gz.MultiMemberGZIPInputStream;
import pt.lsts.imc.lsf.LsfIndex;
import pt.lsts.imc.lsf.LsfIndexListener;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.mra.importers.IMraLog;
import pt.lsts.neptus.mra.importers.IMraLogGroup;
import pt.lsts.neptus.mra.importers.lsf.LsfMraLog;

public class LsfLogSource
implements IMraLogGroup {
    IMCDefinition defs;
    LsfIndex index;
    File lsfFile;
    LsfIndexListener listener = null;
    String[] existingMessages = null;
    Collection<Integer> vehicleSources;

    public LsfLogSource(String filename, LsfIndexListener listener) throws Exception {
        this(new File(filename), listener);
    }

    public LsfLogSource(File file, LsfIndexListener listener) throws Exception {
        this.listener = listener;
        this.loadLog(file);
    }

    @Override
    public void cleanup() {
        if (this.index != null) {
            this.index.cleanup();
        }
    }

    private void loadLog(File f) throws Exception {
        if (!f.canRead()) {
            throw new IOException();
        }
        if (f.getName().endsWith(".lsf.gz")) {
            MultiMemberGZIPInputStream mmgis = new MultiMemberGZIPInputStream((InputStream)new FileInputStream(f));
            File outFile = new File(f.getAbsolutePath().replaceAll("\\.gz$", ""));
            outFile.createNewFile();
            FileOutputStream outStream = new FileOutputStream(outFile);
            try {
                byte[] extra = new byte[50000];
                int ret = 0;
                while ((ret = mmgis.read(extra)) != -1) {
                    byte[] extra1 = new byte[ret];
                    System.arraycopy(extra, 0, extra1, 0, ret);
                    outStream.write(extra1);
                    outStream.flush();
                }
                f = outFile;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.lsfFile = f;
        File defsFile1 = new File(f.getParent() + "/IMC.xml");
        File defsFile2 = new File(f.getParent() + "/IMC.xml.gz");
        this.defs = defsFile1.canRead() ? new IMCDefinition((InputStream)new FileInputStream(defsFile1)) : (defsFile2.canRead() ? new IMCDefinition((InputStream)new MultiMemberGZIPInputStream((InputStream)new FileInputStream(defsFile2))) : IMCDefinition.getInstance());
        this.index = new LsfIndex(this.lsfFile, this.defs, this.listener);
    }

    @Override
    public String name() {
        return this.lsfFile.getParentFile().getName();
    }

    @Override
    public LinkedHashMap<String, Object> metaInfo() {
        return null;
    }

    @Override
    public IMraLog getLog(String logName) {
        if (this.index == null) {
            return null;
        }
        try {
            int i = this.index.getFirstMessageOfType(logName);
            if (i != -1) {
                return new LsfMraLog(this.index, logName);
            }
            return null;
        }
        catch (Exception e) {
            NeptusLog.pub().info((Object)("<###>Index is: " + this.index));
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public boolean parse(URI uri) {
        return false;
    }

    @Override
    public String[] listLogs() {
        if (this.existingMessages == null) {
            Vector<String> list = new Vector<String>();
            Vector<Integer> indexes = new Vector<Integer>();
            for (int i = 0; i < this.index.getNumberOfMessages(); ++i) {
                int type = this.index.typeOf(i);
                if (indexes.contains(type)) continue;
                indexes.add(type);
                String msgName = this.index.getDefinitions().getMessageName(type);
                if (msgName == null) {
                    System.err.println("Message type not found in the definitions: " + type + ", " + (this.index.getNumberOfMessages() - i));
                    continue;
                }
                list.add(this.index.getDefinitions().getMessageName(type));
            }
            this.existingMessages = list.toArray(new String[list.size()]);
        }
        return this.existingMessages;
    }

    @Override
    public File getDir() {
        if (this.lsfFile != null) {
            return this.lsfFile.getParentFile();
        }
        return null;
    }

    @Override
    public File getFile(String name) {
        if (this.lsfFile != null) {
            File f = new File(this.lsfFile.getParentFile(), name);
            if (f.canRead()) {
                return f;
            }
            return null;
        }
        return null;
    }

    @Override
    public String getEntityName(int src, int src_ent) {
        return this.index.getEntityName(src, src_ent);
    }

    @Override
    public String getSystemName(int src) {
        return this.index.getSystemName(src);
    }

    @Override
    public Collection<Integer> getMessageGenerators(String msgType) {
        Vector<Integer> sources = new Vector<Integer>();
        int idx = 0;
        while ((idx = this.index.getNextMessageOfType(msgType, idx)) != -1) {
            if (sources.contains(this.index.sourceOf(idx))) continue;
            sources.add(this.index.sourceOf(idx));
        }
        return sources;
    }

    @Override
    public Collection<Integer> getVehicleSources() {
        if (this.vehicleSources == null) {
            this.vehicleSources = this.getMessageGenerators("EntityInfo");
        }
        ArrayList<Integer> toRemove = new ArrayList<Integer>();
        for (Integer v : this.vehicleSources) {
            if (v <= 16384) continue;
            toRemove.add(v);
        }
        this.vehicleSources.removeAll(toRemove);
        return this.vehicleSources;
    }

    @Override
    public LsfIndex getLsfIndex() {
        return this.index;
    }
}

