/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.util.llf;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Image;
import com.lowagie.text.PageSize;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import org.apache.batik.dom.svg.SAXSVGDocumentFactory;
import org.apache.batik.transcoder.SVGAbstractTranscoder;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.print.PrintTranscoder;
import org.apache.batik.util.XMLResourceDescriptor;
import org.jfree.chart.JFreeChart;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.colormap.ColorMap;
import pt.lsts.neptus.colormap.ColorMapFactory;
import pt.lsts.neptus.console.plugins.PropertiesProviders.SidescanConfig;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.mra.LogMarker;
import pt.lsts.neptus.mra.MRAPanel;
import pt.lsts.neptus.mra.MRAProperties;
import pt.lsts.neptus.mra.SidescanLogMarker;
import pt.lsts.neptus.mra.api.SidescanLine;
import pt.lsts.neptus.mra.api.SidescanParameters;
import pt.lsts.neptus.mra.api.SidescanParser;
import pt.lsts.neptus.mra.api.SidescanParserFactory;
import pt.lsts.neptus.mra.importers.IMraLogGroup;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.map.MapGroup;
import pt.lsts.neptus.types.map.MapType;
import pt.lsts.neptus.types.map.PathElement;
import pt.lsts.neptus.types.map.PlanElement;
import pt.lsts.neptus.types.mission.MissionType;
import pt.lsts.neptus.types.mission.plan.PlanType;
import pt.lsts.neptus.types.vehicle.VehicleType;
import pt.lsts.neptus.util.FileUtil;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.ImageUtils;
import pt.lsts.neptus.util.SvgUtil;
import pt.lsts.neptus.util.conf.ConfigFetch;
import pt.lsts.neptus.util.llf.LogTree;
import pt.lsts.neptus.util.llf.LogUtils;
import pt.lsts.neptus.util.llf.LsfLogSource;
import pt.lsts.neptus.util.llf.LsfReportProperties;
import pt.lsts.neptus.util.llf.chart.LLFChart;

public class LsfReport {
    protected static org.w3c.dom.Document logoDoc = null;
    private static int page = 1;

    public static org.w3c.dom.Document getLogoDoc() {
        if (logoDoc == null) {
            String parser = XMLResourceDescriptor.getXMLParserClassName();
            SAXSVGDocumentFactory f = new SAXSVGDocumentFactory(parser);
            String data = FileUtil.getFileAsString(FileUtil.getResourceAsFile("/images/neptus_logo_ns.svg"));
            try {
                logoDoc = f.createDocument(null, (Reader)new StringReader(data));
                logoDoc = SvgUtil.cleanInkscapeSVG(logoDoc);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return logoDoc;
    }

    private static void writeDetailsPage(PdfContentByte cb, IMraLogGroup source) {
        Rectangle pageSize = PageSize.A4.rotate();
        try {
            cb.beginText();
            BaseFont bf = BaseFont.createFont((String)"Helvetica", (String)"Cp1252", (boolean)false);
            cb.setFontAndSize(bf, 24.0f);
            cb.setColorFill(new Color(50, 100, 200));
            cb.showTextAligned(1, I18n.text("Mission Statistics"), pageSize.getWidth() / 2.0f, pageSize.getHeight() - 100.0f, 0.0f);
            cb.setFontAndSize(bf, 14.0f);
            cb.setColorFill(Color.gray.darker());
            float xpos = pageSize.getWidth() / 4.0f;
            float ypos = pageSize.getHeight() - 160.0f;
            LinkedHashMap<String, String> stats = LogUtils.generateStatistics(source);
            for (String field : stats.keySet()) {
                cb.setColorFill(Color.blue.darker());
                cb.showTextAligned(2, field + ":", xpos - 10.0f, ypos, 0.0f);
                cb.setColorFill(Color.black);
                cb.showTextAligned(0, stats.get(field), xpos + 10.0f, ypos, 0.0f);
                ypos -= 20.0f;
            }
            cb.endText();
            VehicleType vehicle = LogUtils.getVehicle(source);
            if (vehicle != null) {
                java.awt.Image vehicleImage = vehicle.getPresentationImageHref().equalsIgnoreCase("") ? ImageUtils.getScaledImage(vehicle.getSideImageHref(), 300, 300) : ImageUtils.getScaledImage(vehicle.getPresentationImageHref(), 300, 300);
                PdfTemplate tp = cb.createTemplate(300.0f, 300.0f);
                Graphics2D g2 = tp.createGraphicsShapes(300.0f, 300.0f);
                g2.drawImage(vehicleImage, 0, 0, null);
                g2.dispose();
                cb.addTemplate(tp, pageSize.getWidth() - 350.0f, pageSize.getHeight() - 460.0f);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void writeFirstPage(PdfContentByte cb, IMraLogGroup source) {
        Rectangle pageSize = PageSize.A4.rotate();
        try {
            BaseFont bf = BaseFont.createFont((String)"Helvetica", (String)"Cp1252", (boolean)false);
            if (LsfReport.getLogoDoc() != null) {
                PrintTranscoder prm = new PrintTranscoder();
                prm.addTranscodingHint(SVGAbstractTranscoder.KEY_WIDTH, (Object)new Float(500.0f));
                prm.addTranscodingHint(SVGAbstractTranscoder.KEY_HEIGHT, (Object)new Float(193.0f));
                TranscoderInput ti = new TranscoderInput(LsfReport.getLogoDoc());
                prm.transcode(ti, null);
                PdfTemplate tp = cb.createTemplate(500.0f, 200.0f);
                Graphics2D g2 = tp.createGraphicsShapes(500.0f, 200.0f);
                Paper paper = new Paper();
                paper.setSize(pageSize.getWidth(), pageSize.getHeight());
                paper.setImageableArea(0.0, 0.0, 500.0, 193.0);
                PageFormat page = new PageFormat();
                page.setPaper(paper);
                prm.print((Graphics)g2, page, 0);
                g2.dispose();
                cb.addTemplate(tp, pageSize.getWidth() / 2.0f - 250.0f, pageSize.getHeight() / 2.0f - 91.0f + 120.0f);
            }
            cb.beginText();
            cb.setFontAndSize(bf, 18.0f);
            Date d = new Date(source.getLog("EstimatedState").currentTimeMillis());
            cb.showTextAligned(1, source.name() + "  (" + LogUtils.getVehicle(source) + ")", pageSize.getWidth() / 2.0f, pageSize.getHeight() / 2.0f - 40.0f, 0.0f);
            cb.setColorFill(new Color(200, 200, 200));
            cb.showTextAligned(1, I18n.textf("Mission executed on %date", d.toString()), pageSize.getWidth() / 2.0f, pageSize.getHeight() / 2.0f - 140.0f, 0.0f);
            cb.setFontAndSize(bf, 32.0f);
            cb.setColorFill(new Color(50, 100, 200));
            cb.showTextAligned(1, I18n.text("Neptus Mission Report"), pageSize.getWidth() / 2.0f, pageSize.getHeight() / 2.0f, 0.0f);
            cb.endText();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void writePageNumber(PdfContentByte cb, int curPage) {
        if (!LsfReportProperties.printPageNumbers) {
            return;
        }
        Rectangle pageSize = PageSize.A4.rotate();
        try {
            BaseFont bf = BaseFont.createFont((String)"Helvetica", (String)"Cp1252", (boolean)false);
            cb.beginText();
            cb.setFontAndSize(bf, 12.0f);
            cb.showTextAligned(2, Integer.toString(curPage), pageSize.getWidth() - 10.0f, 575.0f, 0.0f);
            cb.endText();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void writeHeader(PdfContentByte cb, IMraLogGroup source) {
        try {
            BaseFont bf = BaseFont.createFont((String)"Helvetica", (String)"Cp1252", (boolean)false);
            cb.beginText();
            cb.setFontAndSize(bf, 12.0f);
            cb.moveText(10.0f, 575.0f);
            cb.showText(I18n.text("Neptus Mission Report") + " - " + source.name());
            cb.endText();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void writeFooter(PdfContentByte cb, IMraLogGroup source) {
        try {
            BaseFont bf = BaseFont.createFont((String)"Helvetica", (String)"Cp1252", (boolean)false);
            cb.setColorFill(Color.gray);
            cb.beginText();
            cb.setFontAndSize(bf, 12.0f);
            Rectangle pageSize = PageSize.A4.rotate();
            cb.moveText(10.0f, 10.0f);
            cb.showTextAligned(1, I18n.textf("Document generated by %generator on %date.", "Neptus " + ConfigFetch.getNeptusVersion(), new Date().toString()), pageSize.getWidth() / 2.0f, 10.0f, 0.0f);
            cb.endText();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean savePdf(IMraLogGroup source, LLFChart llfChart, File destination) {
        Rectangle pageSize = PageSize.A4.rotate();
        try {
            FileOutputStream out = new FileOutputStream(destination);
            Document doc = new Document(pageSize);
            PdfWriter writer = PdfWriter.getInstance((Document)doc, (OutputStream)out);
            doc.open();
            doc.addTitle(llfChart.getName());
            doc.addCreationDate();
            doc.addCreator("Neptus " + ConfigFetch.getNeptusVersion());
            doc.addProducer();
            doc.addAuthor(System.getProperty("user.name"));
            PdfContentByte cb = writer.getDirectContent();
            Graphics2D g2 = cb.createGraphicsShapes(pageSize.getWidth(), pageSize.getHeight());
            int width = (int)pageSize.getWidth();
            int height = (int)pageSize.getHeight();
            JFreeChart chart = llfChart.getChart(source, MRAProperties.defaultTimestep);
            chart.setTitle("");
            chart.setBackgroundPaint((Paint)Color.white);
            chart.draw(g2, (Rectangle2D)new Rectangle2D.Double(25.0, 25.0, width - 50, height - 50));
            g2.dispose();
            doc.close();
            out.flush();
            out.close();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean generateReport(IMraLogGroup source, File destination, MRAPanel panel) {
        LogTree tree = panel.getLogTree();
        Vector<LLFChart> llfCharts = new Vector<LLFChart>();
        for (int i = 0; i < tree.chartsNode.getChildCount(); ++i) {
            try {
                LLFChart chart = (LLFChart)((DefaultMutableTreeNode)tree.chartsNode.getChildAt(i)).getUserObject();
                llfCharts.add(chart);
                continue;
            }
            catch (Exception e) {
                NeptusLog.pub().error((Object)e);
            }
        }
        Rectangle pageSize = PageSize.A4.rotate();
        try {
            FileOutputStream out = new FileOutputStream(destination);
            Document doc = new Document(pageSize);
            PdfWriter writer = PdfWriter.getInstance((Document)doc, (OutputStream)out);
            doc.open();
            doc.addTitle(I18n.text("Neptus Mission Report") + " - " + source.name());
            doc.addCreationDate();
            doc.addCreator("Neptus " + ConfigFetch.getNeptusVersion());
            doc.addProducer();
            doc.addAuthor(System.getProperty("user.name"));
            PdfContentByte cb = writer.getDirectContent();
            page = 1;
            LsfReport.writeFirstPage(cb, source);
            ++page;
            doc.newPage();
            for (LLFChart llfChart : llfCharts) {
                Graphics2D g2 = cb.createGraphicsShapes(pageSize.getWidth(), pageSize.getHeight());
                int width = (int)pageSize.getWidth();
                int height = (int)pageSize.getHeight();
                JFreeChart chart = llfChart.getChart(source, llfChart.getDefaultTimeStep());
                chart.setBackgroundPaint((Paint)Color.white);
                chart.draw(g2, (Rectangle2D)new Rectangle2D.Double(25.0, 25.0, width - 50, height - 50));
                g2.dispose();
                LsfReport.writePageNumber(cb, page++);
                LsfReport.writeHeader(cb, source);
                LsfReport.writeFooter(cb, source);
                doc.newPage();
            }
            int width = (int)pageSize.getWidth();
            int height = (int)pageSize.getHeight();
            PdfTemplate tp = cb.createTemplate((float)(width - 100), (float)(height - 100));
            final Graphics2D g2 = tp.createGraphicsShapes((float)(width - 100), (float)(height - 100));
            MissionType mt = LogUtils.generateMission(source);
            PlanType plan = LogUtils.generatePlan(mt, source);
            PathElement path = LogUtils.generatePath(mt, source);
            final StateRenderer2D r2d = new StateRenderer2D(MapGroup.getMapGroupInstance(mt));
            r2d.setShowWorldMapOnScreenControls(false);
            PlanElement po = new PlanElement(r2d.getMapGroup(), new MapType());
            po.setTransp2d(0.5);
            po.setPlan(plan);
            po.setRenderer(r2d);
            po.setColor(new Color(255, 255, 255, 128));
            po.setShowDistances(false);
            po.setShowManNames(false);
            r2d.addPostRenderPainter(po, "Plan Painter");
            r2d.setSize(width - 100, height - 100);
            r2d.focusLocation(path.getCenterPoint());
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    r2d.update(g2);
                }
            });
            g2.dispose();
            cb.addTemplate(tp, 50.0f, 50.0f);
            LsfReport.writePageNumber(cb, page++);
            LsfReport.writeHeader(cb, source);
            LsfReport.writeFooter(cb, source);
            doc.newPage();
            LsfReport.createTable(cb, doc, source, panel);
            LsfReport.writeHeader(cb, source);
            LsfReport.writeFooter(cb, source);
            doc.newPage();
            LsfReport.writeDetailsPage(cb, source);
            LsfReport.writePageNumber(cb, page++);
            LsfReport.writeHeader(cb, source);
            LsfReport.writeFooter(cb, source);
            doc.close();
            out.flush();
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            GuiUtils.errorMessage(I18n.text("Error generating report"), e.getMessage());
            return false;
        }
        return true;
    }

    public static void createTable(PdfContentByte cb, Document doc, IMraLogGroup source, MRAPanel panel) throws DocumentException {
        try {
            SidescanParser ssParser = SidescanParserFactory.build(source);
            int nSubsys = ssParser.getSubsystemList().size();
            SidescanConfig config = new SidescanConfig();
            int colorMapCode = LsfReportProperties.sidescanColorMap;
            boolean globalColorMap = true;
            if (colorMapCode == -1) {
                globalColorMap = false;
            } else {
                config.colorMap = LsfReport.getColorMapFromCode(colorMapCode);
            }
            SidescanParameters sidescanParams = new SidescanParameters(0.0, 0.0);
            sidescanParams.setNormalization(config.normalization);
            sidescanParams.setTvgGain(config.tvgGain);
            PdfPTable table = new PdfPTable(3 + nSubsys);
            LsfReport.setRowsWidth(table, nSubsys);
            LsfReport.writeHeader(table, ssParser.getSubsystemList());
            ArrayList<LogMarker> markers = panel.getMarkers();
            for (LogMarker m : markers) {
                LsfReport.createPdfMarksRows(table, m);
                if (m.getClass() == SidescanLogMarker.class) {
                    LsfReport.createPdfSidescanMarks(table, m, nSubsys, ssParser, config, source, sidescanParams, globalColorMap);
                    continue;
                }
                for (int i = 0; i < nSubsys; ++i) {
                    table.addCell("");
                }
            }
            LsfReport.actualWriteToPdf(source, cb, table, doc);
        }
        catch (Exception e) {
            e.printStackTrace();
            GuiUtils.errorMessage(I18n.text("Error creating PDF table"), e.getMessage());
        }
    }

    public static void actualWriteToPdf(IMraLogGroup source, PdfContentByte cb, PdfPTable table, Document doc) {
        Rectangle pageSize = PageSize.A4.rotate();
        cb.beginText();
        LsfReport.writePageNumber(cb, page++);
        LsfReport.writeHeader(cb, source);
        LsfReport.writeFooter(cb, source);
        try {
            BaseFont bf = BaseFont.createFont((String)"Helvetica", (String)"Cp1252", (boolean)false);
            cb.setFontAndSize(bf, 24.0f);
            cb.setColorFill(new Color(50, 100, 200));
            cb.showTextAligned(1, I18n.text("Marks' Table"), pageSize.getWidth() / 2.0f, pageSize.getHeight() - 100.0f, 0.0f);
            cb.endText();
            float xpos = pageSize.getWidth() / 18.0f;
            float ypos = pageSize.getHeight() - 175.0f;
            cb.setColorFill(new Color(50, 100, 200));
            ypos = table.writeSelectedRows(0, 1, xpos, ypos, cb);
            for (int i = 1; i < table.getRows().size(); ++i) {
                PdfPCell[] cells;
                if (ypos - table.getRow(i).getMaxHeights() < 75.0f) {
                    doc.newPage();
                    cb.beginText();
                    LsfReport.writePageNumber(cb, page++);
                    LsfReport.writeHeader(cb, source);
                    LsfReport.writeFooter(cb, source);
                    cb.setFontAndSize(bf, 24.0f);
                    cb.setColorFill(new Color(50, 100, 200));
                    cb.showTextAligned(1, I18n.text("Marks' Table"), pageSize.getWidth() / 2.0f, pageSize.getHeight() - 100.0f, 0.0f);
                    cb.endText();
                    ypos = pageSize.getHeight() - 160.0f;
                    cb.setColorFill(new Color(50, 100, 200));
                    ypos = table.writeSelectedRows(0, 1, xpos, ypos, cb);
                }
                if (i % 2 == 0) {
                    cb.setColorFill(Color.gray.darker());
                } else {
                    cb.setColorFill(Color.black);
                }
                for (PdfPCell cell : cells = table.getRow(i).getCells()) {
                    if (!(cell.getHeight() > 250.0f)) continue;
                    table.getRow(i).setMaxHeights(250.0f);
                    break;
                }
                ypos = table.writeSelectedRows(i, i + 1, xpos, ypos, cb);
            }
        }
        catch (Exception e) {
            NeptusLog.pub().error((Object)e.getMessage());
        }
    }

    public static void createPdfSidescanMarks(PdfPTable table, LogMarker m, int nSubsys, SidescanParser ssParser, SidescanConfig config, IMraLogGroup source, SidescanParameters sidescanParams, boolean globalColorMap) {
        SidescanLogMarker sd = (SidescanLogMarker)m;
        sd.setDefaults(ssParser.getSubsystemList().get(0));
        for (int i = 0; i < nSubsys; ++i) {
            Image iTextImage = null;
            BufferedImage image = null;
            try {
                image = LsfReport.getSidescanMarkImage(source, ssParser, sidescanParams, config, globalColorMap, sd, i);
            }
            catch (Exception e) {
                NeptusLog.pub().error((Object)e.getMessage());
            }
            if (image != null) {
                try {
                    ImageIO.write((RenderedImage)image, "png", new File("tmp.png"));
                    iTextImage = Image.getInstance((String)"tmp.png");
                    File file = new File("tmp.png");
                    Boolean deleted = file.delete();
                    if (!deleted.booleanValue()) {
                        throw new DocumentException("file.delete() failed");
                    }
                }
                catch (Exception e) {
                    NeptusLog.pub().error((Object)e.getMessage());
                }
                PdfPCell cell = new PdfPCell(iTextImage, true);
                table.addCell(cell);
                continue;
            }
            table.addCell("");
        }
    }

    public static void createPdfMarksRows(PdfPTable table, LogMarker m) {
        String dateAsText = new SimpleDateFormat("HH:mm:ss.ms").format(m.getTimestamp());
        table.addCell(dateAsText);
        table.addCell(m.getLabel());
        LocationType loc = new LocationType(Math.toDegrees(m.getLat()), Math.toDegrees(m.getLon()));
        String locString = loc.toString();
        table.addCell(locString);
    }

    public static void setRowsWidth(PdfPTable table, int nSubsys) {
        Rectangle pageSize = PageSize.A4.rotate();
        float tableWidth = pageSize.getWidth() * 5.0f / 6.0f;
        table.setTotalWidth(tableWidth);
        float[] columnWidth = new float[3 + nSubsys];
        if (nSubsys == 0) {
            columnWidth[0] = 0.3f;
            columnWidth[1] = 0.4f;
            columnWidth[2] = 0.3f;
        }
        if (nSubsys > 0) {
            columnWidth[0] = 0.15f;
            columnWidth[1] = 0.25f;
            columnWidth[2] = 0.15f;
            for (int i = 3; i < 3 + nSubsys; ++i) {
                columnWidth[i] = 0.45f / (float)nSubsys;
            }
        }
        try {
            table.setWidths(columnWidth);
        }
        catch (Exception e) {
            NeptusLog.pub().error((Object)e.getMessage());
        }
    }

    public static void writeHeader(PdfPTable table, ArrayList<Integer> subSysList) {
        table.addCell(I18n.text("Timestamp"));
        table.addCell(I18n.text("Label"));
        table.addCell(I18n.text("Location"));
        int nSubsys = subSysList.size();
        for (int i = 0; i < nSubsys; ++i) {
            table.addCell(I18n.textf("Image %number", subSysList.get(i)));
        }
    }

    public static BufferedImage getSidescanMarkImage(IMraLogGroup source, SidescanParser ssParser, SidescanParameters sidescanParams, SidescanConfig config, boolean globalColorMap, SidescanLogMarker mark, int subSysN) throws DocumentException {
        BufferedImage result = null;
        SidescanLogMarker adjustedMark = LsfReport.adjustMark(mark);
        int subSys = ssParser.getSubsystemList().get(subSysN);
        double wMeters = adjustedMark.wMeters;
        boolean point = adjustedMark.point;
        int indexX = -1;
        int indexY = -1;
        ArrayList<SidescanLine> list = null;
        list = LsfReport.getLines(ssParser, subSys, sidescanParams, adjustedMark);
        if (list.isEmpty()) {
            throw new DocumentException("list of lines empty");
        }
        list = LsfReport.adjustLines(list, adjustedMark);
        float range = list.get((int)(list.size() / 2)).range;
        if (wMeters == -1.0) {
            wMeters = list.get((int)(list.size() / 2)).range / 5.0f;
        }
        double x = adjustedMark.x;
        double x1 = (x += (double)range) - wMeters / 2.0;
        double x2 = x + wMeters / 2.0;
        if (x > (double)(2.0f * range) || x < 0.0) {
            return null;
        }
        boolean border = false;
        if (x1 < 0.0) {
            x1 = 0.0;
            border = true;
        }
        if (x2 > (double)(2.0f * range)) {
            x2 = 2.0f * range;
            border = true;
        }
        if (x1 > x2) {
            throw new DocumentException("x1>x2");
        }
        int size = list.get((int)(list.size() / 2)).data.length;
        int i1 = LsfReport.convertMtoIndex(x1, range, size);
        int i2 = LsfReport.convertMtoIndex(x2, range, size);
        if (i2 > size) {
            i2 = size;
        }
        if (i1 < 0) {
            i1 = 0;
        }
        Color color = null;
        if (!globalColorMap) {
            config.colorMap = ColorMapFactory.getColorMapByName(adjustedMark.colorMap);
        }
        ArrayList<BufferedImage> imgLineList = LsfReport.createImgLineList(list, i1, i2, config);
        BufferedImage img = LsfReport.drawImage(imgLineList, adjustedMark);
        if (point) {
            indexY = LsfReport.getIndexY(list, adjustedMark, subSys);
            indexX = LsfReport.getIndexX(adjustedMark, ssParser, sidescanParams, border, i1, i2);
            color = LsfReport.getColor(adjustedMark, ssParser, sidescanParams, config);
            result = LsfReport.paintPointHighlight(img, indexX, indexY, color, config.colorMap);
        } else {
            result = img;
        }
        return result;
    }

    public static Color getColor(SidescanLogMarker mark, SidescanParser ssParser, SidescanParameters sidescanParams, SidescanConfig config) {
        Color color = null;
        int d = 1;
        long t = (long)mark.getTimestamp();
        ArrayList<SidescanLine> list2 = ssParser.getLinesBetween(t - (long)d, t + (long)d, mark.subSys, sidescanParams);
        while (list2.isEmpty()) {
            list2 = ssParser.getLinesBetween(t - (long)(d += 10), t + (long)d, mark.subSys, sidescanParams);
        }
        SidescanLine l = list2.get(list2.size() / 2);
        int index = LsfReport.convertMtoIndex(mark.x + (double)l.range, l.range, l.data.length);
        color = config.colorMap.getColor(l.data[index]);
        return color;
    }

    public static int getIndexX(SidescanLogMarker mark, SidescanParser ssParser, SidescanParameters sidescanParams, boolean border, int i1, int i2) {
        int indexX = -1;
        int d = 1;
        long t = (long)mark.getTimestamp();
        ArrayList<SidescanLine> list2 = ssParser.getLinesBetween(t - (long)d, t + (long)d, mark.subSys, sidescanParams);
        while (list2.isEmpty()) {
            list2 = ssParser.getLinesBetween(t - (long)(d += 10), t + (long)d, mark.subSys, sidescanParams);
        }
        SidescanLine l = list2.get(list2.size() / 2);
        int index = LsfReport.convertMtoIndex(mark.x + (double)l.range, l.range, l.data.length);
        if (border) {
            if (index > i2 - i1) {
                index -= i1;
            }
            indexX = (int)((double)index / (double)(i2 - i1) * 100.0);
        } else {
            indexX = 50;
        }
        return indexX;
    }

    public static int getIndexY(ArrayList<SidescanLine> list, SidescanLogMarker mark, int subSys) {
        if (mark.subSys != subSys) {
            return 50;
        }
        double t = mark.getTimestamp();
        for (int i = 0; i < list.size(); ++i) {
            SidescanLine l = list.get(i);
            if ((double)l.timestampMillis != t) continue;
            return i;
        }
        return -1;
    }

    public static BufferedImage drawImage(ArrayList<BufferedImage> imgLineList, SidescanLogMarker mark) {
        int w = mark.w;
        int h = mark.h;
        BufferedImage imgScalled = new BufferedImage(w, h, 1);
        Graphics2D g2d = imgScalled.createGraphics();
        int y = imgLineList.size();
        for (BufferedImage imgLine : imgLineList) {
            if (y < 0) {
                return null;
            }
            g2d.drawImage(ImageUtils.getScaledImage(imgLine, imgScalled.getWidth(), imgLine.getHeight(), true), 0, y, null);
            --y;
        }
        BufferedImage result = new BufferedImage(w, h, 1);
        if (imgScalled.getWidth() != result.getWidth() || imgScalled.getHeight() != result.getHeight()) {
            g2d = result.createGraphics();
            g2d.drawImage(ImageUtils.getScaledImage(imgScalled, result.getWidth(), result.getHeight(), true), 0, 0, null);
        } else {
            result = imgScalled;
        }
        return result;
    }

    public static ArrayList<BufferedImage> createImgLineList(ArrayList<SidescanLine> list, int i1, int i2, SidescanConfig config) {
        ArrayList<BufferedImage> imgLineList = new ArrayList<BufferedImage>();
        for (int i = 0; i < list.size(); ++i) {
            SidescanLine l = list.get(i);
            BufferedImage imgLine = new BufferedImage(i2 - i1, 1, 1);
            for (int c = 0; c < i2 - i1; ++c) {
                int rgb = config.colorMap.getColor(l.data[c + i1]).getRGB();
                imgLine.setRGB(c, 0, rgb);
            }
            imgLineList.add(imgLine);
        }
        return imgLineList;
    }

    public static ArrayList<SidescanLine> adjustLines(ArrayList<SidescanLine> list, SidescanLogMarker mark) {
        int h = mark.h;
        long t = (long)mark.getTimestamp();
        int yref = list.size();
        while (yref > h) {
            long tFirst = list.get((int)0).timestampMillis;
            long tLast = list.get((int)(list.size() - 1)).timestampMillis;
            if (tFirst == t) {
                list.remove(list.size() - 1);
                --yref;
                continue;
            }
            if (tLast == t) {
                list.remove(0);
                --yref;
                continue;
            }
            if (Math.abs(t - tFirst) < Math.abs(t - tLast)) {
                list.remove(list.size() - 1);
                --yref;
                continue;
            }
            if (Math.abs(t - tFirst) < Math.abs(t - tLast)) continue;
            list.remove(0);
            --yref;
        }
        return list;
    }

    public static ArrayList<SidescanLine> getLines(SidescanParser ssParser, int subSys, SidescanParameters sidescanParams, SidescanLogMarker mark) {
        long t = (long)mark.getTimestamp();
        int h = mark.h;
        ArrayList<SidescanLine> list = new ArrayList<SidescanLine>();
        long firstTimestamp = ssParser.firstPingTimestamp();
        long lastTimestamp = ssParser.lastPingTimestamp();
        int deviation = 0;
        int counter = 0;
        while (list.size() < h && counter < 10) {
            ++counter;
            long t1 = t - (long)((deviation += 250) * (h / 2));
            long t2 = t + (long)(deviation * (h / 2));
            if (t1 < firstTimestamp) {
                t1 = firstTimestamp;
            }
            if (t2 > lastTimestamp) {
                t2 = lastTimestamp;
            }
            list = ssParser.getLinesBetween(t1, t2, subSys, sidescanParams);
        }
        return list;
    }

    public static SidescanLogMarker adjustMark(SidescanLogMarker mark) {
        SidescanLogMarker newMark = new SidescanLogMarker(mark.getLabel(), mark.getTimestamp(), mark.getLat(), mark.getLon(), mark.x, mark.y, mark.w, mark.h, mark.wMeters, mark.subSys, ColorMapFactory.getColorMapByName(mark.colorMap));
        newMark.point = mark.point;
        int h = newMark.h;
        int w = newMark.w;
        double wMeters = newMark.wMeters;
        if (w == 0 && h == 0) {
            w = 100;
            h = 100;
            wMeters = -1.0;
        }
        if (w < 100 || h < 100 || wMeters < 0.05) {
            if (w < 100) {
                w = 100;
                wMeters = -1.0;
            }
            if (h < 100) {
                h = 100;
            }
        } else if (w < 150 || h < 150) {
            if (w < 150) {
                w = (int)((double)w * 1.2);
                wMeters *= 1.2;
            }
            if (h < 150) {
                h = (int)((double)h * 1.2);
            }
        } else if (w < 200 || h < 200) {
            if (w < 200) {
                w = (int)((double)w * 1.1);
                wMeters *= 1.1;
            }
            if (h < 200) {
                h = (int)((double)h * 1.1);
            }
        }
        newMark.h = h;
        newMark.w = w;
        newMark.wMeters = wMeters;
        return newMark;
    }

    public static BufferedImage paintPointHighlight(BufferedImage original, int x, int y, Color color, ColorMap colorMap) {
        BufferedImage result = original;
        Graphics2D g2d = result.createGraphics();
        int w = 10;
        int h = 10;
        x -= w / 2;
        y -= h / 2;
        Color c = null;
        boolean fixedColor = true;
        if (LsfReportProperties.sidescanMarksPointsFixedColor == 0) {
            fixedColor = false;
        }
        c = fixedColor ? LsfReport.getFixedColor(colorMap) : LsfReport.getContrastColor(color);
        g2d.setColor(c);
        int shape = LsfReportProperties.sidescanMarksPointsShape;
        switch (shape) {
            case 0: {
                g2d.drawRect(x, y, w, h);
                if (fixedColor) break;
                g2d.setColor(color);
                g2d.drawRect(x - 1, y - 1, w + 2, h + 2);
                break;
            }
            case 1: {
                g2d.drawOval(x, y, w, h);
                if (fixedColor) break;
                g2d.setColor(color);
                g2d.drawOval(x - 1, y - 1, w + 2, h + 2);
                break;
            }
            default: {
                NeptusLog.pub().info((Object)"Sidescan Point Marks Shape Code not found, using 0 square instead");
                g2d.drawRect(x, y, w, h);
                if (fixedColor) break;
                g2d.setColor(color);
                g2d.drawRect(x - 1, y - 1, w + 2, h + 2);
            }
        }
        return result;
    }

    public static Color getFixedColor(ColorMap colorMap) {
        String colorMapString = colorMap.toString().toLowerCase();
        Color c = null;
        switch (colorMapString) {
            case "redyellowgreen": 
            case "autumn": 
            case "summer": 
            case "spring": {
                c = new Color(0, 0, 0);
                break;
            }
            case "rainbow": {
                c = new Color(255, 255, 255);
                break;
            }
            case "winter": 
            case "cool": 
            case "gray scale": {
                c = new Color(255, 0, 0);
                break;
            }
            case "pink": {
                c = new Color(0, 255, 0);
                break;
            }
            case "bronze": 
            case "storedata": 
            case "copper": 
            case "hot": {
                c = new Color(0, 0, 255);
                break;
            }
            case "blue to red": 
            case "rgb": 
            case "jet": {
                c = new Color(255, 255, 0);
                break;
            }
            case "greenradar": 
            case "bone": {
                c = new Color(255, 0, 255);
                break;
            }
            default: {
                NeptusLog.pub().info((Object)"ColorMap.toString() not found, assuming bronze code");
                c = new Color(0, 0, 255);
            }
        }
        return c;
    }

    public static Color getContrastColor(Color color) {
        Color result = null;
        int r = color.getRed();
        int g = color.getGreen();
        int b = color.getBlue();
        int newR = 255 - r;
        int newG = 255 - g;
        int newB = 255 - b;
        result = new Color(newR, newG, newB);
        return result;
    }

    public static ColorMap getColorMapFromCode(int colorMapCode) {
        switch (colorMapCode) {
            case 0: {
                return ColorMapFactory.createBronzeColormap();
            }
            case 1: {
                return ColorMapFactory.createStoreDataColormap();
            }
            case 2: {
                return ColorMapFactory.createRainbowColormap();
            }
            case 3: {
                return ColorMapFactory.createRedYellowGreenColorMap();
            }
            case 4: {
                return ColorMapFactory.createGreenRadarColorMap();
            }
            case 5: {
                return ColorMapFactory.createPinkColorMap();
            }
            case 6: {
                return ColorMapFactory.createBlueToRedColorMap();
            }
            case 7: {
                return ColorMapFactory.createRedGreenBlueColorMap();
            }
            case 8: {
                return ColorMapFactory.createWinterColorMap();
            }
            case 9: {
                return ColorMapFactory.createAutumnColorMap();
            }
            case 10: {
                return ColorMapFactory.createSummerColorMap();
            }
            case 11: {
                return ColorMapFactory.createSpringColorMap();
            }
            case 12: {
                return ColorMapFactory.createBoneColorMap();
            }
            case 13: {
                return ColorMapFactory.createCopperColorMap();
            }
            case 14: {
                return ColorMapFactory.createHotColorMap();
            }
            case 15: {
                return ColorMapFactory.createCoolColorMap();
            }
            case 16: {
                return ColorMapFactory.createJetColorMap();
            }
            case 17: {
                return ColorMapFactory.createGrayScaleColorMap();
            }
        }
        NeptusLog.pub().info((Object)"colorMap code not found, using default Bronze");
        return ColorMapFactory.createBronzeColormap();
    }

    public static int convertMtoIndex(double m, float range, int size) {
        return (int)(m / (double)(2.0f * range) * (double)size);
    }

    public static void generateReport(LsfLogSource source, JFreeChart[] charts, File desFile) {
        Rectangle pageSize = PageSize.A4.rotate();
        try {
            FileOutputStream out = new FileOutputStream(desFile);
            Document doc = new Document(pageSize);
            doc.addTitle(I18n.text("Neptus Mission Report") + " - " + source.name());
            doc.addCreationDate();
            doc.addCreator("Neptus " + ConfigFetch.getNeptusVersion());
            doc.addProducer();
            doc.addAuthor(System.getProperty("user.name"));
            PdfWriter writer = PdfWriter.getInstance((Document)doc, (OutputStream)out);
            writer.setPdfVersion('1');
            doc.open();
            PdfContentByte cb = writer.getDirectContent();
            int page = 1;
            LsfReport.writeFirstPage(cb, source);
            doc.newPage();
            ++page;
            for (int i = 0; i < charts.length; ++i) {
                cb.beginText();
                Graphics2D g2 = cb.createGraphicsShapes(pageSize.getWidth(), pageSize.getHeight());
                int width = (int)pageSize.getWidth();
                int height = (int)pageSize.getHeight();
                Paint oldPaint = charts[i].getBackgroundPaint();
                charts[i].setBackgroundPaint((Paint)Color.white);
                charts[i].draw(g2, (Rectangle2D)new Rectangle2D.Double(25.0, 25.0, width - 50, height - 50));
                charts[i].setBackgroundPaint(oldPaint);
                g2.dispose();
                LsfReport.writePageNumber(cb, page++);
                LsfReport.writeHeader(cb, source);
                LsfReport.writeFooter(cb, source);
                doc.newPage();
            }
            doc.close();
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void generateLogs(File f, MRAPanel panel) {
        try {
            LsfLogSource folder = new LsfLogSource(f, null);
            Vector<File> subFolders = new Vector<File>();
            for (File fl : f.listFiles()) {
                if (!fl.isDirectory()) continue;
                subFolders.add(fl);
                try {
                    LsfReport.generateReport((IMraLogGroup)folder, new File(f.getName() + ".pdf"), panel);
                }
                catch (Exception e) {
                    System.err.println(I18n.textf("Unable to generate report for %filename", fl.getAbsolutePath()));
                }
            }
            for (File fl : subFolders) {
                LsfReport.generateLogs(fl, panel);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

