/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.util.llf;

import java.util.Arrays;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import pt.lsts.imc.IMCMessage;
import pt.lsts.imc.lsf.LsfIndex;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.mra.importers.IMraLog;
import pt.lsts.neptus.mra.importers.IMraLogGroup;
import pt.lsts.neptus.util.llf.LLFField;
import pt.lsts.neptus.util.llf.LLFTreeLog;
import pt.lsts.neptus.util.llf.MyTreeCellRenderer;

public class LsfTree
extends JTree {
    private static final long serialVersionUID = 1L;
    private DefaultTreeModel treeModel = new DefaultTreeModel(new DefaultMutableTreeNode(I18n.text("LSF Listing")));
    private IMraLogGroup source;

    public LsfTree(IMraLogGroup source) {
        this.source = source;
        this.setModel(this.treeModel);
        this.setCellRenderer(new MyTreeCellRenderer());
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        this.parseLogSource(source);
    }

    public void parseLogSource(IMraLogGroup source) {
        Object[] logs = source.listLogs();
        if (logs == null) {
            logs = new String[]{};
        }
        Arrays.sort(logs);
        for (Object l : logs) {
            this.addLog((String)l);
        }
        this.expandPath(new TreePath(this.treeModel.getRoot()));
    }

    public void addLog(String logName) {
        try {
            IMraLog parser = this.source.getLog(logName);
            LsfIndex index = this.source.getLsfIndex();
            int mgid = index.getDefinitions().getMessageId(logName);
            int firstPos = index.getFirstMessageOfType(mgid);
            IMCMessage entry = index.getMessage(firstPos);
            LLFTreeLog file = new LLFTreeLog(parser, logName);
            DefaultMutableTreeNode fileNode = new DefaultMutableTreeNode(file);
            this.treeModel.insertNodeInto(fileNode, (DefaultMutableTreeNode)this.treeModel.getRoot(), ((DefaultMutableTreeNode)this.treeModel.getRoot()).getChildCount());
            for (String fieldName : entry.getFieldNames()) {
                String fieldType = entry.getTypeOf(fieldName);
                LLFField field = new LLFField(fieldName, fieldType);
                this.treeModel.insertNodeInto(new DefaultMutableTreeNode(field), fileNode, this.treeModel.getChildCount(fileNode));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

