/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.util.llf;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JPopupMenu;
import javax.swing.tree.TreePath;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.gui.CloseTabbedPane;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.mra.MRAChartPanel;
import pt.lsts.neptus.mra.MRAPanel;
import pt.lsts.neptus.mra.importers.IMraLog;
import pt.lsts.neptus.mra.importers.IMraLogGroup;
import pt.lsts.neptus.mra.plots.GenericPlot;
import pt.lsts.neptus.mra.plots.ReplayPlot;
import pt.lsts.neptus.mra.visualizations.ColorMapVisualization;
import pt.lsts.neptus.util.ImageUtils;
import pt.lsts.neptus.util.conf.ConfigFetch;
import pt.lsts.neptus.util.llf.LogTableVisualization;
import pt.lsts.neptus.util.llf.LsfTree;

public class LsfTreeMouseAdapter
extends MouseAdapter {
    LsfTree tree;
    IMraLogGroup source;
    MRAPanel panel;
    CloseTabbedPane tabPane;

    public LsfTreeMouseAdapter(MRAPanel mraPanel) {
        this.panel = mraPanel;
        this.tree = this.panel.getTree();
        this.source = this.panel.getSource();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        String fileToOpen;
        TreePath[] path = this.tree.getSelectionPaths();
        if (e.getButton() == 1 && e.getClickCount() == 2) {
            if (path == null) {
                return;
            }
            if (path.length == 1 && path[0].getPath().length == 2) {
                fileToOpen = path[0].getPath()[1].toString();
                IMraLog log = this.source.getLog(fileToOpen);
                this.panel.loadVisualization(new LogTableVisualization(log, this.panel), true);
            }
        }
        if (e.getButton() == 3) {
            if (path == null) {
                return;
            }
            if (path.length == 1 && path[0].getPath().length == 2) {
                fileToOpen = path[0].getPath()[1].toString();
                JPopupMenu popup = new JPopupMenu();
                String text = I18n.textf("Show %log data", fileToOpen);
                popup.add(text).addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        IMraLog log = LsfTreeMouseAdapter.this.source.getLog(fileToOpen);
                        LsfTreeMouseAdapter.this.panel.loadVisualization(new LogTableVisualization(log, LsfTreeMouseAdapter.this.panel), true);
                    }
                });
                popup.show(this.tree, e.getX(), e.getY());
                return;
            }
            final Vector<String> fieldsToPlot = new Vector<String>();
            int count = 0;
            for (int i = 0; i < path.length; ++i) {
                if (path[i].getPath().length != 3) continue;
                ++count;
                String message = path[i].getPath()[1].toString();
                String field = path[i].getPath()[2].toString();
                fieldsToPlot.add(message + "." + field);
            }
            if (count == 0) {
                return;
            }
            JPopupMenu popup = new JPopupMenu();
            popup.add(I18n.text("Plot data")).addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LsfTreeMouseAdapter.this.panel.loadVisualization(new GenericPlot(fieldsToPlot.toArray(new String[0]), LsfTreeMouseAdapter.this.panel), true);
                }
            });
            popup.add(I18n.text("Timeline Plot")).addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LsfTreeMouseAdapter.this.panel.loadVisualization(new ReplayPlot(LsfTreeMouseAdapter.this.panel, fieldsToPlot.toArray(new String[0])), true);
                }
            });
            popup.add(I18n.text("Plot data on new window")).addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GenericPlot chart = new GenericPlot(fieldsToPlot.toArray(new String[0]), LsfTreeMouseAdapter.this.panel);
                    MRAChartPanel fcp = new MRAChartPanel(chart, LsfTreeMouseAdapter.this.source, LsfTreeMouseAdapter.this.panel);
                    JDialog dialog = new JDialog(ConfigFetch.getSuperParentAsFrame());
                    dialog.setTitle("[MRA] " + chart.getName());
                    dialog.setIconImage(ImageUtils.getScaledImage("images/menus/graph.png", 16, 16));
                    dialog.add(fcp);
                    dialog.setSize(640, 480);
                    dialog.setResizable(true);
                    dialog.setVisible(true);
                    fcp.regeneratePanel();
                }
            });
            if (count == 1) {
                popup.add(I18n.text("Plot ColorMap")).addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        NeptusLog.pub().info((Object)("<###> " + fieldsToPlot));
                        LsfTreeMouseAdapter.this.panel.loadVisualization(new ColorMapVisualization(LsfTreeMouseAdapter.this.panel, "ALL", (String)fieldsToPlot.get(0)), true);
                    }
                });
            }
            popup.show(this.tree, e.getX(), e.getY());
        }
    }
}

