/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.util.llf;

import java.awt.Color;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.SimpleDateFormat;
import java.util.TimeZone;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import pt.lsts.imc.IMCMessage;
import pt.lsts.imc.IMCUtil;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.mra.importers.IMraLogGroup;
import pt.lsts.neptus.mra.visualizations.MRAVisualization;
import pt.lsts.neptus.util.ImageUtils;

public class MessageHtmlVisualization
implements MRAVisualization {
    protected IMCMessage message;
    private static final SimpleDateFormat fmt = new SimpleDateFormat("HH:mm:ss.SSS");
    protected JScrollPane scroll;
    protected JLabel lbl;

    public MessageHtmlVisualization(final IMCMessage message) {
        fmt.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.message = message;
        this.lbl = new JLabel(IMCUtil.getAsHtml((IMCMessage)message));
        this.lbl.setBackground(Color.white);
        this.lbl.setOpaque(true);
        this.lbl.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 3) {
                    JPopupMenu popup = new JPopupMenu();
                    popup.add(I18n.text("Copy HTML to clipboard")).addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            StringSelection selection = new StringSelection(IMCUtil.getAsHtml((IMCMessage)message));
                            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(selection, null);
                        }
                    });
                    popup.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
        this.scroll = new JScrollPane(this.lbl);
    }

    @Override
    public void onHide() {
    }

    @Override
    public void onShow() {
    }

    @Override
    public boolean supportsVariableTimeSteps() {
        return false;
    }

    @Override
    public String getName() {
        return String.format("%s [%s, %02x]", this.message.getAbbrev(), fmt.format(this.message.getDate()), this.lbl.getText().hashCode());
    }

    @Override
    public ImageIcon getIcon() {
        return ImageUtils.getIcon("images/menus/view.png");
    }

    @Override
    public Double getDefaultTimeStep() {
        return null;
    }

    @Override
    public Component getComponent(IMraLogGroup source, double timestep) {
        return this.scroll;
    }

    @Override
    public MRAVisualization.Type getType() {
        return MRAVisualization.Type.TABLE;
    }

    @Override
    public void onCleanup() {
    }

    @Override
    public boolean canBeApplied(IMraLogGroup source) {
        return true;
    }

    public int hashCode() {
        return new String(this.message.getSrc() + "." + this.message.getSrcEnt() + "." + this.message.getTimestampMillis()).hashCode();
    }
}

