/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.util.llf;

import java.text.SimpleDateFormat;
import java.util.TimeZone;
import javax.swing.table.AbstractTableModel;
import org.apache.commons.collections.map.LRUMap;
import pt.lsts.imc.IMCMessage;
import pt.lsts.imc.lsf.LsfIndex;

public class RawMessagesTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private LsfIndex index;
    private SimpleDateFormat sdf = new SimpleDateFormat("YYYY-MM-dd HH:mm:ss.SSS");
    LRUMap map = new LRUMap(100);
    private static final int NUM = 0;
    private static final int TIMESTAMP = 1;
    private static final int MGID = 2;
    private static final int SRC = 3;
    private static final int SRC_ENT = 4;
    private static final int DST = 5;
    private static final int DST_ENT = 6;
    private static final int SIZE = 7;

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return "Index";
            }
            case 1: {
                return "Time";
            }
            case 2: {
                return "Type";
            }
            case 3: {
                return "Source";
            }
            case 4: {
                return "Source Entity";
            }
            case 5: {
                return "Destination";
            }
            case 6: {
                return "Destination entity";
            }
            case 7: {
                return "Size";
            }
        }
        return "??";
    }

    public RawMessagesTableModel(LsfIndex index) {
        this.index = index;
        this.sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    @Override
    public int getRowCount() {
        return this.index.getNumberOfMessages();
    }

    @Override
    public int getColumnCount() {
        return 8;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (!this.map.containsKey((Object)rowIndex)) {
            this.map.put((Object)rowIndex, (Object)this.index.getMessage(rowIndex));
        }
        IMCMessage m = (IMCMessage)this.map.get((Object)rowIndex);
        switch (columnIndex) {
            case 0: {
                return String.format("%8d", rowIndex);
            }
            case 1: {
                return this.sdf.format(m.getDate());
            }
            case 3: {
                return m.getSourceName();
            }
            case 4: {
                return this.index.entityNameOf((int)m.getSrcEnt());
            }
            case 5: {
                return this.index.getDefinitions().getResolver().resolve(m.getDst());
            }
            case 6: {
                if (m.getSrc() == m.getDst()) {
                    return this.index.entityNameOf((int)m.getDstEnt());
                }
                return m.getDstEnt();
            }
            case 2: {
                return m.getAbbrev();
            }
            case 7: {
                return this.index.sizeOf(rowIndex);
            }
        }
        return "??";
    }
}

