/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.util.llf.chart;

import java.io.File;
import java.util.Vector;
import pt.lsts.neptus.mra.MRAPanel;
import pt.lsts.neptus.mra.plots.ScriptedPlot;
import pt.lsts.neptus.mra.visualizations.MRAVisualization;
import pt.lsts.neptus.plugins.PluginsRepository;

public class MRAChartFactory {
    private static Class<?>[] automaticCharts = null;

    public static MRAVisualization[] getAutomaticCharts(MRAPanel panel) {
        if (automaticCharts == null) {
            automaticCharts = PluginsRepository.getMraVisualizations().values().toArray(new Class[0]);
        }
        Vector<MRAVisualization> charts = new Vector<MRAVisualization>();
        for (int i = 0; i < automaticCharts.length; ++i) {
            try {
                MRAVisualization chart = (MRAVisualization)automaticCharts[i].getConstructor(MRAPanel.class).newInstance(panel);
                charts.add(chart);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Vector<ScriptedPlot> scrptPlots = MRAChartFactory.getScriptedPlots(panel);
        if (scrptPlots != null && scrptPlots.size() > 0) {
            charts.addAll(scrptPlots);
        }
        return charts.toArray(new MRAVisualization[charts.size()]);
    }

    public static Vector<ScriptedPlot> getScriptedPlots(MRAPanel panel) {
        File[] scripts;
        Vector<ScriptedPlot> plots = new Vector<ScriptedPlot>();
        File sFx = new File("conf/mraplots");
        File[] fileArray = scripts = sFx.exists() ? sFx.listFiles() : null;
        if (scripts == null || scripts.length == 0) {
            return plots;
        }
        for (File f : scripts) {
            if (f.isDirectory() || !f.canRead()) continue;
            ScriptedPlot plot = new ScriptedPlot(panel, f.getAbsolutePath());
            plots.add(plot);
        }
        return plots;
    }
}

