/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.util.logdb;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import pt.lsts.imc.IMCDefinition;
import pt.lsts.imc.IMCMessage;
import pt.lsts.imc.IMCMessageType;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.util.FileUtil;
import pt.lsts.neptus.util.conf.ConfigFetch;

public class SQLiteSerialization {
    private static final String driver = "org.sqlite.JDBC";
    private static DateFormat day = new SimpleDateFormat("yyyyMMdd");
    private static DateFormat timeOfDay = new SimpleDateFormat("HHmmss");
    private Connection conn = null;
    private PreparedStatement newHeader;
    private PreparedStatement updateHeaderMsgId;
    private long commitTime = System.currentTimeMillis();
    private static SQLiteSerialization sessionDb = null;
    private String filename = null;
    private static final String DB_TEMPLATE_FILENAME = "conf/sqlite_template.db";
    protected LinkedHashMap<Integer, PreparedStatement> messageInserts = new LinkedHashMap();

    public static synchronized SQLiteSerialization getDb() {
        if (sessionDb == null) {
            sessionDb = SQLiteSerialization.connect();
        }
        return sessionDb;
    }

    public static SQLiteSerialization connect() {
        return SQLiteSerialization.connect(SQLiteSerialization.getNewDbFilename());
    }

    public static SQLiteSerialization connect(String filename) {
        try {
            return new SQLiteSerialization(filename);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IMCMessage getLatestMessageOfType(int messageType) throws SQLException {
        IMCMessage msg = null;
        IMCMessageType type = new IMCMessage(Integer.valueOf(messageType)).getMessageType();
        String sql = "select * from " + type.getShortName() + " join (select * from IMC_MessageHeader where IMC_MessageType_id = " + messageType + " order by IMC_MessageHeader_timestamp desc limit 1) using (IMC_MessageHeader_id);";
        Connection connection = this.conn;
        synchronized (connection) {
            Statement st = this.conn.createStatement();
            ResultSet rs = st.executeQuery(sql);
            if (rs.next()) {
                try {
                    msg = IMCDefinition.getInstance().create(type.getShortName(), new Object[0]);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                msg.setTimestamp((double)rs.getLong("IMC_MessageHeader_timestamp"));
                for (String fieldName : type.getFieldNames()) {
                    msg.setValue(fieldName, SQLiteSerialization.extractValue(type.getFieldType(fieldName).getTypeName(), fieldName, rs));
                }
            }
            rs.close();
        }
        return msg;
    }

    public IMCMessage getLastMessageOfType(String messageAbbrev) throws SQLException {
        return this.getLastMessageOfType(IMCDefinition.getInstance().getMessageId(messageAbbrev));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IMCMessage getLastMessageOfType(int messageType) throws SQLException {
        IMCMessageType type = new IMCMessage(Integer.valueOf(messageType)).getMessageType();
        IMCMessage msg = null;
        String sql = "select * from (select * from " + type.getShortName() + " order by rowid desc limit 1) join IMC_MessageHeader using (IMC_MessageHeader_id)";
        Connection connection = this.conn;
        synchronized (connection) {
            Statement st = this.conn.createStatement();
            ResultSet rs = st.executeQuery(sql);
            if (rs.next()) {
                msg = new IMCMessage(type.getShortName());
                msg.setTimestamp((double)rs.getLong("IMC_MessageHeader_timestamp"));
                for (String fieldName : type.getFieldNames()) {
                    msg.setValue(fieldName, SQLiteSerialization.extractValue(type.getFieldType(fieldName).getTypeName(), fieldName, rs));
                }
            }
            rs.close();
        }
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long store(IMCMessage msg) throws SQLException {
        long href = this.storeHeader((IMCMessage)msg.getHeader());
        PreparedStatement stmt = this.getMessageInsertStatement(msg.getMgid());
        if (stmt == null) {
            return href;
        }
        stmt.setLong(1, href);
        int i = 2;
        IMCMessageType messageType = msg.getMessageType();
        for (String fieldName : messageType.getFieldNames()) {
            String fieldType = messageType.getFieldType(fieldName).getTypeName();
            if (fieldType.contains("int")) {
                stmt.setLong(i, msg.getLong(fieldName));
            } else if (fieldType.contains("fp")) {
                stmt.setDouble(i, msg.getDouble(fieldName));
            } else if (fieldType.equals("plaintext")) {
                stmt.setString(i, msg.getString(fieldName));
            } else if (fieldType.equals("rawdata")) {
                stmt.setBlob(i, new ByteArrayInputStream(msg.getRawData(fieldName)));
            } else if (fieldType.equals("message")) {
                long mref = -1L;
                stmt.setLong(i, mref);
            } else {
                NeptusLog.pub().error((Object)("Field type " + fieldType + " not recognized"));
            }
            ++i;
        }
        long msg_ref = -1L;
        Connection connection = this.conn;
        synchronized (connection) {
            stmt.executeUpdate();
            ResultSet rs = stmt.getGeneratedKeys();
            msg_ref = rs.getLong(1);
            rs.close();
        }
        this.updateHeaderMsgId.setLong(1, msg_ref);
        this.updateHeaderMsgId.setLong(2, href);
        connection = this.conn;
        synchronized (connection) {
            this.updateHeaderMsgId.executeUpdate();
        }
        if (System.currentTimeMillis() - this.commitTime > 1000L) {
            this.commit();
        }
        return href;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void commit() throws SQLException {
        this.commitTime = System.currentTimeMillis();
        Connection connection = this.conn;
        synchronized (connection) {
            this.conn.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SQLiteSerialization(String filename) throws SQLException {
        if (!new File(filename).canRead()) {
            FileUtil.copyFile(DB_TEMPLATE_FILENAME, filename);
        }
        this.conn = DriverManager.getConnection("jdbc:sqlite:" + filename);
        this.conn.setAutoCommit(false);
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (SQLiteSerialization.this.conn != null) {
                    try {
                        System.out.print("closing db connection...");
                        Connection connection = SQLiteSerialization.this.conn;
                        synchronized (connection) {
                            SQLiteSerialization.this.conn.close();
                        }
                        NeptusLog.pub().info((Object)"<###>Done.");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }));
        Connection connection = this.conn;
        synchronized (connection) {
            this.newHeader = this.conn.prepareStatement("INSERT INTO IMC_MessageHeader (IMC_MessageHeader_timestamp,IMC_Specification_id,IMC_MessageType_id,IMC_MessageHeader_src,IMC_MessageHeader_dst) VALUES (?, ?, ?, ?, ?)");
            this.updateHeaderMsgId = this.conn.prepareStatement("UPDATE IMC_MessageHeader set IMC_Message_id = ? where IMC_MessageHeader_id = ?;");
        }
        this.filename = filename;
    }

    private static String getNewDbFilename() {
        Date startDate = new Date();
        String filename = "log/db/" + day.format(startDate) + "/" + timeOfDay.format(startDate);
        new File(filename).mkdirs();
        return filename + "/sqlite.db";
    }

    protected PreparedStatement getMessageInsertStatement(int msgType) throws SQLException {
        if (this.messageInserts.containsKey(msgType)) {
            return this.messageInserts.get(msgType);
        }
        IMCMessageType type = IMCDefinition.getInstance().getType(Integer.valueOf(msgType));
        String secondPart = ") values (?";
        String sql = "insert into " + type.getShortName() + " (IMC_MessageHeader_id";
        for (String fieldName : type.getFieldNames()) {
            sql = sql + ",`" + fieldName + "`";
            secondPart = secondPart + ",?";
        }
        sql = sql + secondPart + ");";
        PreparedStatement stmt = this.conn.prepareStatement(sql);
        this.messageInserts.put(msgType, stmt);
        return stmt;
    }

    public static Object extractValue(String imcType, String column, ResultSet rs) throws SQLException {
        if (imcType.contains("int")) {
            return rs.getLong(column);
        }
        if (imcType.contains("fp")) {
            return rs.getDouble(column);
        }
        if (imcType.equals("plaintext")) {
            return rs.getString(column);
        }
        if (imcType.equals("rawdata")) {
            Blob b = rs.getBlob(column);
            return b.getBytes(1L, (int)b.length());
        }
        if (imcType.equals("message")) {
            return null;
        }
        return rs.getObject(column);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long storeHeader(IMCMessage header) throws SQLException {
        int src = header.getInteger("src");
        int dst = header.getInteger("src");
        this.newHeader.setDouble(1, header.getTimestamp() / 1000.0);
        this.newHeader.setInt(2, 0);
        this.newHeader.setInt(3, header.getMgid());
        this.newHeader.setInt(4, src);
        this.newHeader.setInt(5, dst);
        Connection connection = this.conn;
        synchronized (connection) {
            this.newHeader.executeUpdate();
        }
        ResultSet rs = this.newHeader.getGeneratedKeys();
        long l = rs.getLong(1);
        rs.close();
        if (System.currentTimeMillis() - this.commitTime > 1000L) {
            this.commit();
        }
        return l;
    }

    public Connection getConn() {
        return this.conn;
    }

    public String getFilename() {
        return this.filename;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws SQLException {
        ConfigFetch.initialize();
        final SQLiteSerialization ser = SQLiteSerialization.connect("myDb.db");
        NeptusLog.pub().info((Object)("<###> " + System.currentTimeMillis()));
        LinkedHashMap<Double, Long> all = new LinkedHashMap<Double, Long>();
        Connection connection = ser.conn;
        synchronized (connection) {
            Statement st = ser.conn.createStatement();
            ResultSet rs = st.executeQuery("select IMC_Message_id, IMC_MessageHeader_timestamp from IMC_MessageHeader where IMC_MessageType_id = 3");
            while (rs.next()) {
                all.put(rs.getDouble(2), rs.getLong(1));
            }
            rs.close();
        }
        NeptusLog.pub().info((Object)("<###> " + all.size()));
        NeptusLog.pub().info((Object)("<###> " + System.currentTimeMillis()));
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    try {
                        block3: while (true) {
                            Thread.sleep(1000L);
                            int i = 0;
                            while (true) {
                                if (i >= 10) continue block3;
                                IMCMessage m = ser.getLastMessageOfType(3);
                                NeptusLog.pub().info((Object)("<###> " + m.getValue("x")));
                                ++i;
                            }
                            break;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
        });
        t.start();
        Thread t2 = new Thread(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    try {
                        block3: while (true) {
                            Thread.sleep(1202L);
                            int i = 0;
                            while (true) {
                                if (i >= 10) continue block3;
                                IMCMessage m = ser.getLastMessageOfType(3);
                                NeptusLog.pub().info((Object)("<###> " + m.getValue("x")));
                                ++i;
                            }
                            break;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
        });
        t2.start();
        for (int i = 100000; i > 0; --i) {
            IMCMessage msg = null;
            try {
                msg = IMCDefinition.getInstance().create("EstimatedState", new Object[]{"x", i});
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            System.out.flush();
            NeptusLog.pub().info((Object)("<###> " + i));
            ser.store(msg);
        }
        System.exit(0);
    }

    static {
        try {
            Class.forName(driver);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

