/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.util.logdownload;

import foxtrot.AsyncTask;
import foxtrot.AsyncWorker;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.TimerTask;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JProgressBar;
import javax.swing.border.EmptyBorder;
import org.apache.commons.net.ftp.FTPFile;
import org.jdesktop.swingx.JXLabel;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.painter.AbstractAreaPainter;
import org.jdesktop.swingx.painter.CompoundPainter;
import org.jdesktop.swingx.painter.GlossPainter;
import org.jdesktop.swingx.painter.Painter;
import org.jdesktop.swingx.painter.RectanglePainter;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.ftp.FtpDownloader;
import pt.lsts.neptus.gui.MiniButton;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.util.DateTimeUtil;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.ImageUtils;
import pt.lsts.neptus.util.MathMiscUtils;
import pt.lsts.neptus.util.MovingAverage;
import pt.lsts.neptus.util.StreamUtil;
import pt.lsts.neptus.util.conf.GeneralPreferences;
import pt.lsts.neptus.util.logdownload.DownloadStateListener;
import pt.lsts.neptus.util.logdownload.QueueWorkTickets;

public class DownloaderPanel
extends JXPanel
implements ActionListener {
    private static final int DELAY_START_ON_TIMEOUT = 8000;
    private static final int DELAY_START_ON_QUEUE = 1000;
    private static boolean debug = false;
    public static final ImageIcon ICON_STOP = ImageUtils.getIcon("images/stop.png");
    public static final ImageIcon ICON_DOWNLOAD = ImageUtils.getIcon("images/restart.png");
    private static final Color COLOR_IDLE = new JXPanel().getBackground();
    private static final Color COLOR_DONE = new Color(140, 255, 170);
    private static final Color COLOR_NOT_DONE = new Color(255, 210, 140);
    private static final Color COLOR_TIMEOUT = new Color(173, 154, 79);
    private static final Color COLOR_QUEUED = new Color(255, 240, 245);
    private static final Color COLOR_ERROR = new Color(255, 100, 100);
    private static final Color COLOR_WORKING = new Color(190, 220, 240);
    public static final String ACTION_STOP = "Stop";
    public static final String ACTION_DOWNLOAD = "Download";
    private State state = State.IDLE;
    private DownloadStateListener stateListener = null;
    private boolean usePartialDownload = true;
    private String name = "";
    private String uri = "";
    private File outFile = null;
    private long startTimeMillis = -1L;
    private long endTimeMillis = -1L;
    private long downloadedSize = 0L;
    private long fullSize = -1L;
    private FtpDownloader client = null;
    private FTPFile ftpFile;
    private HashMap<String, FTPFile> directoryContentsList = new LinkedHashMap<String, FTPFile>();
    private boolean isDirectory = false;
    private long doneFilesForDirectory = 0L;
    private InputStream stream;
    private boolean stopping = false;
    private JXLabel infoLabel = null;
    private JProgressBar progressBar = null;
    private JXLabel msgLabel = null;
    private MiniButton stopButton = null;
    private MiniButton downloadButton = null;
    private RectanglePainter rectPainter;
    private CompoundPainter<JXPanel> compoundBackPainter;
    private ScheduledThreadPoolExecutor threadScheduledPool;
    private QueueWorkTickets<DownloaderPanel> queueWorkTickets;

    public DownloaderPanel() {
        this.initialize();
    }

    public DownloaderPanel(FtpDownloader client, FTPFile ftpFile, String uri, File outFile, ScheduledThreadPoolExecutor threadScheduledPool, QueueWorkTickets<DownloaderPanel> queueWorkTickets) {
        this(client, ftpFile, uri, outFile, null, threadScheduledPool, queueWorkTickets);
    }

    public DownloaderPanel(FtpDownloader client, FTPFile ftpFile, String uri, File outFile, HashMap<String, FTPFile> directoryContentsList, ScheduledThreadPoolExecutor threadScheduledPool, QueueWorkTickets<DownloaderPanel> queueWorkTickets) {
        this();
        this.client = client;
        this.ftpFile = ftpFile;
        this.name = ftpFile.getName();
        this.uri = uri;
        this.outFile = outFile;
        this.threadScheduledPool = threadScheduledPool;
        this.queueWorkTickets = queueWorkTickets;
        this.isDirectory = ftpFile.isDirectory();
        if (this.isDirectory && directoryContentsList != null && !directoryContentsList.isEmpty()) {
            this.directoryContentsList.putAll(directoryContentsList);
        }
        this.updateInfoLabel();
    }

    private void updateInfoLabel() {
        String prefixTxt = "";
        String txt = this.name + " (" + this.uri + ")";
        switch (this.getState()) {
            case ERROR: {
                prefixTxt = I18n.text("Error");
                break;
            }
            case NOT_DONE: {
                prefixTxt = I18n.text("Incomplete");
                break;
            }
            case TIMEOUT: {
                prefixTxt = I18n.text("Timeout");
                break;
            }
            case QUEUED: {
                prefixTxt = I18n.text("Queued");
                break;
            }
        }
        txt = prefixTxt + (prefixTxt.isEmpty() ? "" : " :: ") + txt;
        this.getInfoLabel().setText(txt);
    }

    private void initialize() {
        this.usePartialDownload = GeneralPreferences.logsDownloaderEnablePartialDownload;
        this.setPreferredSize(new Dimension(400, 75));
        this.updateBackColor(this.getBackground());
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setAutoCreateGaps(false);
        layout.setAutoCreateContainerGaps(false);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent((Component)this.getInfoLabel()).addGroup(layout.createSequentialGroup().addComponent(this.getProgressBar()).addGap(5).addComponent(this.getDownloadButton(), (int)this.getProgressBar().getPreferredSize().getHeight(), (int)this.getProgressBar().getPreferredSize().getHeight(), (int)this.getProgressBar().getPreferredSize().getHeight()).addComponent(this.getStopButton(), (int)this.getProgressBar().getPreferredSize().getHeight(), (int)this.getProgressBar().getPreferredSize().getHeight(), (int)this.getProgressBar().getPreferredSize().getHeight())).addComponent((Component)this.getMsgLabel()));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent((Component)this.getInfoLabel()).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.getProgressBar()).addComponent(this.getDownloadButton()).addComponent(this.getStopButton())).addComponent((Component)this.getMsgLabel()));
        layout.linkSize(1, this.getProgressBar(), this.getStopButton(), this.getDownloadButton());
    }

    private RectanglePainter getRectPainter() {
        if (this.rectPainter == null) {
            this.rectPainter = new RectanglePainter(5, 5, 5, 5, 10, 10);
            this.rectPainter.setFillPaint((Paint)COLOR_IDLE);
            this.rectPainter.setBorderPaint((Paint)COLOR_IDLE.darker().darker().darker());
            this.rectPainter.setStyle(AbstractAreaPainter.Style.BOTH);
            this.rectPainter.setBorderWidth(2.0f);
            this.rectPainter.setAntialiasing(true);
        }
        return this.rectPainter;
    }

    private CompoundPainter<JXPanel> getCompoundBackPainter() {
        this.compoundBackPainter = new CompoundPainter(new Painter[]{this.getRectPainter(), new GlossPainter()});
        return this.compoundBackPainter;
    }

    private void updateBackColor(Color color) {
        this.getRectPainter().setFillPaint((Paint)color);
        this.getRectPainter().setBorderPaint((Paint)color.darker().darker().darker());
        this.setBackgroundPainter((Painter)this.getCompoundBackPainter());
    }

    public String toString() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public String getUri() {
        return this.uri;
    }

    private JXLabel getInfoLabel() {
        if (this.infoLabel == null) {
            this.infoLabel = new JXLabel(I18n.text("Downloading..."));
        }
        return this.infoLabel;
    }

    private JXLabel getMsgLabel() {
        if (this.msgLabel == null) {
            this.msgLabel = new JXLabel("");
        }
        return this.msgLabel;
    }

    private JProgressBar getProgressBar() {
        if (this.progressBar == null) {
            this.progressBar = new JProgressBar(0);
            this.progressBar.setIndeterminate(false);
            this.progressBar.setStringPainted(true);
        }
        return this.progressBar;
    }

    private MiniButton getStopButton() {
        if (this.stopButton == null) {
            this.stopButton = new MiniButton();
            this.stopButton.setIcon(ICON_STOP);
            this.stopButton.addActionListener(this);
            this.stopButton.setActionCommand(ACTION_STOP);
            this.stopButton.setEnabled(false);
        }
        return this.stopButton;
    }

    private MiniButton getDownloadButton() {
        if (this.downloadButton == null) {
            this.downloadButton = new MiniButton();
            this.downloadButton.setIcon(ICON_DOWNLOAD);
            this.downloadButton.addActionListener(this);
            this.downloadButton.setActionCommand(ACTION_DOWNLOAD);
            this.downloadButton.setEnabled(true);
        }
        return this.downloadButton;
    }

    public State getState() {
        return this.state;
    }

    private void setState(State state) {
        State oldState = this.state;
        this.state = state;
        if (state == State.WORKING) {
            this.updateBackColor(COLOR_WORKING);
            this.getStopButton().setEnabled(true);
            this.getDownloadButton().setEnabled(false);
        } else if (state == State.ERROR) {
            this.updateBackColor(COLOR_ERROR);
            this.getStopButton().setEnabled(false);
            this.getDownloadButton().setEnabled(true);
        } else if (state == State.DONE) {
            this.updateBackColor(COLOR_DONE);
            this.getStopButton().setEnabled(false);
            this.getDownloadButton().setEnabled(true);
        } else if (state == State.NOT_DONE) {
            this.updateBackColor(COLOR_NOT_DONE);
            this.getStopButton().setEnabled(false);
            this.getDownloadButton().setEnabled(true);
        } else if (state == State.TIMEOUT) {
            this.updateBackColor(COLOR_TIMEOUT);
            this.getStopButton().setEnabled(true);
            this.getDownloadButton().setEnabled(true);
        } else if (state == State.QUEUED) {
            this.updateBackColor(COLOR_QUEUED);
            this.getStopButton().setEnabled(true);
            this.getDownloadButton().setEnabled(true);
        } else {
            this.updateBackColor(COLOR_IDLE);
            this.getStopButton().setEnabled(false);
            this.getDownloadButton().setEnabled(true);
        }
        this.updateInfoLabel();
        this.warnStateListener(this.state, oldState);
    }

    private void setStateIdle() {
        this.setState(State.IDLE);
    }

    private void setStateWorking() {
        this.setState(State.WORKING);
    }

    private void setStateError() {
        this.setState(State.ERROR);
    }

    private void setStateDone() {
        this.setState(State.DONE);
    }

    private void setStateNotDone() {
        this.setState(State.NOT_DONE);
    }

    private void setStateTimeout() {
        this.setState(State.TIMEOUT);
    }

    private void setStateQueued() {
        this.setState(State.QUEUED);
    }

    private void warnStateListener(State newState, State oldState) {
        if (this.stateListener != null && newState != oldState) {
            this.stateListener.downloaderStateChange(newState, oldState);
        }
    }

    public boolean addStateChangeListener(DownloadStateListener stateListener) {
        this.stateListener = stateListener;
        return true;
    }

    public boolean removeStateChangeListener() {
        this.stateListener = null;
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        if (ACTION_STOP.equals(action)) {
            this.doStop();
        } else if (ACTION_DOWNLOAD.equals(action)) {
            AsyncWorker.post((AsyncTask)new AsyncTask(){

                public Object run() throws Exception {
                    DownloaderPanel.this.doDownload();
                    return null;
                }

                public void finish() {
                }
            });
        }
    }

    public void actionDownload() {
        new Thread(){

            @Override
            public void run() {
                DownloaderPanel.this.doDownload();
            }
        }.start();
    }

    public void actionStop() {
        new Thread(){

            @Override
            public void run() {
                DownloaderPanel.this.doStop();
            }
        }.start();
    }

    public void actionStopAndInvalidate() {
        new Thread(){

            @Override
            public void run() {
                DownloaderPanel.this.doStopAndInvalidate();
            }
        }.start();
    }

    private boolean doDownload() {
        if (this.getState() == State.QUEUED) {
            if (this.queueWorkTickets.isLeased(this)) {
                return this.doDownloadWorker();
            }
            if (this.queueWorkTickets.isQueued(this)) {
                System.out.println("Is not leased but is queued! " + this.name);
                return true;
            }
            if (GeneralPreferences.logsNumberSimultaneousDownloadsControl) {
                return this.askForLease();
            }
            return this.doDownloadWorker();
        }
        if (GeneralPreferences.logsNumberSimultaneousDownloadsControl) {
            return this.askForLease();
        }
        return this.doDownloadWorker();
    }

    private boolean askForLease() {
        this.setStateQueued();
        Future<Boolean> future = this.queueWorkTickets.leaseAndWait(this, new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                if (DownloaderPanel.this.getState() == State.QUEUED) {
                    NeptusLog.pub().debug((Object)("callable download for " + DownloaderPanel.this.getName()));
                    return DownloaderPanel.this.doDownloadWorker();
                }
                DownloaderPanel.this.queueWorkTickets.release(DownloaderPanel.this);
                return true;
            }
        });
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doDownloadWorker() {
        boolean isOnTimeout;
        block43: {
            if (this.getState() == State.WORKING) {
                return false;
            }
            State prevState = this.getState();
            this.setStateWorking();
            this.stopping = false;
            String basePath = this.outFile.getParentFile().getParentFile().getParentFile().getAbsolutePath();
            NeptusLog.pub().debug((Object)(DownloaderPanel.class.getSimpleName() + " :: " + "Downloading" + (this.isDirectory ? " directory" : "") + " '" + this.name + "' from '" + this.uri + "' to " + this.outFile.getAbsolutePath()));
            if (!this.client.isConnected()) {
                try {
                    this.client.renewClient();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.setStateError();
                    return false;
                }
            }
            long begByte = 0L;
            if (this.usePartialDownload && prevState != State.DONE && this.outFile.exists() && this.outFile.isFile() && !this.isDirectory) {
                begByte = this.outFile.length();
                if (begByte > this.ftpFile.getSize()) {
                    begByte = 0L;
                }
                NeptusLog.pub().warn((Object)(DownloaderPanel.class.getSimpleName() + " :: " + "!begin byte: " + begByte));
            }
            this.setStateWorking();
            isOnTimeout = false;
            if (debug) {
                NeptusLog.pub().info((Object)("<###>URI: " + this.uri));
            }
            try {
                HashMap<String, FTPFile> fileList = this.directoryContentsList;
                long contentLengh = this.ftpFile.getSize();
                final long listSize = fileList.size();
                this.getProgressBar().setValue(0);
                this.getProgressBar().setString(begByte == 0L ? I18n.text("Starting...") : I18n.text("Resuming..."));
                this.getMsgLabel().setText("");
                this.startTimeMillis = System.currentTimeMillis();
                this.getInfoLabel().setText(this.name + " (" + this.uri + ")");
                if (!this.isDirectory) {
                    if (begByte > 0L) {
                        this.downloadedSize = begByte;
                        this.client.getClient().setRestartOffset(begByte);
                        System.out.println(DownloaderPanel.class.getSimpleName() + " :: " + "using resume");
                        begByte = this.client.getClient().getRestartOffset();
                    } else {
                        this.downloadedSize = 0L;
                    }
                    this.stream = this.client.getClient().retrieveFileStream(new String(this.uri.getBytes(), "ISO-8859-1"));
                    this.fullSize = this.ftpFile.getSize();
                    this.outFile.getParentFile().mkdirs();
                    try {
                        this.outFile.createNewFile();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    FilterDownloadDataMonitor ioS = new FilterDownloadDataMonitor(this.stream, this.threadScheduledPool);
                    boolean streamRes = StreamUtil.copyStreamToFile(ioS, this.outFile, begByte != 0L);
                    this.outFile.setLastModified(this.ftpFile.getTimestamp().getTimeInMillis());
                    if (debug) {
                        NeptusLog.pub().info((Object)("<###>To receive / received: " + (begByte > 0L ? this.fullSize - begByte : this.fullSize) + "/" + this.downloadedSize));
                    } else {
                        NeptusLog.pub().debug((Object)("To receive / received: " + (begByte > 0L ? this.fullSize - begByte : this.fullSize) + "/" + this.downloadedSize));
                    }
                    this.endTimeMillis = System.currentTimeMillis();
                    ioS.stopDisplayUpdate();
                    if (streamRes && this.fullSize == this.downloadedSize) {
                        this.getProgressBar().setString(I18n.textf("%fullSize done (in %time) @%dataRate", MathMiscUtils.parseToEngineeringRadix2Notation(this.fullSize, 1) + "B", DateTimeUtil.milliSecondsToFormatedString(this.endTimeMillis - this.startTimeMillis), MathMiscUtils.parseToEngineeringRadix2Notation((double)(begByte > 0L ? this.downloadedSize - begByte : this.downloadedSize) / ((double)(this.endTimeMillis - this.startTimeMillis) / 1000.0), 1) + "B/s"));
                    } else {
                        this.getProgressBar().setString(I18n.textf("%fullSize partially [%partialSize] done (in %time) @%dataRate", MathMiscUtils.parseToEngineeringRadix2Notation(this.fullSize, 1) + "B", MathMiscUtils.parseToEngineeringRadix2Notation(this.downloadedSize, 1) + "B", DateTimeUtil.milliSecondsToFormatedString(this.endTimeMillis - this.startTimeMillis), MathMiscUtils.parseToEngineeringRadix2Notation((double)(begByte > 0L ? this.downloadedSize - begByte : this.downloadedSize) / ((double)(this.endTimeMillis - this.startTimeMillis) / 1000.0), 1) + "B/s"));
                    }
                    if (streamRes && this.fullSize == this.downloadedSize) {
                        this.setStateDone();
                        this.getMsgLabel().setText(I18n.textf("Saved in '%filePath'", this.outFile.getAbsolutePath()));
                    } else {
                        this.setStateNotDone();
                    }
                    break block43;
                }
                this.getProgressBar().setString(I18n.text("Starting... ") + (listSize >= 0L ? I18n.textf("%number files", MathMiscUtils.parseToEngineeringRadix2Notation(this.fullSize, 1)) : "unknown files"));
                this.threadScheduledPool.scheduleAtFixedRate(new Runnable(){

                    @Override
                    public void run() {
                        DownloaderPanel.this.getProgressBar().setValue((int)((float)DownloaderPanel.this.doneFilesForDirectory / (float)listSize * 100.0f));
                        DownloaderPanel.this.getProgressBar().setString(DownloaderPanel.this.doneFilesForDirectory + " out of " + listSize);
                        if (DownloaderPanel.this.state != State.WORKING) {
                            DownloaderPanel.this.threadScheduledPool.remove(this);
                            DownloaderPanel.this.threadScheduledPool.purge();
                        }
                    }
                }, 10L, 100L, TimeUnit.MILLISECONDS);
                this.doneFilesForDirectory = 0L;
                for (String key : fileList.keySet()) {
                    try {
                        if (this.stopping) break;
                        File out = new File(basePath + "/" + key);
                        if (out.exists() && fileList.get(key).getSize() == out.length()) {
                            ++this.doneFilesForDirectory;
                            NeptusLog.pub().debug((Object)("File for folder already synchronized: " + this.doneFilesForDirectory + " | " + key));
                            continue;
                        }
                        this.stream = this.client.getClient().retrieveFileStream(new String(key.getBytes(), "ISO-8859-1"));
                        out.getParentFile().mkdirs();
                        try {
                            out.createNewFile();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        boolean streamRes = StreamUtil.copyStreamToFile(this.stream, out, false);
                        out.setLastModified(fileList.get(key).getTimestamp().getTimeInMillis());
                        if (this.client.getClient() != null) {
                            this.client.getClient().completePendingCommand();
                        }
                        if (!streamRes) continue;
                        ++this.doneFilesForDirectory;
                    }
                    catch (Exception e) {
                        if (this.stopping) continue;
                        e.printStackTrace();
                    }
                }
                this.endTimeMillis = System.currentTimeMillis();
                if (this.doneFilesForDirectory == listSize) {
                    this.getProgressBar().setString(I18n.textf("%listSize files done (in %time) @%dataRate", listSize, DateTimeUtil.milliSecondsToFormatedString(this.endTimeMillis - this.startTimeMillis), MathMiscUtils.parseToEngineeringRadix2Notation((double)this.downloadedSize / ((double)(this.endTimeMillis - this.startTimeMillis) / 1000.0), 1) + "B/s"));
                    this.getMsgLabel().setText(I18n.textf("Saved in '%filePath'", this.outFile.getAbsolutePath()));
                    this.setStateDone();
                } else {
                    this.setStateNotDone();
                }
            }
            catch (Exception ex) {
                if (!this.stopping) {
                    NeptusLog.pub().warn((Object)ex, (Throwable)ex);
                }
                if (ex.getMessage() != null && ex.getMessage().startsWith("Timeout waiting for connection")) {
                    isOnTimeout = true;
                    this.getProgressBar().setString(" " + I18n.text("Error:") + " " + ex.getMessage());
                    this.setStateTimeout();
                } else {
                    this.getProgressBar().setString(I18n.text("Error:") + " " + (ex.getMessage() != null ? ex.getMessage() : ex.getClass().getSimpleName()));
                    this.setStateError();
                }
            }
            finally {
                this.queueWorkTickets.release(this);
                try {
                    if (this.client.isConnected()) {
                        this.client.getClient().disconnect();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        if (isOnTimeout) {
            final Runnable command = new Runnable(){

                @Override
                public void run() {
                    if (DownloaderPanel.this.getState() == State.TIMEOUT) {
                        DownloaderPanel.this.doDownload();
                    }
                }
            };
            this.threadScheduledPool.schedule(new Runnable(){

                @Override
                public void run() {
                    new Thread(command, DownloaderPanel.class.getSimpleName() + " :: On Timeout Retry Launcher for '" + DownloaderPanel.this.name + "'").start();
                }
            }, 8000L, TimeUnit.MILLISECONDS);
        }
        return true;
    }

    private void doStop(boolean invalidate) {
        this.stopping = true;
        try {
            if (this.stream != null) {
                this.stream.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            if (this.client != null && this.client.isConnected()) {
                this.client.getClient().disconnect();
            }
            if (invalidate) {
                this.client = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.getState() != State.DONE) {
            this.setStateNotDone();
        }
        if (this.getState() == State.TIMEOUT || this.getState() == State.QUEUED) {
            this.setStateNotDone();
        }
        if (invalidate) {
            this.stateListener = null;
        }
        this.queueWorkTickets.release(this);
    }

    protected void doStop() {
        this.doStop(false);
    }

    protected void doStopAndInvalidate() {
        this.doStop(true);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DownloaderPanel)) {
            return false;
        }
        DownloaderPanel cmp = (DownloaderPanel)obj;
        return this.uri.equals(cmp.uri);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public static void main(String[] args) {
        GuiUtils.setLookAndFeel();
        DownloaderPanel dpn = new DownloaderPanel();
        dpn.getProgressBar().setString("3452bytes (15.9KB/s),00:00:07s left");
    }

    private class FilterDownloadDataMonitor
    extends FilterInputStream {
        private static final int MAX_TIME_MINUTES_LEFT_TO_SHOW = 180;
        private long prec;
        private long timeC;
        private long btimer;
        private ScheduledThreadPoolExecutor threadScheduledPool;
        private Runnable ttask;
        private ScheduledFuture<?> taskFuture;
        private MovingAverage movingAverage;

        public FilterDownloadDataMonitor(InputStream in, ScheduledThreadPoolExecutor threadScheduledPool) {
            super(in);
            this.prec = 0L;
            this.timeC = -1L;
            this.btimer = 0L;
            this.threadScheduledPool = null;
            this.ttask = null;
            this.taskFuture = null;
            this.movingAverage = new MovingAverage(25);
            this.threadScheduledPool = threadScheduledPool;
        }

        public void stopDisplayUpdate() {
            if (this.ttask != null) {
                this.taskFuture.cancel(true);
            }
            this.prec = (long)((double)DownloaderPanel.this.downloadedSize / (double)DownloaderPanel.this.fullSize * 100.0);
            DownloaderPanel.this.getProgressBar().setValue((int)this.prec);
        }

        @Override
        public int read() throws IOException {
            int tmp = super.read();
            DownloaderPanel.this.downloadedSize += tmp == -1 ? 0L : 1L;
            if (tmp != -1) {
                this.updateValueInMessagePanel();
            }
            return tmp;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int tmp = super.read(b, off, len);
            DownloaderPanel.this.downloadedSize += tmp == -1 ? 0L : (long)tmp;
            if (tmp != -1) {
                this.updateValueInMessagePanel();
            }
            return tmp;
        }

        private void updateValueInMessagePanel() {
            if (DownloaderPanel.this.downloadedSize >= DownloaderPanel.this.fullSize) {
                if (this.ttask != null) {
                    this.taskFuture.cancel(true);
                    this.ttask = null;
                    this.updateProgressInfo();
                }
            } else if (this.ttask == null) {
                this.ttask = this.getTimerTask();
                this.taskFuture = this.threadScheduledPool.schedule(this.ttask, 150L, TimeUnit.MILLISECONDS);
            }
        }

        private void updateProgressInfo() {
            double bps = -1.0;
            if (this.timeC != -1L) {
                long ct = System.currentTimeMillis();
                long deltaT = ct - this.timeC;
                long deltaB = DownloaderPanel.this.downloadedSize - this.btimer;
                if ((double)deltaT > 1000.0) {
                    this.timeC = ct;
                    this.btimer = DownloaderPanel.this.downloadedSize;
                }
                bps = (double)deltaB / ((double)deltaT / 1000.0);
                this.movingAverage.update(bps);
            } else {
                this.timeC = System.currentTimeMillis();
                this.btimer = DownloaderPanel.this.downloadedSize;
                this.movingAverage.clear();
            }
            this.prec = (long)((double)DownloaderPanel.this.downloadedSize / (double)DownloaderPanel.this.fullSize * 100.0);
            DownloaderPanel.this.getProgressBar().setValue((int)this.prec);
            DownloaderPanel.this.getProgressBar().setString(I18n.textf("%downloadedSize of %fullSize %dataRate - %remainingSize remaining", MathMiscUtils.parseToEngineeringRadix2Notation(DownloaderPanel.this.downloadedSize, 1) + "B", MathMiscUtils.parseToEngineeringRadix2Notation(DownloaderPanel.this.fullSize, 1) + "B", bps < 0.0 ? "" : " @" + MathMiscUtils.parseToEngineeringRadix2Notation(this.movingAverage.mean(), 1) + "B/s", this.getTimeLeft(this.movingAverage.mean())));
        }

        private String getTimeLeft(double bps) {
            long maxS;
            long leftB = DownloaderPanel.this.fullSize - DownloaderPanel.this.downloadedSize;
            double tLeft = (double)leftB / bps;
            if (tLeft < (double)(maxS = 10800L)) {
                return DateTimeUtil.milliSecondsToFormatedString((long)(MathMiscUtils.round(tLeft, 1) * 1000.0));
            }
            return "+" + DateTimeUtil.milliSecondsToFormatedString(maxS * 1000L);
        }

        private TimerTask getTimerTask() {
            return new TimerTask(){

                @Override
                public void run() {
                    FilterDownloadDataMonitor.this.ttask = null;
                    if (DownloaderPanel.this.downloadedSize >= DownloaderPanel.this.fullSize) {
                        return;
                    }
                    FilterDownloadDataMonitor.this.updateProgressInfo();
                }
            };
        }
    }

    public static enum State {
        IDLE,
        WORKING,
        DONE,
        ERROR,
        NOT_DONE,
        TIMEOUT,
        QUEUED;

    }
}

