/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.util.logdownload;

import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.SortOrder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdesktop.swingx.JXList;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.ImageUtils;
import pt.lsts.neptus.util.MathMiscUtils;
import pt.lsts.neptus.util.logdownload.LogFileInfo;
import pt.lsts.neptus.util.logdownload.LogFolderInfo;

public class LogFileInfoList
extends JXList {
    public static final Icon ICON_NEW = ImageUtils.getScaledIcon("images/downloader/file_new.png", 20, 20);
    public static final Icon ICON_UNKNOWN = ImageUtils.getScaledIcon("images/downloader/file_question.png", 20, 20);
    public static final Icon ICON_DOWN = ImageUtils.getScaledIcon("images/downloader/file_down.png", 20, 20);
    public static final Icon ICON_ERROR = ImageUtils.getScaledIcon("images/downloader/file_error.png", 20, 20);
    public static final Icon ICON_INCOMP = ImageUtils.getScaledIcon("images/downloader/file_warn.png", 20, 20);
    public static final Icon ICON_SYNC = ImageUtils.getScaledIcon("images/downloader/file_sync.png", 20, 20);
    public static final Icon ICON_LOCAL = ImageUtils.getScaledIcon("images/downloader/file_local.png", 20, 20);
    DefaultListModel<LogFileInfo> myModel = new DefaultListModel();

    public LogFileInfoList() {
        this.initialize();
    }

    public void initialize() {
        this.setModel(this.myModel);
        this.setSelectionMode(2);
        this.setCellRenderer(new ListCellRenderer<LogFileInfo>(){

            @Override
            public Component getListCellRendererComponent(JList<? extends LogFileInfo> list, LogFileInfo value, int index, boolean isSelected, boolean cellHasFocus) {
                try {
                    LogFileInfo folder = value;
                    String infoSize = "";
                    if (folder.getSize() >= 0L) {
                        infoSize = " (" + MathMiscUtils.parseToEngineeringRadix2Notation(folder.getSize(), 1) + "B" + (!folder.isDirectory() ? "" : (folder.getDirectoryContents() == null || folder.getDirectoryContents().isEmpty() ? "" : " | " + I18n.textf("%files files", folder.getDirectoryContents().size()))) + ")";
                    }
                    JLabel lbl = new JLabel(folder.getName() + infoSize, ICON_NEW, 2){

                        @Override
                        public void validate() {
                        }

                        @Override
                        public void invalidate() {
                        }

                        @Override
                        public void repaint() {
                        }

                        @Override
                        public void revalidate() {
                        }

                        @Override
                        public void repaint(long tm, int x, int y, int width, int height) {
                        }

                        @Override
                        public void repaint(Rectangle r) {
                        }

                        @Override
                        protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
                            if (propertyName.equals("text") || (propertyName.equals("font") || propertyName.equals("foreground")) && oldValue != newValue && this.getClientProperty("html") != null) {
                                super.firePropertyChange(propertyName, oldValue, newValue);
                            }
                        }

                        @Override
                        public void firePropertyChange(String propertyName, byte oldValue, byte newValue) {
                        }

                        @Override
                        public void firePropertyChange(String propertyName, char oldValue, char newValue) {
                        }

                        @Override
                        public void firePropertyChange(String propertyName, short oldValue, short newValue) {
                        }

                        @Override
                        public void firePropertyChange(String propertyName, int oldValue, int newValue) {
                        }

                        @Override
                        public void firePropertyChange(String propertyName, long oldValue, long newValue) {
                        }

                        @Override
                        public void firePropertyChange(String propertyName, float oldValue, float newValue) {
                        }

                        @Override
                        public void firePropertyChange(String propertyName, double oldValue, double newValue) {
                        }

                        @Override
                        public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
                        }
                    };
                    if (folder.getState() == LogFolderInfo.State.NEW) {
                        lbl.setIcon(ICON_NEW);
                    } else if (folder.getState() == LogFolderInfo.State.DOWNLOADING) {
                        lbl.setIcon(ICON_DOWN);
                    } else if (folder.getState() == LogFolderInfo.State.ERROR) {
                        lbl.setIcon(ICON_ERROR);
                    } else if (folder.getState() == LogFolderInfo.State.INCOMPLETE) {
                        lbl.setIcon(ICON_INCOMP);
                    } else if (folder.getState() == LogFolderInfo.State.SYNC) {
                        lbl.setIcon(ICON_SYNC);
                    } else if (folder.getState() == LogFolderInfo.State.UNKNOWN) {
                        lbl.setIcon(ICON_UNKNOWN);
                    } else if (folder.getState() == LogFolderInfo.State.LOCAL) {
                        lbl.setIcon(ICON_LOCAL);
                    }
                    lbl.setBackground(Color.white);
                    if (isSelected) {
                        lbl.setForeground(LogFileInfoList.this.getBackground());
                        lbl.setBackground(LogFileInfoList.this.getForeground());
                    }
                    lbl.setOpaque(true);
                    lbl.setHorizontalAlignment(2);
                    return lbl;
                }
                catch (Exception e) {
                    return new JLabel("?");
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() != 1 || e.getModifiers() != 128 || e.getClickCount() == 1) {
                    // empty if block
                }
                if (e.getButton() != 1 || e.getClickCount() == 2) {
                    // empty if block
                }
            }
        });
    }

    public void addFile(LogFileInfo file) {
        if (!this.myModel.contains(file)) {
            this.myModel.addElement(file);
        }
    }

    public void removeFile(LogFileInfo file) {
        this.myModel.removeElement(file);
    }

    public boolean containsFile(LogFileInfo file) {
        return this.myModel.contains(file);
    }

    public LogFileInfo getFile(String name) {
        if (!this.containsFile(new LogFileInfo(name))) {
            return null;
        }
        Enumeration<LogFileInfo> iter = this.myModel.elements();
        while (iter.hasMoreElements()) {
            try {
                LogFileInfo lfx = iter.nextElement();
                if (!lfx.getName().equals(name)) continue;
                return lfx;
            }
            catch (Exception e) {
            }
        }
        return null;
    }

    public static void main(String[] args) {
        final LogFileInfoList list = new LogFileInfoList();
        list.addFile(new LogFileInfo("22/A"));
        list.addFile(new LogFileInfo("A12/A"));
        list.addFile(new LogFileInfo("12/A"));
        list.addFile(new LogFileInfo("a12/A"));
        list.addFile(new LogFileInfo("22/a"));
        list.setSortable(true);
        list.setAutoCreateRowSorter(true);
        list.setSortOrder(SortOrder.ASCENDING);
        list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                for (Object sel : list.getSelectedValues()) {
                    NeptusLog.pub().info((Object)("<###> " + (LogFileInfo)sel));
                }
            }
        });
        GuiUtils.testFrame((JComponent)((Object)list));
    }
}

