/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.util.logdownload;

import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.SortOrder;
import org.jdesktop.swingx.JXList;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.ImageUtils;
import pt.lsts.neptus.util.logdownload.LogFolderInfo;

public class LogFolderInfoList
extends JXList {
    public static final Icon ICON_NEW = ImageUtils.getScaledIcon("images/downloader/folder_grey3.png", 20, 20);
    public static final Icon ICON_UNKNOWN = ImageUtils.getScaledIcon("images/downloader/folder_grey2.png", 20, 20);
    public static final Icon ICON_DOWN = ImageUtils.getScaledIcon("images/downloader/folder_download.png", 20, 20);
    public static final Icon ICON_ERROR = ImageUtils.getScaledIcon("images/downloader/folder_red1.png", 20, 20);
    public static final Icon ICON_INCOMP = ImageUtils.getScaledIcon("images/downloader/folder_yellow1.png", 20, 20);
    public static final Icon ICON_SYNC = ImageUtils.getScaledIcon("images/downloader/folder_green1.png", 20, 20);
    public static final Icon ICON_LOCAL = ImageUtils.getScaledIcon("images/downloader/folder_green2.png", 20, 20);
    DefaultListModel<LogFolderInfo> myModel = new DefaultListModel();

    public LogFolderInfoList() {
        this.initialize();
    }

    public void initialize() {
        this.setModel(this.myModel);
        this.setSelectionMode(2);
        this.setCellRenderer(new ListCellRenderer<LogFolderInfo>(){

            @Override
            public Component getListCellRendererComponent(JList<? extends LogFolderInfo> list, LogFolderInfo value, int index, boolean isSelected, boolean cellHasFocus) {
                try {
                    LogFolderInfo folder = value;
                    JLabel lbl = new JLabel(folder.getName(), ICON_NEW, 2){

                        @Override
                        public void validate() {
                        }

                        @Override
                        public void invalidate() {
                        }

                        @Override
                        public void repaint() {
                        }

                        @Override
                        public void revalidate() {
                        }

                        @Override
                        public void repaint(long tm, int x, int y, int width, int height) {
                        }

                        @Override
                        public void repaint(Rectangle r) {
                        }

                        @Override
                        protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
                            if (propertyName.equals("text") || (propertyName.equals("font") || propertyName.equals("foreground")) && oldValue != newValue && this.getClientProperty("html") != null) {
                                super.firePropertyChange(propertyName, oldValue, newValue);
                            }
                        }

                        @Override
                        public void firePropertyChange(String propertyName, byte oldValue, byte newValue) {
                        }

                        @Override
                        public void firePropertyChange(String propertyName, char oldValue, char newValue) {
                        }

                        @Override
                        public void firePropertyChange(String propertyName, short oldValue, short newValue) {
                        }

                        @Override
                        public void firePropertyChange(String propertyName, int oldValue, int newValue) {
                        }

                        @Override
                        public void firePropertyChange(String propertyName, long oldValue, long newValue) {
                        }

                        @Override
                        public void firePropertyChange(String propertyName, float oldValue, float newValue) {
                        }

                        @Override
                        public void firePropertyChange(String propertyName, double oldValue, double newValue) {
                        }

                        @Override
                        public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
                        }
                    };
                    if (folder.getState() == LogFolderInfo.State.NEW) {
                        lbl.setIcon(ICON_NEW);
                    } else if (folder.getState() == LogFolderInfo.State.DOWNLOADING) {
                        lbl.setIcon(ICON_DOWN);
                    } else if (folder.getState() == LogFolderInfo.State.ERROR) {
                        lbl.setIcon(ICON_ERROR);
                    } else if (folder.getState() == LogFolderInfo.State.INCOMPLETE) {
                        lbl.setIcon(ICON_INCOMP);
                    } else if (folder.getState() == LogFolderInfo.State.SYNC) {
                        lbl.setIcon(ICON_SYNC);
                    } else if (folder.getState() == LogFolderInfo.State.UNKNOWN) {
                        lbl.setIcon(ICON_UNKNOWN);
                    } else if (folder.getState() == LogFolderInfo.State.LOCAL) {
                        lbl.setIcon(ICON_LOCAL);
                    }
                    lbl.setBackground(Color.white);
                    if (isSelected) {
                        lbl.setForeground(LogFolderInfoList.this.getBackground());
                        lbl.setBackground(LogFolderInfoList.this.getForeground());
                    }
                    lbl.setOpaque(true);
                    lbl.setHorizontalAlignment(2);
                    return lbl;
                }
                catch (Exception e) {
                    return new JLabel("?");
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() != 1 || e.getModifiers() != 128 || e.getClickCount() == 1) {
                    // empty if block
                }
                if (e.getButton() != 1 || e.getClickCount() == 2) {
                    // empty if block
                }
                if (e.getButton() == 3) {
                    // empty if block
                }
            }
        });
    }

    public void addFolder(LogFolderInfo folder) {
        if (!this.myModel.contains(folder)) {
            this.myModel.addElement(folder);
        }
    }

    public void removeFolder(LogFolderInfo folder) {
        this.myModel.removeElement(folder);
    }

    public boolean containsFolder(LogFolderInfo folder) {
        return this.myModel.contains(folder);
    }

    public LogFolderInfo getFolder(String name) {
        if (!this.containsFolder(new LogFolderInfo(name))) {
            return null;
        }
        Enumeration<LogFolderInfo> iter = this.myModel.elements();
        while (iter.hasMoreElements()) {
            try {
                LogFolderInfo lfd = iter.nextElement();
                if (!lfd.getName().equals(name)) continue;
                return lfd;
            }
            catch (Exception e) {
            }
        }
        return null;
    }

    public static void main(String[] args) {
        LogFolderInfoList list = new LogFolderInfoList();
        list.addFolder(new LogFolderInfo("22/A"));
        list.addFolder(new LogFolderInfo("12/A"));
        list.addFolder(new LogFolderInfo("22/a"));
        list.setSortable(true);
        list.setAutoCreateRowSorter(true);
        list.setSortOrder(SortOrder.ASCENDING);
        GuiUtils.testFrame((JComponent)((Object)list));
    }
}

