/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.util.logdownload;

import foxtrot.AsyncTask;
import foxtrot.AsyncWorker;
import foxtrot.Task;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Vector;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.net.ftp.FTPFile;
import org.jdesktop.swingx.JXCollapsiblePane;
import org.jdesktop.swingx.JXLabel;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.painter.AbstractAreaPainter;
import org.jdesktop.swingx.painter.CompoundPainter;
import org.jdesktop.swingx.painter.GlossPainter;
import org.jdesktop.swingx.painter.Painter;
import org.jdesktop.swingx.painter.RectanglePainter;
import pt.lsts.imc.EntityParameter;
import pt.lsts.imc.EntityState;
import pt.lsts.imc.IMCMessage;
import pt.lsts.imc.SetEntityParameters;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.colormap.ColorMap;
import pt.lsts.neptus.colormap.ColorMapFactory;
import pt.lsts.neptus.colormap.InterpolationColorMap;
import pt.lsts.neptus.comm.manager.imc.EntitiesResolver;
import pt.lsts.neptus.comm.manager.imc.ImcMsgManager;
import pt.lsts.neptus.comm.manager.imc.ImcSystem;
import pt.lsts.neptus.comm.manager.imc.ImcSystemsHolder;
import pt.lsts.neptus.ftp.FtpDownloader;
import pt.lsts.neptus.gui.MiniButton;
import pt.lsts.neptus.gui.NudgeGlassPane;
import pt.lsts.neptus.gui.swing.MessagePanel;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.messages.listener.MessageInfo;
import pt.lsts.neptus.messages.listener.MessageListener;
import pt.lsts.neptus.mra.NeptusMRA;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.ImageUtils;
import pt.lsts.neptus.util.MathMiscUtils;
import pt.lsts.neptus.util.conf.ConfigFetch;
import pt.lsts.neptus.util.conf.GeneralPreferences;
import pt.lsts.neptus.util.logdownload.DownloadStateListener;
import pt.lsts.neptus.util.logdownload.DownloaderHelp;
import pt.lsts.neptus.util.logdownload.DownloaderPanel;
import pt.lsts.neptus.util.logdownload.LogFileInfo;
import pt.lsts.neptus.util.logdownload.LogFileInfoList;
import pt.lsts.neptus.util.logdownload.LogFolderInfo;
import pt.lsts.neptus.util.logdownload.LogFolderInfoList;
import pt.lsts.neptus.util.logdownload.QueueWorkTickets;

public class LogsDownloaderWorker {
    private static final int QUERYPOWERCHANNEL_PERIOD_MILLIS = 5000;
    private static final int ACTIVE_DOWNLOADS_QUEUE_SIZE = 1;
    private static final String SERVER_MAIN = "main";
    private static final String SERVER_CAM = "cam";
    private static final int DEFAULT_PORT = 30021;
    private static final String DEFAULT_TITLE = I18n.text("Download Log Files");
    public static final ImageIcon ICON_DOWNLOAD_FOLDERS = ImageUtils.getScaledIcon("images/downloader/folder_download.png", 32, 32);
    public static final ImageIcon ICON_DOWNLOAD_FILES = ImageUtils.getScaledIcon("images/downloader/file_down.png", 32, 32);
    public static final ImageIcon ICON_DOWNLOAD_LIST = ImageUtils.getScaledIcon("images/downloader/sync-list.png", 32, 32);
    public static final ImageIcon ICON_SETTINGS = ImageUtils.getScaledIcon("images/settings.png", 32, 32);
    public static final ImageIcon ICON_DELETE_FOLDERS = ImageUtils.getScaledIcon("images/downloader/folder_delete1.png", 32, 32);
    public static final ImageIcon ICON_DELETE_FILES = ImageUtils.getScaledIcon("images/downloader/file_delete1.png", 32, 32);
    public static final ImageIcon ICON_HELP = ImageUtils.getScaledIcon("images/downloader/help.png", 32, 32);
    public static final ImageIcon ICON_RESET = ImageUtils.getScaledIcon("images/buttons/redo.png", 32, 32);
    public static final ImageIcon ICON_STOP = ImageUtils.getScaledIcon("images/downloader/stop.png", 32, 32);
    public static final ImageIcon ICON_DOWNLOAD_PHOTO = ImageUtils.getScaledIcon("images/downloader/camera.png", 32, 32);
    private static final ColorMap diskFreeColorMap = ColorMapFactory.createInvertedColorMap((InterpolationColorMap)ColorMapFactory.createRedYellowGreenColorMap());
    protected static final long DELTA_TIME_TO_CLEAR_DONE = 5000L;
    protected static final long DELTA_TIME_TO_CLEAR_NOT_WORKING = 45000L;
    protected static final String CAMERA_CPU_LABEL = "Slave CPU";
    private FtpDownloader clientFtp = null;
    private FtpDownloader cameraFtp = null;
    private boolean stopLogListProcessing = false;
    private boolean resetting = false;
    private String host = "127.0.0.1";
    private int port = 30021;
    private String dirBaseToStoreFiles = "log/downloaded";
    private String logLabel = I18n.text("unknown");
    private boolean frameIsExternalControlled = false;
    private AbstractAction downloadListAction = null;
    private AbstractAction downloadSelectedLogDirsAction = null;
    private AbstractAction downloadSelectedLogFilesAction = null;
    private AbstractAction deleteSelectedLogFoldersAction = null;
    private AbstractAction deleteSelectedLogFilesAction = null;
    private AbstractAction toggleConfPanelAction = null;
    private AbstractAction toggleExtraInfoPanelAction = null;
    private AbstractAction helpAction = null;
    private AbstractAction resetAction = null;
    private AbstractAction stopAllAction = null;
    private AbstractAction turnCameraOn = null;
    private JFrame frame = null;
    private JXPanel frameCompHolder = null;
    private JTextField hostField = null;
    private JTextField portField = null;
    private JTextField logLabelField = null;
    private JLabel hostLabel = null;
    private JLabel portLabel = null;
    private JLabel logLabelLabel = null;
    private MessagePanel msgPanel = null;
    private JXLabel logFoldersListLabel = null;
    private JXLabel logFilesListLabel = null;
    private JPanel downloadWorkersHolder = null;
    private JScrollPane downloadWorkersScroll = null;
    private LogFolderInfoList logFolderList = null;
    private JScrollPane logFolderScroll = null;
    private LogFileInfoList logFilesList = null;
    private JScrollPane logFilesScroll = null;
    private JXLabel diskFreeLabel = null;
    private MiniButton downloadListButton = null;
    private MiniButton downloadSelectedLogDirsButton = null;
    private MiniButton downloadSelectedLogFilesButton = null;
    private MiniButton deleteSelectedLogFoldersButton = null;
    private MiniButton deleteSelectedLogFilesButton = null;
    private MiniButton toggleConfPanelButton = null;
    private MiniButton toggleExtraInfoPanelButton = null;
    private MiniButton helpButton = null;
    private MiniButton resetButton = null;
    private MiniButton stopAllButton = null;
    private JButton cameraButton = null;
    private DownloaderHelp downHelpDialog = null;
    private JXPanel configHolder = null;
    private JXCollapsiblePane configCollapsiblePanel = null;
    private JXCollapsiblePane extraInfoCollapsiblePanel = null;
    private JProgressBar listHandlingProgressBar = null;
    private RectanglePainter rectPainter;
    private CompoundPainter<JXPanel> compoundBackPainter;
    private ScheduledThreadPoolExecutor threadScheduledPool = null;
    private Runnable ttaskLocalDiskSpace = null;
    private MessageListener<MessageInfo, IMCMessage> messageListener;
    private boolean isUpdatingFileList = false;
    private boolean exitRequest = false;
    private final Object lock = new Object();
    private QueueWorkTickets<DownloaderPanel> queueWorkTickets = new QueueWorkTickets(1);

    public LogsDownloaderWorker() {
        this(null);
    }

    public LogsDownloaderWorker(JFrame parentFrame) {
        if (parentFrame != null) {
            this.frame = parentFrame;
            this.frameIsExternalControlled = true;
        }
        this.initializeComm();
        this.initialize();
    }

    private void initializeComm() {
        this.threadScheduledPool = (ScheduledThreadPoolExecutor)Executors.newScheduledThreadPool(4, new ThreadFactory(){
            private ThreadGroup group;
            private long count = 0L;
            {
                SecurityManager s = System.getSecurityManager();
                this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            }

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(this.group, r);
                t.setName(LogsDownloaderWorker.class.getSimpleName() + "::" + Integer.toHexString(LogsDownloaderWorker.this.hashCode()) + "::" + this.count++);
                t.setDaemon(true);
                return t;
            }
        });
        this.messageListener = new MessageListener<MessageInfo, IMCMessage>(){

            public void onMessage(MessageInfo info, IMCMessage msg) {
                int srcIdNumber;
                ImcSystem sys;
                if (msg.getAbbrev().equals("EntityState") && (sys = ImcSystemsHolder.lookupSystem(srcIdNumber = msg.getSrc())) != null && LogsDownloaderWorker.this.logLabel.equalsIgnoreCase(sys.getName())) {
                    EntityState est = (EntityState)msg;
                    String entityName = EntitiesResolver.resolveName(LogsDownloaderWorker.this.getLogLabel(), Integer.valueOf(msg.getSrcEnt()));
                    if (entityName != null && LogsDownloaderWorker.CAMERA_CPU_LABEL.equalsIgnoreCase(entityName)) {
                        String descStateCode = est.getDescription();
                        if (descStateCode != null && ("active".equalsIgnoreCase(descStateCode.trim()) || I18n.text("active").equalsIgnoreCase(descStateCode.trim()))) {
                            LogsDownloaderWorker.this.cameraButton.setBackground(Color.GREEN);
                        } else {
                            LogsDownloaderWorker.this.cameraButton.setBackground(null);
                        }
                    }
                }
            }
        };
        ImcMsgManager.getManager().addListener((MessageListener)this.messageListener);
        this.threadScheduledPool.scheduleAtFixedRate(new Runnable(){
            protected IMCMessage msg = new IMCMessage("QueryPowerChannelState");

            @Override
            public void run() {
                if (LogsDownloaderWorker.this.getLogLabel() == null || LogsDownloaderWorker.this.getLogLabel().length() == 0) {
                    return;
                }
                this.msg.setTimestampMillis(System.currentTimeMillis());
                ImcMsgManager.getManager().sendMessageToSystem(this.msg, LogsDownloaderWorker.this.getLogLabel());
            }
        }, 500L, 5000L, TimeUnit.MILLISECONDS);
    }

    private void initialize() {
        this.initializeActions();
        if (this.frame == null) {
            this.frame = new JFrame();
            this.frame.setSize(900, 560);
            this.frame.setIconImages(ConfigFetch.getIconImagesForFrames());
            this.frame.setTitle(DEFAULT_TITLE + " - " + this.logLabel);
            this.frame.setDefaultCloseOperation(2);
            this.frame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent e) {
                    super.windowClosed(e);
                    LogsDownloaderWorker.this.cleanup();
                }
            });
        }
        this.hostLabel = new JLabel(I18n.text("Host: "));
        this.hostField = new JTextField(20);
        this.hostField.setText(this.host);
        this.portLabel = new JLabel(I18n.text("Port: "));
        this.portField = new JTextField(5);
        this.portField.setText("" + this.port);
        this.logLabelLabel = new JLabel(I18n.text("System Label: "));
        this.logLabelField = new JTextField(40);
        this.logLabelField.setText(this.logLabel);
        this.logLabelField.setToolTipText(I18n.text("This will dictate the directory where the logs will go."));
        this.msgPanel = new MessagePanel();
        this.msgPanel.showButtons(false);
        this.logFoldersListLabel = new JXLabel("<html><b>" + I18n.text("Log Folders"), 0);
        this.logFilesListLabel = new JXLabel("<html><b>" + I18n.text("Log Files"), 0);
        this.diskFreeLabel = new JXLabel("<html><b>?", 0);
        this.diskFreeLabel.setBackgroundPainter(this.getCompoundBackPainter());
        this.resetButton = new MiniButton();
        this.resetButton.setToolTipText(I18n.text("Reset the interface"));
        this.resetButton.setIcon(ICON_RESET);
        this.resetButton.addActionListener(this.resetAction);
        this.stopAllButton = new MiniButton();
        this.stopAllButton.setToolTipText(I18n.text("Stop all log downloads"));
        this.stopAllButton.setIcon(ICON_STOP);
        this.stopAllButton.addActionListener(this.stopAllAction);
        this.cameraButton = new JButton();
        this.cameraButton.setToolTipText(I18n.text("Turn on/off camera CPU"));
        this.cameraButton.setIcon(ICON_DOWNLOAD_PHOTO);
        this.cameraButton.addActionListener(this.turnCameraOn);
        this.downloadWorkersHolder = new JPanel();
        this.downloadWorkersHolder.setLayout(new BoxLayout(this.downloadWorkersHolder, 1));
        this.downloadWorkersHolder.setBackground(Color.WHITE);
        this.downloadWorkersScroll = new JScrollPane();
        this.downloadWorkersScroll.setVerticalScrollBarPolicy(22);
        this.downloadWorkersScroll.setHorizontalScrollBarPolicy(30);
        this.downloadWorkersScroll.setViewportView(this.downloadWorkersHolder);
        this.logFolderList = new LogFolderInfoList();
        this.logFolderList.setSortable(true);
        this.logFolderList.setAutoCreateRowSorter(true);
        this.logFolderList.setSortOrder(SortOrder.DESCENDING);
        this.logFolderList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                AsyncTask task = new AsyncTask(){

                    public Object run() throws Exception {
                        LogsDownloaderWorker.this.updateFilesListGUIForFolderSelected();
                        return null;
                    }

                    public void finish() {
                        LogsDownloaderWorker.this.logFilesList.setValueIsAdjusting(false);
                        LogsDownloaderWorker.this.logFilesList.invalidate();
                        LogsDownloaderWorker.this.logFilesList.validate();
                        LogsDownloaderWorker.this.logFilesList.setEnabled(true);
                    }
                };
                AsyncWorker.getWorkerThread().postTask((Task)task);
            }
        });
        this.logFolderList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 3) {
                    String baseFxPath = LogsDownloaderWorker.this.dirBaseToStoreFiles + "/" + LogsDownloaderWorker.this.getLogLabel() + "/" + LogsDownloaderWorker.this.logFolderList.getSelectedValue() + "/";
                    File imc = new File(baseFxPath + "IMC.xml");
                    File imcGz = new File(baseFxPath + "IMC.xml.gz");
                    final File log = new File(baseFxPath + "Data.lsf");
                    final File logGz = new File(baseFxPath + "Data.lsf.gz");
                    if ((imc.exists() || imcGz.exists()) && (logGz.exists() || log.exists())) {
                        JPopupMenu popup = new JPopupMenu();
                        popup.add(I18n.text("Open this log in MRA")).addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                Thread t = new Thread(LogsDownloaderWorker.class.getSimpleName() + " :: MRA Openner"){

                                    @Override
                                    public void run() {
                                        NeptusMRA mra = new NeptusMRA();
                                        mra.setDefaultCloseOperation(2);
                                        File fx = null;
                                        if (logGz.exists()) {
                                            fx = logGz;
                                        }
                                        if (log.exists()) {
                                            fx = log;
                                        }
                                        mra.getMraFilesHandler().openLog(fx);
                                    }
                                };
                                t.setDaemon(true);
                                t.start();
                            }
                        });
                        popup.show((Component)e.getSource(), e.getX(), e.getY());
                    } else {
                        LogsDownloaderWorker.this.warnMsg(I18n.text("Basic log folder not synchronized. Can't open MRA"));
                        return;
                    }
                }
            }
        });
        this.logFolderScroll = new JScrollPane();
        this.logFolderScroll.setVerticalScrollBarPolicy(22);
        this.logFolderScroll.setHorizontalScrollBarPolicy(30);
        this.logFolderScroll.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.logFolderScroll.setViewportView((Component)((Object)this.logFolderList));
        this.logFilesList = new LogFileInfoList();
        this.logFilesList.setSortable(true);
        this.logFilesList.setAutoCreateRowSorter(true);
        this.logFilesList.setSortOrder(SortOrder.DESCENDING);
        this.logFilesScroll = new JScrollPane();
        this.logFilesScroll.setVerticalScrollBarPolicy(22);
        this.logFilesScroll.setHorizontalScrollBarPolicy(30);
        this.logFilesScroll.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.logFilesScroll.setViewportView((Component)((Object)this.logFilesList));
        this.downloadListButton = new MiniButton();
        this.downloadListButton.setToolTipText(I18n.text("Synchronize List of Log Folders"));
        this.downloadListButton.setIcon(ICON_DOWNLOAD_LIST);
        this.downloadListButton.addActionListener(this.downloadListAction);
        this.downloadSelectedLogDirsButton = new MiniButton();
        this.downloadSelectedLogDirsButton.setToolTipText(I18n.text("Synchronize Selected Log Folders"));
        this.downloadSelectedLogDirsButton.setIcon(ICON_DOWNLOAD_FOLDERS);
        this.downloadSelectedLogDirsButton.addActionListener(this.downloadSelectedLogDirsAction);
        this.downloadSelectedLogFilesButton = new MiniButton();
        this.downloadSelectedLogFilesButton.setToolTipText(I18n.text("Synchronize Selected Log Files"));
        this.downloadSelectedLogFilesButton.setIcon(ICON_DOWNLOAD_FILES);
        this.downloadSelectedLogFilesButton.addActionListener(this.downloadSelectedLogFilesAction);
        this.deleteSelectedLogFoldersButton = new MiniButton();
        this.deleteSelectedLogFoldersButton.setToolTipText(I18n.text("Delete Selected Log Folders"));
        this.deleteSelectedLogFoldersButton.setIcon(ICON_DELETE_FOLDERS);
        this.deleteSelectedLogFoldersButton.addActionListener(this.deleteSelectedLogFoldersAction);
        this.deleteSelectedLogFilesButton = new MiniButton();
        this.deleteSelectedLogFilesButton.setToolTipText(I18n.text("Delete Selected Log Files"));
        this.deleteSelectedLogFilesButton.setIcon(ICON_DELETE_FILES);
        this.deleteSelectedLogFilesButton.addActionListener(this.deleteSelectedLogFilesAction);
        this.configCollapsiblePanel = new JXCollapsiblePane();
        this.configCollapsiblePanel.setLayout((LayoutManager)new BorderLayout());
        this.configHolder = new JXPanel();
        this.configHolder.setBorder((Border)new TitledBorder(I18n.text("Configuration")));
        this.configCollapsiblePanel.add((Component)this.configHolder, (Object)"Center");
        GroupLayout layoutCfg = new GroupLayout((Container)this.configHolder);
        this.configHolder.setLayout((LayoutManager)layoutCfg);
        layoutCfg.setAutoCreateGaps(true);
        layoutCfg.setAutoCreateContainerGaps(false);
        layoutCfg.setHorizontalGroup(layoutCfg.createParallelGroup(GroupLayout.Alignment.CENTER).addGroup(layoutCfg.createSequentialGroup().addComponent(this.hostLabel).addComponent(this.hostField).addComponent(this.portLabel).addComponent(this.portField)).addGroup(layoutCfg.createSequentialGroup().addComponent(this.logLabelLabel).addComponent(this.logLabelField)));
        layoutCfg.setVerticalGroup(layoutCfg.createSequentialGroup().addGroup(layoutCfg.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.hostLabel).addComponent(this.hostField).addComponent(this.portLabel).addComponent(this.portField)).addGroup(layoutCfg.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.logLabelLabel).addComponent(this.logLabelField)));
        layoutCfg.linkSize(1, this.hostLabel, this.hostField, this.portLabel, this.portField, this.logLabelLabel, this.logLabelField);
        layoutCfg.linkSize(0, this.logLabelLabel, this.hostLabel);
        this.configCollapsiblePanel.setCollapsed(true);
        this.toggleConfPanelButton = new MiniButton();
        this.toggleConfPanelButton.setToolTipText(I18n.text("Show/Hide Configuration Panel"));
        this.toggleConfPanelButton.setIcon(ICON_SETTINGS);
        this.toggleConfPanelButton.addActionListener(this.toggleConfPanelAction);
        this.toggleExtraInfoPanelButton = new MiniButton();
        this.toggleExtraInfoPanelButton.setToolTipText(I18n.text("Show/Hide Download Panel"));
        this.toggleExtraInfoPanelButton.setIcon(ICON_SETTINGS);
        this.toggleExtraInfoPanelButton.addActionListener(this.toggleExtraInfoPanelAction);
        this.helpButton = new MiniButton();
        this.helpButton.setToolTipText(I18n.text("Show Help"));
        this.helpButton.setIcon(ICON_HELP);
        this.helpButton.addActionListener(this.helpAction);
        this.listHandlingProgressBar = new JProgressBar(0);
        this.listHandlingProgressBar.setIndeterminate(false);
        this.listHandlingProgressBar.setStringPainted(true);
        this.listHandlingProgressBar.setString("");
        JPanel contentPanel = new JPanel();
        GroupLayout layout = new GroupLayout(contentPanel);
        contentPanel.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent((Component)this.logFoldersListLabel).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.logFolderScroll).addGroup(layout.createSequentialGroup().addComponent(this.downloadListButton, 34, 34, 34).addGap(10).addComponent(this.downloadSelectedLogDirsButton, 34, 34, 34).addComponent(this.downloadSelectedLogFilesButton, 34, 34, 34).addGap(10).addComponent(this.deleteSelectedLogFoldersButton, 34, 34, 34).addComponent(this.deleteSelectedLogFilesButton, 34, 34, 34).addGap(10).addComponent(this.stopAllButton, 34, 34, 34).addGap(10).addComponent(this.toggleConfPanelButton, 34, 34, 34).addGap(10).addComponent(this.resetButton, 34, 34, 34).addComponent(this.helpButton, 34, 34, 34).addComponent(this.cameraButton, 34, 34, 34).addComponent((Component)this.diskFreeLabel, 60, 80, 120)))).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent((Component)this.logFilesListLabel).addComponent(this.logFilesScroll))).addComponent(this.listHandlingProgressBar).addComponent(this.downloadWorkersScroll));
        layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addGroup(layout.createSequentialGroup().addComponent((Component)this.logFoldersListLabel).addGroup(layout.createSequentialGroup().addComponent(this.logFolderScroll, 180, -2, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.downloadListButton, 34, 34, 34).addComponent(this.downloadSelectedLogDirsButton, 34, 34, 34).addComponent(this.downloadSelectedLogFilesButton, 34, 34, 34).addComponent(this.deleteSelectedLogFoldersButton, 34, 34, 34).addComponent(this.deleteSelectedLogFilesButton, 34, 34, 34).addComponent(this.stopAllButton, 34, 34, 34).addComponent(this.toggleConfPanelButton, 34, 34, 34).addComponent(this.resetButton, 34, 34, 34).addComponent(this.helpButton, 34, 34, 34).addComponent(this.cameraButton, 34, 34, 34).addComponent((Component)this.diskFreeLabel, 34, 34, 34)))).addGroup(layout.createSequentialGroup().addComponent((Component)this.logFilesListLabel).addComponent(this.logFilesScroll, 200, -1, Short.MAX_VALUE))).addComponent(this.listHandlingProgressBar).addComponent(this.downloadWorkersScroll, 80, -1, Short.MAX_VALUE));
        this.frameCompHolder = new JXPanel();
        this.frameCompHolder.setLayout((LayoutManager)new BorderLayout());
        this.frameCompHolder.add((Component)this.configCollapsiblePanel, (Object)"North");
        this.frameCompHolder.add((Component)contentPanel, (Object)"Center");
        if (!this.frameIsExternalControlled) {
            this.frame.setLayout(new BorderLayout());
            this.frame.add((Component)this.frameCompHolder, "Center");
        }
        this.downHelpDialog = new DownloaderHelp(this.frame);
        this.setEnableLogLabel(false);
        this.setEnableHost(true);
        if (!this.frameIsExternalControlled) {
            GuiUtils.centerOnScreen(this.frame);
        }
        this.ttaskLocalDiskSpace = this.getTimerTaskLocalDiskSpace();
        this.threadScheduledPool.scheduleAtFixedRate(this.ttaskLocalDiskSpace, 500L, 5000L, TimeUnit.MILLISECONDS);
    }

    private void initializeActions() {
        this.downloadListAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!LogsDownloaderWorker.this.validateAndSetUI()) {
                    LogsDownloaderWorker.this.popupErrorConfigurationDialog();
                    return;
                }
                AsyncTask task = new AsyncTask(){

                    public Object run() throws Exception {
                        if (LogsDownloaderWorker.this.stopLogListProcessing) {
                            LogsDownloaderWorker.this.stopLogListProcessing = false;
                        }
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                LogsDownloaderWorker.this.listHandlingProgressBar.setValue(0);
                                LogsDownloaderWorker.this.listHandlingProgressBar.setString(I18n.text("Starting..."));
                            }
                        });
                        LogsDownloaderWorker.this.downloadListButton.setEnabled(false);
                        LogsDownloaderWorker.this.logFolderList.setValueIsAdjusting(true);
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                LogsDownloaderWorker.this.listHandlingProgressBar.setValue(10);
                                LogsDownloaderWorker.this.listHandlingProgressBar.setIndeterminate(true);
                                LogsDownloaderWorker.this.listHandlingProgressBar.setString(I18n.text("Connecting to remote system for log list update..."));
                            }
                        });
                        LinkedHashMap<FTPFile, String> retList = null;
                        LinkedHashMap<String, String> serversLogPresenceList = new LinkedHashMap<String, String>();
                        try {
                            LogsDownloaderWorker.this.clientFtp = LogsDownloaderWorker.this.getOrRenewFtpDownloader(LogsDownloaderWorker.this.clientFtp, LogsDownloaderWorker.this.host, LogsDownloaderWorker.this.port);
                            retList = LogsDownloaderWorker.this.clientFtp.listLogs();
                            for (String partialUri : retList.values()) {
                                serversLogPresenceList.put(partialUri, LogsDownloaderWorker.SERVER_MAIN);
                            }
                        }
                        catch (Exception e) {
                            NeptusLog.pub().error((Object)("Connecting with " + LogsDownloaderWorker.this.host + ":" + LogsDownloaderWorker.this.port + " with error: " + e.getMessage()));
                        }
                        String cameraHost = LogsDownloaderWorker.this.getCameraHost(LogsDownloaderWorker.this.getHost());
                        if (cameraHost.length() > 0) {
                            LinkedHashMap<FTPFile, String> retCamList = null;
                            try {
                                LogsDownloaderWorker.this.cameraFtp = LogsDownloaderWorker.this.getOrRenewFtpDownloader(LogsDownloaderWorker.this.cameraFtp, cameraHost, LogsDownloaderWorker.this.port);
                                retCamList = LogsDownloaderWorker.this.cameraFtp.listLogs();
                            }
                            catch (Exception e) {
                                NeptusLog.pub().error((Object)("Connecting with " + cameraHost + ":" + LogsDownloaderWorker.this.port + " with error: " + e.getMessage()));
                            }
                            if (retCamList != null) {
                                if (retList == null) {
                                    retList = retCamList;
                                    for (String partialUri : retList.values()) {
                                        serversLogPresenceList.put(partialUri, LogsDownloaderWorker.SERVER_CAM);
                                    }
                                } else {
                                    for (FTPFile camFTPFile : retCamList.keySet()) {
                                        String val = retCamList.get(camFTPFile);
                                        if (retList.containsValue(val)) {
                                            serversLogPresenceList.put(val, (String)serversLogPresenceList.get(val) + " " + LogsDownloaderWorker.SERVER_CAM);
                                            continue;
                                        }
                                        retList.put(camFTPFile, val);
                                        serversLogPresenceList.put(val, LogsDownloaderWorker.SERVER_CAM);
                                    }
                                }
                            }
                        }
                        if (retList == null) {
                            LogsDownloaderWorker.this.msgPanel.writeMessageTextln(I18n.text("Done"));
                            return null;
                        }
                        LogsDownloaderWorker.this.msgPanel.writeMessageTextln(I18n.textf("Log Folders: %numberoffolders", retList.size()));
                        if (retList.size() > 0) {
                            Object[] ordList = retList.values().toArray(new String[retList.size()]);
                            Arrays.sort(ordList);
                            Object activeLogName = ordList[ordList.length - 1];
                            for (FTPFile fFile : retList.keySet().toArray(new FTPFile[retList.size()])) {
                                if (!retList.get(fFile).equals(activeLogName)) continue;
                                retList.remove(fFile);
                                break;
                            }
                        }
                        if (retList.size() == 0) {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    LogsDownloaderWorker.this.listHandlingProgressBar.setValue(100);
                                    LogsDownloaderWorker.this.listHandlingProgressBar.setIndeterminate(false);
                                    LogsDownloaderWorker.this.listHandlingProgressBar.setString(I18n.text("No logs..."));
                                }
                            });
                            return null;
                        }
                        final String msg1 = I18n.textf("Log Folders: %numberoffolders", retList.size());
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                LogsDownloaderWorker.this.listHandlingProgressBar.setString(msg1);
                            }
                        });
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                LogsDownloaderWorker.this.listHandlingProgressBar.setValue(20);
                                LogsDownloaderWorker.this.listHandlingProgressBar.setIndeterminate(false);
                                LogsDownloaderWorker.this.listHandlingProgressBar.setString(I18n.text("Filtering list..."));
                            }
                        });
                        Object[] objArray = new Object[((LogsDownloaderWorker)LogsDownloaderWorker.this).logFolderList.myModel.size()];
                        ((LogsDownloaderWorker)LogsDownloaderWorker.this).logFolderList.myModel.copyInto(objArray);
                        for (Object comp : objArray) {
                            if (LogsDownloaderWorker.this.stopLogListProcessing) {
                                return null;
                            }
                            try {
                                LogFolderInfo log = (LogFolderInfo)comp;
                                if (retList.containsValue(log.getName())) continue;
                                for (LogFileInfo lfx : log.getLogFiles()) {
                                    if (LogsDownloaderWorker.this.stopLogListProcessing) {
                                        return null;
                                    }
                                    lfx.setState(LogFolderInfo.State.LOCAL);
                                }
                                log.setState(LogFolderInfo.State.LOCAL);
                            }
                            catch (Exception e) {
                                NeptusLog.pub().debug((Object)e.getMessage());
                            }
                        }
                        LinkedList<LogFolderInfo> existenteLogFoldersFromServer = new LinkedList<LogFolderInfo>();
                        LinkedList<LogFolderInfo> newLogFoldersFromServer = new LinkedList<LogFolderInfo>();
                        for (String newLogName : retList.values()) {
                            if (LogsDownloaderWorker.this.stopLogListProcessing) {
                                return null;
                            }
                            final LogFolderInfo newLogDir = new LogFolderInfo(newLogName);
                            if (LogsDownloaderWorker.this.logFolderList.containsFolder(newLogDir)) {
                                existenteLogFoldersFromServer.add(LogsDownloaderWorker.this.logFolderList.getFolder(newLogDir.getName()));
                                continue;
                            }
                            newLogFoldersFromServer.add(newLogDir);
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    LogsDownloaderWorker.this.logFolderList.addFolder(newLogDir);
                                }
                            });
                        }
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                LogsDownloaderWorker.this.listHandlingProgressBar.setValue(30);
                                LogsDownloaderWorker.this.listHandlingProgressBar.setIndeterminate(true);
                                LogsDownloaderWorker.this.listHandlingProgressBar.setString(I18n.text("Contacting remote system for complete log file list..."));
                                LogsDownloaderWorker.this.listHandlingProgressBar.setValue(40);
                                LogsDownloaderWorker.this.listHandlingProgressBar.setIndeterminate(false);
                                LogsDownloaderWorker.this.listHandlingProgressBar.setString(I18n.text("Processing log list..."));
                            }
                        });
                        objArray = new Object[((LogsDownloaderWorker)LogsDownloaderWorker.this).logFolderList.myModel.size()];
                        ((LogsDownloaderWorker)LogsDownloaderWorker.this).logFolderList.myModel.copyInto(objArray);
                        LinkedList tmpLogFolderList = LogsDownloaderWorker.this.getLogFileList(serversLogPresenceList);
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                LogsDownloaderWorker.this.listHandlingProgressBar.setValue(70);
                                LogsDownloaderWorker.this.listHandlingProgressBar.setIndeterminate(false);
                                LogsDownloaderWorker.this.listHandlingProgressBar.setString(I18n.text("Updating logs info..."));
                            }
                        });
                        for (Object comp : objArray) {
                            if (LogsDownloaderWorker.this.stopLogListProcessing) {
                                return null;
                            }
                            try {
                                LogFolderInfo logFolder = (LogFolderInfo)comp;
                                int indexLFolder = tmpLogFolderList.indexOf(logFolder);
                                LinkedHashSet logFilesTmp = indexLFolder != -1 ? ((LogFolderInfo)tmpLogFolderList.get(indexLFolder)).getLogFiles() : new LinkedHashSet();
                                block16: for (LogFileInfo logFx : logFilesTmp) {
                                    if (LogsDownloaderWorker.this.stopLogListProcessing) {
                                        return null;
                                    }
                                    if (!logFolder.getLogFiles().contains(logFx)) {
                                        logFolder.addFile(logFx);
                                        continue;
                                    }
                                    LogFileInfo lfx = logFolder.getLogFile(logFx.getName());
                                    if (lfx.getSize() == -1L) {
                                        lfx.setSize(logFx.getSize());
                                    } else if (lfx.getSize() != logFx.getSize()) {
                                        System.out.println("//////////// " + lfx.getSize() + "  " + logFx.getSize());
                                        if (lfx.getState() == LogFolderInfo.State.SYNC) {
                                            lfx.setState(LogFolderInfo.State.INCOMPLETE);
                                        } else if (lfx.getState() == LogFolderInfo.State.LOCAL) {
                                            lfx.setState(LogFolderInfo.State.INCOMPLETE);
                                        }
                                        lfx.setSize(logFx.getSize());
                                        lfx.setFile(logFx.getFile());
                                    } else if (lfx.getSize() == logFx.getSize() && lfx.getState() == LogFolderInfo.State.LOCAL) {
                                        lfx.setState(LogFolderInfo.State.SYNC);
                                    }
                                    lfx.setHost(logFx.getHost());
                                    if (logFx.isDirectory()) {
                                        ArrayList<LogFileInfo> notMatchElements = new ArrayList<LogFileInfo>();
                                        notMatchElements.addAll(lfx.getDirectoryContents());
                                        for (LogFileInfo lfi : logFx.getDirectoryContents()) {
                                            boolean alreadyExists = false;
                                            for (LogFileInfo lfiLocal : lfx.getDirectoryContents()) {
                                                if (!lfi.equals(lfiLocal)) continue;
                                                alreadyExists = true;
                                                notMatchElements.remove(lfiLocal);
                                                lfi.setSize(lfiLocal.getSize());
                                                lfi.setFile(lfiLocal.getFile());
                                                lfi.setHost(lfiLocal.getHost());
                                            }
                                            if (alreadyExists) continue;
                                            lfx.getDirectoryContents().add(lfi);
                                            lfx.setState(LogFolderInfo.State.INCOMPLETE);
                                        }
                                        for (LogFileInfo lfi : notMatchElements) {
                                            lfx.getDirectoryContents().remove(lfi);
                                        }
                                    }
                                    if (lfx.isDirectory()) {
                                        if (!LogsDownloaderWorker.this.getFileTarget(lfx.getName()).exists()) {
                                            for (LogFileInfo lfi : lfx.getDirectoryContents()) {
                                                if (LogsDownloaderWorker.this.getFileTarget(lfi.getName()).exists()) continue;
                                                if (lfx.getState() == LogFolderInfo.State.NEW || lfx.getState() == LogFolderInfo.State.DOWNLOADING) continue block16;
                                                lfx.setState(LogFolderInfo.State.INCOMPLETE);
                                                continue block16;
                                            }
                                            continue;
                                        }
                                        long sizeD = LogsDownloaderWorker.this.getDiskSizeFromLocal(lfx);
                                        if (lfx.getSize() == sizeD || lfx.getState() != LogFolderInfo.State.SYNC) continue;
                                        lfx.setState(LogFolderInfo.State.INCOMPLETE);
                                        continue;
                                    }
                                    if (!LogsDownloaderWorker.this.getFileTarget(lfx.getName()).exists()) {
                                        if (lfx.getState() == LogFolderInfo.State.NEW || lfx.getState() == LogFolderInfo.State.DOWNLOADING) continue;
                                        lfx.setState(LogFolderInfo.State.INCOMPLETE);
                                        continue;
                                    }
                                    long sizeD = LogsDownloaderWorker.this.getDiskSizeFromLocal(lfx);
                                    if (lfx.getSize() == sizeD || lfx.getState() != LogFolderInfo.State.SYNC) continue;
                                    lfx.setState(LogFolderInfo.State.INCOMPLETE);
                                }
                                LinkedHashSet<LogFileInfo> toDelFL = new LinkedHashSet<LogFileInfo>();
                                for (LogFileInfo lfx : logFolder.getLogFiles()) {
                                    if (logFilesTmp.contains(lfx)) continue;
                                    lfx.setState(LogFolderInfo.State.LOCAL);
                                    if (LogsDownloaderWorker.this.getFileTarget(lfx.getName()).exists()) continue;
                                    toDelFL.add(lfx);
                                }
                                for (LogFileInfo lfx : toDelFL) {
                                    logFolder.getLogFiles().remove(lfx);
                                }
                            }
                            catch (Exception e) {
                                NeptusLog.pub().debug((Object)e.getMessage());
                            }
                        }
                        LogsDownloaderWorker.this.testNewReportedLogFoldersForLocalCorrespondent(newLogFoldersFromServer);
                        for (LogFolderInfo logFolder : existenteLogFoldersFromServer) {
                            LogsDownloaderWorker.this.updateLogFolderState(logFolder);
                        }
                        LogsDownloaderWorker.this.updateLogStateIconForAllLogFolders();
                        new Thread("updateFilesListGUIForFolderSelected"){

                            @Override
                            public void run() {
                                LogsDownloaderWorker.this.updateFilesListGUIForFolderSelected();
                            }
                        }.start();
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                LogsDownloaderWorker.this.listHandlingProgressBar.setValue(90);
                                LogsDownloaderWorker.this.listHandlingProgressBar.setIndeterminate(false);
                                LogsDownloaderWorker.this.listHandlingProgressBar.setString(I18n.text("Updating GUI..."));
                            }
                        });
                        LogsDownloaderWorker.this.logFolderList.invalidate();
                        LogsDownloaderWorker.this.logFolderList.revalidate();
                        LogsDownloaderWorker.this.logFolderList.repaint();
                        LogsDownloaderWorker.this.logFolderList.setEnabled(true);
                        LogsDownloaderWorker.this.logFilesList.setEnabled(true);
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                LogsDownloaderWorker.this.listHandlingProgressBar.setValue(100);
                                LogsDownloaderWorker.this.listHandlingProgressBar.setIndeterminate(false);
                                LogsDownloaderWorker.this.listHandlingProgressBar.setString(I18n.text("Done"));
                            }
                        });
                        return true;
                    }

                    public void finish() {
                        LogsDownloaderWorker.this.stopLogListProcessing = false;
                        LogsDownloaderWorker.this.logFolderList.setValueIsAdjusting(false);
                        LogsDownloaderWorker.this.logFolderList.invalidate();
                        LogsDownloaderWorker.this.logFolderList.revalidate();
                        LogsDownloaderWorker.this.logFolderList.repaint();
                        LogsDownloaderWorker.this.logFolderList.setEnabled(true);
                        LogsDownloaderWorker.this.listHandlingProgressBar.setValue(0);
                        LogsDownloaderWorker.this.listHandlingProgressBar.setIndeterminate(false);
                        LogsDownloaderWorker.this.listHandlingProgressBar.setString("");
                        LogsDownloaderWorker.this.logFilesList.setEnabled(true);
                        LogsDownloaderWorker.this.downloadListButton.setEnabled(true);
                        try {
                            this.getResultOrThrow();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                };
                AsyncWorker.getWorkerThread().postTask((Task)task);
            }
        };
        this.downloadSelectedLogDirsAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!LogsDownloaderWorker.this.validateAndSetUI()) {
                    LogsDownloaderWorker.this.popupErrorConfigurationDialog();
                    return;
                }
                LogsDownloaderWorker.this.downloadSelectedLogDirsButton.setEnabled(false);
                AsyncTask task = new AsyncTask(){

                    public Object run() throws Exception {
                        for (Object comp : LogsDownloaderWorker.this.logFolderList.getSelectedValues()) {
                            try {
                                LogFolderInfo logFd = (LogFolderInfo)comp;
                                for (LogFileInfo lfx : logFd.getLogFiles()) {
                                    if (!LogsDownloaderWorker.this.resetting) {
                                        LogsDownloaderWorker.this.singleLogFileDownloadWorker(lfx, logFd);
                                        continue;
                                    }
                                    break;
                                }
                            }
                            catch (Exception e) {
                                NeptusLog.pub().debug((Object)e.getMessage());
                            }
                            if (LogsDownloaderWorker.this.resetting) break;
                        }
                        return true;
                    }

                    public void finish() {
                        LogsDownloaderWorker.this.downloadSelectedLogDirsButton.setEnabled(true);
                        try {
                            this.getResultOrThrow();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                };
                AsyncWorker.getWorkerThread().postTask((Task)task);
            }
        };
        this.downloadSelectedLogFilesAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!LogsDownloaderWorker.this.validateAndSetUI()) {
                    LogsDownloaderWorker.this.popupErrorConfigurationDialog();
                    return;
                }
                AsyncTask task = new AsyncTask(){

                    public Object run() throws Exception {
                        LogsDownloaderWorker.this.downloadSelectedLogFilesButton.setEnabled(false);
                        for (Object comp : LogsDownloaderWorker.this.logFilesList.getSelectedValues()) {
                            if (LogsDownloaderWorker.this.resetting) break;
                            try {
                                LogFileInfo lfx = (LogFileInfo)comp;
                                LogsDownloaderWorker.this.singleLogFileDownloadWorker(lfx, LogsDownloaderWorker.this.findLogFolderInfoForFile(lfx));
                            }
                            catch (Exception e) {
                                NeptusLog.pub().debug((Object)e.getMessage());
                            }
                        }
                        return true;
                    }

                    public void finish() {
                        LogsDownloaderWorker.this.downloadSelectedLogFilesButton.setEnabled(true);
                        try {
                            this.getResultOrThrow();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                };
                AsyncWorker.getWorkerThread().postTask((Task)task);
            }
        };
        this.deleteSelectedLogFoldersAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!LogsDownloaderWorker.this.validateAndSetUI()) {
                    LogsDownloaderWorker.this.popupErrorConfigurationDialog();
                    return;
                }
                AsyncTask task = new AsyncTask(){

                    public Object run() throws Exception {
                        LogsDownloaderWorker.this.deleteSelectedLogFoldersButton.setEnabled(false);
                        Object[] objArray = LogsDownloaderWorker.this.logFolderList.getSelectedValues();
                        if (objArray.length == 0) {
                            return null;
                        }
                        JOptionPane jop = new JOptionPane(I18n.text("Are you sure you want to delete selected log folders from remote system?"), 3, 0);
                        JDialog dialog = jop.createDialog((Component)LogsDownloaderWorker.this.frameCompHolder, I18n.text("Remote Delete Confirmation"));
                        dialog.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
                        dialog.setVisible(true);
                        Object userChoice = jop.getValue();
                        try {
                            if ((Integer)userChoice != 0) {
                                return null;
                            }
                        }
                        catch (Exception e2) {
                            NeptusLog.pub().error((Object)e2.getMessage());
                            return null;
                        }
                        LogsDownloaderWorker.this.deleteSelectedLogFoldersButton.setEnabled(true);
                        for (Object comp : objArray) {
                            block9: {
                                try {
                                    LogFolderInfo logFd = (LogFolderInfo)comp;
                                    boolean resDel = LogsDownloaderWorker.this.deleteLogFolderFromServer(logFd);
                                    if (!resDel) break block9;
                                    logFd.setState(LogFolderInfo.State.LOCAL);
                                    LinkedHashSet<LogFileInfo> logFiles = logFd.getLogFiles();
                                    LinkedHashSet toDelFL = LogsDownloaderWorker.this.updateLogFilesStateDeleted(logFiles);
                                    for (LogFileInfo lfx : toDelFL) {
                                        if (!LogsDownloaderWorker.this.resetting) {
                                            logFd.getLogFiles().remove(lfx);
                                            continue;
                                        }
                                        break;
                                    }
                                }
                                catch (Exception e) {
                                    NeptusLog.pub().debug((Object)e.getMessage());
                                }
                            }
                            if (LogsDownloaderWorker.this.resetting) break;
                        }
                        LogsDownloaderWorker.this.updateFilesListGUIForFolderSelected();
                        return true;
                    }

                    public void finish() {
                        LogsDownloaderWorker.this.deleteSelectedLogFoldersButton.setEnabled(true);
                        LogsDownloaderWorker.this.logFilesList.revalidate();
                        LogsDownloaderWorker.this.logFilesList.repaint();
                        LogsDownloaderWorker.this.logFilesList.setEnabled(true);
                        LogsDownloaderWorker.this.logFolderList.revalidate();
                        LogsDownloaderWorker.this.logFolderList.repaint();
                        LogsDownloaderWorker.this.logFolderList.setEnabled(true);
                        try {
                            this.getResultOrThrow();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                };
                AsyncWorker.getWorkerThread().postTask((Task)task);
            }
        };
        this.deleteSelectedLogFilesAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!LogsDownloaderWorker.this.validateAndSetUI()) {
                    LogsDownloaderWorker.this.popupErrorConfigurationDialog();
                    return;
                }
                AsyncTask task = new AsyncTask(){

                    public Object run() throws Exception {
                        LogsDownloaderWorker.this.deleteSelectedLogFilesButton.setEnabled(false);
                        Object[] objArray = LogsDownloaderWorker.this.logFilesList.getSelectedValues();
                        if (objArray.length == 0) {
                            return null;
                        }
                        JOptionPane jop = new JOptionPane(I18n.text("Are you sure you want to delete selected log files from remote system?"), 3, 0);
                        JDialog dialog = jop.createDialog((Component)LogsDownloaderWorker.this.frameCompHolder, I18n.text("Remote Delete Confirmation"));
                        dialog.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
                        dialog.setVisible(true);
                        Object userChoice = jop.getValue();
                        try {
                            if ((Integer)userChoice != 0) {
                                return null;
                            }
                        }
                        catch (Exception e2) {
                            NeptusLog.pub().error((Object)e2.getMessage());
                            return null;
                        }
                        LogsDownloaderWorker.this.deleteSelectedLogFoldersButton.setEnabled(true);
                        LinkedHashSet<LogFileInfo> logFiles = new LinkedHashSet<LogFileInfo>();
                        for (Object comp : objArray) {
                            if (LogsDownloaderWorker.this.resetting) break;
                            try {
                                LogFileInfo lfx = (LogFileInfo)comp;
                                if (!LogsDownloaderWorker.this.deleteLogFileFromServer(lfx)) continue;
                                logFiles.add(lfx);
                            }
                            catch (Exception e) {
                                NeptusLog.pub().debug((Object)e.getMessage());
                            }
                        }
                        if (!LogsDownloaderWorker.this.resetting) {
                            LogsDownloaderWorker.this.updateLogFilesStateDeleted(logFiles);
                            LogsDownloaderWorker.this.updateFilesListGUIForFolderSelected();
                        }
                        return true;
                    }

                    public void finish() {
                        LogsDownloaderWorker.this.deleteSelectedLogFilesButton.setEnabled(true);
                        LogsDownloaderWorker.this.logFilesList.revalidate();
                        LogsDownloaderWorker.this.logFilesList.repaint();
                        LogsDownloaderWorker.this.logFilesList.setEnabled(true);
                        LogsDownloaderWorker.this.logFolderList.revalidate();
                        LogsDownloaderWorker.this.logFolderList.repaint();
                        LogsDownloaderWorker.this.logFolderList.setEnabled(true);
                        try {
                            this.getResultOrThrow();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                };
                AsyncWorker.getWorkerThread().postTask((Task)task);
            }
        };
        this.toggleConfPanelAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LogsDownloaderWorker.this.configCollapsiblePanel.getActionMap().get("toggle").actionPerformed(e);
            }
        };
        this.toggleExtraInfoPanelAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LogsDownloaderWorker.this.extraInfoCollapsiblePanel.getActionMap().get("toggle").actionPerformed(e);
            }
        };
        this.helpAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GuiUtils.centerOnScreen((Window)LogsDownloaderWorker.this.downHelpDialog.getDialog());
                LogsDownloaderWorker.this.downHelpDialog.getDialog().setIconImage(ICON_HELP.getImage());
                LogsDownloaderWorker.this.downHelpDialog.getDialog().setVisible(true);
            }
        };
        this.resetAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LogsDownloaderWorker.this.resetButton.setEnabled(false);
                LogsDownloaderWorker.this.doReset(false);
            }
        };
        this.stopAllAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LogsDownloaderWorker.this.stopAllButton.setEnabled(false);
                LogsDownloaderWorker.this.doReset(true);
            }
        };
        this.turnCameraOn = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ArrayList<EntityParameter> propList = new ArrayList<EntityParameter>();
                    EntityParameter entParsm = new EntityParameter().setName("Active").setValue(LogsDownloaderWorker.this.cameraButton.getBackground() != Color.GREEN ? "true" : "false");
                    propList.add(entParsm);
                    SetEntityParameters setParams = new SetEntityParameters();
                    setParams.setName(LogsDownloaderWorker.CAMERA_CPU_LABEL);
                    setParams.setParams(propList);
                    ImcMsgManager.getManager().sendMessageToSystem((IMCMessage)setParams, LogsDownloaderWorker.this.getLogLabel());
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        };
    }

    public JXPanel getContentPanel() {
        return this.frameCompHolder;
    }

    private Runnable getTimerTaskLocalDiskSpace() {
        if (this.ttaskLocalDiskSpace == null) {
            this.ttaskLocalDiskSpace = new Runnable(){

                @Override
                public void run() {
                    Component[] components;
                    try {
                        File fxD = new File(LogsDownloaderWorker.this.dirBaseToStoreFiles);
                        long tspace = fxD.getTotalSpace();
                        long uspace = fxD.getUsableSpace();
                        if (tspace != 0L) {
                            String tSpStr = MathMiscUtils.parseToEngineeringRadix2Notation(tspace, 2) + "B";
                            String uSpStr = MathMiscUtils.parseToEngineeringRadix2Notation(uspace, 2) + "B";
                            double pFree = 1.0 * (double)(tspace - uspace) / (double)tspace;
                            LogsDownloaderWorker.this.diskFreeLabel.setText("<html><b>" + uSpStr);
                            LogsDownloaderWorker.this.diskFreeLabel.setToolTipText(I18n.textf("Local free disk space %usedspace of %totalspace", uSpStr, tSpStr));
                            LogsDownloaderWorker.this.updateDiskFreeLabelBackColor(diskFreeColorMap.getColor(pFree));
                            return;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    LogsDownloaderWorker.this.diskFreeLabel.setText("<html><b>?");
                    LogsDownloaderWorker.this.diskFreeLabel.setToolTipText(I18n.text("Unknown local disk free space"));
                    LogsDownloaderWorker.this.updateDiskFreeLabelBackColor(Color.LIGHT_GRAY);
                    ArrayList workingDonsloaders = LogsDownloaderWorker.this.queueWorkTickets.getAllWorkingClients();
                    for (Component cp : components = LogsDownloaderWorker.this.downloadWorkersHolder.getComponents()) {
                        DownloaderPanel workerD;
                        if (!(cp instanceof DownloaderPanel) || !workingDonsloaders.contains(workerD = (DownloaderPanel)((Object)cp))) continue;
                        workingDonsloaders.remove(workerD);
                    }
                    for (DownloaderPanel cp : workingDonsloaders) {
                        LogsDownloaderWorker.this.queueWorkTickets.release(cp);
                        NeptusLog.pub().error((Object)(cp.getUri() + " should not be holding the lock (forcing release)! State: " + (Object)((Object)cp.getState())));
                    }
                }
            };
        }
        return this.ttaskLocalDiskSpace;
    }

    private FtpDownloader getOrRenewFtpDownloader(FtpDownloader clientFtp, String host, int port) throws Exception {
        if (clientFtp == null) {
            clientFtp = new FtpDownloader(host, port);
        } else {
            clientFtp.setHostAndPort(host, port);
        }
        if (!clientFtp.isConnected()) {
            clientFtp.renewClient();
        }
        return clientFtp;
    }

    public void cleanup() {
        this.disconnectFTPClientsForListing();
        if (this.threadScheduledPool != null) {
            this.threadScheduledPool.shutdownNow();
        }
        if (this.frame != null) {
            if (!this.frameIsExternalControlled) {
                this.frame.dispose();
                this.frame = null;
            } else {
                this.frame = null;
            }
        }
        if (this.downHelpDialog != null) {
            this.downHelpDialog.dispose();
        }
        ImcMsgManager.getManager().removeListener((MessageListener)this.messageListener);
        this.queueWorkTickets.cancelAll();
    }

    private void disconnectFTPClientsForListing() {
        this.stopLogListProcessing = true;
        if (this.clientFtp != null && this.clientFtp.isConnected()) {
            try {
                this.clientFtp.getClient().disconnect();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (this.cameraFtp != null && this.cameraFtp.isConnected()) {
            try {
                this.cameraFtp.getClient().disconnect();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.cleanup();
    }

    private RectanglePainter getRectPainter() {
        if (this.rectPainter == null) {
            this.rectPainter = new RectanglePainter(0, 0, 0, 0, 10, 10);
            this.rectPainter.setFillPaint((Paint)Color.LIGHT_GRAY);
            this.rectPainter.setBorderPaint((Paint)Color.LIGHT_GRAY.darker().darker().darker());
            this.rectPainter.setStyle(AbstractAreaPainter.Style.BOTH);
            this.rectPainter.setBorderWidth(2.0f);
            this.rectPainter.setAntialiasing(true);
        }
        return this.rectPainter;
    }

    private CompoundPainter<JXPanel> getCompoundBackPainter() {
        this.compoundBackPainter = new CompoundPainter(new Painter[]{this.getRectPainter(), new GlossPainter()});
        return this.compoundBackPainter;
    }

    private void updateDiskFreeLabelBackColor(Color color) {
        this.getRectPainter().setFillPaint((Paint)color);
        this.getRectPainter().setBorderPaint((Paint)color.darker());
        this.diskFreeLabel.setBackgroundPainter(this.getCompoundBackPainter());
    }

    private void popupErrorConfigurationDialog() {
        JOptionPane jop = new JOptionPane(I18n.text("Some of the configuration parameters are not correct!"), 0);
        JDialog dialog = jop.createDialog((Component)this.frameCompHolder, I18n.text("Error on configuration"));
        dialog.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        dialog.setVisible(true);
    }

    public boolean validateConfiguration() {
        if ("".equalsIgnoreCase(this.hostField.getText())) {
            return false;
        }
        if ("".equalsIgnoreCase(this.portField.getText())) {
            return false;
        }
        try {
            Integer.parseInt(this.portField.getText());
        }
        catch (NumberFormatException e) {
            NeptusLog.pub().debug((Object)e.getMessage());
            return false;
        }
        return !"".equalsIgnoreCase(this.logLabelField.getText());
    }

    private boolean validateAndSetUI() {
        int iPort = 30021;
        if ("".equalsIgnoreCase(this.hostField.getText())) {
            return false;
        }
        if ("".equalsIgnoreCase(this.portField.getText())) {
            return false;
        }
        try {
            iPort = Integer.parseInt(this.portField.getText());
        }
        catch (NumberFormatException e) {
            NeptusLog.pub().debug((Object)e.getMessage());
            return false;
        }
        if ("".equalsIgnoreCase(this.logLabelField.getText())) {
            return false;
        }
        this.host = this.hostField.getText();
        this.port = iPort;
        this.logLabel = this.logLabelField.getText();
        if ("".equalsIgnoreCase(this.logLabel)) {
            this.logLabel = I18n.text("unknown");
        }
        return true;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
        this.hostField.setText(host);
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
        this.portField.setText("" + port);
    }

    public String getLogLabel() {
        return this.logLabel;
    }

    public void setLogLabel(String logLabel) {
        this.logLabel = logLabel;
        this.logLabelField.setText(logLabel);
        if (!this.frameIsExternalControlled) {
            this.frame.setTitle(DEFAULT_TITLE + " - " + logLabel);
        }
    }

    public void setVisible(boolean show) {
        this.frame.setVisible(show);
        if (show) {
            this.frame.setState(0);
        }
    }

    private LogFolderInfo findLogFolderInfoForFile(LogFileInfo lfx) {
        for (Object comp : this.logFolderList.getSelectedValues()) {
            try {
                LogFolderInfo logFd = (LogFolderInfo)comp;
                if (!logFd.getLogFiles().contains(lfx)) continue;
                return logFd;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFilesListGUIForFolderSelected() {
        if (this.isUpdatingFileList) {
            this.exitRequest = true;
        }
        Object object = this.lock;
        synchronized (object) {
            this.isUpdatingFileList = true;
            this.exitRequest = false;
            this.logFilesList.setValueIsAdjusting(true);
            LinkedHashSet<LogFileInfo> validFiles = new LinkedHashSet<LogFileInfo>();
            for (Object comp : this.logFolderList.getSelectedValues()) {
                try {
                    LogFolderInfo log = (LogFolderInfo)comp;
                    for (LogFileInfo lgfl : log.getLogFiles()) {
                        validFiles.add(lgfl);
                        if (!this.exitRequest) continue;
                        break;
                    }
                }
                catch (Exception e) {
                    NeptusLog.pub().debug((Object)e.getMessage());
                }
                if (this.exitRequest) break;
            }
            this.logFilesList.setIgnoreRepaint(true);
            try {
                if (SwingUtilities.isEventDispatchThread()) {
                    if (this.exitRequest) {
                        return;
                    }
                    this.logFilesList.myModel.clear();
                } else {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            if (LogsDownloaderWorker.this.exitRequest) {
                                return;
                            }
                            ((LogsDownloaderWorker)LogsDownloaderWorker.this).logFilesList.myModel.clear();
                        }
                    });
                }
                for (final LogFileInfo fxS : validFiles) {
                    if (SwingUtilities.isEventDispatchThread()) {
                        if (this.exitRequest) {
                            return;
                        }
                        this.logFilesList.addFile(fxS);
                    } else {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                if (LogsDownloaderWorker.this.exitRequest) {
                                    return;
                                }
                                LogsDownloaderWorker.this.logFilesList.addFile(fxS);
                            }
                        });
                    }
                    if (!this.exitRequest) continue;
                    break;
                }
            }
            catch (Exception e) {
                NeptusLog.pub().error((Object)e.getMessage());
            }
            this.logFilesList.setIgnoreRepaint(false);
            this.logFilesList.setValueIsAdjusting(false);
            this.logFilesList.invalidate();
            this.logFilesList.validate();
            this.isUpdatingFileList = false;
        }
    }

    private void testNewReportedLogFoldersForLocalCorrespondent(LinkedList<LogFolderInfo> newLogFoldersFromServer) {
        for (LogFolderInfo lf : newLogFoldersFromServer) {
            File testFile = new File(this.getDirTarget(), lf.getName());
            if (testFile.exists()) {
                if (lf.getState() == LogFolderInfo.State.DOWNLOADING) continue;
                lf.setState(LogFolderInfo.State.UNKNOWN);
                for (LogFileInfo lfx : lf.getLogFiles()) {
                    File testFx = new File(this.getDirTarget(), lfx.getName());
                    if (!testFx.exists()) continue;
                    lfx.setState(LogFolderInfo.State.UNKNOWN);
                    long sizeD = this.getDiskSizeFromLocal(lfx);
                    if (lfx.getSize() == sizeD) {
                        lfx.setState(LogFolderInfo.State.SYNC);
                        continue;
                    }
                    lfx.setState(LogFolderInfo.State.INCOMPLETE);
                    System.out.println("//////////// " + lfx + "  incomplete " + lfx.getSize());
                }
                this.updateLogFolderState(lf);
                continue;
            }
            lf.setState(LogFolderInfo.State.NEW);
        }
        this.updateLogStateIconForAllLogFolders();
    }

    private long getDiskSizeFromLocal(LogFileInfo fx) {
        File fileTarget = this.getFileTarget(fx.getName());
        if (fileTarget == null) {
            return -1L;
        }
        if (fileTarget.exists()) {
            if (fileTarget.isFile()) {
                return fileTarget.length();
            }
            if (fileTarget.isDirectory()) {
                long allSize = 0L;
                for (LogFileInfo dirFileInfo : fx.getDirectoryContents()) {
                    long dfSize = this.getDiskSizeFromLocal(dirFileInfo);
                    if (dfSize < 0L) continue;
                    allSize += dfSize;
                }
                return allSize;
            }
            return -500L;
        }
        if (!fileTarget.exists()) {
            return -400L;
        }
        return -500L;
    }

    private void singleLogFileDownloadWorker(LogFileInfo lfx, LogFolderInfo logFd) {
        Component[] components;
        if (lfx.getState() == LogFolderInfo.State.SYNC || lfx.getState() == LogFolderInfo.State.LOCAL) {
            return;
        }
        for (Component cp : components = this.downloadWorkersHolder.getComponents()) {
            try {
                DownloaderPanel dpp = (DownloaderPanel)((Object)cp);
                if (!lfx.getName().equals(dpp.getUri())) continue;
                if (dpp.getState() == DownloaderPanel.State.ERROR || dpp.getState() == DownloaderPanel.State.IDLE || dpp.getState() == DownloaderPanel.State.TIMEOUT || dpp.getState() == DownloaderPanel.State.QUEUED || dpp.getState() == DownloaderPanel.State.NOT_DONE) {
                    dpp.actionDownload();
                }
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        DownloaderPanel workerD = null;
        try {
            FtpDownloader ftpDownloader = null;
            ftpDownloader = new FtpDownloader(lfx.getHost(), this.port);
            if (lfx.isDirectory()) {
                LinkedHashMap<String, FTPFile> directoryContentsList = new LinkedHashMap<String, FTPFile>();
                for (LogFileInfo lfi : lfx.getDirectoryContents()) {
                    directoryContentsList.put(lfi.getUriPartial(), lfi.getFile());
                }
                workerD = new DownloaderPanel(ftpDownloader, lfx.getFile(), lfx.getName(), this.getFileTarget(lfx.getName()), directoryContentsList, this.threadScheduledPool, this.queueWorkTickets);
            } else {
                workerD = new DownloaderPanel(ftpDownloader, lfx.getFile(), lfx.getName(), this.getFileTarget(lfx.getName()), this.threadScheduledPool, this.queueWorkTickets);
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        final LogFolderInfo lfdfinal = logFd;
        final LogFileInfo lfxfinal = lfx;
        final DownloaderPanel workerDFinal = workerD;
        workerD.addStateChangeListener(new DownloadStateListener(){
            private LogFileInfo fxLog;
            private Runnable task;
            {
                this.fxLog = lfxfinal;
                this.task = null;
            }

            @Override
            public void downloaderStateChange(DownloaderPanel.State newState, DownloaderPanel.State oldState) {
                if (this.fxLog.getState() != LogFolderInfo.State.LOCAL) {
                    if (newState == DownloaderPanel.State.DONE) {
                        this.fxLog.setState(LogFolderInfo.State.SYNC);
                    } else if (newState == DownloaderPanel.State.ERROR) {
                        this.fxLog.setState(LogFolderInfo.State.ERROR);
                    } else if (newState == DownloaderPanel.State.WORKING || newState == DownloaderPanel.State.TIMEOUT || newState == DownloaderPanel.State.QUEUED) {
                        this.fxLog.setState(LogFolderInfo.State.DOWNLOADING);
                    } else if (newState == DownloaderPanel.State.NOT_DONE) {
                        this.fxLog.setState(LogFolderInfo.State.INCOMPLETE);
                    } else if (newState == DownloaderPanel.State.IDLE) {
                        // empty if block
                    }
                    if (LogsDownloaderWorker.this.logFilesList.containsFile(this.fxLog)) {
                        LogsDownloaderWorker.this.logFilesList.revalidate();
                        LogsDownloaderWorker.this.logFilesList.repaint();
                    }
                    LogsDownloaderWorker.this.updateLogFolderState(lfdfinal);
                    LogsDownloaderWorker.this.updateLogStateIconForAllLogFolders();
                }
                if (newState == DownloaderPanel.State.WORKING || newState == DownloaderPanel.State.TIMEOUT || newState == DownloaderPanel.State.QUEUED) {
                    this.cancelTasksIfSchedule();
                } else if (newState == DownloaderPanel.State.DONE) {
                    this.cancelTasksIfSchedule();
                    this.task = new Runnable(){

                        @Override
                        public void run() {
                            try {
                                if (workerDFinal.getState() == DownloaderPanel.State.DONE) {
                                    workerDFinal.doStopAndInvalidate();
                                    LogsDownloaderWorker.this.downloadWorkersHolder.remove((Component)((Object)workerDFinal));
                                    LogsDownloaderWorker.this.downloadWorkersHolder.revalidate();
                                    LogsDownloaderWorker.this.downloadWorkersHolder.repaint();
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    };
                    LogsDownloaderWorker.this.threadScheduledPool.schedule(this.task, 5000L, TimeUnit.MILLISECONDS);
                } else {
                    this.cancelTasksIfSchedule();
                    this.task = new Runnable(){

                        @Override
                        public void run() {
                            try {
                                if (workerDFinal.getState() != DownloaderPanel.State.WORKING && workerDFinal.getState() != DownloaderPanel.State.TIMEOUT && workerDFinal.getState() != DownloaderPanel.State.QUEUED) {
                                    workerDFinal.doStopAndInvalidate();
                                    LogsDownloaderWorker.this.downloadWorkersHolder.remove((Component)((Object)workerDFinal));
                                    LogsDownloaderWorker.this.downloadWorkersHolder.revalidate();
                                    LogsDownloaderWorker.this.downloadWorkersHolder.repaint();
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    };
                    LogsDownloaderWorker.this.threadScheduledPool.schedule(this.task, 45000L, TimeUnit.MILLISECONDS);
                }
            }

            private void cancelTasksIfSchedule() {
                if (this.task != null) {
                    LogsDownloaderWorker.this.threadScheduledPool.remove(this.task);
                    LogsDownloaderWorker.this.threadScheduledPool.purge();
                }
            }
        });
        this.downloadWorkersHolder.add((Component)((Object)workerD));
        this.downloadWorkersHolder.revalidate();
        this.downloadWorkersHolder.repaint();
        workerD.actionDownload();
    }

    private void updateLogStateIconForAllLogFolders() {
        Object[] objArray = new Object[this.logFolderList.myModel.size()];
        this.logFolderList.myModel.copyInto(objArray);
        long nTotal = 0L;
        long nDownloading = 0L;
        long nError = 0L;
        long nNew = 0L;
        long nIncomplete = 0L;
        long nLocal = 0L;
        long nSync = 0L;
        long nUnknown = 0L;
        block9: for (Object comp : objArray) {
            LogFolderInfo log = (LogFolderInfo)comp;
            ++nTotal;
            switch (log.getState()) {
                case DOWNLOADING: {
                    ++nDownloading;
                    continue block9;
                }
                case ERROR: {
                    ++nError;
                    continue block9;
                }
                case NEW: {
                    ++nNew;
                    continue block9;
                }
                case SYNC: {
                    ++nSync;
                    continue block9;
                }
                case INCOMPLETE: {
                    ++nIncomplete;
                    continue block9;
                }
                case UNKNOWN: {
                    ++nUnknown;
                    continue block9;
                }
                case LOCAL: {
                    ++nLocal;
                }
            }
        }
        if (objArray.length == 0) {
            this.logFoldersListLabel.setIcon(null);
        } else if (nDownloading > 0L) {
            this.logFoldersListLabel.setIcon(LogFolderInfoList.ICON_DOWN);
        } else if (nError > 0L) {
            this.logFoldersListLabel.setIcon(LogFolderInfoList.ICON_ERROR);
        } else if (nSync == nTotal) {
            this.logFoldersListLabel.setIcon(LogFolderInfoList.ICON_SYNC);
        } else if (nNew + nLocal == nTotal) {
            this.logFoldersListLabel.setIcon(LogFolderInfoList.ICON_NEW);
        } else if (nSync + nIncomplete + nUnknown + nNew + nLocal == nTotal) {
            this.logFoldersListLabel.setIcon(LogFolderInfoList.ICON_INCOMP);
        } else if (nLocal == nTotal) {
            this.logFoldersListLabel.setIcon(LogFolderInfoList.ICON_LOCAL);
        } else if (nNew == nTotal) {
            this.logFoldersListLabel.setIcon(LogFolderInfoList.ICON_NEW);
        } else {
            this.logFoldersListLabel.setIcon(LogFolderInfoList.ICON_UNKNOWN);
        }
    }

    private void updateLogFolderState(LogFolderInfo logFolder) {
        LogFolderInfo.State lfdState = logFolder.getState();
        LogFolderInfo.State lfdStateTmp = LogFolderInfo.State.UNKNOWN;
        long nTotal = 0L;
        long nDownloading = 0L;
        long nError = 0L;
        long nNew = 0L;
        long nIncomplete = 0L;
        long nLocal = 0L;
        long nSync = 0L;
        long nUnknown = 0L;
        for (LogFileInfo tlfx : logFolder.getLogFiles()) {
            ++nTotal;
            switch (tlfx.getState()) {
                case DOWNLOADING: {
                    ++nDownloading;
                    break;
                }
                case ERROR: {
                    ++nError;
                    break;
                }
                case NEW: {
                    ++nNew;
                    break;
                }
                case SYNC: {
                    ++nSync;
                    break;
                }
                case INCOMPLETE: {
                    ++nIncomplete;
                    break;
                }
                case UNKNOWN: {
                    ++nUnknown;
                    break;
                }
                case LOCAL: {
                    ++nLocal;
                }
            }
        }
        if (nDownloading > 0L) {
            logFolder.setState(LogFolderInfo.State.DOWNLOADING);
        } else if (nError > 0L) {
            logFolder.setState(LogFolderInfo.State.ERROR);
        } else if (nSync == nTotal) {
            logFolder.setState(LogFolderInfo.State.SYNC);
        } else if (nNew + nLocal == nTotal) {
            logFolder.setState(LogFolderInfo.State.NEW);
        } else if (nSync + nIncomplete + nUnknown + nNew + nLocal == nTotal) {
            logFolder.setState(LogFolderInfo.State.INCOMPLETE);
        } else if (nLocal == nTotal) {
            logFolder.setState(LogFolderInfo.State.LOCAL);
        } else if (nNew == nTotal) {
            logFolder.setState(LogFolderInfo.State.NEW);
        } else {
            logFolder.setState(LogFolderInfo.State.UNKNOWN);
        }
        lfdStateTmp = logFolder.getState();
        if (lfdState != lfdStateTmp && this.logFolderList.containsFolder(logFolder)) {
            this.logFolderList.revalidate();
            this.logFolderList.repaint();
        }
    }

    private boolean deleteLogFolderFromServer(LogFolderInfo logFd) {
        String path = logFd.getName();
        boolean ret = this.deleteLogFolderFromServer(path);
        return ret |= this.deleteLogFolderFromCameraServer(path);
    }

    private boolean deleteLogFileFromServer(LogFileInfo logFx) {
        String path = logFx.getName();
        String hostFx = logFx.getHost();
        if (hostFx.equals(this.host)) {
            return this.deleteLogFolderFromServer(path);
        }
        if (hostFx.equals(this.getCameraHost(this.host))) {
            return this.deleteLogFolderFromCameraServer(path);
        }
        return false;
    }

    private boolean deleteLogFolderFromServer(String path) {
        try {
            System.out.println("Deleting folder");
            try {
                this.clientFtp = this.getOrRenewFtpDownloader(this.clientFtp, this.host, this.port);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return this.clientFtp.getClient().deleteFile("/" + path);
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    private boolean deleteLogFolderFromCameraServer(String path) {
        try {
            if (this.cameraFtp != null) {
                try {
                    this.cameraFtp = this.getOrRenewFtpDownloader(this.cameraFtp, this.getCameraHost(this.host), this.port);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return this.cameraFtp.getClient().deleteFile("/" + path);
            }
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    private LinkedList<LogFolderInfo> getLogFileList(LinkedHashMap<String, String> serversLogPresenceList) {
        if (serversLogPresenceList.size() == 0) {
            return new LinkedList<LogFolderInfo>();
        }
        LinkedList<LogFolderInfo> tmpLogFolders = new LinkedList<LogFolderInfo>();
        String cameraHost = this.getCameraHost(this.getHost());
        System.out.println(LogsDownloaderWorker.class.getSimpleName() + " :: " + cameraHost + " " + this.getLogLabel());
        try {
            LogFileInfo fLogFileTmp;
            String fURIPartial;
            FTPFile fFile;
            ArrayList<LogFileInfo> directoryContents;
            LinkedHashMap<String, FTPFile> dirListing;
            long allSize;
            LogFileInfo logFileTmp;
            String uriPartial;
            String name;
            for (String logDir : serversLogPresenceList.keySet()) {
                FTPFile[] files;
                if (!serversLogPresenceList.get(logDir).contains(SERVER_MAIN)) continue;
                String isoStr = new String(logDir.getBytes(), "ISO-8859-1");
                LogFolderInfo lFolder = new LogFolderInfo(logDir);
                for (FTPFile file : files = this.clientFtp.getClient().listFiles("/" + isoStr + "/")) {
                    name = logDir + "/" + file.getName();
                    uriPartial = logDir + "/" + file.getName();
                    logFileTmp = new LogFileInfo(name);
                    logFileTmp.setUriPartial(uriPartial);
                    logFileTmp.setSize(file.getSize());
                    logFileTmp.setFile(file);
                    logFileTmp.setHost(this.getHost());
                    if (file.isDirectory()) {
                        logFileTmp.setSize(-1L);
                        allSize = 0L;
                        dirListing = this.clientFtp.listDirectory(logFileTmp.getName());
                        directoryContents = new ArrayList<LogFileInfo>();
                        for (String fName : dirListing.keySet()) {
                            fFile = dirListing.get(fName);
                            fURIPartial = fName;
                            fLogFileTmp = new LogFileInfo(fName);
                            fLogFileTmp.setUriPartial(fURIPartial);
                            fLogFileTmp.setSize(fFile.getSize());
                            fLogFileTmp.setFile(fFile);
                            fLogFileTmp.setHost(this.getHost());
                            allSize += fLogFileTmp.getSize();
                            directoryContents.add(fLogFileTmp);
                        }
                        logFileTmp.setDirectoryContents(directoryContents);
                        logFileTmp.setSize(allSize);
                    }
                    lFolder.addFile(logFileTmp);
                    tmpLogFolders.add(lFolder);
                }
            }
            if (cameraHost != null && this.cameraFtp != null) {
                FtpDownloader ftpd = this.cameraFtp;
                for (String logDir : serversLogPresenceList.keySet()) {
                    if (!serversLogPresenceList.get(logDir).contains(SERVER_CAM)) continue;
                    String isoStr = new String(logDir.getBytes(), "ISO-8859-1");
                    LogFolderInfo lFolder = null;
                    for (LogFolderInfo lfi : tmpLogFolders) {
                        if (!lfi.getName().equals(logDir)) continue;
                        lFolder = lfi;
                    }
                    if (lFolder == null) {
                        lFolder = new LogFolderInfo(logDir);
                    }
                    if (!ftpd.isConnected()) {
                        ftpd.renewClient();
                    }
                    try {
                        for (FTPFile file : ftpd.getClient().listFiles("/" + isoStr + "/")) {
                            name = logDir + "/" + file.getName();
                            uriPartial = logDir + "/" + file.getName();
                            logFileTmp = new LogFileInfo(name);
                            logFileTmp.setUriPartial(uriPartial);
                            logFileTmp.setSize(file.getSize());
                            logFileTmp.setFile(file);
                            logFileTmp.setHost(cameraHost);
                            if (file.isDirectory()) {
                                logFileTmp.setSize(-1L);
                                allSize = 0L;
                                dirListing = ftpd.listDirectory(logFileTmp.getName());
                                directoryContents = new ArrayList();
                                for (String fName : dirListing.keySet()) {
                                    fFile = dirListing.get(fName);
                                    fURIPartial = fName;
                                    fLogFileTmp = new LogFileInfo(fName);
                                    fLogFileTmp.setUriPartial(fURIPartial);
                                    fLogFileTmp.setSize(fFile.getSize());
                                    fLogFileTmp.setFile(fFile);
                                    fLogFileTmp.setHost(cameraHost);
                                    allSize += fLogFileTmp.getSize();
                                    directoryContents.add(fLogFileTmp);
                                }
                                logFileTmp.setDirectoryContents(directoryContents);
                                logFileTmp.setSize(allSize);
                            }
                            lFolder.addFile(logFileTmp);
                            tmpLogFolders.add(lFolder);
                        }
                    }
                    catch (Exception e) {
                        System.err.println(isoStr);
                        e.printStackTrace();
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return tmpLogFolders;
    }

    private File getFileTarget(String name) {
        File outFile = new File(this.getDirTarget(), name);
        return outFile;
    }

    private File getDirTarget() {
        File dirToStore = new File(this.dirBaseToStoreFiles);
        dirToStore.mkdirs();
        File dirTarget = new File(dirToStore, this.logLabel);
        return dirTarget;
    }

    private void cleanInterface() {
        this.logFilesList.myModel.clear();
        this.logFolderList.myModel.clear();
        this.downloadWorkersHolder.removeAll();
        this.downloadListButton.setEnabled(true);
        this.downloadSelectedLogDirsButton.setEnabled(true);
        this.downloadSelectedLogFilesButton.setEnabled(true);
        this.deleteSelectedLogFoldersButton.setEnabled(true);
        this.deleteSelectedLogFilesButton.setEnabled(true);
        this.logFoldersListLabel.setIcon(null);
    }

    public void setVisibleHost(boolean visible) {
        this.hostField.setVisible(visible);
        this.hostLabel.setVisible(visible);
    }

    public void setVisiblePort(boolean visible) {
        this.portField.setVisible(visible);
        this.portLabel.setVisible(visible);
    }

    public void setVisibleLogLabel(boolean visible) {
        this.logLabelField.setVisible(visible);
        this.logLabelLabel.setVisible(visible);
    }

    public void setConfigPanelVisible(boolean visible) {
        this.configCollapsiblePanel.setCollapsed(!visible);
    }

    public void setEnableHost(boolean enable) {
        this.hostField.setEnabled(enable);
    }

    public void setEnablePort(boolean enable) {
        this.portField.setEnabled(enable);
    }

    public void setEnableLogLabel(boolean enable) {
        this.logLabelField.setEnabled(enable);
    }

    private void warnMsg(String message) {
        NudgeGlassPane.nudge(this.frameCompHolder.getRootPane(), (this.frameIsExternalControlled ? this.getLogLabel() + " > " : "") + message, 2);
    }

    private void warnLongMsg(String message) {
        NudgeGlassPane.nudge(this.frameCompHolder.getRootPane(), (this.frameIsExternalControlled ? this.getLogLabel() + " > " : "") + message, 6);
    }

    public boolean doUpdateListFromServer() {
        this.downloadListButton.doClick(100);
        return true;
    }

    public boolean doDownloadLogFoldersFromServer(String ... logList) {
        return this.doDownloadOrDeleteLogFoldersFromServer(true, logList);
    }

    public boolean doDeleteLogFoldersFromServer(String ... logList) {
        return this.doDownloadOrDeleteLogFoldersFromServer(false, logList);
    }

    private boolean doDownloadOrDeleteLogFoldersFromServer(final boolean downloadOrDelete, String ... logList) {
        if (logList == null) {
            return false;
        }
        if (logList.length == 0) {
            return false;
        }
        final LinkedList<LogFolderInfo> folders = new LinkedList<LogFolderInfo>();
        for (String str : logList) {
            if (!this.logFolderList.containsFolder(new LogFolderInfo(str))) continue;
            folders.add(this.logFolderList.getFolder(str));
        }
        if (folders.size() == 0) {
            return false;
        }
        SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                LogsDownloaderWorker.this.logFolderList.setEnabled(false);
                LogsDownloaderWorker.this.logFolderList.clearSelection();
                LogsDownloaderWorker.this.logFolderList.setValueIsAdjusting(true);
                for (LogFolderInfo logFd : folders) {
                    int iS = ((LogsDownloaderWorker)LogsDownloaderWorker.this).logFolderList.myModel.indexOf(logFd);
                    iS = LogsDownloaderWorker.this.logFolderList.convertIndexToView(iS);
                    LogsDownloaderWorker.this.logFolderList.addSelectionInterval(iS, iS);
                }
                LogsDownloaderWorker.this.logFolderList.setValueIsAdjusting(false);
                if (downloadOrDelete) {
                    LogsDownloaderWorker.this.downloadSelectedLogDirsButton.doClick(100);
                } else {
                    LogsDownloaderWorker.this.deleteSelectedLogFoldersButton.doClick(100);
                }
                return null;
            }

            @Override
            protected void done() {
                super.done();
                try {
                    this.get();
                }
                catch (Exception e) {
                    NeptusLog.pub().error((Object)e);
                }
                LogsDownloaderWorker.this.logFolderList.setEnabled(true);
            }
        };
        worker.execute();
        return true;
    }

    public LinkedHashMap<String, LogFolderInfo.State> doGiveStateOfLogFolders(String ... logList) {
        LinkedHashMap<String, LogFolderInfo.State> res = new LinkedHashMap<String, LogFolderInfo.State>();
        Vector<String> filter = null;
        if (logList != null && logList.length > 0) {
            filter = new Vector<String>();
            for (String str : logList) {
                filter.add(str);
            }
        }
        Enumeration<LogFolderInfo> iterator = this.logFolderList.myModel.elements();
        while (iterator.hasMoreElements()) {
            LogFolderInfo lfd = iterator.nextElement();
            if (filter == null) {
                res.put(lfd.getName(), lfd.getState());
                continue;
            }
            if (filter.size() == 0) break;
            if (!filter.contains(lfd.getName())) continue;
            res.put(lfd.getName(), lfd.getState());
            filter.remove(lfd.getName());
        }
        return res;
    }

    public String[] doGiveListOfLogFolders() {
        LinkedList<String> list = new LinkedList<String>();
        Enumeration<LogFolderInfo> iterator = this.logFolderList.myModel.elements();
        while (iterator.hasMoreElements()) {
            LogFolderInfo lfd = iterator.nextElement();
            list.add(lfd.getName());
        }
        return list.toArray(new String[0]);
    }

    public String[] doGiveListOfLogFolderFiles(String logFolder) {
        LinkedList<String> list = new LinkedList<String>();
        Enumeration<LogFolderInfo> iterator = this.logFolderList.myModel.elements();
        while (iterator.hasMoreElements()) {
            LogFolderInfo lfd = iterator.nextElement();
            if (!lfd.getName().equalsIgnoreCase(logFolder)) continue;
            for (LogFileInfo lfx : lfd.getLogFiles()) {
                list.add(lfx.getName());
            }
        }
        return list.toArray(new String[0]);
    }

    public LinkedHashMap<String, LogFolderInfo.State> doGiveStateOfLogFolderFiles(String logFolder) {
        LinkedHashMap<String, LogFolderInfo.State> res = new LinkedHashMap<String, LogFolderInfo.State>();
        Enumeration<LogFolderInfo> iterator = this.logFolderList.myModel.elements();
        while (iterator.hasMoreElements()) {
            LogFolderInfo lfd = iterator.nextElement();
            if (!lfd.getName().equalsIgnoreCase(logFolder)) continue;
            for (LogFileInfo lfx : lfd.getLogFiles()) {
                res.put(lfx.getName(), lfx.getState());
            }
        }
        return res;
    }

    private void doStopLogFoldersDownloads(boolean invalidateComponents, String ... logList) {
        Component[] components;
        boolean stopAll = true;
        if (logList != null && logList.length > 0) {
            stopAll = false;
        }
        block2: for (Component cp : components = this.downloadWorkersHolder.getComponents()) {
            try {
                DownloaderPanel workerD = (DownloaderPanel)((Object)cp);
                if (!stopAll) {
                    for (String prefix : logList) {
                        if (!workerD.getName().startsWith(prefix)) continue;
                        if (!invalidateComponents) {
                            workerD.actionStop();
                            continue block2;
                        }
                        workerD.actionStopAndInvalidate();
                        continue block2;
                    }
                    continue;
                }
                workerD.actionStop();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void waitForStopOnAllLogFoldersDownloads(String ... logList) {
        Component[] components;
        if (!GeneralPreferences.logsDownloaderWaitForAllToStop) {
            return;
        }
        boolean waitStopAll = true;
        if (logList != null && logList.length > 0) {
            waitStopAll = false;
        }
        for (Component cp : components = this.downloadWorkersHolder.getComponents()) {
            try {
                DownloaderPanel workerD = (DownloaderPanel)((Object)cp);
                boolean wait = false;
                if (workerD.getState() != DownloaderPanel.State.WORKING && workerD.getState() != DownloaderPanel.State.QUEUED) continue;
                if (!waitStopAll) {
                    for (String prefix : logList) {
                        if (!workerD.getName().startsWith(prefix)) continue;
                        wait = true;
                        break;
                    }
                    if (!wait) continue;
                }
                while (workerD.getState() == DownloaderPanel.State.WORKING || workerD.getState() == DownloaderPanel.State.QUEUED) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    NeptusLog.pub().warn((Object)("Waiting for '" + workerD.getUri() + "' to stop!"));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public synchronized boolean doReset(final boolean justStopDownloads) {
        boolean isEventDispatchThread = SwingUtilities.isEventDispatchThread();
        SwingWorker<Boolean, Void> worker = new SwingWorker<Boolean, Void>(){

            @Override
            protected Boolean doInBackground() throws Exception {
                if (!justStopDownloads) {
                    LogsDownloaderWorker.this.resetting = true;
                }
                boolean resetRes = true;
                if (!justStopDownloads) {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            LogsDownloaderWorker.this.warnLongMsg(I18n.text("Resetting... Wait please..."));
                        }
                    });
                }
                try {
                    LogsDownloaderWorker.this.disconnectFTPClientsForListing();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            LogsDownloaderWorker.this.warnLongMsg(I18n.textf("Error couth on resetting: %errormessage", e.getMessage()));
                        }
                    });
                    resetRes &= false;
                }
                try {
                    if (!justStopDownloads) {
                        LogsDownloaderWorker.this.doStopLogFoldersDownloads(true, new String[0]);
                    } else {
                        LogsDownloaderWorker.this.doStopLogFoldersDownloads(false, new String[0]);
                    }
                    LogsDownloaderWorker.this.waitForStopOnAllLogFoldersDownloads(new String[0]);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            LogsDownloaderWorker.this.warnLongMsg(I18n.textf("Error couth on resetting: %errormessage", e.getMessage()));
                        }
                    });
                    resetRes &= false;
                }
                try {
                    if (!justStopDownloads) {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                LogsDownloaderWorker.this.cleanInterface();
                            }
                        });
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    LogsDownloaderWorker.this.warnLongMsg(I18n.textf("Error couth on resetting: %errormessage", e.getMessage()));
                    resetRes &= false;
                }
                LogsDownloaderWorker.this.queueWorkTickets.cancelAll();
                if (!justStopDownloads) {
                    LogsDownloaderWorker.this.resetting = false;
                }
                return resetRes;
            }

            @Override
            protected void done() {
                if (!justStopDownloads) {
                    LogsDownloaderWorker.this.resetButton.setEnabled(true);
                } else {
                    LogsDownloaderWorker.this.stopAllButton.setEnabled(true);
                    LogsDownloaderWorker.this.updateLogStateIconForAllLogFolders();
                }
            }
        };
        worker.execute();
        if (!isEventDispatchThread) {
            try {
                return (Boolean)worker.get();
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }

    private LinkedHashSet<LogFileInfo> updateLogFilesStateDeleted(LinkedHashSet<LogFileInfo> logFiles) {
        LinkedHashSet<LogFileInfo> toDelFL = new LinkedHashSet<LogFileInfo>();
        for (LogFileInfo lfx : logFiles) {
            Component[] components;
            lfx.setState(LogFolderInfo.State.LOCAL);
            for (Component cp : components = this.downloadWorkersHolder.getComponents()) {
                try {
                    DownloaderPanel dpp = (DownloaderPanel)((Object)cp);
                    if (!lfx.getName().equals(dpp.getUri())) continue;
                    if (dpp.getState() != DownloaderPanel.State.WORKING && dpp.getState() != DownloaderPanel.State.QUEUED) break;
                    dpp.addStateChangeListener(null);
                    dpp.actionStop();
                    final DownloaderPanel workerDFinal = dpp;
                    SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

                        @Override
                        protected Void doInBackground() throws Exception {
                            if (workerDFinal.getState() == DownloaderPanel.State.IDLE) {
                                workerDFinal.doStopAndInvalidate();
                                LogsDownloaderWorker.this.downloadWorkersHolder.remove((Component)((Object)workerDFinal));
                                LogsDownloaderWorker.this.downloadWorkersHolder.revalidate();
                                LogsDownloaderWorker.this.downloadWorkersHolder.repaint();
                            }
                            return null;
                        }
                    };
                    worker.execute();
                    break;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (!this.getFileTarget(lfx.getName()).exists()) {
                toDelFL.add(lfx);
            }
            lfx.setState(LogFolderInfo.State.LOCAL);
        }
        return toDelFL;
    }

    public String getCameraHost(String mainHost) {
        String cameraHost = null;
        try {
            Object[] parts = mainHost.split("\\.");
            parts[3] = "" + (Integer.parseInt(parts[3]) + 3);
            cameraHost = StringUtils.join((Object[])parts, (String)".");
        }
        catch (Exception oops) {
            NeptusLog.pub().error((Object)("Could not get camera host string: " + oops.getClass().getSimpleName()), (Throwable)oops);
            cameraHost = "";
        }
        catch (Error oops) {
            NeptusLog.pub().error((Object)("Could not get camera host string: " + oops.getClass().getSimpleName()), (Throwable)oops);
            cameraHost = "";
        }
        return cameraHost;
    }

    public static void main(String[] args) {
        GuiUtils.setLookAndFeel();
        LogsDownloaderWorker logFetcher = new LogsDownloaderWorker();
        logFetcher.setEnableLogLabel(true);
        logFetcher.frame.setDefaultCloseOperation(3);
        logFetcher.frame.setVisible(true);
    }
}

