/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.util.logdownload;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import pt.lsts.neptus.NeptusLog;

public class QueueWorkTickets<C> {
    private int maximumTickets = 10;
    private LinkedBlockingQueue<C> waitingClients = new LinkedBlockingQueue();
    private LinkedBlockingQueue<C> workingClients = new LinkedBlockingQueue();
    private HashMap<C, QueueFuture> futures = new HashMap();

    public QueueWorkTickets(int maximumTickets) {
        this.maximumTickets = maximumTickets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean lease(C client) {
        if (this.waitingClients.contains(client)) {
            return false;
        }
        LinkedBlockingQueue<C> linkedBlockingQueue = this.workingClients;
        synchronized (linkedBlockingQueue) {
            if (this.workingClients.contains(client)) {
                return true;
            }
        }
        this.waitingClients.offer(client);
        this.leaseNext();
        return this.isLeased(client);
    }

    public Future<Boolean> leaseAndWait(C client) {
        return this.leaseAndWait(client, null);
    }

    public Future<Boolean> leaseAndWait(C client, Callable<Boolean> callable) {
        if (this.futures.containsKey(client)) {
            QueueFuture fTmp = this.futures.remove(client);
            fTmp.cancel(true);
        }
        QueueFuture future = new QueueFuture(client, callable);
        this.futures.put(client, future);
        boolean res = this.lease(client);
        return future;
    }

    private void runFuture(QueueFuture future) {
        future.run();
    }

    public boolean isLeased(C client) {
        boolean ret = this.workingClients.contains(client);
        if (!ret) {
            this.leaseNext();
            return this.workingClients.contains(client);
        }
        NeptusLog.pub().warn((Object)(QueueWorkTickets.class.getSimpleName() + " .................... size of workers=" + this.workingClients.size() + "  waiting=" + this.waitingClients.size()));
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isQueued(C client) {
        boolean ret = false;
        LinkedBlockingQueue<C> linkedBlockingQueue = this.workingClients;
        synchronized (linkedBlockingQueue) {
            ret = this.workingClients.contains(client) || this.waitingClients.contains(client);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean release(C client) {
        boolean ret;
        LinkedBlockingQueue<C> linkedBlockingQueue = this.workingClients;
        synchronized (linkedBlockingQueue) {
            ret = this.workingClients.remove(client);
            ret |= this.waitingClients.remove(client);
            QueueFuture fTmp = this.futures.remove(client);
            if (fTmp != null) {
                fTmp.cancel(true);
            }
        }
        this.leaseNext();
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void leaseNext() {
        LinkedBlockingQueue<C> linkedBlockingQueue = this.workingClients;
        synchronized (linkedBlockingQueue) {
            if (this.workingClients.size() < this.maximumTickets) {
                try {
                    C client = this.waitingClients.poll(100L, TimeUnit.MILLISECONDS);
                    if (client != null) {
                        this.workingClients.offer(client);
                        QueueFuture future = this.futures.remove(client);
                        if (future != null) {
                            this.runFuture(future);
                        }
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        NeptusLog.pub().warn((Object)(QueueWorkTickets.class.getSimpleName() + " |................... size of workers=" + this.workingClients.size() + "  waiting=" + this.waitingClients.size()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelAll() {
        LinkedBlockingQueue<C> linkedBlockingQueue = this.workingClients;
        synchronized (linkedBlockingQueue) {
            NeptusLog.pub().warn((Object)(QueueWorkTickets.class.getSimpleName() + " |..cancel all....... size of workers=" + this.workingClients.size() + "  waiting=" + this.waitingClients.size()));
            this.workingClients.clear();
            this.waitingClients.clear();
            for (QueueFuture ft : this.futures.values()) {
                ft.cancel(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<C> getAllWorkingClients() {
        ArrayList<Object> ret = new ArrayList<Object>();
        try {
            Object[] retArray;
            LinkedBlockingQueue<C> linkedBlockingQueue = this.workingClients;
            synchronized (linkedBlockingQueue) {
                retArray = this.workingClients.toArray(new Object[this.workingClients.size()]);
            }
            for (Object o : retArray) {
                ret.add(o);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static void main(String[] args) {
        Object o1 = new Object();
        Object o2 = new Object();
        Object o3 = new Object();
        Object o4 = new Object();
        QueueWorkTickets<Object> qt = new QueueWorkTickets<Object>(2);
        System.out.println("true = " + qt.lease(o1));
        System.out.println("true = " + qt.lease(o2));
        System.out.println("false = " + qt.lease(o3));
        System.out.println("false = " + qt.lease(o4));
        System.out.println("----------------------------------");
        System.out.println("true = " + qt.release(o2));
        System.out.println("true = " + qt.lease(o3));
        System.out.println("false = " + qt.lease(o4));
        System.out.println();
        System.out.println();
        System.out.println();
        System.out.println("----------------------------------");
        qt.cancelAll();
        System.out.println("true = " + qt.lease(o1));
        System.out.println("true = " + qt.lease(o2));
        Future<Boolean> ft = qt.leaseAndWait(o3, new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                System.out.println("true = o3");
                return true;
            }
        });
        try {
            ft.get(2L, TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            e.printStackTrace();
        }
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        System.out.println("true = " + qt.release(o2));
        try {
            System.out.println("true = " + ft.get());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        qt.cancelAll();
        System.out.println();
        System.out.println();
        System.out.println();
        System.out.println("----------------------------------");
        Future<Boolean> ft1 = qt.leaseAndWait(o1, new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                System.out.println("true = o1");
                return true;
            }
        });
        try {
            ft1.get(2L, TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            e.printStackTrace();
        }
    }

    private class QueueFuture
    implements Future<Boolean> {
        private C client = null;
        private Callable<Boolean> callable = null;
        private Boolean result = null;
        private boolean canceled = false;

        public QueueFuture(C client, Callable<Boolean> callable) {
            this.client = client;
            this.callable = callable;
        }

        boolean run() {
            if (this.canceled) {
                this.result = false;
            } else if (this.callable != null) {
                try {
                    new Thread(QueueWorkTickets.class.getSimpleName() + ":: " + Integer.toHexString(QueueWorkTickets.this.hashCode())){

                        @Override
                        public void run() {
                            try {
                                QueueFuture.this.callable.call();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }.start();
                    this.result = true;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.result = false;
                    QueueWorkTickets.this.release(this.client);
                }
            } else {
                this.result = true;
            }
            return this.result;
        }

        @Override
        public Boolean get() throws InterruptedException, ExecutionException {
            while (this.result == null) {
                Thread.sleep(100L);
            }
            return this.result;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            this.canceled = true;
            return false;
        }

        @Override
        public Boolean get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            long startTime = System.currentTimeMillis();
            while (this.result == null) {
                Thread.sleep(100L);
                if (System.currentTimeMillis() - startTime <= unit.toMillis(timeout)) continue;
                throw new TimeoutException("Timeout while waiting");
            }
            return this.result;
        }

        @Override
        public boolean isCancelled() {
            return this.canceled;
        }

        @Override
        public boolean isDone() {
            return this.result != null;
        }
    }
}

