/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.util.lsf.gz;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import pt.lsts.neptus.NeptusLog;

public class ConcatInputStream
extends InputStream {
    private int inputStreamQueueIndex = 0;
    private ArrayList<InputStream> inputStreamQueue = new ArrayList();
    private InputStream currentInputStream = null;
    private boolean doneAddingInputStreams = false;
    private boolean closed = false;

    public void lastInputStreamAdded() {
        this.doneAddingInputStreams = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInputStream(InputStream in) {
        ArrayList<InputStream> arrayList = this.inputStreamQueue;
        synchronized (arrayList) {
            if (in == null) {
                throw new NullPointerException();
            }
            if (this.closed) {
                throw new IllegalStateException("ConcatInputStream has been closed");
            }
            if (this.doneAddingInputStreams) {
                throw new IllegalStateException("Cannot add more inputStreams - the last inputStream has already been added.");
            }
            this.inputStreamQueue.add(in);
        }
    }

    public void addInputStreams(InputStream[] in) {
        for (InputStream element : in) {
            this.addInputStream(element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream getCurrentInputStream() {
        if (this.currentInputStream == null && this.inputStreamQueueIndex < this.inputStreamQueue.size()) {
            ArrayList<InputStream> arrayList = this.inputStreamQueue;
            synchronized (arrayList) {
                this.currentInputStream = this.inputStreamQueue.get(this.inputStreamQueueIndex);
            }
        }
        return this.currentInputStream;
    }

    private void advanceToNextInputStream() {
        this.currentInputStream = null;
        ++this.inputStreamQueueIndex;
    }

    public ConcatInputStream() {
    }

    public ConcatInputStream(InputStream in) {
        this.addInputStream(in);
        this.lastInputStreamAdded();
    }

    public ConcatInputStream(InputStream in1, InputStream in2) {
        this.addInputStream(in1);
        this.addInputStream(in2);
        this.lastInputStreamAdded();
    }

    public ConcatInputStream(InputStream[] in) {
        this.addInputStreams(in);
        this.lastInputStreamAdded();
    }

    @Override
    public int read() throws IOException {
        if (this.closed) {
            throw new IOException("InputStream closed");
        }
        int r = -1;
        while (r == -1) {
            InputStream in = this.getCurrentInputStream();
            if (in == null) {
                if (this.doneAddingInputStreams) {
                    return -1;
                }
                try {
                    Thread.sleep(100L);
                    continue;
                }
                catch (InterruptedException iox) {
                    throw new IOException("Interrupted");
                }
            }
            r = in.read();
            if (r != -1) continue;
            this.advanceToNextInputStream();
        }
        return r;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (off < 0 || len < 0 || off + len > b.length) {
            throw new IllegalArgumentException();
        }
        if (this.closed) {
            throw new IOException("InputStream closed");
        }
        int r = -1;
        while (r == -1) {
            InputStream in = this.getCurrentInputStream();
            if (in == null) {
                if (this.doneAddingInputStreams) {
                    return -1;
                }
                try {
                    Thread.sleep(100L);
                    continue;
                }
                catch (InterruptedException iox) {
                    throw new IOException("Interrupted");
                }
            }
            r = in.read(b, off, len);
            if (r != -1) continue;
            this.advanceToNextInputStream();
        }
        return r;
    }

    @Override
    public long skip(long n) throws IOException {
        if (this.closed) {
            throw new IOException("InputStream closed");
        }
        if (n <= 0L) {
            return 0L;
        }
        long s = -1L;
        while (s <= 0L) {
            InputStream in = this.getCurrentInputStream();
            if (in == null) {
                if (this.doneAddingInputStreams) {
                    return 0L;
                }
                try {
                    Thread.sleep(100L);
                    continue;
                }
                catch (InterruptedException iox) {
                    throw new IOException("Interrupted");
                }
            }
            s = in.skip(n);
            if (s > 0L) continue;
            s = this.read() == -1 ? -1 : 1;
        }
        return s;
    }

    @Override
    public int available() throws IOException {
        if (this.closed) {
            throw new IOException("InputStream closed");
        }
        InputStream in = this.getCurrentInputStream();
        if (in == null) {
            return 0;
        }
        return in.available();
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        for (InputStream element : this.inputStreamQueue) {
            element.close();
        }
        this.closed = true;
    }

    @Override
    public void mark(int readlimit) {
    }

    @Override
    public void reset() throws IOException {
        throw new IOException("Reset not supported");
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    public static void main(String[] args) throws Exception {
        ConcatInputStream cis = new ConcatInputStream();
        cis.addInputStream(new FileInputStream("/home/zp/Desktop/mra-cmap/160924_motor_limit_half/Cache.lsf"));
        cis.addInputStream(new FileInputStream("/home/zp/Desktop/mra-cmap/160924_motor_limit_half/Data.lsf"));
        cis.lastInputStreamAdded();
        byte[] buff = new byte[255];
        while (cis.read(buff, 0, 255) != -1) {
            NeptusLog.pub().info((Object)"<###>read");
        }
        NeptusLog.pub().info((Object)"<###>finito");
        cis.close();
    }
}

