/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.util.output;

import java.awt.BorderLayout;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;
import javax.swing.JPanel;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.conf.ConfigFetch;
import pt.lsts.neptus.util.output.OutputListener;

public class OutputMonitor {
    private static PrintStream oldErr = System.err;
    private static PrintStream oldOut = System.out;
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final int ERR = 1;
    private static final int OUT = 0;
    private static final int START = -1;
    private Vector<OutputListener> listeners = new Vector();
    private Vector<Thread> mutedThreads = new Vector();
    private BufferedWriter bw = null;
    private BufferedWriter htmlOut;
    private FilteredStream filteredOut = new FilteredStream(oldOut, 0);
    private FilteredStream filteredErr = new FilteredStream(oldErr, 1);
    private static OutputMonitor instance = null;
    int lastOutputType = -1;
    private static boolean disable = false;

    public void muteThread(Thread t) {
        if (!this.mutedThreads.contains(t)) {
            this.mutedThreads.add(t);
        }
    }

    public static boolean isDisable() {
        return disable;
    }

    public static void setDisable(boolean disable) {
        OutputMonitor.disable = disable;
    }

    public static OutputMonitor getInstance() {
        if (instance == null) {
            instance = new OutputMonitor();
        }
        return instance;
    }

    public static void grab() {
        if (OutputMonitor.isDisable()) {
            return;
        }
        OutputMonitor.getInstance();
    }

    private OutputMonitor() {
        try {
            this.htmlOut = new BufferedWriter(new FileWriter(GuiUtils.getLogFileName("output", "html")));
            this.htmlOut.write("<html><head><title>Neptus Output</title></head><body><font color='green'><i>Neptus started at " + this.sdf.format(new Date()) + "</i></font><hr>\n\n");
        }
        catch (IOException e) {
            NeptusLog.pub().error((Object)e);
        }
        System.setOut(new PrintStream(this.filteredOut));
        System.setErr(new PrintStream(this.filteredErr));
    }

    public static void end() {
        if (instance != null) {
            instance.endGrabbing();
        }
        instance = null;
    }

    public void endGrabbing() {
        System.setErr(oldErr);
        System.setOut(oldOut);
        try {
            if (this.bw != null) {
                this.bw.close();
            }
        }
        catch (IOException e) {
            NeptusLog.pub().error((Object)e);
        }
        try {
            if (this.htmlOut != null) {
                this.htmlOut.write("</pre></font>\n<hr>\n<font color='green'><i>Neptus closed at " + this.sdf.format(new Date()) + "</i></font>\n</body></html>");
                this.htmlOut.close();
            }
        }
        catch (IOException e) {
            NeptusLog.pub().error((Object)e);
        }
    }

    public static void main(String[] args) {
        ConfigFetch.initialize();
        NeptusLog.pub().info((Object)"<###>dsd");
        System.err.println("dsd asdf sdf sadf asdfa sdkfg aksjdgf ksdagfk jasdgfkjasgd fkajsgd fkjasgdkjf hgaskjdgfkasjd f\nsdasdf gasdf hgaskdjfg ksajdgfk asgdfk gaskdjfgkjashdgf sdf sdf sadfa sdf");
    }

    public void addOutputListener(OutputListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeOutputListener(OutputListener listener) {
        if (this.listeners.contains(listener)) {
            this.listeners.remove(listener);
        }
    }

    public void warnListeners(String text, int type) {
        if (type == 1) {
            for (OutputListener listener : this.listeners) {
                listener.addErr(text);
            }
        }
        if (type == 0) {
            for (OutputListener listener : this.listeners) {
                listener.addOut(text);
            }
        }
    }

    public static void addListener(OutputListener listener) {
        if (instance != null) {
            instance.addOutputListener(listener);
        }
    }

    public JPanel getOutputPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        return panel;
    }

    class FilteredStream
    extends FilterOutputStream {
        private int type;
        private String[] color;

        public FilteredStream(OutputStream aStream, int type) {
            super(aStream);
            this.type = -1;
            this.color = new String[]{"black", "red"};
            this.type = type;
        }

        @Override
        public void write(byte[] b) throws IOException {
            if (OutputMonitor.this.mutedThreads.contains(Thread.currentThread())) {
                return;
            }
            super.write(b);
            String aString = new String(b);
            this.writeToHtmlOutput(aString);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            if (OutputMonitor.this.mutedThreads.contains(Thread.currentThread())) {
                return;
            }
            super.write(b, off, len);
            String aString = new String(b, off, len);
            this.writeToHtmlOutput(aString);
        }

        private void writeToHtmlOutput(String aString) throws IOException {
            if (OutputMonitor.this.lastOutputType != this.type && OutputMonitor.this.lastOutputType != -1) {
                OutputMonitor.this.htmlOut.append("</pre></font>");
            }
            if (OutputMonitor.this.lastOutputType != this.type) {
                OutputMonitor.this.htmlOut.append("<font color='" + this.color[this.type] + "'><pre>");
            }
            OutputMonitor.this.htmlOut.append(aString);
            OutputMonitor.this.htmlOut.flush();
            OutputMonitor.this.lastOutputType = this.type;
            OutputMonitor.this.warnListeners(aString, this.type);
            if (OutputMonitor.this.bw != null) {
                OutputMonitor.this.bw.write(aString);
                OutputMonitor.this.bw.flush();
            }
        }
    }
}

