/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.util.output;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.ImageUtils;
import pt.lsts.neptus.util.output.OutputListener;
import pt.lsts.neptus.util.output.OutputMonitor;

public class OutputPanel
extends JPanel
implements OutputListener {
    private static final long serialVersionUID = -2153507983997000152L;
    private static DefaultStyledDocument doc = new DefaultStyledDocument();
    private static int MAX_CHARS = 500000;
    private MutableAttributeSet out = new SimpleAttributeSet();
    private MutableAttributeSet err;
    private MutableAttributeSet special;
    private JTextPane textPane;
    private static JFrame frame = null;
    private static OutputPanel instance = null;

    public static void showWindow() {
        if (frame != null) {
            frame.setVisible(true);
            frame.toFront();
        } else {
            frame = new JFrame("Neptus Output");
            frame.setIconImage(ImageUtils.getImage("images/neptus-icon.png"));
            frame.add(OutputPanel.getInstance());
            frame.setSize(400, 300);
            frame.setDefaultCloseOperation(1);
            GuiUtils.centerOnScreen(frame);
            frame.setVisible(true);
            frame.toFront();
        }
        OutputMonitor.addListener(OutputPanel.getInstance());
    }

    private OutputPanel() {
        StyleConstants.setForeground(this.out, Color.black);
        StyleConstants.setFontFamily(this.out, "Helvetica");
        this.err = new SimpleAttributeSet();
        StyleConstants.setForeground(this.err, Color.red);
        StyleConstants.setFontFamily(this.err, "Helvetica");
        this.special = new SimpleAttributeSet();
        StyleConstants.setForeground(this.special, Color.green);
        StyleConstants.setItalic(this.special, true);
        StyleConstants.setFontFamily(this.special, "Helvetica");
        this.setLayout(new BorderLayout());
        this.textPane = new JTextPane(doc);
        this.textPane.setEditable(false);
        this.add((Component)new JScrollPane(this.textPane), "Center");
        JButton clearBtn = new JButton("clear");
        clearBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    doc.remove(0, doc.getLength());
                }
                catch (BadLocationException locEx) {
                    NeptusLog.pub().error((Object)locEx);
                }
            }
        });
        this.add((Component)clearBtn, "South");
    }

    @Override
    public synchronized void addOut(String text) {
        try {
            doc.insertString(doc.getLength(), text, this.out);
            if (doc.getLength() > MAX_CHARS) {
                doc.remove(0, doc.getLength() - MAX_CHARS - 1);
            }
            this.textPane.setCaretPosition(doc.getLength() - 1);
        }
        catch (BadLocationException e) {
            NeptusLog.pub().error((Object)e);
        }
    }

    @Override
    public synchronized void addErr(String text) {
        try {
            doc.insertString(doc.getLength(), text, this.err);
            this.textPane.setCaretPosition(doc.getLength() - 1);
            if (doc.getLength() > MAX_CHARS) {
                doc.remove(0, doc.getLength() - MAX_CHARS - 1);
            }
        }
        catch (BadLocationException e) {
            NeptusLog.pub().error((Object)e);
        }
    }

    public static OutputPanel getInstance() {
        if (instance == null) {
            instance = new OutputPanel();
        }
        return instance;
    }
}

