/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.util.speech;

import com.sun.speech.freetts.jsapi.FreeTTSEngineCentral;
import java.util.LinkedList;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.speech.EngineCreate;
import javax.speech.EngineList;
import javax.speech.EngineModeDesc;
import javax.speech.EngineStateError;
import javax.speech.synthesis.Synthesizer;
import javax.speech.synthesis.SynthesizerModeDesc;
import javax.speech.synthesis.Voice;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.types.vehicle.VehiclesHolder;
import pt.lsts.neptus.util.conf.ConfigFetch;
import pt.lsts.neptus.util.conf.GeneralPreferences;
import pt.lsts.neptus.util.speech.SpeechUtilControl;

public class SpeechUtil {
    private static SpeechUtil speechUtil = null;
    public static boolean speechOn = false;
    private static LinkedList<String> textQueue = new LinkedList();
    private ReadProcessor readProcessor = new ReadProcessor();
    private Synthesizer synth;
    private static final SpeechUtilControl speechUtilControl = new SpeechUtilControl();
    Voice kevin = new Voice("kevin", 65535, 65535, null);
    Voice kevinHQ = new Voice("kevin16", 65535, 65535, null);

    private SpeechUtil() {
        try {
            SynthesizerModeDesc desc = new SynthesizerModeDesc(null, "general", Locale.US, Boolean.FALSE, null);
            FreeTTSEngineCentral central = new FreeTTSEngineCentral();
            EngineList list = central.createEngineList((EngineModeDesc)desc);
            if (list.size() > 0) {
                EngineCreate creator = (EngineCreate)list.get(0);
                this.synth = (Synthesizer)creator.createEngine();
            }
            if (this.synth == null) {
                System.err.println("Cannot create synthesizer");
                speechUtil = null;
                return;
            }
            this.synth.allocate();
            this.synth.resume();
            this.synth.getSynthesizerProperties().setVoice(this.kevinHQ);
            this.readProcessor.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        catch (Error e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeStringsFromQueue(String regexp) {
        Matcher m;
        String phrase;
        Pattern p = Pattern.compile(regexp);
        LinkedList<String> linkedList = textQueue;
        synchronized (linkedList) {
            for (int i = 0; i < textQueue.size(); ++i) {
                Matcher m2 = p.matcher(textQueue.get(i));
                if (!m2.matches()) continue;
                NeptusLog.pub().warn((Object)("removed " + textQueue.get(i) + " from speech syhthesis queue"));
                textQueue.remove(i);
                --i;
            }
        }
        if (speechUtil != null && (phrase = SpeechUtil.speechUtil.readProcessor.getCurrentPhrase()) != null && (m = p.matcher(SpeechUtil.speechUtil.readProcessor.getCurrentPhrase())).matches()) {
            SpeechUtil.stop();
            SpeechUtil.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean readSimpleText(String text) {
        SpeechUtil.start();
        if (speechUtil == null) {
            return false;
        }
        Object object = textQueue;
        synchronized (object) {
            if (!textQueue.contains(text)) {
                textQueue.add(text);
            }
        }
        object = SpeechUtil.speechUtil.readProcessor;
        synchronized (object) {
            SpeechUtil.speechUtil.readProcessor.notify();
        }
        return true;
    }

    public static synchronized void start() {
        if (!speechOn) {
            return;
        }
        if (speechUtil == null) {
            speechUtil = new SpeechUtil();
        }
    }

    public static synchronized void stop() {
        if (speechUtil == null) {
            return;
        }
        try {
            SpeechUtil.speechUtil.synth.deallocate();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        SpeechUtil.speechUtil.readProcessor.stopProcessing();
        speechUtil = null;
        textQueue.clear();
    }

    private synchronized void readText(String text) {
        try {
            this.synth.speakPlainText(text, null);
        }
        catch (EngineStateError e1) {
            // empty catch block
        }
        try {
            this.synth.waitEngineState(65536L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void main(String[] args) throws InterruptedException {
        speechOn = true;
        ConfigFetch.initialize();
        String[] vehicles = VehiclesHolder.getVehiclesArray();
        for (int i = vehicles.length - 1; i >= 0; --i) {
            NeptusLog.pub().info((Object)("<###> " + vehicles[i]));
            SpeechUtil.readSimpleText(vehicles[i] + "is ready");
        }
    }

    static {
        speechOn = GeneralPreferences.speechOn;
        GeneralPreferences.addPreferencesListener(speechUtilControl);
    }

    private final class ReadProcessor
    extends Thread {
        private boolean running;
        protected String text;

        public ReadProcessor() {
            super("MessageProcessor");
            this.running = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stopProcessing() {
            this.running = false;
            ReadProcessor readProcessor = this;
            synchronized (readProcessor) {
                this.notify();
            }
        }

        public String getCurrentPhrase() {
            return this.text;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (this.running) {
                try {
                    LinkedList linkedList = textQueue;
                    synchronized (linkedList) {
                        this.text = (String)textQueue.remove();
                    }
                    try {
                        SpeechUtil.this.readText(this.text);
                    }
                    catch (Exception e) {
                        NeptusLog.pub().error((Object)(this + " error on child processing method"), (Throwable)e);
                    }
                }
                catch (NoSuchElementException e1) {
                    ReadProcessor readProcessor = this;
                    synchronized (readProcessor) {
                        try {
                            this.wait();
                        }
                        catch (Exception e) {
                            NeptusLog.pub().warn((Object)this, (Throwable)e);
                        }
                    }
                }
            }
        }
    }
}

