/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.util.xsl;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import pt.lsts.neptus.NeptusLog;

public class TransformDocument {
    protected boolean _setDebug = false;
    public short OK = 0;
    public short FATAL_ERROR = (short)3;
    public short ERROR = (short)2;
    public short WARNING = 1;
    public short transformationResult = this.OK;
    public String transformationMessage = "";
    public ByteArrayOutputStream outputMsg = new ByteArrayOutputStream();

    public boolean doTransformation(Source xmlSource, Source xslSheet, Result xmlResult, Hashtable<String, String> styleSheetParam) {
        this.outputMsg.reset();
        this.transformationResult = this.OK;
        this.transformationMessage = "";
        Date data = new Date();
        this.outwrite("\nTransformation ini at " + data.toString() + "\n");
        if (xmlSource == null || xmlResult == null) {
            this.outwrite("==NOTE== Notting to transform (bad command)!");
            return false;
        }
        if (styleSheetParam == null) {
            styleSheetParam = new Hashtable();
        }
        try {
            Transformer transformer;
            TransformerFactory tfactory = TransformerFactory.newInstance();
            try {
                transformer = tfactory.newTransformer(xslSheet);
            }
            catch (NullPointerException e) {
                try {
                    Source embedxsl = tfactory.getAssociatedStylesheet(xmlSource, null, null, null);
                    transformer = tfactory.newTransformer(embedxsl);
                }
                catch (TransformerConfigurationException e1) {
                    this.outwrite("==ERRO== " + e.getMessage() + "\n javax.xml.transform.TransformerConfigurationException" + e1.getMessage());
                    return false;
                }
            }
            transformer.setErrorListener(new ErrorListener(){

                @Override
                public void error(TransformerException exception) throws TransformerException {
                    TransformDocument.this.transformationResult = TransformDocument.this.ERROR;
                    TransformDocument.this.transformationMessage = TransformDocument.this.transformationMessage + "\nERROR: " + exception.getMessageAndLocation();
                }

                @Override
                public void fatalError(TransformerException exception) throws TransformerException {
                    TransformDocument.this.transformationResult = TransformDocument.this.FATAL_ERROR;
                    TransformDocument.this.transformationMessage = TransformDocument.this.transformationMessage + "\nFATAL_ERROR: " + exception.getMessageAndLocation();
                }

                @Override
                public void warning(TransformerException exception) throws TransformerException {
                    TransformDocument.this.transformationResult = TransformDocument.this.WARNING;
                    TransformDocument.this.transformationMessage = TransformDocument.this.transformationMessage + "\nWARNING: " + exception.getMessageAndLocation();
                }
            });
            this.outwrite("     > Number of parameters = " + styleSheetParam.size() + "\n");
            if (!styleSheetParam.isEmpty()) {
                Enumeration<String> keys = styleSheetParam.keys();
                Enumeration<String> elements = styleSheetParam.elements();
                try {
                    while (elements.hasMoreElements()) {
                        String pa1 = keys.nextElement();
                        String pa2 = elements.nextElement();
                        transformer.setParameter(pa1, pa2);
                        this.outwrite("            Key: " + pa1.toString() + "\n              Elem: " + pa2.toString() + "\n");
                    }
                }
                catch (NoSuchElementException e) {
                    // empty catch block
                }
            }
            transformer.transform(xmlSource, xmlResult);
            data = new Date();
            this.outwrite("     > Transformation (<text/xml> into <" + transformer.getOutputProperty("media-type") + ">) out ok at\n            " + data.toString() + "\n");
            return this.transformationResult <= this.WARNING;
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
            this.outwrite("==ERRO== javax.xml.transform.TransformerConfigurationException" + e.getMessage());
            return false;
        }
        catch (TransformerException e) {
            this.outwrite("==ERRO== javax.xml.transform.TransformerException" + e.getMessage());
            return false;
        }
        catch (Exception e) {
            this.outwrite("==ERRO== java.lang.Exception" + e.getMessage());
            return false;
        }
    }

    public boolean doTransformation(Source xmlSource, Result xmlResult, Hashtable<String, String> styleSheetParam) {
        return this.doTransformation(xmlSource, null, xmlResult, styleSheetParam);
    }

    public boolean doTransformation(Source xmlSource, Result xmlResult) {
        return this.doTransformation(xmlSource, null, xmlResult, null);
    }

    public boolean doTransformation(Source xmlSource, Source xslSheet, Result xmlResult) {
        return this.doTransformation(xmlSource, xslSheet, xmlResult, null);
    }

    public void setDebug(boolean setDebug) {
        this._setDebug = setDebug;
    }

    private void outwrite(String st) {
        try {
            this.outputMsg.write(st.getBytes());
            this.outputMsg.flush();
        }
        catch (IOException e) {
            // empty catch block
        }
        if (this._setDebug) {
            try {
                OutputStreamWriter out = new OutputStreamWriter(System.err);
                out.write(st);
                ((Writer)out).flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public StreamSource createStreamSource(File f) {
        return new StreamSource(f);
    }

    public StreamSource createStreamSource(InputStream inputStream) {
        return new StreamSource(inputStream);
    }

    public StreamSource createStreamSource(InputStream inputStream, String systemId) {
        return new StreamSource(inputStream, systemId);
    }

    public StreamSource createStreamSource(Reader reader) {
        return new StreamSource(reader);
    }

    public StreamSource createStreamSource(Reader reader, String systemId) {
        return new StreamSource(reader, systemId);
    }

    public StreamSource createStreamSource(String systemId) {
        return new StreamSource(systemId);
    }

    public StreamResult createStreamResult(File f) {
        return new StreamResult(f);
    }

    public StreamResult createStreamResult(OutputStream outputStream) {
        return new StreamResult(outputStream);
    }

    public StreamResult createStreamResult(Writer writer) {
        return new StreamResult(writer);
    }

    public StreamResult createStreamResult(String systemId) {
        return new StreamResult(systemId);
    }

    public static void main(String[] args) throws IOException, MalformedURLException {
        StreamResult out;
        StreamSource xsl;
        StreamSource in;
        NeptusLog.pub().info((Object)"<###>\n-- Start Processing ----------------\n");
        System.out.flush();
        if (args.length < 1) {
            TransformDocument.printArgOptions();
            NeptusLog.pub().info((Object)"<###>\n   Tranformation done: false");
            NeptusLog.pub().info((Object)"<###>\n-- End Processing ------------------");
            System.out.flush();
            return;
        }
        String inFileName = "";
        String xslFileName = "";
        String outFileName = "";
        Hashtable<String, String> styleSheetParam = new Hashtable<String, String>();
        TransformDocument processor = new TransformDocument();
        processor.setDebug(true);
        for (int i = 0; i < args.length; ++i) {
            if ("-IN".equalsIgnoreCase(args[i])) {
                if (i + 1 < args.length) {
                    inFileName = args[++i];
                    continue;
                }
                System.err.println("ER_MISSING_ARG_FOR_OPTION {\"-IN\"}");
                continue;
            }
            if ("-OUT".equalsIgnoreCase(args[i])) {
                if (i + 1 < args.length) {
                    outFileName = args[++i];
                    continue;
                }
                System.err.println("ER_MISSING_ARG_FOR_OPTION, new Object[] {\"-OUT\"}");
                continue;
            }
            if ("-XSL".equalsIgnoreCase(args[i])) {
                if (i + 1 < args.length) {
                    xslFileName = args[++i];
                    continue;
                }
                System.err.println("ER_MISSING_ARG_FOR_OPTION, new Object[] {\"-XSL\"}");
                continue;
            }
            if (!"-PARAM".equalsIgnoreCase(args[i])) continue;
            if (i + 2 < args.length) {
                String name = args[++i];
                String expression = args[++i];
                styleSheetParam.put(name, expression);
                continue;
            }
            System.err.println("ER_MISSING_ARG_FOR_OPTION, new Object[] {\"-PARAM\"}");
        }
        if (inFileName.compareTo("") != 0) {
            in = new StreamSource(inFileName);
            xsl = xslFileName.compareTo("") != 0 ? new StreamSource(new File(xslFileName)) : null;
            if (outFileName.compareTo("") != 0) {
                FileOutputStream fx = new FileOutputStream(new File(outFileName));
                out = new StreamResult(fx);
            } else {
                out = new StreamResult(System.out);
            }
        } else {
            TransformDocument.printArgOptions();
            NeptusLog.pub().info((Object)"<###>\n   Tranformation done: false");
            NeptusLog.pub().info((Object)"<###>\n-- End Processing ------------------");
            System.out.flush();
            return;
        }
        boolean bl = processor.doTransformation(in, xsl, out, styleSheetParam);
        NeptusLog.pub().info((Object)("<###>\n   Tranformation done: " + bl));
        NeptusLog.pub().info((Object)("<###>\n   " + processor.transformationMessage));
        NeptusLog.pub().info((Object)"<###>\n-- End Processing ------------------");
        System.out.flush();
    }

    protected static void printArgOptions() {
        NeptusLog.pub().info((Object)"<###>xslproc options: ");
        NeptusLog.pub().info((Object)"<###>    -IN inputXMLURL");
        NeptusLog.pub().info((Object)"<###>   [-XSL XSLTransformationURL]");
        NeptusLog.pub().info((Object)"<###>   [-OUT outputFileName]");
        NeptusLog.pub().info((Object)"<###>   [-PARAM name expression (Set a stylesheet parameter)]");
        System.out.flush();
    }
}

