/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.util.xsl;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.apps.Fop;
import org.apache.fop.apps.FopFactory;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.util.conf.ConfigFetch;

public class TransformFOP {
    public static boolean convertXML2PDF(String xml, String xslt, String pdf) {
        File xmlFx = new File(xml);
        File xsltFx = new File(xslt);
        File pdfFx = new File(pdf);
        return TransformFOP.convertXML2PDF(xmlFx, xsltFx, pdfFx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean convertXML2PDF(File xml, File xslt, File pdf) {
        FopFactory fopFactory = FopFactory.newInstance();
        FOUserAgent foUserAgent = fopFactory.newFOUserAgent();
        foUserAgent.setAuthor("Neptus " + ConfigFetch.getVersionSimpleString());
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(pdf);
        }
        catch (FileNotFoundException e3) {
            e3.printStackTrace();
            return false;
        }
        try {
            Fop fop = fopFactory.newFop("application/pdf", foUserAgent, (OutputStream)out);
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer(new StreamSource(xslt));
            StreamSource src = new StreamSource(xml);
            SAXResult res = new SAXResult(fop.getDefaultHandler());
            transformer.transform(src, res);
        }
        catch (IllegalArgumentException e2) {
            e2.printStackTrace();
            boolean bl = false;
            return bl;
        }
        catch (TransformerException e) {
            boolean bl = false;
            return bl;
        }
        catch (FOPException e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                ((OutputStream)out).close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    public static void main(String[] args) {
        try {
            NeptusLog.pub().info((Object)"<###>FOP ExampleXML2PDF\n");
            NeptusLog.pub().info((Object)"<###>Preparing...");
            File baseDir = new File(".");
            File outDir = new File(baseDir, "out");
            outDir.mkdirs();
            File xmlfile = new File("checklists/rov-checklist.xml");
            File xsltfile = new File("conf/checklist-fo.xsl");
            File pdffile = new File("checklists/teste.pdf");
            NeptusLog.pub().info((Object)("<###>Input: XML (" + xmlfile + ")"));
            NeptusLog.pub().info((Object)("<###>Stylesheet: " + xsltfile));
            NeptusLog.pub().info((Object)("<###>Output: PDF (" + pdffile + ")"));
            NeptusLog.pub().info((Object)"<###>Transforming...");
            TransformFOP.convertXML2PDF(xmlfile, xsltfile, pdffile);
            NeptusLog.pub().info((Object)"<###>Success!");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }
}

