/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.util.xsl.xalan;

import java.text.NumberFormat;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.io.DOMReader;
import org.dom4j.io.DOMWriter;
import org.w3c.dom.Node;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.types.coord.CoordinateUtil;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.MathMiscUtils;

public class CoordinateUtilForXalan {
    private static NumberFormat nf6 = GuiUtils.getNeptusDecimalFormat(6);

    private static double[] getCylOffsetsSum(String offsetDistance, String azimuth, String zenith, String offsetNorth, String offsetSouth, String offsetEast, String offsetWest, String offsetUp, String offsetDown) {
        if (offsetDistance.equals("")) {
            offsetDistance = "0";
        }
        if (azimuth.equals("")) {
            azimuth = "0";
        }
        if (zenith.equals("")) {
            zenith = "0";
        }
        if (offsetNorth.equals("")) {
            offsetNorth = "0";
        }
        if (offsetSouth.equals("")) {
            offsetSouth = "0";
        }
        if (offsetEast.equals("")) {
            offsetEast = "0";
        }
        if (offsetWest.equals("")) {
            offsetWest = "0";
        }
        if (offsetUp.equals("")) {
            offsetUp = "0";
        }
        if (offsetDown.equals("")) {
            offsetDown = "0";
        }
        double r = Double.parseDouble(offsetDistance);
        double theta = Double.parseDouble(azimuth);
        double phi = Double.parseDouble(zenith);
        double x = Double.parseDouble(offsetNorth) - Double.parseDouble(offsetSouth);
        double y = Double.parseDouble(offsetEast) - Double.parseDouble(offsetWest);
        double z = -Double.parseDouble(offsetUp) + Double.parseDouble(offsetDown);
        double[] cyl = CoordinateUtil.addSphericalToCartesianOffsetsAndGetAsCylindrical(r, theta, phi, x, y, z);
        return cyl;
    }

    public static String getRCylOffsetsSumAsString(String offsetDistance, String azimuth, String zenith, String offsetNorth, String offsetSouth, String offsetEast, String offsetWest, String offsetUp, String offsetDown) {
        double[] cyl = CoordinateUtilForXalan.getCylOffsetsSum(offsetDistance, azimuth, zenith, offsetNorth, offsetSouth, offsetEast, offsetWest, offsetUp, offsetDown);
        double tmp = MathMiscUtils.round(cyl[0], 3);
        return Double.toString(tmp);
    }

    public static String getThetaCylOffsetsSumAsString(String offsetDistance, String azimuth, String zenith, String offsetNorth, String offsetSouth, String offsetEast, String offsetWest, String offsetUp, String offsetDown) {
        double[] cyl = CoordinateUtilForXalan.getCylOffsetsSum(offsetDistance, azimuth, zenith, offsetNorth, offsetSouth, offsetEast, offsetWest, offsetUp, offsetDown);
        double tmp = MathMiscUtils.round(Math.toDegrees(cyl[1]), 3);
        return Double.toString(tmp);
    }

    public static String getHeightCylOffsetsSumAsString(String offsetDistance, String azimuth, String zenith, String offsetNorth, String offsetSouth, String offsetEast, String offsetWest, String offsetUp, String offsetDown) {
        double[] cyl = CoordinateUtilForXalan.getCylOffsetsSum(offsetDistance, azimuth, zenith, offsetNorth, offsetSouth, offsetEast, offsetWest, offsetUp, offsetDown);
        double tmp = MathMiscUtils.round(cyl[2], 3);
        return Double.toString(tmp);
    }

    public static String add(String param1, String param2) {
        if (param1.equals("")) {
            param1 = "0";
        }
        if (param2.equals("")) {
            param2 = "0";
        }
        double res = Double.parseDouble(param1) + Double.parseDouble(param2);
        return Double.toString(res);
    }

    public static void printVector(String header, double[] vec) {
        String res = header.concat(": ");
        for (int i = 0; i < vec.length; ++i) {
            res = res + " # " + vec[i];
        }
        NeptusLog.pub().info((Object)("<###> " + res));
    }

    public static Node getMiddlePoint(Node p1, Node p2) {
        return p1;
    }

    public static Node getLatLonDepthABS(Node point) throws Exception {
        if (point == null) {
            throw new Exception("Missing point!");
        }
        try {
            org.w3c.dom.Document doc = new DOMWriter().write(DocumentHelper.createDocument());
            doc.appendChild(doc.importNode(point, true));
            Document p1DOM4J = new DOMReader().read(doc);
            Object absLoc = new LocationType(p1DOM4J.asXML()).getNewAbsoluteLatLonDepth();
            ((LocationType)absLoc).setLatitudeStr(nf6.format(((LocationType)absLoc).getLatitudeDegs()));
            ((LocationType)absLoc).setLongitudeStr(nf6.format(((LocationType)absLoc).getLongitudeDegs()));
            Document mdDOM4J = ((LocationType)absLoc).asDocument();
            doc = new DOMWriter().write(mdDOM4J);
            return doc.getDocumentElement();
        }
        catch (DocumentException e) {
            e.printStackTrace();
            return point;
        }
    }
}

