/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.util.xsl.xalan;

import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.io.DOMReader;
import org.dom4j.io.DOMWriter;
import org.w3c.dom.Node;
import pt.lsts.neptus.types.coord.LocationType;

public class DiffFromForXalan {
    private Node refPoint;

    public void setRefPoint(Node refPoint) {
        this.refPoint = refPoint;
    }

    public Node getDiffPoint(Node point) throws Exception {
        if (this.refPoint == null) {
            throw new Exception("Missing reference point!");
        }
        if (point == null) {
            throw new Exception("Missing point!");
        }
        try {
            org.w3c.dom.Document doc = new DOMWriter().write(DocumentHelper.createDocument());
            doc.appendChild(doc.importNode(this.refPoint, true));
            Document refPointDOM4J = new DOMReader().read(doc);
            doc = new DOMWriter().write(DocumentHelper.createDocument());
            doc.appendChild(doc.importNode(point, true));
            Document pointDOM4J = new DOMReader().read(doc);
            LocationType refPointLoc = new LocationType(refPointDOM4J.asXML());
            LocationType pointLoc = new LocationType(pointDOM4J.asXML());
            double[] dists = pointLoc.getOffsetFrom(refPointLoc);
            Object mdLoc = refPointLoc.getNewAbsoluteLatLonDepth();
            Object ptLoc = pointLoc.getNewAbsoluteLatLonDepth();
            ((LocationType)mdLoc).setOffsetNorth(dists[0]);
            ((LocationType)mdLoc).setOffsetEast(dists[1]);
            ((LocationType)mdLoc).setOffsetDown(((LocationType)ptLoc).getDepth());
            Document mdDOM4J = ((LocationType)mdLoc).asDocument();
            doc = new DOMWriter().write(mdDOM4J);
            return doc.getDocumentElement();
        }
        catch (DocumentException e) {
            e.printStackTrace();
            return this.refPoint;
        }
    }
}

