/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.util.xsl.xalan;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.transform.TransformerException;
import org.apache.xalan.extensions.ExpressionContext;
import org.apache.xalan.extensions.XSLProcessorContext;
import org.apache.xalan.templates.ElemExtensionCall;
import org.apache.xml.dtm.DTM;
import org.apache.xpath.XPathContext;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.util.FileUtil;

public class FileUtilForXalan {
    protected static String uriBase = ".";
    protected static String uriXML = ".";
    protected static String uriXSL = ".";
    protected static String fxSep = System.getProperty("file.separator", "/");

    public void init(XSLProcessorContext context, ElemExtensionCall extensionElement) throws TransformerException {
        uriXML = context.getTransformer().getBaseURLOfSource();
        try {
            new URI(uriXML);
        }
        catch (Exception e) {
            uriXML = new File(uriXML).toURI().toASCIIString();
        }
        uriXSL = context.getStylesheet().getHref();
        try {
            new URI(uriXSL);
        }
        catch (Exception e) {
            uriXSL = new File(uriXSL).toURI().toString();
        }
        String sysId = extensionElement.getSystemId();
        try {
            new URI(sysId);
        }
        catch (Exception e) {
            sysId = new File(sysId).toURI().toString();
        }
        uriBase = sysId;
    }

    public String getFileAsString(ExpressionContext expContext, String url) {
        String urlG = url;
        String uriCSrc = "";
        NeptusLog.pub().info((Object)"<###>url---".concat(url));
        NeptusLog.pub().info((Object)"<###>uriBase---".concat(uriBase));
        NeptusLog.pub().info((Object)"<###>uriXML---".concat(uriXML));
        NeptusLog.pub().info((Object)"<###>uriXSL---".concat(uriXSL));
        try {
            XPathContext xctxt = expContext.getXPathContext();
            uriCSrc = this.getCurrentSrcDocLocation(xctxt);
            try {
                new URI(uriCSrc);
            }
            catch (Exception e) {
                uriCSrc = new File(uriCSrc).toURI().toString();
            }
        }
        catch (TransformerException e1) {
            NeptusLog.pub().error((Object)this, (Throwable)e1);
        }
        NeptusLog.pub().info((Object)"<###>uriCSrc---".concat(uriCSrc));
        if (!new File(url).isAbsolute()) {
            try {
                URI uriB = new URI(uriBase);
                urlG = new File(uriB.resolve(url)).getAbsolutePath();
                if (!(new File(urlG).exists() || new File(urlG = new File((uriB = new URI(uriXML)).resolve(url)).getAbsolutePath()).exists() || new File(urlG = new File((uriB = new URI(uriCSrc)).resolve(url)).getAbsolutePath()).exists() || new File(urlG = new File((uriB = new URI(uriXSL)).resolve(url)).getAbsolutePath()).exists())) {
                    return urlG;
                }
            }
            catch (URISyntaxException e) {
                NeptusLog.pub().error((Object)this, (Throwable)e);
                return urlG;
            }
        }
        String res = FileUtil.getFileAsString(urlG);
        res = res.replaceAll("\r", "");
        return res;
    }

    protected String getCurrentSrcDocLocation(XPathContext xctxt) {
        String fileLocation = null;
        int whereNode = xctxt.getCurrentNode();
        fileLocation = null;
        if (-1 != whereNode) {
            DTM dtm = xctxt.getDTM(whereNode);
            if (11 == dtm.getNodeType(whereNode)) {
                whereNode = dtm.getFirstChild(whereNode);
            }
            if (-1 != whereNode) {
                fileLocation = dtm.getDocumentBaseURI();
            }
        }
        return null != fileLocation ? fileLocation : "";
    }

    public void getString(ExpressionContext expContext, String str) {
        NeptusLog.pub().info((Object)"<###>->>>> ".concat(str));
    }
}

