/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.util.xsl.xalan;

import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.io.DOMReader;
import org.dom4j.io.DOMWriter;
import org.w3c.dom.Node;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.util.AngleCalc;

public class PointsUtilForXalan {
    private Node p1;
    private Node p2;

    public void setPoint1(Node p1) {
        this.p1 = p1;
    }

    public void setPoint2(Node p2) {
        this.p2 = p2;
    }

    public Node getMiddlePoint(String name) throws Exception {
        int maxDive = 20;
        if (this.p1 == null) {
            throw new Exception("Missing start point!");
        }
        if (this.p2 == null) {
            throw new Exception("Missing end point!");
        }
        try {
            org.w3c.dom.Document doc = new DOMWriter().write(DocumentHelper.createDocument());
            doc.appendChild(doc.importNode(this.p1, true));
            Document p1DOM4J = new DOMReader().read(doc);
            doc = new DOMWriter().write(DocumentHelper.createDocument());
            doc.appendChild(doc.importNode(this.p2, true));
            Document p2DOM4J = new DOMReader().read(doc);
            LocationType p1Loc = new LocationType(p1DOM4J.asXML());
            LocationType p2Loc = new LocationType(p2DOM4J.asXML());
            double[] dists = p2Loc.getOffsetFrom(p1Loc);
            LocationType mdLoc = new LocationType(p1Loc);
            mdLoc.setId(name);
            mdLoc.setName(name);
            double x = 0.0;
            double y = 0.0;
            double z = 0.0;
            double d = 0.0;
            x = dists[0] / 2.0;
            y = dists[1] / 2.0;
            z = dists[2] / 2.0;
            d = x * x + y * y + z * z;
            if (d > 20.0) {
                double angXY = AngleCalc.calcAngle(0.0, 0.0, x, y);
                double angXZ = AngleCalc.calcAngle(0.0, 0.0, x, z);
                d = 20.0;
                x = d * Math.sin(angXY);
                y = d * Math.cos(angXY);
                z = d * Math.cos(angXZ);
            }
            mdLoc.setOffsetNorth(mdLoc.getOffsetNorth() + x);
            mdLoc.setOffsetEast(mdLoc.getOffsetEast() + y);
            mdLoc.setOffsetDown(mdLoc.getOffsetDown() + z);
            Document mdDOM4J = mdLoc.asDocument();
            doc = new DOMWriter().write(mdDOM4J);
            return doc.getDocumentElement();
        }
        catch (DocumentException e) {
            e.printStackTrace();
            return this.p2;
        }
    }
}

