/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.viewer3d;

import com.mnstarfire.loaders3d.Inspector3DS;
import com.sun.j3d.loaders.Scene;
import com.sun.j3d.utils.scenegraph.io.SceneGraphFileReader;
import com.sun.j3d.utils.scenegraph.io.SceneGraphFileWriter;
import com.sun.j3d.utils.scenegraph.io.UnsupportedUniverseException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Group;
import javax.media.j3d.Node;
import javax.media.j3d.TransformGroup;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import org.web3d.j3d.loaders.VRML97Loader;
import org.web3d.j3d.loaders.X3DLoader;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.gui.WaitPanel;
import pt.lsts.neptus.gui.swing.NeptusFileView;
import pt.lsts.neptus.renderer3d.Camera3D;
import pt.lsts.neptus.renderer3d.Obj3D;
import pt.lsts.neptus.renderer3d.Renderer3D;
import pt.lsts.neptus.renderer3d.Util3D;
import pt.lsts.neptus.util.FileUtil;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.ImageUtils;
import pt.lsts.neptus.util.RecentlyOpenedFilesUtil;
import pt.lsts.neptus.util.X3dParse;
import pt.lsts.neptus.util.conf.ConfigFetch;

public class Viewer3D
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 8461400298712596459L;
    private JMenuBar menu = new JMenuBar();
    private Renderer3D render;
    private LinkedHashMap<JMenuItem, File> miscFilesOpened = new LinkedHashMap();
    private JMenu recentlyOpenFilesMenu = null;
    public static final String RECENTLY_OPENED_3D = "conf/3d_recent.xml";
    private File openedFile = null;
    JFrame frame = null;
    Obj3D lobj = null;
    Thread t;
    String saveFile = null;

    public Viewer3D() {
        this.init();
        this.loadRecentlyOpenedFiles();
        this.show();
    }

    public Viewer3D(TransformGroup obj) {
        this.init();
        Obj3D obj3d = new Obj3D();
        obj3d.setModel3D(obj);
        this.render.addObj3D(obj3d);
        this.doLayout();
        this.repaint();
        this.setVisible(true);
    }

    private void init() {
        final WaitPanel wait = new WaitPanel();
        wait.start();
        GuiUtils.setLookAndFeel();
        this.t = new Thread(){

            @Override
            public void run() {
                Viewer3D.this.createMenuBar();
                Viewer3D.this.createRender();
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        Viewer3D.this.setLayout(new BorderLayout());
                        Viewer3D.this.add((Component)Viewer3D.this.menu, "North");
                        Viewer3D.this.add((Component)Viewer3D.this.render, "Center");
                        wait.stop();
                    }
                };
                SwingUtilities.invokeLater(r);
            }
        };
        this.createMenuBar();
        this.createRender();
        this.setLayout(new BorderLayout());
        this.add((Component)this.menu, "North");
        this.add((Component)this.render, "Center");
        wait.stop();
    }

    public boolean disableMenuBar() {
        this.remove(this.menu);
        return true;
    }

    @Override
    public void show() {
        this.prepareFrame();
        this.frame.getContentPane().add(this);
        this.frame.setVisible(true);
    }

    protected void prepareFrame() {
        if (this.frame == null) {
            this.frame = new JFrame("Neptus 3D Viewer");
            this.frame.setSize(800, 600);
            this.frame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent arg0) {
                }
            });
            this.frame.setTitle("Neptus 3D Viewer");
            this.frame.setIconImages(ConfigFetch.getIconImagesForFrames());
            this.frame.setDefaultCloseOperation(2);
        }
    }

    public JFrame getFrame() {
        if (this.frame == null) {
            this.prepareFrame();
        }
        return this.frame;
    }

    public void createMenuBar() {
        JMenu file = new JMenu();
        file.getPopupMenu().setLightWeightPopupEnabled(false);
        file.setText("File");
        JMenuItem open = new JMenuItem("Open", new ImageIcon(ImageUtils.getImage("images/menus/open.png")));
        open.setText("Open");
        open.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Viewer3D.this.openFile();
            }
        });
        JMenuItem saveas = new JMenuItem("Save as", new ImageIcon(ImageUtils.getImage("images/menus/saveas.png")));
        saveas.setText("Save as");
        saveas.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Viewer3D.this.saveAsFile();
            }
        });
        JMenuItem quit = new JMenuItem("Quit", new ImageIcon(ImageUtils.getImage("images/menus/exit.png")));
        quit.setText("Quit");
        quit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Viewer3D.this.setVisible(false);
                if (Viewer3D.this.frame != null) {
                    Viewer3D.this.frame.dispose();
                }
            }
        });
        file.add(this.getRecentlyOpenFilesMenu());
        file.add(open);
        file.add(saveas);
        file.addSeparator();
        file.add(quit);
        this.menu.add(file);
    }

    public void createRender() {
        Camera3D cam = new Camera3D(3);
        cam.setRho(60.0);
        Camera3D[] cams = new Camera3D[]{cam};
        this.render = new Renderer3D(cams, 1, 1);
        this.render.setMode(1);
        this.render.grid(true, true);
        this.render.infoAxis(true);
        this.render.infoCam(true);
        this.render.setViewMode(3);
        this.render.showAxis(true);
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
    }

    public File showOpenImageDialog() {
        File fx;
        JFileChooser jfc = new JFileChooser();
        if (this.openedFile != null && this.openedFile.exists()) {
            fx = this.openedFile;
        } else {
            fx = new File(ConfigFetch.getConfigFile());
            if (!fx.exists() && !(fx = new File(ConfigFetch.resolvePath("."))).exists()) {
                fx = new File(".");
            }
        }
        jfc.setCurrentDirectory(fx);
        jfc.setFileView(new NeptusFileView());
        jfc.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                String extension = FileUtil.getFileExtension(f).toLowerCase();
                if (extension != null) {
                    return extension.equals("j3d") || extension.equals("3ds") || extension.equals("x3d") || extension.equals("wrl");
                }
                return false;
            }

            @Override
            public String getDescription() {
                return "3D model files ('j3d', '3ds', 'x3d', 'wrl')";
            }
        });
        int result = jfc.showDialog(this, "Open 3D File");
        if (result == 1) {
            return null;
        }
        return jfc.getSelectedFile();
    }

    public File showSaveImageDialog() {
        File fx;
        JFileChooser jfc = new JFileChooser();
        if (this.openedFile != null && this.openedFile.exists()) {
            fx = this.openedFile;
        } else {
            fx = new File(ConfigFetch.getConfigFile());
            if (!fx.exists() && !(fx = new File(ConfigFetch.resolvePath("."))).exists()) {
                fx = new File(".");
            }
        }
        if (this.openedFile != null) {
            String fxS = FileUtil.replaceFileExtension(this.openedFile.getName(), "j3d");
            jfc.setSelectedFile(new File(this.openedFile.getParentFile(), fxS));
        }
        jfc.setCurrentDirectory(fx);
        jfc.setFileView(new NeptusFileView());
        jfc.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                String extension = FileUtil.getFileExtension(f);
                if (extension != null) {
                    return extension.equals("j3d");
                }
                return false;
            }

            @Override
            public String getDescription() {
                return "Java 3D files ('j3d')";
            }
        });
        int result = jfc.showDialog(this, "Save File");
        if (result == 1) {
            return null;
        }
        return jfc.getSelectedFile();
    }

    public TransformGroup load(File xml) {
        NeptusLog.pub().info((Object)(this + " Load file: " + xml.getAbsoluteFile()));
        X3dParse parse = new X3dParse();
        parse.setFileX3d(xml.getAbsolutePath().toString());
        try {
            return parse.parse();
        }
        catch (Exception e) {
            NeptusLog.pub().error((Object)(" Viewer3D parse file error [" + e.getStackTrace() + "]"));
            return null;
        }
    }

    public void saveAsFile() {
        TransformGroup themodel = this.lobj.getModel3D();
        File file = this.showSaveImageDialog();
        if (file != null) {
            BranchGroup scene = new BranchGroup();
            this.render.removeObj3D(this.lobj);
            Enumeration enume = themodel.getAllChildren();
            while (enume.hasMoreElements()) {
                Group next = (Group)enume.nextElement();
                themodel.removeChild((Node)next);
                scene.addChild((Node)next);
            }
            try {
                SceneGraphFileWriter filew = new SceneGraphFileWriter(file, null, false, "genereted by Neptus", null);
                filew.writeBranchGraph(scene);
                System.err.println("vehicle w:" + file.getPath() + "\n");
                filew.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (UnsupportedUniverseException e) {
                e.printStackTrace();
            }
            TransformGroup themodel2 = new TransformGroup();
            enume = scene.getAllChildren();
            while (enume.hasMoreElements()) {
                Group next = (Group)enume.nextElement();
                scene.removeChild((Node)next);
                themodel2.addChild((Node)next);
            }
            this.lobj = new Obj3D();
            this.lobj.setModel3D(themodel2);
            this.render.addObj3D(this.lobj);
        }
    }

    public void openFile() {
        this.openFile(null);
    }

    public void openFile(File fx) {
        this.saveFile = null;
        File file = fx == null ? this.showOpenImageDialog() : fx;
        if (file != null) {
            if ("3ds".equalsIgnoreCase(FileUtil.getFileExtension(file))) {
                if (this.lobj != null) {
                    this.render.removeObj3D(this.lobj);
                }
                Inspector3DS loader = new Inspector3DS(file.getAbsolutePath());
                loader.parseIt();
                TransformGroup theModel1 = loader.getModel();
                NeptusLog.waste().info((Object)("Point to view window " + Util3D.getModelDim(theModel1)));
                this.lobj = new Obj3D();
                this.lobj.setModel3D(theModel1);
                this.render.addObj3D(this.lobj);
                this.update3dFilesOpened(file);
            } else if ("wrl".equalsIgnoreCase(FileUtil.getFileExtension(file))) {
                if (this.lobj != null) {
                    this.render.removeObj3D(this.lobj);
                }
                VRML97Loader myFileLoader = null;
                Scene myVRMLScene = null;
                BranchGroup myVRMLModel = null;
                try {
                    myFileLoader = new VRML97Loader();
                    myFileLoader.setBasePath(file.getParent());
                    myFileLoader.setFlags(myFileLoader.getFlags() | 8);
                    myVRMLScene = myFileLoader.load(file.getAbsolutePath());
                    myVRMLModel = myVRMLScene.getSceneGroup();
                    this.lobj = new Obj3D();
                    TransformGroup scene = new TransformGroup();
                    Enumeration enume = myVRMLModel.getAllChildren();
                    while (enume.hasMoreElements()) {
                        Node next = (Node)enume.nextElement();
                        myVRMLModel.removeChild(next);
                        scene.addChild(next);
                    }
                    this.lobj.setModel3D(scene);
                    this.render.addObj3D(this.lobj);
                    this.update3dFilesOpened(file);
                    System.err.println("fez o load----------");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    GuiUtils.errorMessage(this, "Load", "Error Loading WRL File");
                }
            } else if ("x3d".equalsIgnoreCase(FileUtil.getFileExtension(file)) || "x3dv".equalsIgnoreCase(FileUtil.getFileExtension(file))) {
                if (this.lobj != null) {
                    this.render.removeObj3D(this.lobj);
                }
                X3DLoader myFileLoader = null;
                Scene myVRMLScene = null;
                BranchGroup myVRMLModel = null;
                try {
                    myFileLoader = new X3DLoader();
                    myFileLoader.setBasePath(file.getParent());
                    myVRMLScene = myFileLoader.load(file.getAbsolutePath());
                    myVRMLModel = myVRMLScene.getSceneGroup();
                    this.lobj = new Obj3D();
                    TransformGroup scene = new TransformGroup();
                    Enumeration enume = myVRMLModel.getAllChildren();
                    while (enume.hasMoreElements()) {
                        Group next = (Group)enume.nextElement();
                        myVRMLModel.removeChild((Node)next);
                        scene.addChild((Node)next);
                    }
                    this.lobj.setModel3D(scene);
                    this.render.addObj3D(this.lobj);
                    this.update3dFilesOpened(file);
                    System.err.println("fez o load----------");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    GuiUtils.errorMessage(this, "Load", "Error Loading x3D File");
                }
            } else if ("j3d".equalsIgnoreCase(FileUtil.getFileExtension(file))) {
                if (this.lobj != null) {
                    this.render.removeObj3D(this.lobj);
                }
                BranchGroup bg = null;
                try {
                    SceneGraphFileReader filer = new SceneGraphFileReader(file);
                    bg = filer.readAllBranchGraphs()[0];
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                if (bg == null) {
                    NeptusLog.pub().error((Object)("Error loading vehicle model\n" + this));
                }
                TransformGroup scene = new TransformGroup();
                Enumeration enume = bg.getAllChildren();
                while (enume.hasMoreElements()) {
                    Group next = (Group)enume.nextElement();
                    bg.removeChild((Node)next);
                    scene.addChild((Node)next);
                }
                this.lobj = new Obj3D();
                this.lobj.setModel3D(scene);
                this.render.addObj3D(this.lobj);
                this.update3dFilesOpened(file);
            } else {
                GuiUtils.errorMessage(this, "Load", "Invalid file type.");
            }
        }
    }

    private JMenu getRecentlyOpenFilesMenu() {
        if (this.recentlyOpenFilesMenu == null) {
            this.recentlyOpenFilesMenu = new JMenu();
            this.recentlyOpenFilesMenu.getPopupMenu().setLightWeightPopupEnabled(false);
            this.recentlyOpenFilesMenu.setText("Recently opened");
            RecentlyOpenedFilesUtil.constructRecentlyFilesMenuItems(this.recentlyOpenFilesMenu, this.miscFilesOpened);
        } else {
            RecentlyOpenedFilesUtil.constructRecentlyFilesMenuItems(this.recentlyOpenFilesMenu, this.miscFilesOpened);
        }
        return this.recentlyOpenFilesMenu;
    }

    private void loadRecentlyOpenedFiles() {
        String recentlyOpenedFiles = ConfigFetch.resolvePath(RECENTLY_OPENED_3D);
        Method methodUpdate = null;
        try {
            Class[] params = new Class[]{File.class};
            methodUpdate = this.getClass().getMethod("update3dFilesOpened", params);
        }
        catch (Exception e) {
            NeptusLog.pub().error((Object)(this + "loadRecentlyOpenedFiles"), (Throwable)e);
            return;
        }
        if (recentlyOpenedFiles == null) {
            return;
        }
        if (!new File(recentlyOpenedFiles).exists()) {
            return;
        }
        RecentlyOpenedFilesUtil.loadRecentlyOpenedFiles(recentlyOpenedFiles, methodUpdate, this);
    }

    public boolean update3dFilesOpened(File fx) {
        this.openedFile = fx;
        RecentlyOpenedFilesUtil.updateFilesOpenedMenuItems(fx, this.miscFilesOpened, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object key = e.getSource();
                File value = (File)Viewer3D.this.miscFilesOpened.get(key);
                if (!(value instanceof File)) {
                    return;
                }
                File fx = value;
                Viewer3D.this.openFile(fx);
            }
        });
        this.getRecentlyOpenFilesMenu();
        this.storeRecentlyOpenedFiles();
        return true;
    }

    private void storeRecentlyOpenedFiles() {
        String recentlyOpenedFiles = ConfigFetch.resolvePathBasedOnConfigFile(RECENTLY_OPENED_3D);
        LinkedHashMap<JMenuItem, File> hMap = this.miscFilesOpened;
        String header = "Recently opened 3D files.";
        RecentlyOpenedFilesUtil.storeRecentlyOpenedFiles(recentlyOpenedFiles, hMap, header);
    }
}

