/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.ws;

import java.net.URL;
import java.util.ArrayList;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.ws.NeptusStateServlet;

public class HTTPPublisher {
    private URL serverURL;
    private HttpClient client = new DefaultHttpClient();

    public HTTPPublisher(URL serverURL) {
        this.setServerURL(serverURL);
    }

    public HTTPPublisher() {
        try {
            this.serverURL = new URL("http://whale.fe.up.pt/neptusWS/update.php");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void publish(String type, String xml) {
        HttpHost target = new HttpHost(this.serverURL.getHost(), this.serverURL.getPort(), this.serverURL.getProtocol());
        HttpPost post = new HttpPost(this.serverURL.getPath());
        BasicNameValuePair nvp_type = new BasicNameValuePair("type", type);
        BasicNameValuePair nvp_xml = new BasicNameValuePair("xml", xml);
        ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
        nvps.add(nvp_type);
        nvps.add(nvp_xml);
        try {
            post.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps, "UTF-8"));
            HttpResponse res = this.client.execute(target, (HttpRequest)post);
            NeptusLog.pub().info((Object)("HTTP Response: " + EntityUtils.toString((HttpEntity)res.getEntity())));
        }
        catch (Exception e) {
            NeptusLog.pub().error((Object)("HTTP Response: " + e.getMessage()));
        }
        finally {
            post.abort();
            this.client.getConnectionManager().shutdown();
        }
    }

    public void publishPlan(String xml) {
        this.publish("plan", xml);
        NeptusStateServlet.setPlanXML(xml);
    }

    public void publishState(String xml) {
        this.publish("state", xml);
        NeptusStateServlet.setStateXML(xml);
    }

    public void publishWSN(String xml) {
        this.publish("wsn", xml);
        NeptusStateServlet.setWsnXML(xml);
    }

    public static void main(String[] args) throws Exception {
        new HTTPPublisher(new URL("http://127.0.0.1:8080/state")).publishPlan("<?xml version=\"1.0\" ?><t>\nIsto \u00e9 um teste</t>");
    }

    public URL getServerURL() {
        return this.serverURL;
    }

    public void setServerURL(URL serverURL) {
        this.serverURL = serverURL;
    }

    protected void finalize() throws Throwable {
        this.client.getConnectionManager().shutdown();
        super.finalize();
    }
}

