/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.ws;

import java.util.StringTokenizer;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.w3c.dom.NodeList;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.ws.CoordinateSimpleUtil;

public class Location {
    private double latitude;
    private double longitude;
    private double depth;
    private double easting;
    private double northing;
    String id = null;
    String name = null;

    public Location(double latitude, double longitude) {
        this.latitude = latitude;
        this.longitude = longitude;
        this.depth = 0.0;
        this.easting = 0.0;
        this.northing = 0.0;
    }

    public Location(Location loc) {
        this.latitude = loc.getLatitude();
        this.longitude = loc.getLongitude();
        this.depth = loc.getDepth();
        this.easting = loc.getEasting();
        this.northing = loc.getNorthing();
    }

    public Location(double latitude, double longitude, double depth) {
        this.latitude = latitude;
        this.longitude = longitude;
        this.depth = depth;
        this.easting = 0.0;
        this.northing = 0.0;
    }

    public double[] getNEDOffsetFrom(Location anotherLocation) {
        double[] diff = CoordinateSimpleUtil.latLonDiff(anotherLocation.getLatitude(), anotherLocation.getLongitude(), this.latitude, this.longitude);
        double[] ret = new double[]{diff[0] + this.getNorthing() - anotherLocation.getNorthing(), diff[1] + this.getEasting() - anotherLocation.getEasting(), this.depth - anotherLocation.depth};
        return ret;
    }

    private double[] latLonAddNE(double lat, double lon, double north, double east) {
        double lat_rad = lat * Math.PI / 180.0;
        lat += north / (111132.92 - 559.82 * Math.cos(2.0 * lat_rad) + 1.175 * Math.cos(4.0 * lat_rad));
        lon += east / (111412.84 * Math.cos(lat_rad) - 93.5 * Math.cos(3.0 * lat_rad));
        while (lon > 180.0) {
            lon -= 360.0;
        }
        while (lon < -180.0) {
            lon += 360.0;
        }
        while (lat > 90.0) {
            lat -= 180.0;
        }
        while (lat < -90.0) {
            lat += 180.0;
        }
        double[] latLon = new double[]{lat, lon};
        return latLon;
    }

    private String latitudeAsString(double latitude) {
        double tmp = latitude;
        String letter = "N";
        String result = "";
        if (tmp < 0.0) {
            tmp = -tmp;
            letter = "S";
        }
        int degs = (int)Math.floor(tmp);
        result = result + degs + "" + letter;
        tmp -= (double)degs;
        int mins = (int)Math.floor(tmp *= 60.0);
        result = result + mins + "'";
        tmp -= (double)mins;
        float secs = (float)(tmp *= 60.0);
        result = result + secs + "''";
        return result;
    }

    private String longitudeAsString(double longitude) {
        double tmp = longitude;
        String letter = "E";
        String result = "";
        if (tmp < 0.0) {
            tmp = -tmp;
            letter = "W";
        }
        int degs = (int)Math.floor(tmp);
        result = result + degs + "" + letter;
        tmp -= (double)degs;
        int mins = (int)Math.floor(tmp *= 60.0);
        result = result + mins + "'";
        tmp -= (double)mins;
        float secs = (float)(tmp *= 60.0);
        result = result + secs + "''";
        return result;
    }

    public String getLatitudeAsString() {
        return this.latitudeAsString(this.getLatitude());
    }

    public String getLongitudeAsString() {
        return this.longitudeAsString(this.getLongitude());
    }

    public String getAbsoluteLatitude() {
        double[] newLatLon = this.latLonAddNE(this.getLatitude(), this.getLongitude(), this.getNorthing(), this.getEasting());
        return this.latitudeAsString(newLatLon[0]);
    }

    public String getAbsoluteLongitude() {
        double[] newLatLon = this.latLonAddNE(this.getLatitude(), this.getLongitude(), this.getNorthing(), this.getEasting());
        return this.longitudeAsString(newLatLon[1]);
    }

    public double getAbsoluteLongitudeDouble() {
        double[] newLatLon = this.latLonAddNE(this.getLatitude(), this.getLongitude(), this.getNorthing(), this.getEasting());
        return newLatLon[1];
    }

    public double getAbsoluteLatitudeDouble() {
        double[] newLatLon = this.latLonAddNE(this.getLatitude(), this.getLongitude(), this.getNorthing(), this.getEasting());
        return newLatLon[0];
    }

    public double getDepth() {
        return this.depth;
    }

    public void setDepth(double depth) {
        this.depth = depth;
    }

    public double getEasting() {
        return this.easting;
    }

    public void setEasting(double easting) {
        this.easting = easting;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public void setLatitude(double latitude) {
        this.latitude = latitude;
    }

    public void setLatitude(String latitude) {
        this.latitude = Location.parseDMSString(latitude);
    }

    public double getLongitude() {
        return this.longitude;
    }

    public void setLongitude(double longitude) {
        this.longitude = longitude;
    }

    public void setLongitude(String longitude) {
        this.longitude = Location.parseDMSString(longitude);
    }

    public double getNorthing() {
        return this.northing;
    }

    public void setNorthing(double northing) {
        this.northing = northing;
    }

    public void translate(double northOffset, double eastOffset, double depthOffset) {
        this.northing += northOffset;
        this.easting += eastOffset;
        this.depth += depthOffset;
    }

    public static double[] sphericalToCartesianCoordinates(double r, double theta, double phi) {
        theta = Math.toRadians(theta);
        phi = Math.toRadians(phi);
        double x = r * Math.cos(theta) * Math.sin(phi);
        double y = r * Math.sin(theta) * Math.sin(phi);
        double z = r * Math.cos(phi);
        double[] cartesian = new double[]{x, y, z};
        return cartesian;
    }

    public static void main(String[] args) {
        Location loc = new Location(41.23974, -8.341);
        Location loc2 = new Location(loc);
        loc2.setLongitude(-8.3434);
        NeptusLog.pub().info((Object)("<###> " + loc.getNEDOffsetFrom(loc2)[1]));
        loc = new Location(41.2323, -8.2323);
        loc.setEasting(-23.0);
        loc.setDepth(34.2343);
        NeptusLog.pub().info((Object)("<###> " + loc.asXMLElement().asXML()));
    }

    public static double parseDMSString(String dms) {
        StringTokenizer st = new StringTokenizer(dms, " '\u00ba\u00b0NWES");
        double degrees = 0.0;
        double minutes = 0.0;
        double seconds = 0.0;
        try {
            degrees = Double.parseDouble(st.nextToken());
            minutes = Double.parseDouble(st.nextToken());
            seconds = Double.parseDouble(st.nextToken());
        }
        catch (Exception e) {
            NeptusLog.pub().debug((Object)e.getMessage());
        }
        double value = degrees + minutes / 60.0 + seconds / 3600.0;
        if (dms.contains("W") || dms.contains("S")) {
            value = -value;
        }
        return value;
    }

    public Element asXMLElement() {
        Element elem = DocumentHelper.createElement((String)"coordinate");
        elem.addElement("latitude").setText(this.getLatitudeAsString());
        elem.addElement("longitude").setText(this.getLongitudeAsString());
        elem.addElement("depth").setText("" + this.getDepth());
        elem.addElement("offset-north").setText("" + this.getNorthing());
        elem.addElement("offset-east").setText("" + this.getEasting());
        return elem;
    }

    public static Location readLocation(org.w3c.dom.Node node) {
        Location loc = new Location(0.0, 0.0);
        NodeList nl = node.getChildNodes();
        double azimuth = 0.0;
        double zenith = 0.0;
        double distance = 0.0;
        for (int i = 0; i < nl.getLength(); ++i) {
            org.w3c.dom.Node nd = nl.item(i);
            if (nd.getNodeName().equalsIgnoreCase("latitude")) {
                loc.setLatitude(nd.getTextContent());
                continue;
            }
            if (nd.getNodeName().equalsIgnoreCase("longitude")) {
                loc.setLongitude(nd.getTextContent());
                continue;
            }
            if (nd.getNodeName().equalsIgnoreCase("height")) {
                loc.setDepth(-Double.parseDouble(nd.getTextContent()));
                continue;
            }
            if (nd.getNodeName().equalsIgnoreCase("depth")) {
                loc.setDepth(Double.parseDouble(nd.getTextContent()));
                continue;
            }
            if (nd.getNodeName().equalsIgnoreCase("offset-north")) {
                loc.setNorthing(Double.parseDouble(nd.getTextContent()));
                continue;
            }
            if (nd.getNodeName().equalsIgnoreCase("offset-east")) {
                loc.setEasting(Double.parseDouble(nd.getTextContent()));
                continue;
            }
            if (nd.getNodeName().equalsIgnoreCase("offset-west")) {
                loc.setEasting(-Double.parseDouble(nd.getTextContent()));
                continue;
            }
            if (nd.getNodeName().equalsIgnoreCase("offset-south")) {
                loc.setNorthing(-Double.parseDouble(nd.getTextContent()));
                continue;
            }
            if (nd.getNodeName().equalsIgnoreCase("offset-down")) {
                loc.setDepth(loc.getDepth() + Double.parseDouble(nd.getTextContent()));
                continue;
            }
            if (nd.getNodeName().equalsIgnoreCase("offset-up")) {
                loc.setDepth(loc.getDepth() - Double.parseDouble(nd.getTextContent()));
                continue;
            }
            if (nd.getNodeName().equalsIgnoreCase("azimuth")) {
                azimuth = Double.parseDouble(nd.getTextContent());
                continue;
            }
            if (nd.getNodeName().equalsIgnoreCase("zenith")) {
                zenith = Double.parseDouble(nd.getTextContent());
                continue;
            }
            if (!nd.getNodeName().equalsIgnoreCase("offset-distance")) continue;
            distance = Double.parseDouble(nd.getTextContent());
        }
        if (distance != 0.0) {
            double[] offsets = Location.sphericalToCartesianCoordinates(distance, azimuth, zenith);
            loc.translate(offsets[0], offsets[1], offsets[2]);
        }
        return loc;
    }

    public static Location readLocation(Element elem) {
        Location loc = new Location(0.0, 0.0);
        Node node = elem.selectSingleNode("./latitude");
        if (node != null) {
            loc.setLatitude(node.getText());
        }
        if ((node = elem.selectSingleNode("./longitude")) != null) {
            loc.setLongitude(node.getText());
        }
        if ((node = elem.selectSingleNode("./height")) != null) {
            loc.setDepth(-Double.parseDouble(node.getText()));
        }
        if ((node = elem.selectSingleNode("./depth")) != null) {
            loc.setDepth(Double.parseDouble(node.getText()));
        }
        if ((node = elem.selectSingleNode("./offset-north")) != null) {
            loc.setNorthing(Double.parseDouble(node.getText()));
        }
        if ((node = elem.selectSingleNode("./offset-east")) != null) {
            loc.setEasting(Double.parseDouble(node.getText()));
        }
        if ((node = elem.selectSingleNode("./offset-west")) != null) {
            loc.setEasting(-Double.parseDouble(node.getText()));
        }
        if ((node = elem.selectSingleNode("./offset-south")) != null) {
            loc.setNorthing(-Double.parseDouble(node.getText()));
        }
        if ((node = elem.selectSingleNode("./offset-down")) != null) {
            loc.setDepth(Double.parseDouble(node.getText()) + loc.getDepth());
        }
        if ((node = elem.selectSingleNode("./offset-up")) != null) {
            loc.setDepth(-Double.parseDouble(node.getText()) + loc.getDepth());
        }
        double azimuth = 0.0;
        double zenith = 0.0;
        double distance = 0.0;
        node = elem.selectSingleNode("./azimuth");
        if (node != null) {
            azimuth = Double.parseDouble(node.getText());
        }
        if ((node = elem.selectSingleNode("./zenith")) != null) {
            zenith = Double.parseDouble(node.getText());
        }
        if ((node = elem.selectSingleNode("./offset-distance")) != null) {
            distance = Double.parseDouble(node.getText());
        }
        double[] offsets = Location.sphericalToCartesianCoordinates(distance, azimuth, zenith);
        loc.translate(offsets[0], offsets[1], offsets[2]);
        return loc;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }
}

