/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.ws;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.mp.Maneuver;
import pt.lsts.neptus.mp.ManeuverLocation;
import pt.lsts.neptus.mp.maneuvers.LocatedManeuver;
import pt.lsts.neptus.mp.maneuvers.PathProvider;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.map.MarkElement;
import pt.lsts.neptus.types.map.PathElement;
import pt.lsts.neptus.types.mission.HomeReference;
import pt.lsts.neptus.types.mission.MapMission;
import pt.lsts.neptus.types.mission.MissionType;
import pt.lsts.neptus.types.mission.plan.PlanType;

public class PublishHelper {
    private PublishHelper() {
    }

    public static String createPlanPath(MissionType missionType, PlanType plan) {
        LocationType locStart = new LocationType();
        LocationType startPos = new LocationType();
        LinkedHashMap<String, MapMission> mapList = missionType.getMapsList();
        HomeReference hRef = new HomeReference(missionType.getHomeRef().asXML());
        hRef.setRoll(0.0);
        hRef.setPitch(0.0);
        hRef.setYaw(0.0);
        locStart.setLocation(hRef);
        boolean isFound = false;
        for (MapMission mpm : mapList.values()) {
            LinkedHashMap<String, MarkElement> transList = mpm.getMap().getMarksList();
            for (MarkElement tmp : transList.values()) {
                String name = tmp.getId();
                if (!name.equalsIgnoreCase("start")) continue;
                locStart.setLocation(tmp.getCenterLocation());
                isFound = true;
                break;
            }
            if (!isFound) continue;
            break;
        }
        startPos = isFound ? new LocationType(locStart) : new LocationType(locStart);
        LinkedList<Maneuver> mans = plan.getGraph().getGraphAsManeuversList();
        NeptusLog.pub().debug((Object)(PublishHelper.class.getSimpleName() + "\nPlan: " + mans.size()));
        if (mans.size() == 0) {
            return new PathElement().asXML();
        }
        Vector<LocationType> locLst = PublishHelper.planPathLocs(plan);
        PathElement path = PublishHelper.planPathElement(locLst, plan.getId());
        if (path == null) {
            path = new PathElement(null, null, startPos);
            path.setId(plan.getId());
            path.setFinished(true);
        }
        String pathXML = path.asXML();
        return pathXML;
    }

    public static final Vector<LocationType> planPathLocs(PlanType plan) {
        Vector<LocationType> locations = new Vector<LocationType>();
        if (plan == null) {
            return locations;
        }
        LinkedList<Maneuver> mans = plan.getGraph().getGraphAsManeuversList();
        for (Maneuver man : mans) {
            if (!(man instanceof LocatedManeuver)) continue;
            ManeuverLocation destTo = ((LocatedManeuver)((Object)man)).getManeuverLocation();
            if (man instanceof PathProvider) {
                locations.addAll(((PathProvider)((Object)man)).getPathLocations());
                continue;
            }
            locations.add(destTo);
        }
        return locations;
    }

    public static final PathElement planPathElement(List<LocationType> locLst, String pathId) {
        Object pivotLoc;
        if (locLst.size() == 0) {
            return null;
        }
        Object destFrom = pivotLoc = locLst.get(0).getNewAbsoluteLatLonDepth();
        LocationType destTo = null;
        double[] offsetsum = new double[]{0.0, 0.0, 0.0};
        PathElement path = new PathElement(null, null, (LocationType)pivotLoc);
        if (pathId != null && pathId.length() > 0) {
            path.setId(pathId);
        }
        Iterator<LocationType> i$ = locLst.iterator();
        while (i$.hasNext()) {
            LocationType loc;
            destTo = loc = i$.next();
            double[] offsets = destTo.getOffsetFrom((LocationType)destFrom);
            offsetsum[0] = offsetsum[0] + offsets[0];
            offsetsum[1] = offsetsum[1] + offsets[1];
            offsetsum[2] = offsetsum[2] + offsets[2];
            NeptusLog.pub().debug((Object)(PublishHelper.class.getSimpleName() + "\nPlan: " + offsets[0] + "; " + offsets[1] + "; " + offsets[2] + "."));
            path.addPoint(offsetsum[1], offsetsum[0], offsetsum[2], false);
            destFrom = destTo;
        }
        path.setFinished(true);
        return path;
    }
}

