/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.ws;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import pt.lsts.imc.IMCDefinition;
import pt.lsts.imc.IMCMessage;
import pt.lsts.neptus.comm.IMCUtils;
import pt.lsts.neptus.comm.manager.imc.ImcMsgManager;
import pt.lsts.neptus.messages.listener.MessageInfoImpl;
import pt.lsts.neptus.util.StreamUtil;
import pt.lsts.neptus.util.logdb.SQLiteSerialization;

public class RESTServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;

    protected void messagesReceived(IMCMessage[] messages) {
        for (int i = 0; i < messages.length; ++i) {
            try {
                MessageInfoImpl info = new MessageInfoImpl();
                info.setTimeReceivedNanos(System.currentTimeMillis() * 1000000L);
                info.setTimeSentNanos((long)messages[i].getHeader().getTimestamp() * 1000000000L);
                ImcMsgManager.getManager().onMessage(info, messages[i]);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected void doHead(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doHead(req, resp);
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Vector<String> errors;
        block8: {
            String[] parts = req.getRequestURI().split("/");
            errors = new Vector<String>();
            if (parts.length > 2 && parts[parts.length - 2].equals("imc")) {
                String format;
                String[] p2 = parts[parts.length - 1].split("\\.");
                String msgName = p2.length > 0 ? p2[0] : parts[parts.length - 1];
                String string = format = p2.length <= 1 ? "xml" : p2[1].toLowerCase();
                if (IMCDefinition.getInstance().getMessageId(msgName) != -1) {
                    try {
                        if (format.equalsIgnoreCase("xml")) {
                            String xml = StreamUtil.copyStreamToString((InputStream)req.getInputStream());
                            req.getInputStream().close();
                            IMCMessage[] messages = IMCUtils.parseImcXml(xml);
                            this.messagesReceived(messages);
                            resp.setStatus(200);
                            break block8;
                        }
                        if (format.equalsIgnoreCase("lsf")) {
                            IMCMessage[] msgs = IMCUtils.parseLsf((InputStream)req.getInputStream());
                            this.messagesReceived(msgs);
                            resp.setStatus(200);
                            break block8;
                        }
                        resp.setStatus(500);
                        errors.add("Currently only IMC-XML and LSF are suppported");
                    }
                    catch (Exception e) {
                        resp.setStatus(500);
                        errors.add(e.getMessage());
                    }
                } else {
                    resp.setStatus(404);
                    errors.add("Message not found: " + msgName);
                }
            }
        }
        resp.setContentType("text/plain");
        for (String e : errors) {
            resp.getWriter().println(e);
        }
        resp.getWriter().close();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String[] parts = req.getRequestURI().split("/");
        Vector<String> errors = new Vector<String>();
        if (parts.length > 2 && parts[parts.length - 2].equals("imc")) {
            String[] p2 = parts[parts.length - 1].split("\\.");
            String msgName = p2.length > 0 ? p2[0] : parts[parts.length - 1];
            String format = p2.length <= 1 ? "xml" : p2[1].toLowerCase();
            resp.setContentType("application/" + format);
            if (IMCDefinition.getInstance().getMessageId(msgName) != -1) {
                if (format.equals("xml")) {
                    try {
                        resp.setContentType("text/xml");
                        resp.getWriter().println(IMCUtils.getAsImcXml(new IMCMessage[]{SQLiteSerialization.getDb().getLastMessageOfType(msgName)}).asXML());
                        resp.getWriter().close();
                        return;
                    }
                    catch (Exception e) {
                        resp.setStatus(500);
                        errors.add(e.getMessage());
                    }
                } else if (format.equals("lsf")) {
                    resp.setContentType("application/lsf");
                    try {
                        IMCUtils.writeAsLsf(SQLiteSerialization.getDb().getLastMessageOfType(msgName), (OutputStream)resp.getOutputStream());
                    }
                    catch (Exception e) {
                        resp.setStatus(500);
                        errors.add(e.getMessage());
                    }
                } else if (format.equals("txt")) {
                    resp.setContentType("text/plain");
                    try {
                        IMCUtils.writeAsTxt(SQLiteSerialization.getDb().getLastMessageOfType(msgName), (OutputStream)resp.getOutputStream());
                    }
                    catch (Exception e) {
                        resp.setStatus(500);
                        errors.add(e.getMessage());
                    }
                }
            } else {
                resp.setStatus(404);
                errors.add("Message not found: " + msgName);
            }
        } else {
            resp.setStatus(403);
            errors.add("Malformed URL");
        }
        resp.setContentType("text/plain");
        for (String e : errors) {
            resp.getWriter().println(e);
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doPut(req, resp);
    }
}

