/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.spot;

import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.HashMap;
import java.util.TreeSet;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.plugins.spot.SpotMessage;

public class DataExporter {
    public static boolean exportToCsv(HashMap<String, TreeSet<SpotMessage>> msgBySpot) {
        try {
            PrintWriter writer = new PrintWriter("spotMessages.csv", "UTF-8");
            writer.println("Id;Timestamp;Latitude;Longitude");
            Collection<TreeSet<SpotMessage>> spotIds = msgBySpot.values();
            for (TreeSet<SpotMessage> msgTreeSet : spotIds) {
                for (SpotMessage spotMessage : msgTreeSet) {
                    writer.println(spotMessage.id + ";" + spotMessage.timestamp + ";" + spotMessage.latitude + ";" + spotMessage.longitude + ";");
                }
                writer.println();
            }
            writer.close();
            return true;
        }
        catch (FileNotFoundException | UnsupportedEncodingException e) {
            NeptusLog.pub().error((Object)"Error printing spot data to cvs", (Throwable)e);
            return false;
        }
    }
}

