/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.spot;

import java.util.ArrayList;
import java.util.TreeSet;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import pt.lsts.neptus.plugins.spot.SpotMessage;
import pt.lsts.neptus.plugins.spot.Vector3f;
import pt.lsts.neptus.types.coord.LocationType;

public class Spot {
    public static Logger log = Logger.getLogger((String)"SPOT");
    private final String id;
    protected Float speed;
    protected Double direction;
    protected ArrayList<LocationType> lastLocations;

    public Spot(String id) {
        this.id = id;
        this.speed = null;
        this.direction = null;
        this.lastLocations = new ArrayList();
    }

    public void update(TreeSet<SpotMessage> messages) {
        final LocationSpeedDirection speedLocationDirection = this.setSpeedMpsAndDirection(messages);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Spot.this.speed = speedLocationDirection.speed;
                Spot.this.direction = speedLocationDirection.direction;
                Spot.this.lastLocations = speedLocationDirection.locations;
            }
        });
    }

    private LocationSpeedDirection setSpeedMpsAndDirection(TreeSet<SpotMessage> messages) {
        if (messages.size() == 1) {
            LocationType location = new LocationType(messages.first().latitude, messages.first().longitude);
            ArrayList<LocationType> locations = new ArrayList<LocationType>();
            locations.add(location);
            return new LocationSpeedDirection(-1.0f, 1.0, locations);
        }
        int numMeasurements = 0;
        double sumSpeed = 0.0;
        ArrayList<LocationType> locations = new ArrayList<LocationType>();
        SpotMessage prevMsg = null;
        LocationType prevLocation = null;
        LocationType tmpLocation = null;
        Vector3f sumDirVector = new Vector3f(0.0f, 0.0f, 0.0f);
        for (SpotMessage tmpMsg : messages) {
            tmpLocation = new LocationType(tmpMsg.latitude, tmpMsg.longitude);
            locations.add(tmpLocation);
            ++numMeasurements;
            if (prevMsg != null) {
                double distanceInMeters = tmpLocation.getDistanceInMeters(prevLocation);
                long elapsedTime = tmpMsg.timestamp - prevMsg.timestamp;
                double speedMeterSecond = distanceInMeters / (double)elapsedTime;
                log.debug((Object)("Traveled " + distanceInMeters + " in " + elapsedTime + " = " + speedMeterSecond + "  (" + tmpMsg.latitude + ", " + tmpMsg.longitude + " at " + tmpMsg.timestamp));
                sumSpeed += speedMeterSecond;
                double[] movementVectorArray = prevLocation.getOffsetFrom(tmpLocation);
                Vector3f movementVector = new Vector3f(new Float(movementVectorArray[0]).floatValue(), new Float(movementVectorArray[1]).floatValue(), 0.0f);
                movementVector = movementVector.divide(movementVector.length());
                sumDirVector.x = movementVector.x * (float)numMeasurements;
                sumDirVector.y = movementVector.y * (float)numMeasurements;
            }
            prevMsg = tmpMsg;
            prevLocation = tmpLocation;
        }
        Float factorial = new Float(Spot.gamma(numMeasurements - 1));
        sumDirVector.x /= factorial.floatValue();
        sumDirVector.y /= factorial.floatValue();
        Float finalSpeed = new Float(sumSpeed / (double)(numMeasurements - 1));
        double finalDirection = Math.atan(sumDirVector.y / sumDirVector.x);
        log.debug((Object)("finalSpeed " + finalSpeed + ", direction: (" + sumDirVector.x + ", " + sumDirVector.y + ")" + finalDirection));
        return new LocationSpeedDirection(finalSpeed.floatValue(), finalDirection, locations);
    }

    static double gamma(double z) {
        double tmp1 = Math.sqrt(Math.PI * 2 / z);
        double tmp2 = z + 1.0 / (12.0 * z - 1.0 / (10.0 * z));
        tmp2 = Math.pow(tmp2 / Math.E, z);
        return tmp1 * tmp2;
    }

    public LocationType getLastLocation() {
        int size = this.lastLocations.size();
        if (size > 0) {
            return this.lastLocations.get(size - 1);
        }
        return null;
    }

    public ArrayList<LocationType> getLastLocations() {
        return this.lastLocations;
    }

    public String getName() {
        return this.id;
    }

    public float getSpeed() {
        return this.speed.floatValue();
    }

    public Double getDirection() {
        return this.direction;
    }

    class LocationSpeedDirection {
        public static final float NO_VALUE_F = -1.0f;
        public static final double NO_VALUE_D = -1.0;
        public final double direction;
        public final Float speed;
        public final ArrayList<LocationType> locations;

        public LocationSpeedDirection(float speed, double direction, ArrayList<LocationType> locations) {
            this.speed = Float.valueOf(speed);
            this.direction = direction;
            this.locations = locations;
        }
    }

    class DirVector {
        public double latitude;
        public double longitude;

        public DirVector(double latitude, double longitude) {
            this.latitude = latitude;
            this.longitude = longitude;
        }
    }
}

