/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.spot;

import java.text.SimpleDateFormat;

public class SpotMessage
implements Comparable<SpotMessage> {
    public final double latitude;
    public final double longitude;
    public final long timestamp;
    String id;

    public SpotMessage(double lat, double lon, long timestamp, String id) {
        this.latitude = lat;
        this.longitude = lon;
        this.timestamp = timestamp;
        this.id = id;
    }

    @Override
    public int compareTo(SpotMessage o) {
        return (int)(this.timestamp - o.timestamp);
    }

    public int hashCode() {
        return new String("" + this.latitude + this.longitude + this.id + this.timestamp).hashCode();
    }

    public boolean equals(Object obj) {
        return this.hashCode() == obj.hashCode();
    }

    public static String latString(double latitude, String posneg) {
        String ns = posneg.substring(0, 1);
        if (latitude < 0.0) {
            ns = posneg.substring(1);
            latitude = -latitude;
        }
        String ret = (int)latitude + ns;
        latitude -= (double)((int)latitude);
        ret = ret + (int)(latitude *= 60.0) + "'";
        latitude -= (double)((int)latitude);
        ret = ret + (float)(latitude * 60.0);
        return ret;
    }

    public String asVehicleState() {
        SimpleDateFormat time = new SimpleDateFormat("HH:mm:ss.SSS");
        SimpleDateFormat date = new SimpleDateFormat("yyyy-MM-dd");
        String xml = "<VehicleState id='" + this.id + "' time='" + time.format(this.timestamp) + "' date='" + date.format(this.timestamp) + "'>\n";
        xml = xml + "  <coordinate>\n    <id>id</id>\n    <name>name</name>\n    <coordinate>\n";
        xml = xml + "      <latitude>" + SpotMessage.latString(this.latitude, "NS") + "</latitude>\n";
        xml = xml + "      <longitude>" + SpotMessage.latString(this.longitude, "EW") + "</longitude>\n";
        xml = xml + "      <depth>0</depth>\n    </coordinate>\n  </coordinate>\n";
        xml = xml + "  <attitude><phi>0</phi><theta>0</theta><psi>0</psi></attitude>\n  <imc/>\n";
        xml = xml + "</VehicleState>\n";
        return xml;
    }

    public String toString() {
        return this.id + " (" + this.latitude + ", " + this.longitude + ") " + this.timestamp;
    }
}

