/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.spot;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.plugins.spot.Spot;
import pt.lsts.neptus.plugins.spot.SpotMessage;

public class SpotMsgFetcher {
    public static HashMap<String, TreeSet<SpotMessage>> get(int hours) throws ParserConfigurationException, SAXException, IOException {
        long currentTime = System.currentTimeMillis() / 1000L;
        long timeWindow = hours * 60 * 60;
        long startOfTimeWindowSecs = currentTime - timeWindow;
        HashMap<String, TreeSet<SpotMessage>> msgBySpot = new HashMap<String, TreeSet<SpotMessage>>();
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        try {
            File file = new File("/home/meg/LSTS/spot.xml");
            Document doc = db.parse(file);
            NodeList nlist = doc.getFirstChild().getChildNodes();
            if (nlist.getLength() == 1) {
                Node feedMsgResp = nlist.item(0);
                String tagName = feedMsgResp.getNodeName();
                if (tagName.equals("feedMessageResponse")) {
                    nlist = feedMsgResp.getChildNodes();
                    if (nlist.getLength() == 5) {
                        for (int i = 1; i < nlist.getLength(); ++i) {
                            Node messages = nlist.item(i);
                            tagName = messages.getNodeName();
                            if (!tagName.equals("messages")) continue;
                            nlist = messages.getChildNodes();
                            for (int m = 1; m < nlist.getLength(); ++m) {
                                tagName = nlist.item(m).getNodeName();
                                if (!tagName.equals("message")) continue;
                                SpotMsgFetcher.processMsg(startOfTimeWindowSecs, msgBySpot, nlist, m);
                            }
                        }
                    } else {
                        NeptusLog.pub().error((Object)"Unexpected element number in xml structure level 2.");
                    }
                } else {
                    NeptusLog.pub().error((Object)"Unexpected element at xml structure level 1.");
                }
            } else {
                NeptusLog.pub().error((Object)"Unexpected root elements");
            }
        }
        catch (SAXParseException e) {
            NeptusLog.pub().warn((Object)"Error parsing xml!");
        }
        catch (Exception e) {
            NeptusLog.pub().warn((Object)"Error getting SPOT info!");
        }
        return msgBySpot;
    }

    private static void processMsg(long startOfTimeWindowSecs, HashMap<String, TreeSet<SpotMessage>> msgBySpot, NodeList nlist, int i) {
        double lat = 0.0;
        double lon = 0.0;
        String id = "_";
        long timestamp = System.currentTimeMillis();
        NodeList elems = nlist.item(i).getChildNodes();
        for (int j = 0; j < elems.getLength(); ++j) {
            String tag = elems.item(j).getNodeName();
            if (tag.equals("latitude")) {
                lat = Double.parseDouble(elems.item(j).getTextContent());
                continue;
            }
            if (tag.equals("longitude")) {
                lon = Double.parseDouble(elems.item(j).getTextContent());
                continue;
            }
            if (tag.equals("messengerName")) {
                id = elems.item(j).getTextContent();
                continue;
            }
            if (!tag.equals("unixTime")) continue;
            timestamp = Long.parseLong(elems.item(j).getTextContent());
        }
        if (timestamp > startOfTimeWindowSecs) {
            TreeSet<SpotMessage> spotMsgTree = msgBySpot.get(id);
            if (spotMsgTree == null) {
                spotMsgTree = new TreeSet();
                msgBySpot.put(id, spotMsgTree);
            }
            Spot.log.debug((Object)("Adding " + id + " " + timestamp + " @ (" + lat + ", " + lon + ")"));
            spotMsgTree.add(new SpotMessage(lat, lon, timestamp, id));
        }
    }
}

