/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.spot;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.SwingUtilities;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.plugins.ConfigurationListener;
import pt.lsts.neptus.plugins.NeptusProperty;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.plugins.SimpleRendererInteraction;
import pt.lsts.neptus.plugins.spot.DataExporter;
import pt.lsts.neptus.plugins.spot.Spot;
import pt.lsts.neptus.plugins.spot.SpotMessage;
import pt.lsts.neptus.plugins.spot.SpotMsgFetcher;
import pt.lsts.neptus.plugins.update.IPeriodicUpdates;
import pt.lsts.neptus.plugins.update.PeriodicUpdatesService;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.util.GuiUtils;

@PluginDescription(author="Margarida", name="SPOT Overlay")
public class SpotOverlay
extends SimpleRendererInteraction
implements IPeriodicUpdates,
ConfigurationListener {
    private Vector<Spot> spotsOnMap;
    private boolean active = false;
    private static final long serialVersionUID = -4807939956933128721L;
    @NeptusProperty
    public int updateMinutes = 2;
    @NeptusProperty(name="Visible", userLevel=NeptusProperty.LEVEL.REGULAR)
    public boolean visible = true;
    @NeptusProperty
    public boolean showOnlyWhenInteractionIsActive = true;
    @NeptusProperty
    public boolean showNames = true;
    @NeptusProperty
    public boolean showSpeedValue = true;
    @NeptusProperty(userLevel=NeptusProperty.LEVEL.REGULAR, description="Set the time window (in hours) for considered positions. Will only consider positions in the last x hours.", name="Time window (hours)")
    public int hours = 70;
    @NeptusProperty(userLevel=NeptusProperty.LEVEL.REGULAR, name="Export to CSV")
    public boolean printCvsFile = false;
    protected GeneralPath gp = new GeneralPath();

    public SpotOverlay(ConsoleLayout console) {
        super(console);
        this.gp.moveTo(-2.0f, -8.0f);
        this.gp.lineTo(2.0f, -8.0f);
        this.gp.lineTo(2.0f, 2.0f);
        this.gp.lineTo(5.0f, 2.0f);
        this.gp.lineTo(0.0f, 8.0f);
        this.gp.lineTo(-5.0f, 2.0f);
        this.gp.lineTo(-2.0f, 2.0f);
        this.gp.closePath();
        this.spotsOnMap = new Vector();
    }

    public boolean isExclusive() {
        return false;
    }

    public long millisBetweenUpdates() {
        return this.updateMinutes * 60 * 1000;
    }

    public boolean update() {
        this.updateFromPage();
        return true;
    }

    private void updateFromPage() {
        HashMap<String, TreeSet<SpotMessage>> msgBySpot;
        Vector<Spot> nextSpotsOnMap = new Vector<Spot>();
        try {
            msgBySpot = SpotMsgFetcher.get(this.hours);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            NeptusLog.pub().error((Object)"Exception while loading data from Spot website.", (Throwable)e);
            return;
        }
        if (this.printCvsFile) {
            DataExporter.exportToCsv(msgBySpot);
        }
        if (msgBySpot.size() == 0) {
            return;
        }
        Collection<TreeSet<SpotMessage>> spotIds = msgBySpot.values();
        for (TreeSet<SpotMessage> msgTreeSet : spotIds) {
            SpotMessage firstMsg = msgTreeSet.first();
            Spot spot = new Spot(firstMsg.id);
            spot.update(msgTreeSet);
            nextSpotsOnMap.add(spot);
        }
        this.spotsOnMap = nextSpotsOnMap;
        this.repaint();
    }

    public void initSubPanel() {
    }

    public void cleanSubPanel() {
        PeriodicUpdatesService.unregister((IPeriodicUpdates)this);
    }

    public void setActive(boolean mode, StateRenderer2D source) {
        super.setActive(mode, source);
        this.active = mode;
        if (this.active) {
            this.update();
        }
    }

    public void paint(Graphics2D g, StateRenderer2D renderer) {
        if (!this.visible) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g.create();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        for (Spot spot : this.spotsOnMap) {
            double speedMps;
            LocationType spotLoc = spot.getLastLocation();
            if (spotLoc == null) continue;
            Point2D pt = renderer.getScreenPosition(spotLoc);
            double xScreenPos = pt.getX();
            double yScreenPos = pt.getY();
            g.translate(xScreenPos, yScreenPos);
            if (this.showNames) {
                g.setColor(Color.red.darker().darker());
                g.drawString(spot.getName(), 5, 0);
            }
            if ((speedMps = (double)spot.getSpeed()) != -1.0 && this.showSpeedValue) {
                g.setColor(Color.black);
                g.drawString(GuiUtils.getNeptusDecimalFormat((int)1).format(speedMps) + " m/s", 5, 10);
            }
            g.translate(-xScreenPos, -yScreenPos);
            ArrayList<LocationType> lastLocations = spot.getLastLocations();
            GeneralPath spotPath = new GeneralPath();
            Iterator<LocationType> iterator = lastLocations.iterator();
            float shadeOfGreyInc = 0.05f;
            float shadeOfGrey = (float)lastLocations.size() * shadeOfGreyInc;
            if (!iterator.hasNext()) continue;
            LocationType location = iterator.next();
            pt = renderer.getScreenPosition(location);
            spotPath.moveTo(pt.getX(), pt.getY());
            while (iterator.hasNext()) {
                location = iterator.next();
                pt = renderer.getScreenPosition(location);
                spotPath.lineTo(pt.getX(), pt.getY());
                float min = 1.0f - Math.min(shadeOfGrey, 0.8f);
                g2.setColor(new Color(min, min, min));
                g2.fillOval((int)(pt.getX() - 3.0), (int)(pt.getY() - 3.0), 7, 7);
                shadeOfGrey -= shadeOfGreyInc;
            }
            g2.setStroke(new BasicStroke(1.0f));
            g2.setColor(new Color(0.4f, 0.4f, 0.4f, 0.5f));
            g2.draw(spotPath);
        }
    }

    public void propertiesChanged() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SpotOverlay.this.updateFromPage();
            }
        });
    }
}

