/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.sim;

import com.google.common.eventbus.Subscribe;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import pt.lsts.imc.SimulatedState;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.ConsolePanel;
import pt.lsts.neptus.mp.SystemPositionAndAttitude;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.renderer2d.LayerPriority;
import pt.lsts.neptus.renderer2d.Renderer2DPainter;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.neptus.types.coord.LocationType;

@PluginDescription(author="zp", name="Simulated State Layer", icon="pt/lsts/neptus/plugins/position/painter/simulator.png")
@LayerPriority(priority=60)
public class SimulatedStatePainter
extends ConsolePanel
implements Renderer2DPainter {
    protected SystemPositionAndAttitude simulatedState = null;
    protected long lastStateMillis = 0L;
    protected GeneralPath path = new GeneralPath();
    private static final long serialVersionUID = 1L;

    public SimulatedStatePainter(ConsoleLayout console) {
        super(console);
        this.path.moveTo(0.0f, -10.0f);
        this.path.lineTo(0.0f, -2.0f);
        this.path.lineTo(-7.0f, -4.0f);
        this.path.lineTo(0.0f, 10.0f);
        this.path.lineTo(7.0f, -4.0f);
        this.path.lineTo(0.0f, -2.0f);
        this.path.closePath();
    }

    public void initSubPanel() {
        this.setVisibility(false);
    }

    public void paint(Graphics2D g, StateRenderer2D renderer) {
        if (System.currentTimeMillis() - this.lastStateMillis > 2000L) {
            return;
        }
        Point2D pt = renderer.getScreenPosition(this.simulatedState.getPosition());
        g.translate(pt.getX(), pt.getY());
        g.rotate(-renderer.getRotation() + this.simulatedState.getYaw() + Math.PI);
        g.setStroke(new BasicStroke(2.0f));
        g.setColor(Color.cyan.darker().darker());
        g.draw(this.path);
        g.setColor(Color.cyan.brighter().brighter());
        g.fill(this.path);
        g.drawString("S", -4, -4);
    }

    @Subscribe
    public void consume(SimulatedState simState) {
        LocationType loc = new LocationType(Math.toDegrees(simState.getLat()), Math.toDegrees(simState.getLon()));
        loc.setHeight(simState.getHeight());
        loc.translatePosition(simState.getX(), simState.getY(), simState.getZ());
        this.simulatedState = new SystemPositionAndAttitude(loc, simState.getPhi(), simState.getTheta(), simState.getPsi());
        this.lastStateMillis = System.currentTimeMillis();
    }

    public void cleanSubPanel() {
    }
}

