/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.sim;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Vector;
import javax.swing.JOptionPane;
import pt.lsts.imc.GpsFix;
import pt.lsts.imc.IMCMessage;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.ConsolePanel;
import pt.lsts.neptus.console.plugins.planning.MapPanel;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.plugins.NeptusProperty;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.util.GuiUtils;

public class SimulationActionsPlugin
extends ConsolePanel {
    protected final String menuTools = I18n.text((String)"Tools");
    protected final String menuSimulation = I18n.text((String)"Simulation");
    protected final String menuSendFix = I18n.text((String)"Send GPS Fix");
    protected final String menuChooseHeight = I18n.text((String)"Simulated Height...");
    @NeptusProperty
    private double simulatedHeight = 0.0;
    private static final long serialVersionUID = 1L;

    public SimulationActionsPlugin(ConsoleLayout console) {
        super(console);
        this.setVisibility(false);
    }

    public void initSubPanel() {
        this.addMenuItem(this.menuTools + ">" + this.menuSimulation + ">" + this.menuSendFix, null, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SimulationActionsPlugin.this.sendGpsFix();
            }
        });
        this.addMenuItem(this.menuTools + ">" + this.menuSimulation + ">" + this.menuChooseHeight, null, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SimulationActionsPlugin.this.selectHeight();
            }
        });
    }

    private void selectHeight() {
        String sel = JOptionPane.showInputDialog((Component)this.getConsole(), "Select Simulated Height", "" + this.simulatedHeight);
        if (sel == null) {
            return;
        }
        try {
            this.simulatedHeight = Double.parseDouble(sel);
        }
        catch (Exception e) {
            GuiUtils.errorMessage((Component)this.getConsole(), (Exception)e);
        }
    }

    private void sendGpsFix() {
        Vector pps = this.getConsole().getSubPanelsOfClass(MapPanel.class);
        if (pps.isEmpty()) {
            GuiUtils.errorMessage((String)I18n.text((String)"Cannot send GPS fix"), (String)I18n.text((String)"There must be a planning panel in the console"));
            return;
        }
        LocationType loc = ((MapPanel)pps.firstElement()).getRenderer().getCenter();
        loc.convertToAbsoluteLatLonDepth();
        Calendar cal = GregorianCalendar.getInstance();
        GpsFix fix = GpsFix.create((Object[])new Object[]{"validity", 65535, "type", "MANUAL_INPUT", "utc_year", cal.get(1), "utc_month", cal.get(2) + 1, "utc_day", cal.get(5), "utc_time", cal.get(11) * 3600 + cal.get(12) * 60 + cal.get(13), "lat", loc.getLatitudeRads(), "lon", loc.getLongitudeRads(), "height", this.simulatedHeight, "satellites", 4, "cog", 0, "sog", 0, "hdop", 1, "vdop", 1, "hacc", 2, "vacc", 2});
        this.send((IMCMessage)fix);
    }

    public void cleanSubPanel() {
    }
}

