/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.help;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.JPanel;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.ConsolePanel;
import pt.lsts.neptus.doc.DocumentationPanel;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.plugins.SimpleMenuAction;

@PluginDescription(author="ZP", description="Shows context-specific help", name="Context help", icon="pt/lsts/neptus/plugins/help/help.png")
public class ContextHelperPlugin
extends SimpleMenuAction {
    private static final long serialVersionUID = 1L;
    protected Component oldGlassPane;
    protected JPanel glassPane = new JPanel();

    public ContextHelperPlugin(ConsoleLayout console) {
        super(console);
    }

    public String getMenuName() {
        return I18n.text((String)"Help") + ">" + I18n.text((String)"Context Help");
    }

    public void actionPerformed(ActionEvent e) {
        this.oldGlassPane = this.getConsole().getGlassPane();
        this.glassPane.setOpaque(false);
        this.getConsole().setGlassPane((Component)this.glassPane);
        this.glassPane.setCursor(new Cursor(1));
        this.glassPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                MouseMotionListener[] ms;
                Component c;
                super.mouseClicked(e);
                for (c = ContextHelperPlugin.this.getConsole().getMainPanel().findComponentAt(e.getPoint()); c != null && !(c instanceof ConsolePanel) && c != c.getParent(); c = c.getParent()) {
                }
                ContextHelperPlugin.this.glassPane.removeMouseListener(this);
                for (MouseMotionListener m : ms = ContextHelperPlugin.this.glassPane.getMouseMotionListeners()) {
                    ContextHelperPlugin.this.glassPane.removeMouseMotionListener(m);
                }
                ContextHelperPlugin.this.getConsole().setGlassPane(ContextHelperPlugin.this.oldGlassPane);
                if (c != null) {
                    DocumentationPanel.showDocumentation(c.getClass());
                } else {
                    DocumentationPanel.showDocumentation((String)"start.html");
                }
            }
        });
    }

    public void cleanSubPanel() {
    }
}

