/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.alarms;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.RenderingHints;
import java.awt.geom.RoundRectangle2D;
import java.util.LinkedHashMap;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import org.jdesktop.swingx.JXLabel;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.painter.CompoundPainter;
import org.jdesktop.swingx.painter.GlossPainter;
import org.jdesktop.swingx.painter.Painter;
import pt.lsts.neptus.plugins.update.IPeriodicUpdates;
import pt.lsts.neptus.plugins.update.PeriodicUpdatesService;
import pt.lsts.neptus.util.GuiUtils;

public class AlarmDisplay
extends JXPanel
implements Painter<JXLabel>,
IPeriodicUpdates {
    private Color color = Color.black.darker();
    private JXLabel display = new JXLabel("Heartbeat");
    private int state = -2;
    private static final int NOT_BLINKING = 0;
    private static final int BLINKING_NORMAL = 1;
    private static final int BLINKING_BRILLIANT = 2;
    private int blinkingState = 0;
    private LinkedHashMap<Integer, Color> colors = new LinkedHashMap();

    public long millisBetweenUpdates() {
        switch (this.blinkingState) {
            case 0: {
                return 0L;
            }
            case 1: {
                return 100L;
            }
            case 2: {
                return 900L;
            }
        }
        return 0L;
    }

    public boolean update() {
        if (this.blinkingState == 0) {
            return false;
        }
        this.blinkingState = this.blinkingState == 1 ? 2 : 1;
        this.repaint();
        return true;
    }

    public void setText(String text) {
        this.display.setText(text);
    }

    public void setState(int state) {
        int oldState = this.state;
        this.state = state;
        if (oldState != state) {
            if (state == 4) {
                this.blinkingState = 1;
                PeriodicUpdatesService.register((IPeriodicUpdates)this);
            } else {
                this.blinkingState = 0;
            }
            this.repaint();
        }
    }

    public AlarmDisplay() {
        this.colors.put(-1, Color.black);
        this.colors.put(-2, Color.gray.darker());
        this.colors.put(0, Color.green.darker());
        this.colors.put(1, Color.blue.darker());
        this.colors.put(2, Color.yellow.darker());
        this.colors.put(3, Color.orange.darker());
        this.colors.put(4, Color.red.darker());
        this.setLayout(new BorderLayout());
        this.display.setBackgroundPainter((Painter)new CompoundPainter(new Painter[]{this, new GlossPainter()}));
        this.display.setHorizontalTextPosition(0);
        this.display.setHorizontalAlignment(0);
        this.display.setFont(new Font("Arial", 1, 14));
        this.display.setForeground(Color.white);
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.add((Component)this.display, "Center");
    }

    public void paint(Graphics2D arg0, JXLabel arg1, int arg2, int arg3) {
        this.color = this.colors.get(this.state);
        if (this.color == null) {
            this.color = Color.black;
        }
        if (this.blinkingState == 2) {
            this.color = this.color.brighter();
        }
        RoundRectangle2D.Double rect = new RoundRectangle2D.Double(2.0, 2.0, arg1.getWidth() - 4, arg1.getHeight() - 4, 10.0, 10.0);
        arg0.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        arg0.setPaint(new LinearGradientPaint(0.0f, 0.0f, this.getWidth(), this.getHeight(), new float[]{0.0f, 1.0f}, new Color[]{this.color, this.color.darker()}));
        arg0.fill(rect);
        arg0.setStroke(new BasicStroke(2.0f));
        arg0.setColor(this.color);
        arg0.draw(rect);
    }

    public static void main(String[] args) {
        final AlarmDisplay disp = new AlarmDisplay();
        Timer t = new Timer("AlarmDisplay");
        GuiUtils.testFrame((JComponent)((Object)disp));
        TimerTask changeColor = new TimerTask(){
            int i = 0;

            @Override
            public void run() {
                if (this.i < 1) {
                    disp.setState(4);
                    ++this.i;
                } else {
                    disp.setState(4);
                    this.i = 0;
                }
            }
        };
        t.schedule(changeColor, 1000L);
    }
}

