/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.alarms;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.JPopupMenu;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.LoggingEvent;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.plugins.alarms.SimpleAlarm;

@PluginDescription(icon="pt/lsts/neptus/plugins/alarms/icon.png", name="Error monitor", description="This panel shows software exceptions that may occur")
public class ExceptionAlarm
extends SimpleAlarm {
    private static final long serialVersionUID = 1L;
    private boolean added = false;
    private static final String ok_message = "No errors found";
    private String messageToShow = "No errors found";
    private int currentLevel = 0;
    private AppenderSkeleton appender = new AppenderSkeleton(){

        public boolean requiresLayout() {
            return false;
        }

        protected void append(LoggingEvent arg0) {
            if (arg0.getLevel().isGreaterOrEqual((Priority)Level.ERROR)) {
                if (arg0.getMessage() instanceof Exception) {
                    Exception e = (Exception)arg0.getMessage();
                    ExceptionAlarm.this.messageToShow = e.getClass().getSimpleName() + ": " + e.getMessage();
                } else {
                    ExceptionAlarm.this.messageToShow = arg0.getRenderedMessage();
                }
                ExceptionAlarm.this.currentLevel = 4;
            }
        }

        public void close() {
        }
    };

    @Override
    protected String getTextToDisplay() {
        return "SW Errors";
    }

    public ExceptionAlarm(ConsoleLayout console) {
        super(console);
        this.display.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                if (e.getButton() == 3 && ExceptionAlarm.this.currentLevel == 4) {
                    JPopupMenu popup = new JPopupMenu();
                    popup.add(new AbstractAction("Clear errors"){
                        private static final long serialVersionUID = 1L;

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            ExceptionAlarm.this.currentLevel = 0;
                            ExceptionAlarm.this.messageToShow = ExceptionAlarm.ok_message;
                        }
                    });
                    popup.show((Component)((Object)ExceptionAlarm.this.display), e.getX(), e.getY());
                }
            }
        });
    }

    public void initSubPanel() {
        if (!this.added) {
            NeptusLog.pubRoot().addAppender((Appender)this.appender);
        }
        this.added = true;
    }

    public void cleanSubPanel() {
        if (this.added) {
            NeptusLog.pubRoot().removeAppender((Appender)this.appender);
        }
        this.added = false;
    }

    public String getAlarmMessage() {
        return this.messageToShow;
    }

    public int getAlarmState() {
        return this.currentLevel;
    }
}

