/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.alarms;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.painter.Painter;
import pt.lsts.imc.IMCMessage;
import pt.lsts.neptus.comm.manager.imc.ImcSystem;
import pt.lsts.neptus.comm.manager.imc.ImcSystemsHolder;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.ConsolePanel;
import pt.lsts.neptus.console.plugins.AlarmProviderOld;
import pt.lsts.neptus.console.plugins.MainVehicleChangeListener;
import pt.lsts.neptus.gui.painters.SubPanelTitlePainter;
import pt.lsts.neptus.plugins.NeptusMessageListener;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.plugins.update.IPeriodicUpdates;
import pt.lsts.neptus.util.DateTimeUtil;

@PluginDescription(name="Last Error Panel", author="Paulo Dias", version="0.1", documentation="entity-state/lasterror.html")
public class LastErrorPanel
extends ConsolePanel
implements MainVehicleChangeListener,
IPeriodicUpdates,
AlarmProviderOld,
NeptusMessageListener {
    private JLabel entitiesInErrorTitle;
    private JTextArea entitiesInErrorLabel;
    private JScrollPane entitiesInErrorScrollPane;
    private JLabel lastErrorTitle;
    private JTextArea lastErrorLabel;
    private JScrollPane lastErrorScrollPane;
    private SubPanelTitlePainter backPainter;
    private Font font = new Font("Sans", 0, 12);
    private String lastError = "";
    private long lastErrorTime = -1L;
    private int alarmState = 0;
    int oldState = -100;

    public LastErrorPanel(ConsoleLayout console) {
        super(console);
        this.initialize();
    }

    private void initialize() {
        this.backPainter = new SubPanelTitlePainter("Error State");
        this.removeAll();
        this.setSize(180, 130);
        JXPanel holder = new JXPanel((LayoutManager)new MigLayout());
        holder.setBackgroundPainter((Painter)this.backPainter);
        this.setLayout(new BorderLayout());
        this.add((Component)holder);
        holder.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.lastErrorTitle = new JLabel("<html><b>Last error: ");
        this.lastErrorTitle.setHorizontalAlignment(10);
        this.lastErrorTitle.setFont(this.font);
        this.lastErrorLabel = new JTextArea("");
        this.lastErrorLabel.setFont(this.font);
        this.lastErrorLabel.setLineWrap(true);
        this.lastErrorLabel.setWrapStyleWord(true);
        this.lastErrorLabel.setEditable(false);
        this.lastErrorLabel.setEnabled(false);
        this.lastErrorLabel.setOpaque(false);
        this.lastErrorScrollPane = new JScrollPane();
        this.lastErrorScrollPane.setViewportView(this.lastErrorLabel);
        this.lastErrorScrollPane.setOpaque(false);
        this.entitiesInErrorTitle = new JLabel("<html><b>Error entities: ");
        this.entitiesInErrorTitle.setFont(this.font);
        this.entitiesInErrorLabel = new JTextArea("");
        this.entitiesInErrorLabel.setFont(this.font);
        this.entitiesInErrorLabel.setLineWrap(true);
        this.entitiesInErrorLabel.setWrapStyleWord(true);
        this.entitiesInErrorLabel.setEditable(false);
        this.entitiesInErrorLabel.setEnabled(false);
        this.entitiesInErrorLabel.setOpaque(false);
        this.entitiesInErrorScrollPane = new JScrollPane();
        this.entitiesInErrorScrollPane.setViewportView(this.entitiesInErrorLabel);
        this.entitiesInErrorScrollPane.setOpaque(false);
        holder.add((Component)this.entitiesInErrorTitle, (Object)"wrap, gaptop 8");
        holder.add((Component)this.entitiesInErrorScrollPane, (Object)"wrap ,h 45%, w 100%");
        holder.add((Component)this.lastErrorTitle, (Object)"wrap");
        holder.add((Component)this.lastErrorScrollPane, (Object)"wrap,h 45%, w 100%");
    }

    public long millisBetweenUpdates() {
        return 500L;
    }

    public boolean update() {
        String dateStr;
        ImcSystem sys = ImcSystemsHolder.lookupSystemByName((String)this.getMainVehicleId());
        if (sys != null) {
            if (sys.isOnErrorState()) {
                dateStr = "";
                if (sys.getLastErrorStateReceived() != -1L) {
                    dateStr = DateTimeUtil.timeFormaterNoMillis2.format(new Date(sys.getLastErrorStateReceived()));
                    if (System.currentTimeMillis() - sys.getLastErrorStateReceived() > 5000L) {
                        this.entitiesInErrorLabel.setEnabled(false);
                    } else {
                        this.entitiesInErrorLabel.setEnabled(true);
                    }
                }
                this.entitiesInErrorLabel.setText(dateStr + " - " + sys.getOnErrorStateStr());
            } else {
                this.alarmState = 0;
                this.warningAlarmChange();
                this.entitiesInErrorLabel.setText("");
            }
        } else {
            this.entitiesInErrorLabel.setText("<html><b>?");
        }
        if (this.lastError != null && !"".equalsIgnoreCase(this.lastError)) {
            dateStr = "";
            if (this.lastErrorTime != -1L) {
                dateStr = DateTimeUtil.timeFormaterNoMillis2.format(new Date(this.lastErrorTime * 1000L));
                if (System.currentTimeMillis() - this.lastErrorTime * 1000L > 5000L) {
                    this.lastErrorLabel.setEnabled(this.entitiesInErrorLabel.isEnabled() && !"".equalsIgnoreCase(this.entitiesInErrorLabel.getText()));
                } else {
                    this.lastErrorLabel.setEnabled(true);
                }
            }
            this.lastErrorLabel.setText(dateStr + " - " + this.lastError);
        } else {
            this.alarmState = 0;
            this.warningAlarmChange();
            this.lastErrorLabel.setText("");
        }
        return true;
    }

    private void warningAlarmChange() {
        if (this.oldState < 0 || this.oldState != this.alarmState) {
            try {
                try {
                    this.getMainpanel().getAlarmlistener().updateAlarmsListeners((AlarmProviderOld)this);
                }
                catch (RuntimeException e) {
                    e.printStackTrace();
                }
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
            this.oldState = this.alarmState;
        }
    }

    public int getAlarmState() {
        return this.alarmState;
    }

    public String getAlarmMessage() {
        return "Alarm";
    }

    public int sourceState() {
        return 0;
    }

    public String[] getObservedMessages() {
        return new String[]{"VehicleState"};
    }

    public void messageArrived(IMCMessage message) {
        String lastErrorTmp = message.getString("last_error");
        long lastErrorTimeTmp = message.getLong("last_error_time");
        if (!this.lastError.equals(lastErrorTmp)) {
            this.lastError = lastErrorTmp;
            this.lastErrorTime = lastErrorTimeTmp;
        }
    }

    public void initSubPanel() {
    }

    public void cleanSubPanel() {
    }
}

